/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons;

import java.util.Stack;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.ecss.extensions.api.link.Attr;
import ro.sync.ecss.extensions.api.link.ElementLocator;
import ro.sync.ecss.extensions.api.link.ElementLocatorException;
import ro.sync.ecss.extensions.api.link.IDTypeVerifier;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class XPointerElementLocator
extends ElementLocator {
    private static final Logger logger = LoggerFactory.getLogger((String)XPointerElementLocator.class.getName());
    private IDTypeVerifier idVerifier;
    private String[] xpointerPath;
    private Stack currentElementIndexStack = new Stack();
    private int xpointerPathDepth;
    private boolean startWithElementID = false;
    private int startElementDepth = 0;
    private int endElementDepth = 0;
    private int lastIndexInParent;

    public XPointerElementLocator(IDTypeVerifier iDTypeVerifier, String string) throws ElementLocatorException {
        super(string);
        this.idVerifier = iDTypeVerifier;
        string = string.substring("element(".length(), string.length() - 1);
        if (string != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/", false);
            this.xpointerPath = new String[stringTokenizer.countTokens()];
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                this.xpointerPath[n2] = stringTokenizer.nextToken();
                boolean bl = false;
                if (this.xpointerPath[n2].length() == 0) {
                    bl = true;
                }
                if (n2 > 0) {
                    try {
                        NumberParserUtil.parseInt((String)this.xpointerPath[n2]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = true;
                    }
                }
                if (bl) {
                    throw new ElementLocatorException("Only the element() scheme is supported when locating XPointer links. Supported formats: element(elementID), element(/1/2/3), element(elemID/2/3/4).");
                }
                ++n2;
            }
            if (Character.isDigit(this.xpointerPath[0].charAt(0))) {
                this.xpointerPathDepth = this.xpointerPath.length;
            } else {
                this.xpointerPathDepth = -1;
                this.startWithElementID = true;
            }
        } else {
            String string2 = "Syntax Error.\nThe XPointer element() scheme with no arguments is not permitted.";
            throw new ElementLocatorException(string2);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        this.endElementDepth = this.startElementDepth--;
        this.lastIndexInParent = (Integer)this.currentElementIndexStack.pop();
    }

    @Override
    public boolean startElement(String string, String string2, String string3, Attr[] attrArray) {
        int n2;
        boolean bl = false;
        ++this.startElementDepth;
        if (this.endElementDepth != this.startElementDepth) {
            this.currentElementIndexStack.push(1);
        } else {
            this.currentElementIndexStack.push(this.lastIndexInParent + 1);
        }
        if (this.startWithElementID) {
            String string4 = this.xpointerPath[0];
            for (n2 = 0; n2 < attrArray.length; ++n2) {
                if (!string4.equals(attrArray[n2].getValue()) || !this.idVerifier.hasIDType(string2, string, attrArray[n2].getQName(), attrArray[n2].getNamespace())) continue;
                this.xpointerPathDepth = this.startElementDepth + this.xpointerPath.length - 1;
                break;
            }
        }
        if (this.xpointerPathDepth == this.startElementDepth) {
            bl = true;
            try {
                int n3;
                int n4 = this.xpointerPath.length - 1;
                int n5 = n3 = this.startWithElementID ? 1 : 0;
                for (n2 = this.currentElementIndexStack.size() - 1; n4 >= n3 && n2 >= 0; --n4, --n2) {
                    int n6;
                    int n7 = NumberParserUtil.parseInt((String)this.xpointerPath[n4]);
                    if (n7 == (n6 = ((Integer)this.currentElementIndexStack.get(n2)).intValue())) continue;
                    bl = false;
                    break;
                }
            }
            catch (NumberFormatException numberFormatException) {
                logger.warn((Object)numberFormatException, (Throwable)numberFormatException);
            }
        }
        return bl;
    }
}

