/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.api.webapp.references;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.css.EditorContent;
import ro.sync.ecss.css.StaticContent;
import ro.sync.ecss.css.Styles;
import ro.sync.ecss.css.db;
import ro.sync.ecss.dom.o;
import ro.sync.ecss.dom.z;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.webapp.formcontrols.WebappImageMapRenderer;
import ro.sync.exml.workspace.api.references.Reference;
import ro.sync.exml.workspace.api.references.ReferenceExtractor;

@API(type=APIType.NOT_EXTENDABLE, src=SourceType.PUBLIC)
public class ImageMapExtractor
implements ReferenceExtractor {
    private static final Logger logger = LoggerFactory.getLogger(ImageMapExtractor.class);
    private db stylesheet;

    public ImageMapExtractor(db db2) {
        this.stylesheet = db2;
    }

    @Override
    public Optional<Reference> extract(o o2) {
        AttrValue attrValue;
        Optional<Reference> optional = Optional.empty();
        Styles styles = this.stylesheet.q(o2);
        StaticContent[] staticContentArray = styles.getMixedContent();
        boolean bl = Arrays.stream(staticContentArray).filter(staticContent -> staticContent instanceof EditorContent).map(staticContent -> ((EditorContent)staticContent).getProperties().get("webappRendererClassName")).anyMatch(object -> WebappImageMapRenderer.class.getName().equals(object));
        if (bl && (attrValue = ((z)o2).getAttribute("href")) != null) {
            String string = attrValue.getValue();
            try {
                URL uRL = new URL(o2.getXMLBaseURL(), string);
                optional = Optional.of(new Reference(Reference.Type.STATIC_CONTENT, uRL.toString()));
            }
            catch (MalformedURLException malformedURLException) {
                logger.error("Cannot resolve URL. xmlBase:" + o2.getXMLBaseURL() + " href:" + string, (Throwable)malformedURLException);
            }
        }
        return optional;
    }
}

