/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.api.webapp.plugin;

import com.google.common.base.Objects;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.URLStreamHandler;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.webapp.plugin.UserActionRequiredException;
import ro.sync.ecss.extensions.api.webapp.plugin.UserContext;
import ro.sync.ecss.webapp.cb;
import ro.sync.ecss.webapp.plugin.e;
import ro.sync.security.Sandbox;

@API(src=SourceType.PUBLIC, type=APIType.EXTENDABLE)
public abstract class URLStreamHandlerWithContext
extends URLStreamHandler {
    private static final String FAKE_ORIGIN = "oxygen-webapp";
    private static final Logger logger = LoggerFactory.getLogger((String)URLStreamHandlerWithContext.class.getName());

    protected URLStreamHandlerWithContext() {
    }

    void setUserContext(UserContext userContext, URL uRL) throws MalformedURLException {
        String string = this.getContextId(userContext);
        this.setContextId(uRL, string);
    }

    void setContextId(URL uRL, String object) {
        String string;
        String string2 = uRL.getUserInfo();
        if (string2 != null) {
            try {
                object = (String)object + ":" + URLEncoder.encode(string2, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                logger.error((Object)unsupportedEncodingException, (Throwable)unsupportedEncodingException);
            }
        }
        if ((string = uRL.getAuthority()) == null) {
            string = FAKE_ORIGIN;
        }
        String string3 = string.substring(string.indexOf(64) + 1);
        this.setURL(uRL, uRL.getProtocol(), uRL.getHost(), uRL.getPort(), (String)object + "@" + string3, (String)object, uRL.getPath(), uRL.getQuery(), uRL.getRef());
    }

    protected String getContextId(UserContext userContext) {
        return userContext.getSessionId();
    }

    URL stripUrlContextId(URL uRL) {
        URL uRL2 = uRL;
        String string = uRL.getAuthority();
        if (string != null) {
            Object object;
            uRL2 = this.stripUrl(uRL);
            String string2 = string.substring(string.indexOf(64) + 1);
            if (FAKE_ORIGIN.equals(string2)) {
                string2 = null;
            }
            String string3 = uRL.getUserInfo();
            String string4 = null;
            if (string3 != null && string3.contains(":")) {
                object = string3.split(":")[1];
                try {
                    string4 = URLDecoder.decode((String)object, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    logger.error((Object)unsupportedEncodingException, (Throwable)unsupportedEncodingException);
                }
            }
            object = string2;
            if (string4 != null) {
                object = string4 + "@" + string2;
            }
            this.setURL(uRL2, uRL.getProtocol(), uRL.getHost(), uRL.getPort(), (String)object, string4, uRL.getPath(), uRL.getQuery(), uRL.getRef());
        }
        return uRL2;
    }

    private URL stripUrl(final URL uRL) {
        URL uRL2 = uRL;
        try {
            uRL2 = (URL)Sandbox.runWithAllPerms((PrivilegedExceptionAction)new PrivilegedExceptionAction<URL>(){

                @Override
                public URL run() throws Exception {
                    return new URL(uRL, uRL.toExternalForm(), URLStreamHandlerWithContext.this);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            logger.error("Error re-parsing URL: " + uRL.toExternalForm(), (Throwable)privilegedActionException);
        }
        return uRL2;
    }

    String getUrlContextId(URL uRL) {
        String string = uRL.getUserInfo();
        if (string != null && string.contains(":")) {
            string = string.split(":")[0];
        }
        return string;
    }

    @Override
    protected final URLConnection openConnection(URL uRL, Proxy proxy) throws IOException {
        String string = this.getUrlContextId(uRL);
        URL uRL2 = this.stripUrlContextId(uRL);
        URLConnection uRLConnection = null;
        try {
            uRLConnection = this.openConnectionInContext(string, uRL2, proxy);
        }
        catch (UserActionRequiredException userActionRequiredException) {
            cb.f().e(userActionRequiredException.getUserMessage(uRL));
            throw userActionRequiredException;
        }
        return new e(uRLConnection);
    }

    @Override
    protected final URLConnection openConnection(URL uRL) throws IOException {
        return this.openConnection(uRL, null);
    }

    protected abstract URLConnection openConnectionInContext(String var1, URL var2, Proxy var3) throws IOException;

    @Override
    public int hashCode(URL uRL) {
        return Objects.hashCode((Object[])new Object[]{uRL.getProtocol(), uRL.getAuthority(), uRL.getHost(), uRL.getFile(), uRL.getQuery()});
    }

    @Override
    protected boolean hostsEqual(URL uRL, URL uRL2) {
        if (uRL.getHost() != null && uRL2.getHost() != null) {
            return uRL.getHost().equalsIgnoreCase(uRL2.getHost());
        }
        return uRL.getHost() == null && uRL2.getHost() == null;
    }
}

