/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.api.webapp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.webapp.PluginCspConfiguration;
import ro.sync.exml.options.Options;
import ro.sync.exml.plugin.Plugin;
import ro.sync.exml.plugin.PluginDescriptor;
import ro.sync.exml.plugin.PluginExtension;
import ro.sync.exml.plugin.PluginManager;
import ro.sync.exml.plugin.workspace.security.CspDirective;
import ro.sync.exml.plugin.workspace.security.CspProviderExtension;
import ro.sync.options.e;

@API(type=APIType.INTERNAL, src=SourceType.PRIVATE)
public final class CspConfigurationProviderCollector {
    private static final Logger logger = LoggerFactory.getLogger(CspConfigurationProviderCollector.class);
    private List<PluginCspConfiguration> pluginAdditionalCspConfigurations = new ArrayList<PluginCspConfiguration>();
    private List<Map<CspDirective, List<String>>> collectedCspConfigurations = new ArrayList<Map<CspDirective, List<String>>>();
    private final e propertyListener = new e("", true){

        @Override
        public void update() {
            CspConfigurationProviderCollector.this.refreshCspConfigurations();
        }
    };

    public CspConfigurationProviderCollector() {
        Options.getInstance().addPropertyListener(this.propertyListener);
    }

    public List<PluginCspConfiguration> getPluginCspConfigurations() {
        return Collections.unmodifiableList(this.pluginAdditionalCspConfigurations);
    }

    public List<Map<CspDirective, List<String>>> getCollectedCspConfigurations() {
        return Collections.unmodifiableList(this.collectedCspConfigurations);
    }

    public void refreshCspConfigurations() {
        this.pluginAdditionalCspConfigurations = CspConfigurationProviderCollector.collectPluginCspConfigurations();
        this.collectedCspConfigurations = CspConfigurationProviderCollector.collectCspConfigurations(this.pluginAdditionalCspConfigurations);
    }

    public void cleanup() {
        Options.getInstance().removePropertyListener(this.propertyListener);
    }

    private static List<PluginCspConfiguration> collectPluginCspConfigurations() {
        ArrayList<PluginCspConfiguration> arrayList = new ArrayList<PluginCspConfiguration>();
        List<Plugin> list = PluginManager.getInstance().getPlugins();
        for (Plugin plugin : list) {
            List<PluginDescriptor.PluginExtensionDescription> list2 = plugin.getDescriptor().getExtensions("Csp");
            for (PluginDescriptor.PluginExtensionDescription pluginExtensionDescription : list2) {
                PluginExtension pluginExtension = pluginExtensionDescription.getPluginExtension();
                if (!(pluginExtension instanceof CspProviderExtension)) continue;
                CspProviderExtension cspProviderExtension = (CspProviderExtension)pluginExtension;
                String string = plugin.getDescriptor().getName();
                String string2 = string != null && !string.trim().isEmpty() ? string : plugin.getDescriptor().getID();
                try {
                    Map<CspDirective, List<String>> map = cspProviderExtension.getAdditionalCspConfiguration();
                    arrayList.add(new PluginCspConfiguration(map, string2));
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Plugin " + string2 + " contributed additional CSP configuration: " + map);
                }
                catch (Throwable throwable) {
                    logger.error("Could not load additional CSP configuration for plugin " + string2 + "; the provided CSP configuration will be ignored. Error: " + throwable.getMessage(), throwable);
                }
            }
        }
        return arrayList;
    }

    private static List<Map<CspDirective, List<String>>> collectCspConfigurations(List<PluginCspConfiguration> list) {
        return list.stream().map(PluginCspConfiguration::getCspConfiguration).collect(Collectors.toList());
    }
}

