/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.api.text;

import java.net.URL;
import java.util.List;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.Extension;
import ro.sync.ecss.extensions.api.ExternalObjectInsertionSources;
import ro.sync.ecss.extensions.api.text.TextPageOperationException;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.editor.page.text.xml.WSXMLTextEditorPage;
import ro.sync.exml.workspace.api.util.UtilAccess;

@API(type=APIType.EXTENDABLE, src=SourceType.PUBLIC)
public abstract class TextPageExternalObjectInsertionHandler
implements ExternalObjectInsertionSources,
Extension {
    public void insertURLs(WSXMLTextEditorPage wSXMLTextEditorPage, List<URL> list, int n2) throws TextPageOperationException {
    }

    public boolean acceptsURLs(WSXMLTextEditorPage wSXMLTextEditorPage, List<URL> list, int n2) {
        return this.acceptsSource(wSXMLTextEditorPage, n2) || TextPageExternalObjectInsertionHandler.containsOnlyImages(wSXMLTextEditorPage, list) || TextPageExternalObjectInsertionHandler.containsOnlyBinaryResources(wSXMLTextEditorPage, list);
    }

    public boolean acceptsSource(WSXMLTextEditorPage wSXMLTextEditorPage, int n2) {
        return n2 == 1 || n2 == 0 || n2 == 4 || n2 == 6 || n2 == 3 || n2 == 5 || n2 == 8;
    }

    protected static boolean containsOnlyImages(WSXMLTextEditorPage wSXMLTextEditorPage, List<URL> list) {
        UtilAccess utilAccess;
        PluginWorkspace pluginWorkspace = PluginWorkspaceProvider.getPluginWorkspace();
        if (pluginWorkspace != null && (utilAccess = pluginWorkspace.getUtilAccess()) != null) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                URL uRL = list.get(i2);
                if (utilAccess.isSupportedImageURL(uRL)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected static boolean containsOnlyBinaryResources(WSXMLTextEditorPage wSXMLTextEditorPage, List<URL> list) {
        UtilAccess utilAccess;
        PluginWorkspace pluginWorkspace = PluginWorkspaceProvider.getPluginWorkspace();
        if (pluginWorkspace != null && (utilAccess = pluginWorkspace.getUtilAccess()) != null) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                URL uRL = list.get(i2);
                if (utilAccess.isUnhandledBinaryResourceURL(uRL)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        return "Text Page External Object Insertion Handler";
    }
}

