/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.api.node;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Segment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.dom.c.h;
import ro.sync.ecss.dom.k;
import ro.sync.ecss.dom.o;
import ro.sync.ecss.extensions.api.Content;
import ro.sync.ecss.extensions.api.highlights.AuthorPersistentHighlight;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;

@API(type=APIType.NOT_EXTENDABLE, src=SourceType.PUBLIC)
public class AuthorDocumentFragment {
    private static final Logger logger = LoggerFactory.getLogger((String)AuthorDocumentFragment.class.getName());
    private final Content content;
    private List<AuthorNode> nodes;
    private int righSplits;
    private int leftSplits;
    private List<AuthorPersistentHighlight> changeMarks;
    private List<AuthorPersistentHighlight> persistentMarks;
    private Map<AuthorElement, LinkedHashMap<String, AuthorPersistentHighlight>> attributesChanges = null;
    private int suggestedRelativeCaretOffset = -1;

    public AuthorDocumentFragment(Content content, List<AuthorNode> list, int n2, int n3) {
        this(content, list, n2, n3, null, null);
    }

    public AuthorDocumentFragment(Content content, List<AuthorNode> list, int n2, int n3, List<AuthorPersistentHighlight> list2, List<AuthorPersistentHighlight> list3) {
        this(content, list, n2, n3, list2, list3, null);
    }

    public AuthorDocumentFragment(Content content, List<AuthorNode> list, int n2, int n3, List<AuthorPersistentHighlight> list2, List<AuthorPersistentHighlight> list3, Map<AuthorElement, LinkedHashMap<String, AuthorPersistentHighlight>> map) {
        this.content = content;
        this.nodes = list;
        this.leftSplits = n2;
        this.righSplits = n3;
        this.changeMarks = list2;
        this.persistentMarks = list3;
        this.attributesChanges = map;
    }

    public Content getContent() {
        return this.content;
    }

    public int getAcceptedLength() {
        int n2 = this.getLength();
        if (this.changeMarks != null) {
            for (int i2 = 0; i2 < this.changeMarks.size(); ++i2) {
                AuthorPersistentHighlight authorPersistentHighlight = this.changeMarks.get(i2);
                if (authorPersistentHighlight.getType() != AuthorPersistentHighlight.PersistentHighlightType.CHANGE_DELETE) continue;
                n2 -= authorPersistentHighlight.getEndOffset() - authorPersistentHighlight.getStartOffset() + 1;
            }
        }
        return n2;
    }

    public int getLength() {
        return this.content.getLength();
    }

    public List<AuthorNode> getContentNodes() {
        return this.nodes;
    }

    public String toString() {
        Object object = "";
        try {
            object = "Fragment content '" + this.content.getString(0, this.content.getLength()).replace('\u0000', 'X') + "'\n Elements '" + this.nodes + "\nRight splits:" + this.righSplits + " Left splits:" + this.leftSplits;
            if (this.persistentMarks != null && !this.persistentMarks.isEmpty()) {
                object = (String)object + "\nPersistent markers: " + this.persistentMarks;
            }
            if (this.changeMarks != null && !this.changeMarks.isEmpty()) {
                object = (String)object + "\nChange markers: " + this.changeMarks;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return object;
    }

    public int getLeftSplits() {
        return this.leftSplits;
    }

    public int getRightSplits() {
        return this.righSplits;
    }

    public void setLeftSplits(int n2) {
        this.leftSplits = n2;
    }

    public void setRighSplits(int n2) {
        this.righSplits = n2;
    }

    public List<AuthorPersistentHighlight> getChangeHighlights() {
        return this.changeMarks;
    }

    public Map<AuthorElement, LinkedHashMap<String, AuthorPersistentHighlight>> getAttributesChangeHighlights() {
        return this.attributesChanges;
    }

    public List<AuthorPersistentHighlight> getCommentsAndCustomHighlights() {
        return this.persistentMarks;
    }

    public void setCommentAndCustomHighlights(List<AuthorPersistentHighlight> list) {
        this.persistentMarks = list;
    }

    public void setChangeHighlights(List<AuthorPersistentHighlight> list) {
        this.changeMarks = list;
    }

    public void setAttributesChanges(Map<AuthorElement, LinkedHashMap<String, AuthorPersistentHighlight>> map) {
        this.attributesChanges = map;
    }

    public boolean isEmpty() {
        return this.content.getLength() == 0;
    }

    public boolean containsSimpleText() {
        boolean bl = false;
        try {
            List<AuthorNode> list = this.getContentNodes();
            Content content = this.getContent();
            if (list == null || list.size() == 0) {
                String string = content.getString(0, content.getLength());
                bl = string.trim().length() > 0;
            } else {
                int n2 = 0;
                Object object = list.iterator();
                while (object.hasNext()) {
                    String string;
                    AuthorNode authorNode = object.next();
                    int n3 = authorNode.getStartOffset();
                    if (n3 < n2) continue;
                    if (n3 != n2 && (string = content.getString(n2, n3 - n2)).trim().length() > 0) {
                        bl = true;
                        break;
                    }
                    n2 = authorNode.getEndOffset() + 1;
                }
                if (((String)(object = content.getString(n2, content.getLength() - n2))).trim().length() > 0) {
                    bl = true;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            logger.error((Object)badLocationException, (Throwable)badLocationException);
        }
        return bl;
    }

    public AuthorDocumentFragment clone() throws CloneNotSupportedException {
        AuthorDocumentFragment authorDocumentFragment = null;
        try {
            Object object;
            Object object2;
            Content content = this.cloneContent();
            ArrayList<AuthorNode> arrayList = this.nodes != null ? new ArrayList<AuthorNode>(this.nodes.size()) : null;
            final HashMap<AuthorNode, AuthorNode> hashMap = new HashMap<AuthorNode, AuthorNode>();
            if (arrayList != null && this.nodes != null && !this.nodes.isEmpty()) {
                for (int i2 = 0; i2 < this.nodes.size(); ++i2) {
                    object2 = (o)this.nodes.get(i2);
                    object = ((o)object2).q(content, 0, false, new k(){

                        @Override
                        public void nodeCloned(AuthorNode authorNode, AuthorNode authorNode2) {
                            hashMap.put(authorNode, authorNode2);
                        }
                    }, true);
                    hashMap.put((AuthorNode)object2, (AuthorNode)object);
                    arrayList.add((AuthorNode)object);
                }
            }
            Map<AuthorElement, LinkedHashMap<String, AuthorPersistentHighlight>> map = this.cloneAttributeChanges(content, hashMap);
            object2 = this.cloneChangeMarkers(content);
            object = this.clonePersistentMarkers(content);
            authorDocumentFragment = new AuthorDocumentFragment(content, (List<AuthorNode>)arrayList, this.leftSplits, this.righSplits, (List<AuthorPersistentHighlight>)object2, (List<AuthorPersistentHighlight>)object, map);
            authorDocumentFragment.setSuggestedRelativeCaretOffset(this.getSuggestedRelativeCaretOffset());
        }
        catch (Exception exception) {
            logger.error((Object)exception, (Throwable)exception);
            CloneNotSupportedException cloneNotSupportedException = new CloneNotSupportedException(exception.getMessage());
            cloneNotSupportedException.initCause(exception);
            throw cloneNotSupportedException;
        }
        return authorDocumentFragment;
    }

    private List<AuthorPersistentHighlight> clonePersistentMarkers(Content content) throws CloneNotSupportedException {
        ArrayList<AuthorPersistentHighlight> arrayList;
        ArrayList<AuthorPersistentHighlight> arrayList2 = arrayList = this.persistentMarks != null ? new ArrayList<AuthorPersistentHighlight>(this.persistentMarks.size()) : null;
        if (arrayList != null && !this.persistentMarks.isEmpty()) {
            for (int i2 = 0; i2 < this.persistentMarks.size(); ++i2) {
                arrayList.add(this.persistentMarks.get(i2).clone(content));
            }
        }
        return arrayList;
    }

    private List<AuthorPersistentHighlight> cloneChangeMarkers(Content content) throws CloneNotSupportedException {
        ArrayList<AuthorPersistentHighlight> arrayList;
        ArrayList<AuthorPersistentHighlight> arrayList2 = arrayList = this.changeMarks != null ? new ArrayList<AuthorPersistentHighlight>(this.changeMarks.size()) : null;
        if (arrayList != null && !this.changeMarks.isEmpty()) {
            for (int i2 = 0; i2 < this.changeMarks.size(); ++i2) {
                arrayList.add(this.changeMarks.get(i2).clone(content));
            }
        }
        return arrayList;
    }

    private Map<AuthorElement, LinkedHashMap<String, AuthorPersistentHighlight>> cloneAttributeChanges(Content content, Map<AuthorNode, AuthorNode> map) throws CloneNotSupportedException {
        HashMap<AuthorElement, LinkedHashMap<String, AuthorPersistentHighlight>> hashMap;
        HashMap<AuthorElement, LinkedHashMap<String, AuthorPersistentHighlight>> hashMap2 = hashMap = this.attributesChanges != null ? new HashMap<AuthorElement, LinkedHashMap<String, AuthorPersistentHighlight>>() : null;
        if (hashMap != null) {
            for (AuthorElement authorElement : this.attributesChanges.keySet()) {
                AuthorElement authorElement2;
                LinkedHashMap<String, AuthorPersistentHighlight> linkedHashMap = this.attributesChanges.get(authorElement);
                if (linkedHashMap == null || linkedHashMap.isEmpty() || (authorElement2 = (AuthorElement)map.get(authorElement)) == null) continue;
                LinkedHashMap<String, AuthorPersistentHighlight> linkedHashMap2 = new LinkedHashMap<String, AuthorPersistentHighlight>();
                for (String string : linkedHashMap.keySet()) {
                    AuthorPersistentHighlight authorPersistentHighlight = linkedHashMap.get(string);
                    linkedHashMap2.put(string, authorPersistentHighlight.clone(content));
                }
                hashMap.put(authorElement2, linkedHashMap2);
            }
        }
        return hashMap;
    }

    private Content cloneContent() throws BadLocationException {
        h h2 = new h(this.content.getLength());
        Segment segment = new Segment();
        segment.setPartialReturn(false);
        this.content.getChars(0, this.content.getLength(), segment);
        h2.insertChars(0, segment.array, segment.offset, segment.length());
        return h2;
    }

    public void setSuggestedRelativeCaretOffset(int n2) {
        this.suggestedRelativeCaretOffset = n2;
    }

    public int getSuggestedRelativeCaretOffset() {
        return this.suggestedRelativeCaretOffset;
    }

    public void setContentNodes(List<AuthorNode> list) {
        this.nodes = list;
    }
}

