/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.api.component.sync;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.io.FileSystemUtil;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.extensions.api.component.sync.ExpandedSyncInfo;
import ro.sync.ecss.extensions.api.component.sync.Resource2Synchronize;
import ro.sync.ecss.extensions.api.component.sync.ResourcesSynchronizerListener;
import ro.sync.ecss.extensions.api.component.sync.SyncInfoManager;
import ro.sync.io.TemporaryFilesFactory;

@API(type=APIType.INTERNAL, src=SourceType.PRIVATE)
public class ResourcesSynchronizer {
    private static final Logger logger = LoggerFactory.getLogger((String)ResourcesSynchronizer.class.getName());
    private SyncInfoManager syncManager;
    private final File syncDir;
    private ResourcesSynchronizerListener listener;
    private static final String LOCK_FILE_NAME = "sync.lock";

    public ResourcesSynchronizer(File file, ResourcesSynchronizerListener resourcesSynchronizerListener) {
        this.syncDir = file;
        this.syncManager = new SyncInfoManager(file);
        this.listener = resourcesSynchronizerListener;
    }

    public SyncInfoManager getSyncManager() {
        return this.syncManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync(Resource2Synchronize[] resource2SynchronizeArray) {
        if (logger.isDebugEnabled()) {
            logger.debug("Synchronize frameworks in " + URLUtil.filterPasswords((String)this.syncDir.getAbsolutePath()));
        }
        File file = null;
        File file2 = new File(this.syncDir, LOCK_FILE_NAME);
        if (file2.exists()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Frameworks update already in progress, returning.");
            }
            return;
        }
        boolean bl = false;
        try {
            if (file2.getParentFile() != null) {
                file2.getParentFile().mkdirs();
            }
            bl = file2.createNewFile();
            file2.deleteOnExit();
        }
        catch (IOException iOException) {
            logger.warn((Object)iOException, (Throwable)iOException);
        }
        {
            Object object;
            int n2;
            int n3;
            ArrayList<ExpandedSyncInfo> arrayList = new ArrayList<ExpandedSyncInfo>();
            List<ExpandedSyncInfo> list = this.syncManager.getSyncInfo();
            if (logger.isDebugEnabled()) {
                logger.debug("Current frameworks info " + list);
            }
            if (this.listener != null) {
                this.listener.refreshing();
            }
            Iterator<ExpandedSyncInfo> iterator = list.iterator();
            while (iterator.hasNext()) {
                String[] stringArray;
                ExpandedSyncInfo expandedSyncInfo = iterator.next();
                boolean bl2 = true;
                for (n3 = 0; n3 < resource2SynchronizeArray.length; ++n3) {
                    if ((!"jndi".equals(resource2SynchronizeArray[n3].getURL().getProtocol()) || !resource2SynchronizeArray[n3].getURL().getPath().equals(expandedSyncInfo.getRemoteZIPURL().getPath())) && !expandedSyncInfo.getRemoteZIPURL().equals(resource2SynchronizeArray[n3].getURL())) continue;
                    bl2 = false;
                    break;
                }
                if (!bl2) {
                    bl2 = false;
                    String[] stringArray2 = expandedSyncInfo.getResourceNames();
                    if (stringArray2 != null && stringArray2.length > 0) {
                        for (n2 = 0; n2 < stringArray2.length; ++n2) {
                            object = new File(this.syncDir, stringArray2[n2]);
                            if (((File)object).exists()) continue;
                            bl2 = true;
                            break;
                        }
                    }
                }
                if (!bl2) continue;
                iterator.remove();
                for (String string : stringArray = expandedSyncInfo.getResourceNames()) {
                    File file3 = new File(this.syncDir, string);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Remove from disk " + URLUtil.filterPasswords((String)file3.getAbsolutePath()));
                    }
                    FileSystemUtil.deleteRecursivelly((File)file3);
                }
            }
            for (int i2 = 0; i2 < resource2SynchronizeArray.length; ++i2) {
                URL uRL;
                block47: {
                    block46: {
                        uRL = resource2SynchronizeArray[i2].getURL();
                        if (logger.isDebugEnabled()) {
                            logger.debug("ZIP is " + URLUtil.filterPasswords((String)String.valueOf(uRL)));
                        }
                        if (this.listener == null || !this.listener.synchronizing(uRL)) break block46;
                    }
                    if (uRL != null) break block47;
                    logger.warn("URL of the ZIPPED frameworks is NULL");
                    resource2SynchronizeArray[i2].disconect();
                    continue;
                }
                try {
                    n3 = -1;
                    for (n2 = 0; n2 < list.size(); ++n2) {
                        if ((!"jndi".equals(resource2SynchronizeArray[i2].getURL().getProtocol()) || !resource2SynchronizeArray[i2].getURL().getPath().equals(list.get(n2).getRemoteZIPURL().getPath())) && !list.get(n2).getRemoteZIPURL().equals(uRL)) continue;
                        n3 = n2;
                        break;
                    }
                    n2 = 1;
                    if (n3 != -1) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Framework already present");
                        }
                        object = list.remove(n3);
                        if (resource2SynchronizeArray[i2].getTimestamp() == ((ExpandedSyncInfo)object).getRemoteZIPTimestamp() && (long)resource2SynchronizeArray[i2].getContentLength() == ((ExpandedSyncInfo)object).getRemoteZIPContentLength()) {
                            n2 = 0;
                            arrayList.add((ExpandedSyncInfo)object);
                            if (logger.isDebugEnabled()) {
                                logger.debug("No update necessary");
                            }
                        } else {
                            String[] stringArray;
                            if (logger.isDebugEnabled()) {
                                logger.debug("Update necessary, timestamp changed");
                            }
                            for (String string : stringArray = ((ExpandedSyncInfo)object).getResourceNames()) {
                                File file4 = new File(this.syncDir, string);
                                if (logger.isDebugEnabled()) {
                                    logger.debug("Remove from disk " + URLUtil.filterPasswords((String)file4.getAbsolutePath()));
                                }
                                FileSystemUtil.deleteRecursivelly((File)file4);
                            }
                        }
                    }
                    if (n2 != 0) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Update from " + URLUtil.filterPasswords((String)String.valueOf(uRL)));
                        }
                        object = resource2SynchronizeArray[i2].getInputStream();
                        file = TemporaryFilesFactory.createNonConfidentialTempFile("resource", ".zip", null);
                        ArrayList<String> arrayList2 = new ArrayList<String>();
                        try {
                            FileSystemUtil.copyInputStreamToOutputStream((InputStream)object, (OutputStream)new FileOutputStream(file), (boolean)true);
                            List list2 = FileSystemUtil.unzip((File)file, (File)this.syncDir, null);
                            for (File file5 : list2) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug("Top resource " + URLUtil.filterPasswords((String)file5.getAbsolutePath()));
                                }
                                arrayList2.add(file5.getName());
                            }
                        }
                        finally {
                            boolean bl3 = file.delete();
                            if (!bl3) {
                                logger.warn("Could not delete temporary unpacked resources.");
                            }
                        }
                        if (!arrayList2.isEmpty()) {
                            ExpandedSyncInfo expandedSyncInfo = new ExpandedSyncInfo(uRL, arrayList2.toArray(new String[0]), resource2SynchronizeArray[i2].getTimestamp(), resource2SynchronizeArray[i2].getContentLength());
                            arrayList.add(expandedSyncInfo);
                        }
                    }
                    resource2SynchronizeArray[i2].disconect();
                    continue;
                }
                catch (Exception exception) {
                    logger.warn((Object)exception, (Throwable)exception);
                    continue;
                }
                finally {
                    resource2SynchronizeArray[i2].disconect();
                }
            }
            this.syncManager.updateSyncInfo(arrayList);
        }
    }
}

