/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.api.component;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.util.Base64;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import ro.sync.ecss.extensions.api.component.AuthorComponentException;
import ro.sync.ecss.extensions.api.component.KeyGenerator;

public final class SystemPropertiesLicenseUtil {
    private static final List<String> acceptedSystemPropertiesValues = List.of("intellij.plugin.diagram.editor.accepter");
    private static final List<String> acceptedSystemProperties = List.of("external.license.plugin.diagram.editor");

    private SystemPropertiesLicenseUtil() {
    }

    public static boolean checkExternalLicense(KeyGenerator keyGenerator) throws AuthorComponentException {
        String string = SystemPropertiesLicenseUtil.getAllowedSystemProperty();
        if ("".equals(string)) {
            return false;
        }
        return SystemPropertiesLicenseUtil.checkIfSystemPropertyIsAccepted(string, keyGenerator);
    }

    private static String getAllowedSystemProperty() {
        return acceptedSystemProperties.stream().filter(string -> System.getProperty(string) != null).findFirst().orElse("");
    }

    private static boolean checkIfSystemPropertyIsAccepted(String string, KeyGenerator keyGenerator) throws AuthorComponentException {
        String string2 = SystemPropertiesLicenseUtil.decodeSystemProperty(string, keyGenerator);
        return acceptedSystemPropertiesValues.contains(string2);
    }

    private static String decodeSystemProperty(String string, KeyGenerator keyGenerator) throws AuthorComponentException {
        byte[] byArray = SystemPropertiesLicenseUtil.decryptData(string, keyGenerator);
        return new String(byArray, StandardCharsets.UTF_8);
    }

    private static byte[] decryptData(String string, KeyGenerator keyGenerator) throws AuthorComponentException {
        PrivateKey privateKey = keyGenerator.getPrivateKey();
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWITHSHA-256ANDMGF1PADDING");
            cipher.init(2, privateKey);
            String string2 = System.getProperty(string);
            byte[] byArray = Base64.getDecoder().decode(string2);
            return cipher.doFinal(byArray);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException generalSecurityException) {
            throw new AuthorComponentException(generalSecurityException);
        }
    }
}

