/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.api;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.Equaler;
import ro.sync.basic.xml.BasicXmlUtil;
import ro.sync.contentcompletion.xml.CIElement;
import ro.sync.contentcompletion.xml.WhatElementsCanGoHereContext;
import ro.sync.contentcompletion.xml.extensibility.elements.CCConfiguration;
import ro.sync.contentcompletion.xml.extensibility.elements.CCConfigurationCache;
import ro.sync.ecss.changetracking.j;
import ro.sync.ecss.css.Styles;
import ro.sync.ecss.dom.y;
import ro.sync.ecss.dom.z;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorActionEventHandler;
import ro.sync.ecss.extensions.api.AuthorActionEventHandlerBase;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorElementBaseInterface;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorSchemaManager;
import ro.sync.ecss.extensions.api.AuthorSelectionModel;
import ro.sync.ecss.extensions.api.ContentInterval;
import ro.sync.ecss.extensions.api.UniqueAttributesProcessor;
import ro.sync.ecss.extensions.api.access.AuthorEditorAccess;
import ro.sync.ecss.extensions.api.editor.IAuthorExtensionAction;
import ro.sync.ecss.extensions.api.highlights.AuthorPersistentHighlight;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.node.AuthorNodeUtil;
import ro.sync.ecss.extensions.api.node.AuthorParentNode;
import ro.sync.ecss.extensions.api.schemaaware.SchemaAwareHandlerResult;
import ro.sync.ecss.extensions.commons.operations.CommonsOperationsUtil;
import ro.sync.ecss.g.i;
import ro.sync.ecss.h.q;
import ro.sync.exml.editor.xmleditor.prettyprint.c;
import ro.sync.exml.workspace.api.editor.documenttype.DocumentTypeInformation;
import ro.sync.exml.workspace.api.node.customizer.BasicRenderingInformation;

@API(type=APIType.EXTENDABLE, src=SourceType.PUBLIC)
public class DefaultAuthorActionEventHandler
extends AuthorActionEventHandlerBase {
    private static final Logger logger = LoggerFactory.getLogger((String)DefaultAuthorActionEventHandler.class.getName());

    @Override
    public boolean handleEvent(AuthorAccess authorAccess, AuthorActionEventHandler.AuthorActionEventType authorActionEventType) {
        boolean bl;
        block14: {
            bl = false;
            AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
            int n2 = authorAccess.getEditorAccess().getCaretOffset();
            if (authorActionEventType == AuthorActionEventHandler.AuthorActionEventType.ENTER_NOT_CONSUMED) {
                String string;
                if (!authorAccess.getEditorAccess().hasSelection() && (string = this.getPreferredXMLElementContent(authorAccess)) != null) {
                    try {
                        SchemaAwareHandlerResult schemaAwareHandlerResult = authorDocumentController.insertXMLFragmentSchemaAware(string, n2);
                        bl = schemaAwareHandlerResult != null;
                    }
                    catch (AuthorOperationException authorOperationException) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)authorOperationException, (Throwable)authorOperationException);
                        }
                    }
                }
            } else {
                try {
                    if (authorActionEventType == AuthorActionEventHandler.AuthorActionEventType.TAB || authorActionEventType == AuthorActionEventHandler.AuthorActionEventType.SHIFT_TAB) {
                        if (this.canMoveListItems(authorAccess)) {
                            List<AuthorNode> list = this.getCandidates(authorAccess);
                            bl = this.handlePromoteDemote(list, authorActionEventType == AuthorActionEventHandler.AuthorActionEventType.TAB, authorAccess);
                        } else {
                            ro.sync.ecss.component.e.c c2 = new ro.sync.ecss.component.e.c(authorAccess);
                            if (authorActionEventType == AuthorActionEventHandler.AuthorActionEventType.TAB && c2.d()) {
                                c2.k();
                                bl = true;
                            } else if (authorActionEventType == AuthorActionEventHandler.AuthorActionEventType.SHIFT_TAB && c2.g()) {
                                c2.m();
                                bl = true;
                            }
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    if (!logger.isDebugEnabled()) break block14;
                    logger.debug((Object)badLocationException, (Throwable)badLocationException);
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handlePromoteDemote(List<AuthorNode> list, boolean bl, AuthorAccess authorAccess) {
        boolean bl2 = false;
        AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
        AuthorEditorAccess authorEditorAccess = authorAccess.getEditorAccess();
        AuthorSelectionModel authorSelectionModel = authorEditorAccess.getAuthorSelectionModel();
        int n2 = authorEditorAccess.getCaretOffset();
        if (list != null) {
            try {
                authorDocumentController.beginCompoundEdit();
                bl2 = true;
                boolean bl3 = true;
                boolean bl4 = authorEditorAccess.hasSelection();
                if (bl4) {
                    bl3 = authorEditorAccess.getCaretOffset() == authorSelectionModel.getSelectionInterval().getEndOffset();
                }
                ContentInterval contentInterval = null;
                contentInterval = bl ? this.demote(authorDocumentController, n2, list, bl4) : this.promote(authorDocumentController, n2, list, bl4);
                if (contentInterval != null) {
                    int n3 = contentInterval.getStartOffset();
                    int n4 = contentInterval.getEndOffset();
                    if (bl4 && !bl3) {
                        n3 = contentInterval.getEndOffset();
                        n4 = contentInterval.getStartOffset();
                    }
                    authorSelectionModel.setSelection(n3, n4);
                } else if (logger.isDebugEnabled()) {
                    logger.warn("A result must have been returned.");
                }
            }
            catch (BadLocationException | AuthorOperationException exception) {
                authorDocumentController.cancelCompoundEdit();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)exception, (Throwable)exception);
                }
            }
            finally {
                authorDocumentController.endCompoundEdit();
            }
        }
        return bl2;
    }

    protected String getPreferredXMLElementContent(AuthorAccess authorAccess) {
        StringBuilder stringBuilder = null;
        String string = this.getParagraphElement(authorAccess);
        if (string != null) {
            stringBuilder = new StringBuilder();
            String string2 = authorAccess.getDocumentController().getAuthorDocumentNode().getRootElement().getNamespace();
            stringBuilder.append("<").append(string);
            if (string2 != null) {
                stringBuilder.append(" xmlns=\"").append(string2).append("\"/>");
            } else {
                stringBuilder.append("/>");
            }
        }
        return stringBuilder != null ? stringBuilder.toString() : null;
    }

    protected String getParagraphElement(AuthorAccess authorAccess) {
        return null;
    }

    private List<AuthorNode> getCandidates(AuthorAccess authorAccess) throws BadLocationException {
        Object object;
        AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
        AuthorEditorAccess authorEditorAccess = authorAccess.getEditorAccess();
        AuthorSelectionModel authorSelectionModel = authorEditorAccess.getAuthorSelectionModel();
        ArrayList<AuthorNode> arrayList = new ArrayList<AuthorNode>();
        if (authorEditorAccess.hasSelection()) {
            object = authorSelectionModel.getSelectionInterval();
            arrayList.addAll(authorDocumentController.getNodesToSelect(((ContentInterval)object).getStartOffset(), ((ContentInterval)object).getEndOffset()));
        } else {
            object = this.isCaretInProperPlace(authorAccess);
            if (object != null) {
                arrayList.add((AuthorNode)object);
            }
        }
        if (!arrayList.isEmpty()) {
            boolean bl = true;
            if (arrayList.size() > 1) {
                AuthorNode authorNode = ((AuthorNode)arrayList.get(0)).getParent();
                for (int i2 = 1; i2 < arrayList.size(); ++i2) {
                    if (((AuthorNode)arrayList.get(i2)).getParent().equals(authorNode)) continue;
                    bl = false;
                    break;
                }
            }
            if (bl) {
                boolean bl2 = true;
                for (AuthorNode authorNode : arrayList) {
                    if (authorDocumentController.isEditable(authorNode)) continue;
                    bl2 = false;
                    break;
                }
                if (bl2) {
                    return arrayList;
                }
            }
        }
        return null;
    }

    private AuthorNode isCaretInProperPlace(AuthorAccess authorAccess) throws BadLocationException {
        AuthorNode authorNode = null;
        AuthorEditorAccess authorEditorAccess = authorAccess.getEditorAccess();
        int n2 = authorEditorAccess.getCaretOffset();
        AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
        AuthorNode authorNode2 = authorDocumentController.getNodeAtOffset(n2);
        if (authorNode2 != null) {
            while (n2 > 0 && n2 == authorNode2.getStartOffset() + 1 && !this.isMovableListItem(authorAccess, authorNode2)) {
                authorNode2 = authorDocumentController.getNodeAtOffset(--n2);
            }
            if (n2 == authorNode2.getStartOffset() + 1 && this.isMovableListItem(authorAccess, authorNode2)) {
                authorNode = authorNode2;
            }
        }
        return authorNode;
    }

    protected boolean isMovableListItem(AuthorAccess authorAccess, AuthorNode authorNode) {
        Styles styles = authorAccess.getEditorAccess().getStyles(authorNode);
        return styles.isListItem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ContentInterval promote(AuthorDocumentController authorDocumentController, int n2, List<AuthorNode> list, boolean bl) throws BadLocationException, AuthorOperationException {
        ContentInterval contentInterval = null;
        int n3 = 0;
        AuthorNode authorNode = list.get(list.size() - 1);
        int n4 = n2 - authorNode.getStartOffset();
        AuthorNode authorNode2 = list.get(0);
        AuthorElement authorElement = (AuthorElement)authorNode2.getParent();
        ++n3;
        int n5 = authorNode2.getStartOffset();
        AuthorNode authorNode3 = authorElement.getParent();
        ++n3;
        while (authorNode3 != null && !authorNode3.getName().equals(authorNode2.getName())) {
            authorNode3 = authorNode3.getParent();
            ++n3;
        }
        AuthorDocumentFragment authorDocumentFragment = authorDocumentController.createDocumentFragment(authorNode2.getStartOffset(), authorNode.getEndOffset());
        AuthorSchemaManager authorSchemaManager = authorDocumentController.getAuthorSchemaManager();
        if (authorNode3 != null && DefaultAuthorActionEventHandler.isHealthySchemaManager(authorSchemaManager)) {
            boolean bl2 = authorSchemaManager.canInsertDocumentFragment(authorDocumentFragment, authorNode3.getEndOffset() + 1, (short)4);
            if (bl2) {
                int n6;
                int n7;
                int n8;
                List<AuthorNode> list2 = authorElement.getContentNodes();
                AuthorDocumentFragment authorDocumentFragment2 = null;
                int n9 = AuthorNodeUtil.getChildIndex(authorNode.getStartOffset() + 1, list2);
                if (n9 != -1 && n9 < list2.size() - 1) {
                    n8 = list2.get(n9 + 1).getStartOffset();
                    n7 = authorElement.getEndOffset();
                    authorDocumentFragment2 = authorDocumentController.createDocumentFragment(n8, n7);
                    DefaultAuthorActionEventHandler.filterUniqueAttrs(authorDocumentController.getUniqueAttributesProcessor(), authorDocumentFragment2.getContentNodes());
                    if (logger.isDebugEnabled()) {
                        logger.debug("toMigrateFrag " + authorDocumentFragment2);
                    }
                    authorDocumentController.delete(n8, n7 - 1);
                }
                if ((n8 = authorDocumentController.delete(authorNode2.getStartOffset(), authorNode.getEndOffset())) == 0) {
                    logger.warn("Unable to delete node");
                }
                if ((n7 = authorDocumentController.split(authorNode3, n5)) == 0) throw new AuthorOperationException("Unable to split.");
                Position position = authorDocumentController.createPositionInContent(n5 + n3);
                j j2 = ((y)authorDocumentController.getAuthorDocumentNode()).sd().ic();
                boolean bl3 = j2.ib();
                try {
                    j2.hb(false);
                    DefaultAuthorActionEventHandler.compensateForSplits((i)authorDocumentController, j2, position, n3);
                }
                finally {
                    j2.hb(bl3);
                }
                int n10 = position.getOffset();
                authorDocumentController.insertFragment(n10, authorDocumentFragment);
                if (authorDocumentFragment2 != null) {
                    AuthorNode authorNode4 = authorDocumentController.getNodeAtOffset(n10 + 1);
                    List<AuthorNode> list3 = ((AuthorElement)authorNode4.getParent()).getContentNodes();
                    int n11 = AuthorNodeUtil.getChildIndex(authorNode4.getStartOffset() + 1, list3);
                    int n12 = n11 + authorDocumentFragment.getContentNodes().size() - 1;
                    authorDocumentController.insertFragment(list3.get(n12).getEndOffset(), authorDocumentFragment2);
                }
                int n13 = n6 = authorDocumentFragment2 != null ? 1 : 0;
                if (bl) {
                    contentInterval = new ContentInterval(n10, n10 + authorDocumentFragment.getLength() - n6);
                } else {
                    int n14 = n10 + n4;
                    contentInterval = new ContentInterval(n14, n14);
                }
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("No upper level to promote.");
        }
        if (contentInterval != null) return contentInterval;
        throw new AuthorOperationException("The promotion could not be performed.");
    }

    private static void filterUniqueAttrs(UniqueAttributesProcessor uniqueAttributesProcessor, List<AuthorNode> list) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            AuthorNode authorNode = list.get(i2);
            if (authorNode.getType() != 0) continue;
            AuthorElement authorElement = (AuthorElement)authorNode;
            ArrayList<String> arrayList = new ArrayList<String>();
            int n2 = authorElement.getAttributesCount();
            for (int i3 = 0; i3 < n2; ++i3) {
                String string = authorElement.getAttributeAtIndex(i3);
                if (uniqueAttributesProcessor.copyAttributeOnSplit(string, authorElement)) continue;
                arrayList.add(string);
            }
            for (String string : arrayList) {
                ((AuthorElement)authorNode).removeAttribute(string);
            }
        }
    }

    private ContentInterval demote(AuthorDocumentController authorDocumentController, int n2, List<AuthorNode> list, boolean bl) throws BadLocationException, AuthorOperationException {
        int n3;
        Object object;
        int n4;
        List<AuthorNode> list2;
        Object object2;
        ContentInterval contentInterval = null;
        int n5 = -1;
        AuthorNode authorNode = list.get(list.size() - 1);
        int n6 = n2 - authorNode.getStartOffset();
        boolean bl2 = true;
        AuthorNode authorNode2 = list.get(0);
        AuthorElement authorElement = (AuthorElement)authorNode2.getParent();
        List<AuthorNode> list3 = authorElement.getContentNodes();
        int n7 = AuthorNodeUtil.getChildIndex(authorNode2.getStartOffset() + 1, list3);
        String string = authorNode2.getName();
        if (n7 != -1) {
            if (n7 > 0) {
                object2 = list3.get(n7 - 1);
                if (logger.isDebugEnabled()) {
                    logger.debug("previous sibling : " + (AuthorNode)object2);
                }
                if (object2.getName().equals(string)) {
                    list2 = ((AuthorParentNode)object2).getContentNodes();
                    if (!list2.isEmpty()) {
                        n4 = object2.getEndOffset() - 1;
                        object = authorDocumentController.getContentInformationAtOffset(n4);
                        n3 = authorDocumentController.getContentCharSequence().charAt(n4);
                        while (object.getPositionType() != 1 && (object.getPositionType() != 0 || c.i((char)n3))) {
                            AuthorNode authorNode3 = object.getNodeForMarkerOffset();
                            if (this.areCompatibleLists(authorElement, authorNode3)) {
                                n5 = authorNode3.getEndOffset();
                                bl2 = false;
                                break;
                            }
                            n3 = authorDocumentController.getContentCharSequence().charAt(--n4);
                            object = authorDocumentController.getContentInformationAtOffset(n4);
                        }
                    }
                    if (n5 == -1) {
                        n5 = object2.getEndOffset();
                        bl2 = true;
                    }
                }
            }
        } else {
            logger.warn("Unable to find child: " + authorNode2 + " in parent " + authorElement);
        }
        if (DefaultAuthorActionEventHandler.isHealthySchemaManager((AuthorSchemaManager)(object2 = authorDocumentController.getAuthorSchemaManager()))) {
            if (n5 != -1) {
                list2 = authorDocumentController.createPositionInContent(n5);
                n4 = list2.getOffset();
                object = authorDocumentController.createDocumentFragment(authorNode2.getStartOffset(), authorNode.getEndOffset());
                if (bl2 && (n3 = this.insertElementIfPossible(authorDocumentController, authorElement, n4)) != 0) {
                    ++n4;
                }
                if (object2.canInsertDocumentFragment((AuthorDocumentFragment)object, n4, (short)1)) {
                    authorDocumentController.insertFragment(n4, (AuthorDocumentFragment)object);
                    authorDocumentController.delete(authorNode2.getStartOffset(), authorNode.getEndOffset());
                    if (bl) {
                        contentInterval = new ContentInterval(n4, n4 + ((AuthorDocumentFragment)object).getLength());
                    } else {
                        n3 = n4 + n6;
                        contentInterval = new ContentInterval(n3, n3);
                    }
                }
                if (!bl) {
                    AuthorNode authorNode4 = authorDocumentController.getContentInformationAtOffset(n4).getNodeForMarkerOffset();
                    this.promoteSubListItems(authorDocumentController, authorNode4, authorElement);
                }
            } else {
                list2 = new StringBuilder();
                ((StringBuilder)((Object)list2)).append("<").append(string);
                String string2 = authorNode2.getNamespace();
                if (string2 != null && !string2.isEmpty()) {
                    ((StringBuilder)((Object)list2)).append(" xmlns");
                    object = CommonsOperationsUtil.getPrefix(string);
                    if (object != null && !((String)object).isEmpty()) {
                        ((StringBuilder)((Object)list2)).append(":" + (String)object);
                    }
                    ((StringBuilder)((Object)list2)).append("=\"").append(string2).append("\"");
                }
                ((StringBuilder)((Object)list2)).append("><").append(authorElement.getDisplayName()).append("/>").append("</").append(authorNode2.getDisplayName()).append(">");
                object = authorDocumentController.createDocumentFragment(authorElement, true);
                n3 = object2.canInsertDocumentFragment((AuthorDocumentFragment)object, authorNode2.getStartOffset() + 1, (short)1) ? 1 : 0;
                if (n3 != 0) {
                    int n8 = authorNode2.getStartOffset();
                    int n9 = authorNode.getEndOffset();
                    authorDocumentController.surroundInFragment(((StringBuilder)((Object)list2)).toString(), n8, n9);
                    int n10 = 2;
                    contentInterval = bl ? new ContentInterval(n8 + n10, n9 + n10 + 1) : new ContentInterval(n2 + n10, n2 + n10);
                }
            }
        }
        if (contentInterval == null) {
            throw new AuthorOperationException("The demotion could not be performed.");
        }
        return contentInterval;
    }

    private boolean insertElementIfPossible(AuthorDocumentController authorDocumentController, AuthorElement authorElement, int n2) throws BadLocationException, AuthorOperationException {
        CIElement cIElement = this.getInsertableFormForElement(authorDocumentController, authorElement, n2);
        if (cIElement != null) {
            AuthorSchemaManager authorSchemaManager = authorDocumentController.getAuthorSchemaManager();
            AuthorDocumentFragment authorDocumentFragment = authorSchemaManager.createAuthorDocumentFragment(cIElement);
            authorDocumentController.insertFragment(n2, authorDocumentFragment);
            AuthorNode authorNode = authorDocumentController.getNodeAtOffset(n2 + 1);
            DefaultAuthorActionEventHandler.deleteNodeChildren(authorDocumentController, authorNode);
            return true;
        }
        return false;
    }

    private static void deleteNodeChildren(AuthorDocumentController authorDocumentController, AuthorNode authorNode) {
        int n2;
        int n3 = authorNode.getStartOffset() + 1;
        if (n3 <= (n2 = authorNode.getEndOffset() - 1)) {
            authorDocumentController.delete(n3, n2);
        }
    }

    private CIElement getInsertableFormForElement(AuthorDocumentController authorDocumentController, AuthorElement authorElement, int n2) throws BadLocationException {
        AuthorSchemaManager authorSchemaManager = authorDocumentController.getAuthorSchemaManager();
        WhatElementsCanGoHereContext whatElementsCanGoHereContext = authorSchemaManager.createWhatElementsCanGoHereContext(n2);
        return authorSchemaManager.whatElementsCanGoHere(whatElementsCanGoHereContext).stream().filter(cIElement -> BasicXmlUtil.getLocalName((String)cIElement.getName()).equals(authorElement.getLocalName()) && Equaler.verifyNamespaceEquals((String)cIElement.getNamespace(), (String)authorElement.getNamespace())).findAny().orElse(null);
    }

    protected void promoteSubListItems(AuthorDocumentController authorDocumentController, AuthorNode authorNode, AuthorNode authorNode2) throws BadLocationException, AuthorOperationException {
        AuthorElement authorElement;
        List<AuthorNode> list;
        if (authorNode instanceof AuthorElement && !(list = (authorElement = (AuthorElement)authorNode).getContentNodes()).isEmpty()) {
            AuthorNode authorNode3 = null;
            int n2 = 0;
            for (int i2 = 0; i2 < list.size(); ++i2) {
                authorNode3 = list.get(i2);
                if (!this.isList(authorNode3)) continue;
                ++n2;
            }
            if (n2 == 1 && authorNode3 != null && authorNode3.getEndOffset() + 1 == authorElement.getEndOffset() && authorNode3 instanceof AuthorElement) {
                AuthorElement authorElement2 = (AuthorElement)authorNode3;
                List<AuthorNode> list2 = authorElement2.getContentNodes();
                if (this.areCompatibleLists(authorNode3, authorNode2)) {
                    this.promote(authorDocumentController, 0, list2, false);
                }
            }
        }
    }

    protected boolean isList(AuthorNode authorNode) {
        boolean bl = false;
        if (authorNode != null) {
            String string = CommonsOperationsUtil.getLocalName(authorNode.getName());
            bl = "ul".equals(string) || "ol".equals(string);
        }
        return bl;
    }

    protected boolean areCompatibleLists(AuthorNode authorNode, AuthorNode authorNode2) {
        boolean bl = false;
        if (authorNode != null && authorNode2 != null) {
            String string = authorNode.getName();
            String string2 = authorNode2.getName();
            String string3 = CommonsOperationsUtil.getLocalName(string);
            String string4 = CommonsOperationsUtil.getLocalName(string2);
            String string5 = authorNode.getNamespace();
            String string6 = authorNode2.getNamespace();
            boolean bl2 = this.isList(authorNode) && this.isList(authorNode2) && string5.equals(string6) && string3.equals(string4);
            bl = bl2 || "ul".equals(string3) && "ol".equals(string4) || "ol".equals(string3) && "ul".equals(string4);
        }
        return bl;
    }

    private static boolean isHealthySchemaManager(AuthorSchemaManager authorSchemaManager) {
        return authorSchemaManager != null && !authorSchemaManager.hasLoadingErrors() && !authorSchemaManager.isLearnSchema();
    }

    private static void compensateForSplits(i i2, j j2, Position position, int n2) throws BadLocationException {
        AuthorNode authorNode;
        int n3;
        if (logger.isDebugEnabled()) {
            logger.debug("Marker offset " + position);
        }
        AuthorNode authorNode2 = null;
        for (n3 = n2; n3 > 0; --n3) {
            authorNode = i2.getNodeAtOffset(position.getOffset() - n3);
            if (logger.isDebugEnabled()) {
                logger.debug("Step " + n3 + " node " + authorNode);
            }
            if (authorNode.getStartOffset() + 2 * (n2 - n3) + 1 != authorNode.getEndOffset()) continue;
            authorNode2 = authorNode;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("to delete " + authorNode2);
        }
        if (authorNode2 != null) {
            DefaultAuthorActionEventHandler.removeSplitMarkers(i2, j2, authorNode2.getStartOffset());
            DefaultAuthorActionEventHandler.removeSplitMarkers(i2, j2, authorNode2.getEndOffset());
            i2.deleteNode(authorNode2);
        }
        authorNode2 = null;
        for (n3 = n2; n3 > 0; --n3) {
            authorNode = i2.getNodeAtOffset(position.getOffset() + n3);
            if (authorNode.getStartOffset() + 2 * (n2 - n3) + 1 != authorNode.getEndOffset()) continue;
            authorNode2 = authorNode;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("to delete " + authorNode2);
        }
        if (authorNode2 != null) {
            DefaultAuthorActionEventHandler.removeSplitMarkers(i2, j2, authorNode2.getStartOffset());
            DefaultAuthorActionEventHandler.removeSplitMarkers(i2, j2, authorNode2.getEndOffset());
            i2.deleteNode(authorNode2);
        }
    }

    private static void removeSplitMarkers(i i2, j j2, int n2) {
        List<q> list = j2.h(n2, n2, false);
        if (list != null) {
            for (int i3 = 0; i3 < list.size(); ++i3) {
                q q2 = list.get(i3);
                if (q2.getType() != AuthorPersistentHighlight.PersistentHighlightType.CHANGE_INSERT || !"split".equals(q2.y())) continue;
                i2.vd(q2);
            }
        }
    }

    @Override
    public boolean canHandleEvent(AuthorAccess authorAccess, AuthorActionEventHandler.AuthorActionEventType authorActionEventType) {
        boolean bl = false;
        if (authorActionEventType == AuthorActionEventHandler.AuthorActionEventType.TAB || authorActionEventType == AuthorActionEventHandler.AuthorActionEventType.SHIFT_TAB) {
            try {
                bl = this.canMoveListItems(authorAccess) || this.canChangeCodeblockIndentation(authorAccess, authorActionEventType);
            }
            catch (BadLocationException badLocationException) {
                if (logger.isDebugEnabled()) {
                    logger.error((Object)badLocationException, (Throwable)badLocationException);
                }
            }
        } else if (authorActionEventType == AuthorActionEventHandler.AuthorActionEventType.ENTER_NOT_CONSUMED) {
            bl = this.getPreferredXMLElementContent(authorAccess) != null;
        }
        return bl;
    }

    private boolean canChangeCodeblockIndentation(AuthorAccess authorAccess, AuthorActionEventHandler.AuthorActionEventType authorActionEventType) {
        ro.sync.ecss.component.e.c c2 = new ro.sync.ecss.component.e.c(authorAccess);
        return authorActionEventType == AuthorActionEventHandler.AuthorActionEventType.TAB && c2.d() || authorActionEventType == AuthorActionEventHandler.AuthorActionEventType.SHIFT_TAB && c2.g();
    }

    private boolean canMoveListItems(AuthorAccess authorAccess) throws BadLocationException {
        List<AuthorNode> list = this.getCandidates(authorAccess);
        boolean bl = false;
        if (list != null) {
            bl = true;
            for (AuthorNode authorNode : list) {
                if (this.isMovableListItem(authorAccess, authorNode)) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    @Override
    public String getDescription() {
        return "Handles Author action events in a special manner";
    }

    @Override
    public List<IAuthorExtensionAction> getContentCompletionActions(AuthorAccess authorAccess, int n2) {
        ArrayList<IAuthorExtensionAction> arrayList = null;
        try {
            AuthorElement authorElement;
            AuthorNode authorNode = authorAccess.getDocumentController().getNodeAtOffset(n2);
            if (authorNode instanceof AuthorElement && (authorElement = DefaultAuthorActionEventHandler.getLastListItemToConvert(authorAccess, (AuthorElement)authorNode)) != null) {
                boolean bl = DefaultAuthorActionEventHandler.isInsideNestedList(authorAccess, authorElement);
                arrayList = new ArrayList<IAuthorExtensionAction>();
                if (bl) {
                    arrayList.add(this.getUnindentListItemAction(authorAccess, authorElement));
                } else {
                    IAuthorExtensionAction iAuthorExtensionAction = this.getConvertListItemToParaAction(authorAccess, authorElement);
                    if (iAuthorExtensionAction != null) {
                        arrayList.add(iAuthorExtensionAction);
                    }
                }
            }
        }
        catch (BadLocationException badLocationException) {
            logger.error((Object)badLocationException, (Throwable)badLocationException);
        }
        return arrayList;
    }

    private IAuthorExtensionAction getConvertListItemToParaAction(final AuthorAccess authorAccess, final AuthorElement authorElement) {
        IAuthorExtensionAction iAuthorExtensionAction = null;
        final String string = this.getPreferredXMLElementContent(authorAccess);
        if (string != null) {
            final HashMap<String, String> hashMap = new HashMap<String, String>();
            final String string2 = this.getParagraphElement(authorAccess);
            String string3 = DefaultAuthorActionEventHandler.getConvertToActionName(authorAccess, authorElement, string2);
            hashMap.put("action_name", string3);
            String string4 = authorAccess.getAuthorResourceBundle().getMessage("delete_empty_li_insert_paragraph");
            string4 = MessageFormat.format(string4, authorElement.getName(), string2);
            hashMap.put("description", string4);
            if (logger.isDebugEnabled()) {
                logger.debug("CC " + string3 + " " + string4 + " for element = " + authorElement);
            }
            iAuthorExtensionAction = new IAuthorExtensionAction(){

                @Override
                public void performAction(int n2) {
                    try {
                        AuthorNode authorNode = authorElement.getParent();
                        if (authorNode != null && authorNode.getType() == 0) {
                            AuthorElement authorElement2 = (AuthorElement)authorNode;
                            AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
                            ((i)authorDocumentController).ge(n2, n2);
                            Position position = authorDocumentController.createPositionInContent(authorElement.getEndOffset() + 1);
                            Styles styles = authorAccess.getEditorAccess().getStyles(authorElement);
                            if (styles.isListItem()) {
                                position = authorDocumentController.createPositionInContent(authorElement2.getEndOffset() + 1);
                                AuthorElementBaseInterface authorElementBaseInterface = authorElement2.getParentElement();
                                if (authorElementBaseInterface != null && Equaler.verifyEquals((Object)string2, (Object)authorElementBaseInterface.getLocalName())) {
                                    position = authorElementBaseInterface.getEndOffset() - authorElement.getEndOffset() <= 2 ? authorDocumentController.createPositionInContent(authorElementBaseInterface.getEndOffset() + 1) : authorDocumentController.createPositionInContent(authorNode.getEndOffset() + 1);
                                }
                            }
                            authorDocumentController.deleteNode(authorElement);
                            int n3 = position.getOffset();
                            ((i)authorDocumentController).ge(n3, n2);
                            authorDocumentController.insertXMLFragmentSchemaAware(string, n3);
                            int n4 = authorAccess.getEditorAccess().getCaretOffset();
                            ((i)authorDocumentController).ge(n4, n4);
                        }
                    }
                    catch (Exception exception) {
                        logger.error((Object)exception, (Throwable)exception);
                    }
                }

                @Override
                public void performAction() {
                    this.performAction(authorAccess.getEditorAccess().getCaretOffset());
                }

                @Override
                public Object getValue(String string3) {
                    return hashMap.get(string3);
                }
            };
        }
        return iAuthorExtensionAction;
    }

    private IAuthorExtensionAction getUnindentListItemAction(final AuthorAccess authorAccess, final AuthorElement authorElement) {
        final HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = authorAccess.getAuthorResourceBundle().getMessage("Unindent");
        string = MessageFormat.format(string, authorElement.getName());
        hashMap.put("action_name", string);
        String string2 = authorAccess.getAuthorResourceBundle().getMessage("Unindent_current_element");
        string2 = MessageFormat.format(string2, authorElement.getName());
        hashMap.put("description", string2);
        return new IAuthorExtensionAction(){

            @Override
            public void performAction(int n2) {
                ArrayList<AuthorNode> arrayList = new ArrayList<AuthorNode>();
                arrayList.add(authorElement);
                DefaultAuthorActionEventHandler.this.handlePromoteDemote(arrayList, false, authorAccess);
            }

            @Override
            public void performAction() {
                this.performAction(authorAccess.getEditorAccess().getCaretOffset());
            }

            @Override
            public Object getValue(String string) {
                return hashMap.get(string);
            }
        };
    }

    private static boolean isInsideNestedList(AuthorAccess authorAccess, AuthorElement authorElement) {
        Styles styles;
        boolean bl = false;
        AuthorNode authorNode = authorElement.getParent();
        if (authorNode != null && authorNode.getType() == 0 && (authorNode = authorNode.getParent()) != null && authorNode.getType() == 0 && (styles = authorAccess.getEditorAccess().getStyles(authorNode)).isListItem()) {
            bl = true;
        }
        return bl;
    }

    private static String getConvertToActionName(AuthorAccess authorAccess, AuthorElement authorElement, String string) {
        String string2 = authorAccess.getAuthorResourceBundle().getMessage("convert_element_from_to");
        String string3 = authorElement.getName();
        String string4 = string;
        DocumentTypeInformation documentTypeInformation = authorAccess.getEditorAccess().getDocumentTypeInformation();
        if (documentTypeInformation != null) {
            BasicRenderingInformation basicRenderingInformation;
            String string5 = documentTypeInformation.getID();
            CCConfiguration cCConfiguration = CCConfigurationCache.getInstance().getConfiguration(string5);
            BasicRenderingInformation basicRenderingInformation2 = cCConfiguration.getRenderingInformation(new QName(authorElement.getNamespace(), authorElement.getLocalName()));
            if (basicRenderingInformation2 != null) {
                string3 = basicRenderingInformation2.getRenderedText();
            }
            if ((basicRenderingInformation = cCConfiguration.getRenderingInformation(new QName(string))) != null) {
                string4 = basicRenderingInformation.getRenderedText();
            }
        }
        return MessageFormat.format(string2, string3, string4);
    }

    private static AuthorElement getLastListItemToConvert(AuthorAccess authorAccess, AuthorElement authorElement) {
        AuthorElement authorElement2 = null;
        Styles styles = authorAccess.getEditorAccess().getStyles(authorElement);
        z z2 = (z)authorElement;
        if (z2.cb()) {
            if (styles.isListItem() && z2.db()) {
                authorElement2 = DefaultAuthorActionEventHandler.extractElementInternal(authorElement);
            } else {
                AuthorNode authorNode = authorElement.getParent();
                if (authorNode != null && authorNode.getType() == 0) {
                    Styles styles2 = authorAccess.getEditorAccess().getStyles(authorNode);
                    z z3 = (z)authorNode;
                    if (styles2.isListItem() && z3.db()) {
                        boolean bl;
                        boolean bl2 = bl = z3.getStartOffset() + 1 == authorElement.getStartOffset() && authorElement.getEndOffset() + 1 == z3.getEndOffset();
                        if (bl) {
                            authorElement2 = DefaultAuthorActionEventHandler.extractElementInternal(z3);
                        }
                    }
                }
            }
        }
        return authorElement2;
    }

    private static AuthorElement extractElementInternal(AuthorElement authorElement) {
        AuthorElement authorElement2 = authorElement;
        if (((z)authorElement).u()) {
            authorElement2 = ((z)authorElement).x();
        }
        return authorElement2;
    }
}

