/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.api;

import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.dita.DITAAccess;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorActionEventDetails;
import ro.sync.ecss.extensions.api.AuthorActionEventHandler;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.DefaultAuthorActionEventHandler;
import ro.sync.ecss.extensions.api.access.AuthorEditorAccess;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.schemaaware.SchemaAwareHandlerResult;

@API(type=APIType.NOT_EXTENDABLE, src=SourceType.PUBLIC)
public class DITAAuthorActionEventHandler
extends DefaultAuthorActionEventHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)DITAAuthorActionEventHandler.class.getName());

    @Override
    protected boolean isMovableListItem(AuthorAccess authorAccess, AuthorNode authorNode) {
        AuthorElement authorElement;
        AttrValue attrValue;
        boolean bl = false;
        if (authorNode instanceof AuthorElement && (attrValue = (authorElement = (AuthorElement)authorNode).getAttribute("class")) != null && attrValue.getValue().contains(" topic/li ") && !attrValue.getValue().contains(" task/step ")) {
            bl = super.isMovableListItem(authorAccess, authorNode);
        }
        return bl;
    }

    @Override
    protected boolean isList(AuthorNode authorNode) {
        AuthorElement authorElement;
        AttrValue attrValue;
        boolean bl = false;
        if (authorNode instanceof AuthorElement && (attrValue = (authorElement = (AuthorElement)authorNode).getAttribute("class")) != null) {
            String string = attrValue.getValue();
            bl = string.contains(" topic/ol ") || string.contains(" topic/ul ");
        }
        return bl;
    }

    @Override
    protected String getParagraphElement(AuthorAccess authorAccess) {
        return DITAAccess.getPossibleElementQName(authorAccess.getDocumentController(), " topic/p ", "p");
    }

    @Override
    protected boolean areCompatibleLists(AuthorNode authorNode, AuthorNode authorNode2) {
        boolean bl = false;
        if (authorNode instanceof AuthorElement && authorNode2 instanceof AuthorElement) {
            AuthorElement authorElement = (AuthorElement)authorNode;
            AuthorElement authorElement2 = (AuthorElement)authorNode2;
            String string = authorNode.getNamespace();
            String string2 = authorNode2.getNamespace();
            AttrValue attrValue = authorElement.getAttribute("class");
            AttrValue attrValue2 = authorElement2.getAttribute("class");
            if (attrValue != null && attrValue2 != null) {
                String string3 = attrValue.getValue();
                String string4 = attrValue2.getValue();
                bl = this.isList(authorNode) && this.isList(authorNode2) && string.equals(string2) && (string3.equals(string4) || string3.contains(" topic/ol ") && string4.contains(" topic/ul ") || string3.contains(" topic/ul ") && string4.contains(" topic/ol "));
            }
        }
        return bl;
    }

    @Override
    public AuthorElement getListItemAncestorToSplit(AuthorNode authorNode, AuthorAccess authorAccess) {
        AuthorNode authorNode2;
        if (authorNode.getType() == 0 && this.matchesClass((AuthorElement)authorNode, "topic/dd") && (authorNode2 = authorNode.getParent()) != null && authorNode2.getType() == 0 && this.matchesClass((AuthorElement)authorNode2, "topic/dlentry")) {
            return (AuthorElement)authorNode2;
        }
        return super.getListItemAncestorToSplit(authorNode, authorAccess);
    }

    private boolean matchesClass(AuthorElement authorElement, String string) {
        AttrValue attrValue = authorElement.getAttribute("class");
        if (attrValue != null) {
            String string2 = attrValue.getValue();
            return string2.contains(" " + string + " ");
        }
        return false;
    }

    @Override
    public boolean handleEvent(AuthorAccess authorAccess, AuthorActionEventHandler.AuthorActionEventType authorActionEventType) {
        boolean bl = false;
        if (authorActionEventType == AuthorActionEventHandler.AuthorActionEventType.ENTER_NOT_CONSUMED) {
            bl = this.handleEnterInBeforeSectionTitle(authorAccess);
        } else if (authorActionEventType == AuthorActionEventHandler.AuthorActionEventType.ENTER && this.isCaretAtTableEnd(authorAccess)) {
            bl = this.handleEnterAtTableEnd(authorAccess);
        }
        if (!bl) {
            bl = super.handleEvent(authorAccess, authorActionEventType);
        }
        return bl;
    }

    private boolean handleEnterAtTableEnd(AuthorAccess authorAccess) {
        boolean bl;
        block3: {
            bl = false;
            try {
                AuthorEditorAccess authorEditorAccess = authorAccess.getEditorAccess();
                int n2 = authorEditorAccess.getCaretOffset();
                AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
                String string = this.getPreferredXMLElementContent(authorAccess);
                if (string != null) {
                    SchemaAwareHandlerResult schemaAwareHandlerResult = authorDocumentController.insertXMLFragmentSchemaAware(string, n2);
                    bl = schemaAwareHandlerResult != null;
                }
            }
            catch (AuthorOperationException authorOperationException) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug((Object)authorOperationException, (Throwable)authorOperationException);
            }
        }
        return bl;
    }

    private boolean handleEnterInBeforeSectionTitle(AuthorAccess authorAccess) {
        boolean bl;
        block3: {
            String string;
            AuthorElement authorElement;
            bl = false;
            if (this.isCaretBeforeSectionTitle(authorAccess) && (authorElement = this.getSectionBeforeTitle(authorAccess)) != null && (string = this.getPreferredXMLElementContent(authorAccess)) != null) {
                try {
                    int n2 = authorElement.getEndOffset();
                    AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
                    SchemaAwareHandlerResult schemaAwareHandlerResult = authorDocumentController.insertXMLFragmentSchemaAware(string, n2);
                    bl = schemaAwareHandlerResult != null;
                }
                catch (AuthorOperationException authorOperationException) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug((Object)authorOperationException, (Throwable)authorOperationException);
                }
            }
        }
        return bl;
    }

    private boolean isCaretBeforeSectionTitle(AuthorAccess authorAccess) {
        AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
        AuthorEditorAccess authorEditorAccess = authorAccess.getEditorAccess();
        if (!authorEditorAccess.hasSelection()) {
            try {
                AuthorNode authorNode;
                AuthorNode authorNode2 = authorDocumentController.getNodeAtOffset(authorEditorAccess.getCaretOffset());
                if (authorNode2 != null && authorNode2.getType() == 0 && this.matchesClass((AuthorElement)authorNode2, "topic/title") && authorNode2.getStartOffset() + 1 == authorEditorAccess.getCaretOffset() && (authorNode = authorNode2.getParent()) != null && authorNode.getType() == 0 && this.matchesClass((AuthorElement)authorNode, "topic/section")) {
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return false;
    }

    private AuthorElement getSectionBeforeTitle(AuthorAccess authorAccess) {
        AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
        int n2 = authorAccess.getEditorAccess().getCaretOffset();
        try {
            AuthorNode authorNode = authorDocumentController.getNodeAtOffset(n2);
            AuthorNode authorNode2 = authorNode.getParent();
            AuthorNode authorNode3 = authorDocumentController.getNodeAtOffset(authorNode2.getStartOffset() - 1);
            if (authorNode3 != null && authorNode3.getType() == 0 && this.matchesClass((AuthorElement)authorNode3, "topic/section") && authorNode3 != authorNode2) {
                return (AuthorElement)authorNode3;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public boolean canHandleEvent(AuthorAccess authorAccess, AuthorActionEventDetails authorActionEventDetails) {
        boolean bl = false;
        AuthorActionEventHandler.AuthorActionEventType authorActionEventType = authorActionEventDetails.getEventType();
        if (authorActionEventType == AuthorActionEventHandler.AuthorActionEventType.ENTER) {
            bl = this.shouldHandleEnter(authorAccess, authorActionEventDetails.isShowContentCompletionWindowOnEnter());
        }
        if (!bl) {
            bl = super.canHandleEvent(authorAccess, authorActionEventDetails);
        }
        return bl;
    }

    private boolean shouldHandleEnter(AuthorAccess authorAccess, boolean bl) {
        return !bl && this.isCaretAtTableEnd(authorAccess);
    }

    private boolean isCaretAtTableEnd(AuthorAccess authorAccess) {
        boolean bl = false;
        try {
            AuthorEditorAccess authorEditorAccess = authorAccess.getEditorAccess();
            int n2 = authorEditorAccess.getCaretOffset();
            AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
            AuthorNode authorNode = authorDocumentController.getNodeAtOffset(n2);
            if (authorNode.getType() == 0) {
                AuthorElement authorElement = (AuthorElement)authorNode;
                AttrValue attrValue = authorElement.getAttribute("class");
                boolean bl2 = authorElement.getEndOffset() == n2;
                boolean bl3 = attrValue != null && (attrValue.getValue().contains(" topic/table ") || attrValue.getValue().contains(" topic/tgroup "));
                bl = bl2 && bl3;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return bl;
    }
}

