/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.api;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorInputEvent;

@API(type=APIType.NOT_EXTENDABLE, src=SourceType.PUBLIC)
public class AuthorMouseEvent
extends AuthorInputEvent {
    public static final int STATE_PRESSED = 1;
    public static final int STATE_RELEASED = 2;
    public static final int STATE_CLICKED = 3;
    public static final int STATE_MOVED = 4;
    public static final int STATE_DRAGGED = 5;
    public static final int STATE_WHEEL_MOVED = 6;
    public static final int BUTTON1 = 1;
    public static final int BUTTON2 = 2;
    public static final int BUTTON3 = 3;
    public static final int NOBUTTON = 0;
    public final int X;
    public final int Y;
    public final boolean popupTrigger;
    public final int clickCount;
    public final int button;
    public final int state;
    public final boolean wheelUp;

    public AuthorMouseEvent(int n2, int n3, boolean bl, int n4, int n5, int n6) {
        this(n2, n3, bl, n4, n5, n6, 0, false);
    }

    public AuthorMouseEvent(int n2, int n3, boolean bl, int n4, int n5, int n6, int n7) {
        this(n2, n3, bl, n4, n5, n6, n7, false);
    }

    public AuthorMouseEvent(int n2, int n3, boolean bl, int n4, int n5, int n6, int n7, boolean bl2) {
        super(n5);
        this.X = n2;
        this.Y = n3;
        this.popupTrigger = bl;
        this.state = n4;
        this.clickCount = n6;
        this.button = n7;
        this.wheelUp = bl2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Author mouse event, type: ");
        stringBuilder.append(this.getStateDescription(this.getState()));
        stringBuilder.append(", x: ").append(this.getX());
        stringBuilder.append(", y: ").append(this.getY());
        stringBuilder.append(", consumed: ").append(this.isConsumed());
        stringBuilder.append(", modifiers: ").append(this.getModifiers());
        stringBuilder.append(", clicks: ").append(this.getClickCount());
        if (this.state == 6) {
            stringBuilder.append(", wheelUp: ").append(this.wheelUp);
        }
        return stringBuilder.toString();
    }

    protected String getStateDescription(int n2) {
        String string = "unknown";
        switch (n2) {
            case 3: {
                string = "clicked";
                break;
            }
            case 1: {
                string = "pressed";
                break;
            }
            case 2: {
                string = "released";
                break;
            }
            case 4: {
                string = "moved";
                break;
            }
            case 5: {
                string = "dragged";
                break;
            }
            case 6: {
                string = "wheel_moved";
            }
        }
        return string;
    }

    public int getClickCount() {
        return this.clickCount;
    }

    public int getButton() {
        return this.button;
    }

    public boolean isPopupTrigger() {
        return this.popupTrigger;
    }

    public int getX() {
        return this.X;
    }

    public int getY() {
        return this.Y;
    }

    public int getState() {
        return this.state;
    }
}

