/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.api;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.PlatformDetector;

@API(type=APIType.NOT_EXTENDABLE, src=SourceType.PUBLIC)
public abstract class AuthorInputEvent {
    public static final int SHIFT_PRESSED = 1;
    public static final int CTRL_PRESSED = 2;
    public static final int META_PRESSED = 4;
    public static final int ALT_PRESSED = 8;
    public static final int ALT_GRAPH_PRESSED = 32;
    public final int modifiers;
    public boolean consumed;

    public AuthorInputEvent(int n2) {
        this.modifiers = n2;
    }

    public void consume() {
        this.consumed = true;
    }

    public final boolean isConsumed() {
        return this.consumed;
    }

    public boolean isShiftPressed() {
        return (this.modifiers & 1) != 0;
    }

    public final boolean isCtrlPressed() {
        return AuthorInputEvent.isCtrlPressed(this.modifiers);
    }

    public final boolean isAltPressed() {
        return (this.modifiers & 8) != 0;
    }

    public final boolean isAltGraphPressed() {
        return (this.modifiers & 0x20) != 0;
    }

    public final boolean isMetaPressed() {
        return AuthorInputEvent.isMetaPressed(this.modifiers);
    }

    public int getModifiers() {
        return this.modifiers;
    }

    private static boolean isCtrlPressed(int n2) {
        return (n2 & 2) != 0;
    }

    private static boolean isMetaPressed(int n2) {
        return (n2 & 4) != 0;
    }

    public final boolean isCommandPressed() {
        return AuthorInputEvent.isCommandPressed(this.getModifiers());
    }

    public static boolean isCommandPressed(int n2) {
        return PlatformDetector.isMacOS() ? AuthorInputEvent.isMetaPressed(n2) : AuthorInputEvent.isCtrlPressed(n2);
    }
}

