/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.node.AuthorNode;

@API(type=APIType.NOT_EXTENDABLE, src=SourceType.PUBLIC)
public class AuthorCaretEvent {
    private final int offset;
    private final AuthorNode node;
    private final List<int[]> selection;

    public AuthorCaretEvent(int n2, List<int[]> list, AuthorNode authorNode) {
        this.offset = n2;
        if (list == null || list.isEmpty()) {
            list = new ArrayList<int[]>(1);
            list.add(new int[]{1, 1});
        } else {
            list = new ArrayList<int[]>(list);
        }
        this.selection = new ArrayList<int[]>(list);
        this.node = authorNode;
    }

    public int getOffset() {
        return this.offset;
    }

    public AuthorNode getNode() {
        return this.node;
    }

    public int getSelectionStart() {
        return this.selection.get(this.selection.size() - 1)[0];
    }

    public int getSelectionEnd() {
        return this.selection.get(this.selection.size() - 1)[1];
    }

    public List<int[]> getSelectionIntervals() {
        return this.selection;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Caret moved event node ").append(this.node).append(" offset ").append(this.offset);
        List<int[]> list = this.getSelectionIntervals();
        if (list != null && !list.isEmpty()) {
            Iterator<int[]> iterator = list.iterator();
            while (iterator.hasNext()) {
                int[] nArray = iterator.next();
                stringBuilder.append("Sel: ").append(Arrays.toString(nArray));
                if (!iterator.hasNext()) continue;
                stringBuilder.append(" ");
            }
        }
        return stringBuilder.toString();
    }
}

