/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.dom.wrappers.mutable;

import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.text.BadLocationException;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.value.EmptySequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import ro.sync.ecss.contentcompletion.d;
import ro.sync.ecss.css.functions.g;
import ro.sync.ecss.dom.wrappers.mutable.AuthorSource;
import ro.sync.ecss.dom.wrappers.mutable.DOMNodeWrapper;
import ro.sync.ecss.dom.wrappers.mutable.DocumentWrapper;
import ro.sync.ecss.dom.wrappers.mutable.MutableDOMNodeWrapper;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorSelectionModel;
import ro.sync.ecss.extensions.api.ContentInterval;
import ro.sync.ecss.extensions.api.access.AuthorEditorAccess;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.node.NamespaceContext;

public class MutableNodeModelBuilder {
    private static final String SELECTION_PARAM = "selection";
    private static final String OXY_NAMESPACE = "http://www.oxygenxml.com/ns/xqu";
    private static final String OXY_PREFIX = "oxyxq";
    private static final Logger logger = LoggerFactory.getLogger((String)MutableNodeModelBuilder.class.getName());

    static NodeInfo build(AuthorSource authorSource, Configuration configuration) {
        Node node = authorSource.getNode();
        Document document = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
        if (logger.isDebugEnabled()) {
            logger.debug("Wrap " + document);
        }
        DocumentWrapper documentWrapper = new DocumentWrapper(document, authorSource.getSystemId(), configuration);
        return documentWrapper.wrap(document);
    }

    public static DOMNodeWrapper makeWrapper(Node node, DocumentWrapper documentWrapper, DOMNodeWrapper dOMNodeWrapper, int n2) {
        MutableDOMNodeWrapper mutableDOMNodeWrapper;
        switch (node.getNodeType()) {
            case 9: 
            case 11: {
                mutableDOMNodeWrapper = (MutableDOMNodeWrapper)documentWrapper.getRootNode();
                if (mutableDOMNodeWrapper != null) break;
                mutableDOMNodeWrapper = new MutableDOMNodeWrapper(node, documentWrapper, dOMNodeWrapper, n2);
                mutableDOMNodeWrapper.nodeKind = (short)9;
                break;
            }
            case 1: {
                mutableDOMNodeWrapper = new MutableDOMNodeWrapper(node, documentWrapper, dOMNodeWrapper, n2);
                mutableDOMNodeWrapper.setNodeKind((short)1);
                break;
            }
            case 2: {
                mutableDOMNodeWrapper = new MutableDOMNodeWrapper(node, documentWrapper, dOMNodeWrapper, n2);
                mutableDOMNodeWrapper.setNodeKind((short)2);
                break;
            }
            case 3: 
            case 4: {
                mutableDOMNodeWrapper = new MutableDOMNodeWrapper(node, documentWrapper, dOMNodeWrapper, n2);
                mutableDOMNodeWrapper.setNodeKind((short)3);
                break;
            }
            case 8: {
                mutableDOMNodeWrapper = new MutableDOMNodeWrapper(node, documentWrapper, dOMNodeWrapper, n2);
                mutableDOMNodeWrapper.setNodeKind((short)8);
                break;
            }
            case 7: {
                mutableDOMNodeWrapper = new MutableDOMNodeWrapper(node, documentWrapper, dOMNodeWrapper, n2);
                mutableDOMNodeWrapper.setNodeKind((short)7);
                break;
            }
            case 5: {
                throw new IllegalStateException("DOM contains entity reference nodes, which Saxon does not support. The DOM should be built using the expandEntityReferences() option");
            }
            default: {
                throw new IllegalArgumentException("Unsupported node type in DOM! " + node.getNodeType() + " instance " + node.toString());
            }
        }
        mutableDOMNodeWrapper.setTreeInfo(documentWrapper);
        return mutableDOMNodeWrapper;
    }

    private static void setContextNode(AuthorAccess authorAccess, NodeInfo nodeInfo, Configuration configuration, DynamicQueryContext dynamicQueryContext) {
        NamespaceContext namespaceContext;
        String string = MutableNodeModelBuilder.getLocationXpathExpression(authorAccess);
        NodeInfo nodeInfo2 = MutableNodeModelBuilder.getNodesByXPath(nodeInfo, configuration, string, namespaceContext = g.b(authorAccess.getDocumentController().getAuthorDocumentNode(), d.t()));
        if (nodeInfo2 != null) {
            dynamicQueryContext.setContextItem((Item)nodeInfo2);
        } else {
            dynamicQueryContext.setContextItem((Item)nodeInfo);
        }
    }

    private static String getLocationXpathExpression(AuthorAccess authorAccess) {
        if (authorAccess != null) {
            try {
                AuthorEditorAccess authorEditorAccess = authorAccess.getEditorAccess();
                if (authorEditorAccess != null) {
                    int n2 = authorEditorAccess.getCaretOffset();
                    AuthorNode authorNode = authorEditorAccess.getFullySelectedNode();
                    if (authorNode != null) {
                        n2 = authorNode.getStartOffset() + 1;
                    }
                    return authorAccess.getDocumentController().getXPathExpression(n2);
                }
            }
            catch (BadLocationException badLocationException) {
                logger.error((Object)badLocationException, (Throwable)badLocationException);
            }
        }
        return null;
    }

    private static NodeInfo getNodesByXPath(NodeInfo nodeInfo, Configuration configuration, String string, NamespaceContext namespaceContext) {
        XdmNode xdmNode = null;
        if (string != null && string.trim().length() > 0) {
            String string2;
            DocumentBuilder documentBuilder;
            Processor processor = new Processor(configuration);
            XPathCompiler xPathCompiler = processor.newXPathCompiler();
            if (namespaceContext != null) {
                for (DocumentBuilder documentBuilder2 : documentBuilder = namespaceContext.getNamespaces()) {
                    string2 = namespaceContext.getPrefixForNamespace((String)documentBuilder2);
                    xPathCompiler.declareNamespace(string2, (String)documentBuilder2);
                }
            }
            documentBuilder = processor.newDocumentBuilder();
            DocumentBuilder documentBuilder3 = documentBuilder.wrap((Object)nodeInfo);
            try {
                DocumentBuilder documentBuilder2;
                XPathExecutable xPathExecutable = xPathCompiler.compile(string);
                XPathSelector xPathSelector = xPathExecutable.load();
                xPathSelector.setContextItem((XdmItem)documentBuilder3);
                documentBuilder2 = xPathSelector.iterator();
                if (documentBuilder2 != null && documentBuilder2.hasNext()) {
                    string2 = (XdmItem)documentBuilder2.next();
                    XdmNode xdmNode2 = null;
                    if (!string2.isAtomicValue()) {
                        xdmNode2 = (XdmNode)string2;
                    } else {
                        logger.debug("Context expression: '{}' returned an atomic value:", (Object)string, (Object)string2);
                    }
                    if (xdmNode2 != null) {
                        xdmNode = xdmNode2;
                        logger.debug("Set context node: {} ", (Object)xdmNode2);
                    }
                    if (documentBuilder2.hasNext()) {
                        logger.debug("Context expression: '{}' returned more than one result: {}.", (Object)string, documentBuilder2.next());
                    }
                } else {
                    logger.debug("Context expression returned no results: {}", (Object)string);
                }
            }
            catch (SaxonApiException saxonApiException) {
                logger.debug("Cannot evaluate context expression: {}", (Object)string, (Object)saxonApiException);
            }
        }
        logger.debug("XPath: {} mapped to: {}", (Object)string, xdmNode);
        return xdmNode != null ? xdmNode.getUnderlyingNode() : null;
    }

    private static void setSelectionContext(AuthorAccess authorAccess, NodeInfo nodeInfo, Configuration configuration, DynamicQueryContext dynamicQueryContext) {
        AuthorSelectionModel authorSelectionModel;
        EmptySequence emptySequence;
        ArrayList<AuthorNode> arrayList = new ArrayList<AuthorNode>();
        if (authorAccess != null) {
            Object object;
            Object object2;
            Object object3;
            emptySequence = new ArrayList();
            authorSelectionModel = authorAccess.getEditorAccess().getAuthorSelectionModel();
            if (authorSelectionModel.hasSelection()) {
                object3 = authorSelectionModel.getSelectionIntervals();
                Iterator<ContentInterval> iterator = object3.iterator();
                while (iterator.hasNext()) {
                    Object object4;
                    Object object5 = iterator.next();
                    object2 = authorAccess.getEditorAccess().getBalancedSelection(((ContentInterval)object5).getStartOffset(), ((ContentInterval)object5).getEndOffset());
                    if (logger.isDebugEnabled()) {
                        logger.debug(" Selection: " + (ContentInterval)object5);
                        logger.debug("  Balanced: " + object2[0] + ", " + object2[1]);
                    }
                    object = authorAccess.getEditorAccess().getFullySelectedNode(object2[0], object2[1]);
                    boolean bl = false;
                    if (object == null) {
                        try {
                            object4 = authorAccess.getDocumentController().getNodesToSelect(object2[0], object2[1]);
                            if (object4 != null) {
                                emptySequence.addAll(object4);
                                bl = true;
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            logger.error((Object)badLocationException, (Throwable)badLocationException);
                        }
                    }
                    if (!bl && object == null) {
                        try {
                            object4 = authorAccess.getDocumentController().getNodeAtOffset(object2[0]);
                            if (object4 != null && object4.getStartOffset() + 1 == object2[0] && object4.getEndOffset() == object2[1]) {
                                object = object4;
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            logger.error((Object)badLocationException, (Throwable)badLocationException);
                        }
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug(" Selected node: " + (AuthorNode)object);
                    }
                    if (bl || object == null) continue;
                    emptySequence.add(object);
                }
            }
            object3 = authorAccess.getDocumentController().getAuthorDocumentNode().getRootElement().getNamespaceContext();
            for (Object object5 : emptySequence) {
                try {
                    object2 = authorAccess.getDocumentController().getXPathExpression(object5.getStartOffset() + 1);
                    if (logger.isDebugEnabled()) {
                        logger.debug(" Computed XPath:" + (String)object2);
                    }
                    if ((object = MutableNodeModelBuilder.getNodesByXPath(nodeInfo, configuration, (String)object2, (NamespaceContext)object3)) != null) {
                        arrayList.add((AuthorNode)object);
                        continue;
                    }
                    logger.warn("Unable to compute Xpath expression for: " + (AuthorNode)object5);
                }
                catch (BadLocationException badLocationException) {
                    logger.error((Object)badLocationException, (Throwable)badLocationException);
                }
            }
        }
        if (arrayList.isEmpty()) {
            emptySequence = EmptySequence.getInstance();
        } else {
            authorSelectionModel = new ListIterator.Of(arrayList);
            emptySequence = authorSelectionModel.materialize();
            authorSelectionModel.close();
        }
        dynamicQueryContext.setParameter(new StructuredQName(OXY_PREFIX, OXY_NAMESPACE, SELECTION_PARAM), (GroundedValue)emptySequence);
    }

    public static void initializeQueryContext(AuthorSource authorSource, Configuration configuration, DynamicQueryContext dynamicQueryContext) {
        NodeInfo nodeInfo = MutableNodeModelBuilder.build(authorSource, configuration);
        MutableNodeModelBuilder.setContextNode(authorSource.getAuthorAccess(), nodeInfo, configuration, dynamicQueryContext);
        MutableNodeModelBuilder.setSelectionContext(authorSource.getAuthorAccess(), nodeInfo, configuration, dynamicQueryContext);
    }
}

