/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.dom.wrappers.mutable;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.GenericTreeInfo;
import net.sf.saxon.om.NodeInfo;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import ro.sync.ecss.dom.wrappers.mutable.DOMNodeWrapper;
import ro.sync.ecss.dom.wrappers.mutable.MutableNodeModelBuilder;

public class DocumentWrapper
extends GenericTreeInfo {
    protected boolean domLevel3;
    Node docNode;

    public DocumentWrapper(Node node, String string, Configuration configuration) {
        super(configuration);
        if (node.getNodeType() != 9 && node.getNodeType() != 11) {
            throw new IllegalArgumentException("Node must be a DOM Document or DocumentFragment");
        }
        if (configuration.getExternalObjectModel(node.getClass()) == null) {
            throw new IllegalArgumentException("Node class " + node.getClass().getName() + " is not recognized in this Saxon configuration");
        }
        this.domLevel3 = true;
        this.docNode = node;
        this.setRootNode((NodeInfo)this.wrap(node));
        this.setSystemId(string);
    }

    public DOMNodeWrapper wrap(Node node) {
        return MutableNodeModelBuilder.makeWrapper(node, this, null, -1);
    }

    public void setDOMLevel(int n2) {
        if (n2 != 2 && n2 != 3) {
            throw new IllegalArgumentException("DOM Level must be 2 or 3");
        }
        this.domLevel3 = n2 == 3;
    }

    public int getDOMLevel() {
        return this.domLevel3 ? 3 : 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeInfo selectID(String string, boolean bl) {
        Node node = this.docNode;
        synchronized (node) {
            Element element;
            DOMNodeWrapper dOMNodeWrapper = null;
            Node node2 = ((DOMNodeWrapper)this.getRootNode()).node;
            if (node2 instanceof Document && (element = ((Document)node2).getElementById(string)) != null) {
                dOMNodeWrapper = this.wrap(element);
            }
            return dOMNodeWrapper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<String> getUnparsedEntityNames() {
        Node node = this.docNode;
        synchronized (node) {
            Iterator iterator = null;
            Node node2 = ((DOMNodeWrapper)this.getRootNode()).node;
            if (node2 instanceof Document) {
                DocumentType documentType = ((Document)node2).getDoctype();
                if (documentType == null) {
                    List list = Collections.emptyList();
                    iterator = list.iterator();
                } else {
                    NamedNodeMap namedNodeMap = documentType.getEntities();
                    if (namedNodeMap == null) {
                        List list = Collections.emptyList();
                        iterator = list.iterator();
                    } else {
                        ArrayList<String> arrayList = new ArrayList<String>(namedNodeMap.getLength());
                        for (int i2 = 0; i2 < namedNodeMap.getLength(); ++i2) {
                            Entity entity = (Entity)namedNodeMap.item(i2);
                            if (entity.getNotationName() == null) continue;
                            arrayList.add(entity.getLocalName());
                        }
                        return arrayList.iterator();
                    }
                }
            }
            return iterator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getUnparsedEntity(String string) {
        Node node = this.docNode;
        synchronized (node) {
            Entity entity;
            NamedNodeMap namedNodeMap;
            DocumentType documentType;
            String[] stringArray = null;
            Node node2 = ((DOMNodeWrapper)this.getRootNode()).node;
            if (node2 instanceof Document && (documentType = ((Document)node2).getDoctype()) != null && (namedNodeMap = documentType.getEntities()) != null && (entity = (Entity)namedNodeMap.getNamedItem(string)) != null && entity.getNotationName() != null) {
                stringArray = this.getUnparsedEntity(entity);
            }
            return stringArray;
        }
    }

    private String[] getUnparsedEntity(Entity entity) {
        String string = entity.getSystemId();
        try {
            String string2;
            URI uRI = new URI(string);
            if (!uRI.isAbsolute() && (string2 = this.getRootNode().getBaseURI()) != null) {
                uRI = new URI(string2).resolve(uRI);
                string = uRI.toString();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return new String[]{string, entity.getPublicId()};
    }

    public boolean isMutable() {
        return true;
    }
}

