/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.dita.topic.ref;

import java.util.List;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.dita.topic.ref.AuthorDocumentNodesCollector;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorReferenceResolver;
import ro.sync.ecss.extensions.api.DITAMapReferencesResolver;
import ro.sync.ecss.extensions.api.ExtensionsBundle;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.node.AuthorReferenceNode;
import ro.sync.exml.options.Options;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class ExpandableTopicrefCounter {
    private AuthorAccess b;

    public ExpandableTopicrefCounter(AuthorAccess authorAccess) {
        this.b = authorAccess;
    }

    public int getNumberOfReferencesToExpand() throws AuthorOperationException {
        long l2 = this.e();
        long l3 = this.c();
        return (int)(l2 - l3);
    }

    private long c() {
        List<AuthorNode> list = AuthorDocumentNodesCollector.collectNodes(this.b);
        return list.stream().filter(authorNode -> authorNode.getType() == 7).filter(authorNode -> ((AuthorReferenceNode)authorNode).getReferenceType() == 1).count();
    }

    private long e() throws AuthorOperationException {
        ExtensionsBundle extensionsBundle = this.b.getEditorAccess().getExtensionsBundle();
        DITAMapReferencesResolver dITAMapReferencesResolver = ExpandableTopicrefCounter.f(extensionsBundle);
        dITAMapReferencesResolver.setResolveAllTopicReferences(true);
        List<AuthorNode> list = AuthorDocumentNodesCollector.collectNodes(this.b);
        return list.stream().filter(dITAMapReferencesResolver::hasReferences).count();
    }

    private static DITAMapReferencesResolver f(ExtensionsBundle extensionsBundle) throws AuthorOperationException {
        AuthorReferenceResolver authorReferenceResolver = null;
        if (extensionsBundle != null) {
            authorReferenceResolver = extensionsBundle.createAuthorReferenceResolver();
        }
        if (!(authorReferenceResolver instanceof DITAMapReferencesResolver)) {
            throw new AuthorOperationException("Fail to find the number of topic references to expand. Your AuthorReferenceResolver is not a DITAMapReferencesResolver.");
        }
        return (DITAMapReferencesResolver)authorReferenceResolver;
    }

    public static int getTopicRefsLimit() {
        return Options.getInstance().getIntegerProperty("topic.content.refs.limit");
    }
}

