/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.css;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.css.sac.LexicalUnit;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.ecss.css.CSSCounter;
import ro.sync.ecss.css.CSSCounterIncrement;
import ro.sync.ecss.css.RelativeLength;
import ro.sync.ecss.css.StaticContent;
import ro.sync.ecss.css.URIContent;
import ro.sync.ecss.css.cb;
import ro.sync.ecss.css.functions.b.e;
import ro.sync.ecss.css.functions.b.i;
import ro.sync.exml.view.graphics.Color;
import ro.sync.exml.view.graphics.Font;
import ro.sync.exml.view.graphics.FontMetrics;
import ro.sync.ui.theme.o;

@API(type=APIType.NOT_EXTENDABLE, src=SourceType.PRIVATE)
@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class Styles
implements Cloneable {
    private static final Logger logger = LoggerFactory.getLogger((String)Styles.class.getName());
    public static final float EX_FACTOR = 0.6f;
    public static final int FONT_WEIGHT_NORMAL = 400;
    public static final int FONT_WEIGHT_BOLD = 700;
    static final int BORDER_WIDTH_THIN = 1;
    static final int BORDER_WIDTH_MEDIUM = 3;
    static final int BORDER_WIDTH_THICK = 5;
    protected static int counter = 0;
    public static final int KEY_BACKGROUND_COLOR = counter++;
    public static final int KEY_BORDER_BOTTOM_COLOR = counter++;
    public static final int KEY_BORDER_BOTTOM_STYLE = counter++;
    public static final int KEY_BORDER_BOTTOM_WIDTH = counter++;
    public static final int KEY_BORDER_LEFT_COLOR = counter++;
    public static final int KEY_BORDER_LEFT_STYLE = counter++;
    public static final int KEY_BORDER_LEFT_WIDTH = counter++;
    public static final int KEY_BORDER_RIGHT_COLOR = counter++;
    public static final int KEY_BORDER_RIGHT_STYLE = counter++;
    public static final int KEY_BORDER_RIGHT_WIDTH = counter++;
    public static final int KEY_BORDER_TOP_COLOR = counter++;
    public static final int KEY_BORDER_TOP_STYLE = counter++;
    public static final int KEY_BORDER_TOP_WIDTH = counter++;
    public static final int KEY_FOREGROUND_COLOR = counter++;
    public static final int KEY_MIXED_CONTENT = counter++;
    public static final int KEY_DISPLAY = counter++;
    public static final int KEY_FONT = counter++;
    public static final int KEY_FONT_WEIGHT = counter++;
    public static final int KEY_LINE_HEIGHT = counter++;
    public static final int KEY_LIST_STYLE_TYPE = counter++;
    public static final int KEY_LIST_STYLE_POSITION = counter++;
    public static final int KEY_MARGIN_BOTTOM = counter++;
    public static final int KEY_MARGIN_LEFT = counter++;
    public static final int KEY_MARGIN_RIGHT = counter++;
    public static final int KEY_MARGIN_TOP = counter++;
    public static final int KEY_PADDING_BOTTOM = counter++;
    public static final int KEY_PADDING_LEFT = counter++;
    public static final int KEY_PADDING_RIGHT = counter++;
    public static final int KEY_PADDING_TOP = counter++;
    public static final int KEY_WIDTH = counter++;
    public static final int KEY_HEIGHT = counter++;
    public static final int KEY_MIN_WIDTH = counter++;
    public static final int KEY_MAX_WIDTH = counter++;
    public static final int KEY_TEXT_ALIGN = counter++;
    public static final int KEY_TEXT_INDENT = counter++;
    public static final int KEY_WHITESPACE = counter++;
    public static final int KEY_EDITABLE = counter++;
    public static final int KEY_BORDER_SPACING = counter++;
    public static final int KEY_VISIBILITY;
    @Deprecated
    public static final int KEY_VISIBITY;
    public static final int KEY_EMPTY_CELLS;
    public static final int KEY_FOLDABLE;
    public static final int KEY_NON_FOLDABLE_CHILD_NAME;
    public static final int KEY_VERTICAL_ALIGN;
    public static final int KEY_COUNTER_RESET;
    public static final int KEY_COUNTER_INCREMENT;
    public static final int KEY_IMPOSED_DISPLAY;
    public static final int KEY_TEXT_DECORATION_LINE;
    @Deprecated
    public static final int KEY_TEXT_DECORATION;
    public static final int KEY_TEXT_DECORATION_COLOR;
    public static final int KEY_LINK;
    @Deprecated
    public static final int KEY_LINK_URL;
    public static final int KEY_DISPLAY_TAGS;
    public static final int KEY_DIRECT_WHITESPACE;
    public static final int KEY_FILTERED_OUT;
    public static final int KEY_TEXT_TRANSFORM;
    public static final int KEY_SHOW_PLACEHOLDER;
    public static final int KEY_PLACEHOLDER_CONTENT;
    public static final int KEY_FOLDED;
    public static final int KEY_TAGS_BACKGROUND_COLOR;
    public static final int KEY_TAGS_COLOR;
    public static final int KEY_BACKGROUND_IMAGE;
    public static final int KEY_OXY_FOREGROUND_IMAGE;
    public static final int KEY_OXY_VIDEO_COVER;
    public static final int KEY_BACKGROUND_REPEAT;
    public static final int KEY_BACKGROUND_POSITION;
    public static final int KEY_DIRECTION;
    public static final int KEY_UNICODE_BIDI;
    public static final int KEY_TEXT_DECORATION_STYLE;
    public static final int KEY_MIN_HEIGHT;
    public static final int KEY_MAX_HEIGHT;
    public static final int KEY_POSITION;
    public static final int KEY_TOP;
    public static final int KEY_BOTTOM;
    public static final int KEY_LEFT;
    public static final int KEY_RIGHT;
    public static final int KEY_OUTLINE_COLOR;
    public static final int KEY_OUTLINE_STYLE;
    public static final int KEY_OUTLINE_WIDTH;
    public static final int KEY_OXY_STYLE;
    public static final int KEY_EMPTY_CELLS_BOOLEAN;
    public static final int KEY_OXY_LINK_ACTIVATION_TRIGGER;
    public static final int KEY_OXY_FLOATING_TOOLBAR;
    public static final int KEY_BORDER_TOP_LEFT_RADIUS;
    public static final int KEY_BORDER_TOP_RIGHT_RADIUS;
    public static final int KEY_BORDER_BOTTOM_RIGHT_RADIUS;
    public static final int KEY_BORDER_BOTTOM_LEFT_RADIUS;
    protected static int pmCounter;
    public static final int KEY_LIST_STYLE_IMAGE;
    public static final int KEY_PAGE;
    public static final int KEY_OXY_PAGE_GROUP;
    public static final int KEY_IMAGE_RESOLUTION;
    public static final int KEY_OXY_ALT_TEXT;
    public static final int KEY_OXY_PDF_TAG_TYPE;
    public static final int KEY_OXY_PDF_META_AUTHOR;
    public static final int KEY_OXY_PDF_META_TITLE;
    public static final int KEY_OXY_PDF_META_DESCRIPTION;
    public static final int KEY_OXY_PDF_META_KEYWORDS;
    public static final int KEY_OXY_PDF_META_KEYWORD;
    public static final int KEY_OXY_PDF_META_COPYRIGHT;
    public static final int KEY_OXY_PDF_META_COPYRIGHTED;
    public static final int KEY_OXY_PDF_META_COPYRIGHT_URL;
    public static final int KEY_OXY_PDF_META_CUSTOM;
    public static final int KEY_BACKGROUND_SIZE;
    public static final int KEY_BREAK_BEFORE;
    public static final int KEY_BREAK_AFTER;
    public static final int KEY_BREAK_INSIDE;
    public static final int KEY_PAGE_BREAK_AFTER;
    public static final int KEY_PAGE_BREAK_BEFORE;
    public static final int KEY_PAGE_BREAK_INSIDE;
    public static final int KEY_OXY_COLUMN_BREAK_AFTER;
    public static final int KEY_OXY_COLUMN_BREAK_BEFORE;
    public static final int KEY_OXY_COLUMN_BREAK_INSIDE;
    public static final int KEY_OXY_BORDERS_CONDITIONALITY;
    public static final int KEY_OXY_SPACE_BEFORE_CONDITIONALITY;
    public static final int KEY_OXY_SPACE_AFTER_CONDITIONALITY;
    public static final int KEY_OXY_CHANGEBAR_OFFSET;
    public static final int KEY_OXY_CHANGEBAR_STYLE;
    public static final int KEY_OXY_CHANGEBAR_PLACEMENT;
    public static final int KEY_OXY_CHANGEBAR_COLOR;
    public static final int KEY_OXY_CHANGEBAR_WIDTH;
    public static final int KEY_ORPHANS;
    public static final int KEY_WIDOWS;
    public static final int KEY_STRING_SET;
    public static final int KEY_FLOAT;
    public static final int KEY_TABLE_ROW_SPAN;
    public static final int KEY_TABLE_COLUMN_SPAN;
    public static final int KEY_CAPTION_SIDE;
    public static final int KEY_TABLE_LAYOUT;
    public static final int KEY_BORDER_COLLAPSE;
    public static final int KEY_COLUMN_SPAN;
    public static final int KEY_TRANSFORM_ROTATION;
    public static final int KEY_HYPHENS;
    public static final int KEY_BOOKMARK_LEVEL;
    public static final int KEY_BOOKMARK_LABEL;
    public static final int KEY_BOOKMARK_STATE;
    public static final int KEY_LETTER_SPACING;
    public static final int KEY_FONT_FAMILY;
    public static final int KEY_FONT_SIZE;
    public static final int KEY_FONT_STYLE;
    public static final int KEY_FONT_VARIANT;
    public static final int KEY_FONT_VARIANT_ALTERNATES;
    public static final int KEY_FONT_VARIANT_LIGATURES;
    public static final int KEY_FONT_VARIANT_NUMERIC;
    public static final int KEY_OVERFLOW_WRAP;
    public static final int KEY_OXY_HYPHENATION_CHARACTER;
    public static final int KEY_OXY_HYPHENATION_PUSH_CHARACTER_COUNT;
    public static final int KEY_OXY_HYPHENATION_REMAIN_CHARACTER_COUNT;
    public static final int KEY_ALIGNMENT_BASELINE;
    public static final int KEY_OXY_CAPTION_REPEAT_ON_NEXT_PAGES;
    public static final int KEY_OXY_SHOW_ONLY_WHEN_CAPTION_REPEATED_ON_NEXT_PAGES;
    public static final int KEY_OXY_AVOID_BREAKING_LINE_AT_HYPHENS;
    public static final int KEY_OXY_BREAK_LINE_AT_HYPHENS;
    public static final int KEY_OXY_PDF_VIEWER_ZOOM;
    public static final int KEY_OXY_PDF_VIEWER_HIDE_TOOLBAR;
    public static final int KEY_OXY_PDF_VIEWER_HIDE_MENUBAR;
    public static final int KEY_OXY_PDF_VIEWER_FIT_WINDOW;
    public static final int KEY_OXY_PDF_VIEWER_DISPLAY_FILENAME;
    public static final int KEY_OXY_PDF_TABLE_OMIT_HEADER_BREAK;
    public static final int KEY_OXY_PDF_TABLE_OMIT_FOOTER_BREAK;
    public static final int KEY_OXY_PDF_VIEWER_PAGE_MODE;
    public static final int KEY_OXY_PDF_VIEWER_PAGE_LAYOUT;
    protected final Object[] stylesArray;
    private boolean canBeCached;
    private int pseudoLevel;
    private static final String[] EMPTY_STRING_ARRAY;
    private static final StaticContent[] EMPTY_CONTENT;
    private static final CSSCounter[] EMPTY_COUNTERS;
    private static final CSSCounterIncrement[] EMPTY_COUNTERS_INCREMENT;
    private static final int[] EMPTY_BORDER_SPACING;
    private static final RelativeLength ZERO_RELATIVE_LENGTH;
    private static final Map<String, Integer> PROPERTY_TO_INDEX;
    private static final Map<Integer, String> INDEX_TO_PROPERTY;
    private boolean enablePagedMediaProperties;
    private static final HashMap<Integer, String> UN_INHERITABLE_STYLES;
    private static final Set<String> UN_INHERITABLE_PROPERTIES;
    private HashMap<String, e> customCssProperties = null;

    private static <T> T getReplacementIfNull(T t2, T t3) {
        return t2 != null ? t2 : t3;
    }

    private static <T> T getReplacementIfNull(T t2, Supplier<T> supplier) {
        if (t2 != null) {
            return t2;
        }
        return supplier == null ? null : (T)supplier.get();
    }

    public Styles() {
        this.stylesArray = new Object[counter];
    }

    public Styles(boolean bl) {
        this.enablePagedMediaProperties = bl;
        this.stylesArray = bl ? new Object[pmCounter] : new Object[counter];
    }

    public boolean isEnablePagedMediaProperties() {
        return this.enablePagedMediaProperties;
    }

    Styles(Object[] objectArray) {
        this.stylesArray = objectArray;
    }

    public static String getPropertyName(int n2) {
        return INDEX_TO_PROPERTY.get(n2);
    }

    public Object getPropertyByName(String string) {
        Integer n2 = PROPERTY_TO_INDEX.get(string);
        Object object = null;
        if (n2 != null) {
            object = this.getProperty(n2);
            if (object instanceof Integer && "line-height".equals(string)) {
                object = object + "px";
            }
        } else if (this.getFont() != null) {
            Font font = this.getFont();
            if ("font-style".equals(string)) {
                object = (font.getStyle() & 2) == 2 ? "italic" : "normal";
            } else if ("font-size".equals(string)) {
                object = font.getSize() + "px";
            } else if ("font-family".equals(string)) {
                String[] stringArray = font.getFontNames();
                int n3 = stringArray.length;
                StringBuilder stringBuilder = new StringBuilder();
                for (int i2 = 0; i2 < n3; ++i2) {
                    stringBuilder.append(stringArray[i2]);
                    if (i2 >= n3 - 1) continue;
                    stringBuilder.append(" , ");
                }
                object = stringBuilder.toString();
            }
        } else {
            throw new IllegalArgumentException("No property: " + string);
        }
        return object;
    }

    public Color getBackgroundColor() {
        return (Color)this.getProperty(KEY_BACKGROUND_COLOR);
    }

    public URIContent getBackgroundImage() {
        return (URIContent)this.getProperty(KEY_BACKGROUND_IMAGE);
    }

    public String getBackgroundRepeat() {
        return Styles.getReplacementIfNull((String)this.getProperty(KEY_BACKGROUND_REPEAT), "repeat");
    }

    public cb getBackgroundPosition() {
        return (cb)this.getProperty(KEY_BACKGROUND_POSITION);
    }

    public Color getTagsBackgroundColor() {
        return (Color)this.getProperty(KEY_TAGS_BACKGROUND_COLOR);
    }

    public Color getTagsColor() {
        return (Color)this.getProperty(KEY_TAGS_COLOR);
    }

    public boolean hasBorder() {
        return this.getBorderLeftWidth() != 0 || this.getBorderRightWidth() != 0 || this.getBorderTopWidth() != 0 || this.getBorderBottomWidth() != 0;
    }

    public Color getBorderBottomColor() {
        return Styles.getReplacementIfNull((Color)this.getProperty(KEY_BORDER_BOTTOM_COLOR), this::getColor);
    }

    public String getBorderBottomStyle() {
        return Styles.getReplacementIfNull((String)this.getProperty(KEY_BORDER_BOTTOM_STYLE), "none");
    }

    public Color getBorderLeftColor() {
        int n2 = "rtl" == this.getDirection() ? KEY_BORDER_RIGHT_COLOR : KEY_BORDER_LEFT_COLOR;
        return Styles.getReplacementIfNull((Color)this.getProperty(n2), this::getColor);
    }

    public String getBorderLeftStyle() {
        int n2 = "rtl" == this.getDirection() ? KEY_BORDER_RIGHT_STYLE : KEY_BORDER_LEFT_STYLE;
        return Styles.getReplacementIfNull((String)this.getProperty(n2), "none");
    }

    public Color getBorderRightColor() {
        int n2 = "rtl" == this.getDirection() ? KEY_BORDER_LEFT_COLOR : KEY_BORDER_RIGHT_COLOR;
        return Styles.getReplacementIfNull((Color)this.getProperty(n2), this::getColor);
    }

    public String getBorderRightStyle() {
        int n2 = "rtl" == this.getDirection() ? KEY_BORDER_LEFT_STYLE : KEY_BORDER_RIGHT_STYLE;
        return Styles.getReplacementIfNull((String)this.getProperty(n2), "none");
    }

    public Color getBorderTopColor() {
        return Styles.getReplacementIfNull((Color)this.getProperty(KEY_BORDER_TOP_COLOR), this::getColor);
    }

    public String getBorderTopStyle() {
        return Styles.getReplacementIfNull((String)this.getProperty(KEY_BORDER_TOP_STYLE), "none");
    }

    public Color getOutlineColor() {
        return Styles.getReplacementIfNull((Color)this.getProperty(KEY_OUTLINE_COLOR), this::getColor);
    }

    public String getOutlineStyle() {
        return Styles.getReplacementIfNull((String)this.getProperty(KEY_OUTLINE_STYLE), "none");
    }

    public int getOutlineWidth() {
        int n2 = 3;
        if (this.isHiddenBorderStyle(KEY_OUTLINE_WIDTH)) {
            n2 = 0;
        } else {
            Number number = (Number)this.getProperty(KEY_OUTLINE_WIDTH);
            if (number != null) {
                n2 = number.intValue();
            }
        }
        return n2;
    }

    public Color getColor() {
        return Styles.getReplacementIfNull((Color)this.getProperty(KEY_FOREGROUND_COLOR), () -> new Color(o.getInstance().getTextForegroundColor()));
    }

    public StaticContent[] getMixedContent() {
        return Styles.getReplacementIfNull((StaticContent[])this.getProperty(KEY_MIXED_CONTENT), EMPTY_CONTENT);
    }

    public String getDisplay() {
        return Styles.getReplacementIfNull(Styles.getReplacementIfNull((String)this.getProperty(KEY_IMPOSED_DISPLAY), (String)this.getProperty(KEY_DISPLAY)), "inline");
    }

    public String getPosition() {
        return Styles.getReplacementIfNull((String)this.getProperty(KEY_POSITION), "static");
    }

    public boolean isMorphDisplay() {
        String string = this.getDisplay();
        return "morph".equals(string) || "-oxy-morph".equals(string);
    }

    public boolean isChangebarDisplay() {
        String string = this.getDisplay();
        return "-oxy-changebar-start".equals(string) || "-oxy-changebar-end".equals(string);
    }

    public boolean isInvisible() {
        String string = this.getDisplay();
        return "none".equals(string) || "ignored".equals(string);
    }

    public boolean isListItem() {
        return "list-item".equals(this.getDisplay());
    }

    public Font getFont() {
        return (Font)this.getProperty(KEY_FONT);
    }

    public int getFontWeight() {
        Number number = (Number)this.getProperty(KEY_FONT_WEIGHT);
        return number != null ? number.intValue() : 400;
    }

    public String getFontVariant() {
        return Styles.getReplacementIfNull((String)this.getProperty(KEY_FONT_VARIANT), "normal");
    }

    public int getLineHeight(FontMetrics fontMetrics) {
        RelativeLength relativeLength = (RelativeLength)this.getProperty(KEY_LINE_HEIGHT);
        return relativeLength != null ? relativeLength.get(fontMetrics.getHeight()) : fontMetrics.getHeight();
    }

    public String getListStyleType() {
        return Styles.getReplacementIfNull((String)this.getProperty(KEY_LIST_STYLE_TYPE), "disc");
    }

    public String getListStylePosition() {
        return Styles.getReplacementIfNull((String)this.getProperty(KEY_LIST_STYLE_POSITION), "outside");
    }

    public String getTextAlign() {
        return Styles.getReplacementIfNull((String)this.getProperty(KEY_TEXT_ALIGN), "left");
    }

    public boolean isSpecifiedTextAlign() {
        return this.stylesArray[KEY_TEXT_ALIGN] != null;
    }

    public RelativeLength getTextIndent() {
        return (RelativeLength)this.getProperty(KEY_TEXT_INDENT);
    }

    public boolean isInline() {
        String string = this.getDisplay();
        return "inline".equals(string) || "inline-block".equals(string);
    }

    public boolean isTableRowGroup() {
        return this.getDisplay().equals("table-row-group");
    }

    public boolean isTableRow() {
        return this.getDisplay().equals("table-row");
    }

    public int getBorderBottomWidth() {
        int n2 = 3;
        if (this.isHiddenBorderStyle(KEY_BORDER_BOTTOM_STYLE)) {
            n2 = 0;
        } else {
            Number number = (Number)this.getProperty(KEY_BORDER_BOTTOM_WIDTH);
            if (number != null) {
                n2 = number.intValue();
            }
        }
        return n2;
    }

    private final boolean isHiddenBorderStyle(int n2) {
        Object object = this.stylesArray[n2];
        return object == null || "none".equals(object) || "hidden".equals(object);
    }

    public int getBorderLeftWidth() {
        int n2 = KEY_BORDER_LEFT_WIDTH;
        int n3 = KEY_BORDER_LEFT_STYLE;
        if ("rtl" == this.getDirection()) {
            n2 = KEY_BORDER_RIGHT_WIDTH;
            n3 = KEY_BORDER_RIGHT_STYLE;
        }
        int n4 = 3;
        if (this.isHiddenBorderStyle(n3)) {
            n4 = 0;
        } else {
            Number number = (Number)this.getProperty(n2);
            if (number != null) {
                n4 = number.intValue();
            }
        }
        return n4;
    }

    public int getBorderRightWidth() {
        int n2 = KEY_BORDER_RIGHT_WIDTH;
        int n3 = KEY_BORDER_RIGHT_STYLE;
        if ("rtl" == this.getDirection()) {
            n2 = KEY_BORDER_LEFT_WIDTH;
            n3 = KEY_BORDER_LEFT_STYLE;
        }
        int n4 = 3;
        if (this.isHiddenBorderStyle(n3)) {
            n4 = 0;
        } else {
            Number number = (Number)this.getProperty(n2);
            if (number != null) {
                n4 = number.intValue();
            }
        }
        return n4;
    }

    public int getBorderTopWidth() {
        int n2 = 3;
        if (this.isHiddenBorderStyle(KEY_BORDER_TOP_STYLE)) {
            n2 = 0;
        } else {
            Number number = (Number)this.getProperty(KEY_BORDER_TOP_WIDTH);
            if (number != null) {
                n2 = number.intValue();
            }
        }
        return n2;
    }

    public RelativeLength getMarginBottom() {
        return Styles.getReplacementIfNull((RelativeLength)this.getProperty(KEY_MARGIN_BOTTOM), ZERO_RELATIVE_LENGTH);
    }

    public RelativeLength getBorderBottomLeftRadius() {
        return Styles.getReplacementIfNull((RelativeLength)this.getProperty(KEY_BORDER_BOTTOM_LEFT_RADIUS), ZERO_RELATIVE_LENGTH);
    }

    public RelativeLength getBorderBottomRightRadius() {
        return Styles.getReplacementIfNull((RelativeLength)this.getProperty(KEY_BORDER_BOTTOM_RIGHT_RADIUS), ZERO_RELATIVE_LENGTH);
    }

    public RelativeLength getBorderTopLeftRadius() {
        return Styles.getReplacementIfNull((RelativeLength)this.getProperty(KEY_BORDER_TOP_LEFT_RADIUS), ZERO_RELATIVE_LENGTH);
    }

    public RelativeLength getBorderTopRightRadius() {
        return Styles.getReplacementIfNull((RelativeLength)this.getProperty(KEY_BORDER_TOP_RIGHT_RADIUS), ZERO_RELATIVE_LENGTH);
    }

    public RelativeLength getMarginLeft() {
        int n2 = "rtl" == this.getDirection() ? KEY_MARGIN_RIGHT : KEY_MARGIN_LEFT;
        return Styles.getReplacementIfNull((RelativeLength)this.getProperty(n2), ZERO_RELATIVE_LENGTH);
    }

    public RelativeLength getMarginRight() {
        int n2 = "rtl" == this.getDirection() ? KEY_MARGIN_LEFT : KEY_MARGIN_RIGHT;
        return Styles.getReplacementIfNull((RelativeLength)this.getProperty(n2), ZERO_RELATIVE_LENGTH);
    }

    public RelativeLength getMarginTop() {
        return Styles.getReplacementIfNull((RelativeLength)this.getProperty(KEY_MARGIN_TOP), ZERO_RELATIVE_LENGTH);
    }

    public RelativeLength getPaddingBottom() {
        return Styles.getReplacementIfNull((RelativeLength)this.getProperty(KEY_PADDING_BOTTOM), ZERO_RELATIVE_LENGTH);
    }

    public String getDirection() {
        return Styles.getReplacementIfNull((String)this.getProperty(KEY_DIRECTION), "ltr");
    }

    public String getUnicodeBIDI() {
        return Styles.getReplacementIfNull((String)this.getProperty(KEY_UNICODE_BIDI), "normal");
    }

    public RelativeLength getPaddingLeft() {
        int n2 = "rtl" == this.getDirection() ? KEY_PADDING_RIGHT : KEY_PADDING_LEFT;
        return Styles.getReplacementIfNull((RelativeLength)this.getProperty(n2), ZERO_RELATIVE_LENGTH);
    }

    public RelativeLength getPaddingRight() {
        int n2 = "rtl" == this.getDirection() ? KEY_PADDING_LEFT : KEY_PADDING_RIGHT;
        return Styles.getReplacementIfNull((RelativeLength)this.getProperty(n2), ZERO_RELATIVE_LENGTH);
    }

    public RelativeLength getPaddingTop() {
        return Styles.getReplacementIfNull((RelativeLength)this.getProperty(KEY_PADDING_TOP), ZERO_RELATIVE_LENGTH);
    }

    public boolean isTable() {
        String string = this.getDisplay();
        return "table".equals(string) || "inline-table".equals(string);
    }

    public boolean isTableCell() {
        return "table-cell".equals(this.getDisplay());
    }

    public String getWhitespace() {
        return Styles.getReplacementIfNull((String)this.getProperty(KEY_WHITESPACE), "normal");
    }

    public String getDirectWhitespace() {
        return (String)this.getProperty(KEY_DIRECT_WHITESPACE);
    }

    public boolean isTableHeaderGroup() {
        return this.getDisplay().equals("table-header-group");
    }

    public boolean isTableFooterGroup() {
        return this.getDisplay().equals("table-footer-group");
    }

    public boolean isTableColumn() {
        return this.getDisplay().equals("table-column");
    }

    public boolean isTableColumnGroup() {
        return this.getDisplay().equals("table-column-group");
    }

    public RelativeLength getWidth() {
        return (RelativeLength)this.getProperty(KEY_WIDTH);
    }

    public RelativeLength getHeight() {
        return (RelativeLength)this.getProperty(KEY_HEIGHT);
    }

    public RelativeLength getMinWidth() {
        return (RelativeLength)this.getProperty(KEY_MIN_WIDTH);
    }

    public RelativeLength getMaxWidth() {
        return (RelativeLength)this.getProperty(KEY_MAX_WIDTH);
    }

    public boolean isEditable() {
        Boolean bl = (Boolean)this.getProperty(KEY_EDITABLE);
        return bl == null || bl != false;
    }

    public int getHorizontalBorderSpacing() {
        return this.getBorderSpacing()[0];
    }

    public int getVerticalBorderSpacing() {
        return this.getBorderSpacing()[1];
    }

    private int[] getBorderSpacing() {
        return Styles.getReplacementIfNull((int[])this.getProperty(KEY_BORDER_SPACING), EMPTY_BORDER_SPACING);
    }

    public void setProperty(int n2, Object object) {
        if (n2 >= counter && !this.enablePagedMediaProperties) {
            this.reportOutOfBoundsError(n2);
        } else {
            this.stylesArray[n2] = object;
        }
    }

    private void reportOutOfBoundsError(int n2) {
        logger.debug(() -> "The property " + n2 + "( whith the name '" + INDEX_TO_PROPERTY.get(n2) + "') exceeds the styles property array size. Check that this property is not defined in the paged media property sections. This styles has the paged media properties enabled = " + this.enablePagedMediaProperties + ".", (Throwable)new Exception());
    }

    public void setProperty(int n2, Object object, LexicalUnit lexicalUnit) {
        this.setProperty(n2, object);
    }

    public Object getProperty(int n2) {
        return n2 >= counter && !this.enablePagedMediaProperties ? null : this.stylesArray[n2];
    }

    Object[] getStylesArray() {
        return this.stylesArray;
    }

    void copyAdditionalStylesFrom(Styles styles, boolean bl) {
        this.copyAdditionalStylesFrom(styles, bl, false);
    }

    private void copyAdditionalStylesFrom(Styles styles, boolean bl, boolean bl2) {
        if (styles != null) {
            Object[] objectArray = styles.getStylesArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                boolean bl3 = false;
                if (this.stylesArray[i2] == null) {
                    boolean bl4 = bl3 = bl2 || i2 != KEY_COUNTER_RESET && i2 != KEY_COUNTER_INCREMENT && i2 != KEY_MIXED_CONTENT && i2 != KEY_STRING_SET && i2 != KEY_BOOKMARK_LABEL && i2 != KEY_FILTERED_OUT && (!bl || Styles.isInheritable(i2));
                }
                if (!bl3) {
                    boolean bl5 = bl3 = KEY_DISPLAY == i2 && "none".equals(objectArray[i2]);
                }
                if (!bl3) continue;
                this.setProperty(i2, objectArray[i2], styles.getLexicalUnit(i2));
            }
            styles.getCustomCssProperties().forEach(this::addCustomPropertyIfMissing);
        }
    }

    private void addCustomPropertyIfMissing(String string, e e2) {
        if (this.customCssProperties == null) {
            this.customCssProperties = new LinkedHashMap<String, e>();
        }
        this.customCssProperties.putIfAbsent(string, e2);
    }

    public static boolean isInheritable(int n2) {
        return !UN_INHERITABLE_STYLES.containsKey(n2);
    }

    public static boolean isInheritable(String string) {
        return !UN_INHERITABLE_PROPERTIES.contains(string);
    }

    public String getVisibility() {
        return Styles.getReplacementIfNull((String)this.getProperty(KEY_VISIBILITY), "visible");
    }

    public String getShowPlaceholders() {
        return (String)this.getProperty(KEY_SHOW_PLACEHOLDER);
    }

    public String getPlaceholderContent() {
        return (String)this.getProperty(KEY_PLACEHOLDER_CONTENT);
    }

    public boolean getShowEmptyCells() {
        Boolean bl = (Boolean)this.getProperty(KEY_EMPTY_CELLS_BOOLEAN);
        return bl == null || bl != false;
    }

    public boolean isFoldable() {
        Boolean bl = (Boolean)this.getProperty(KEY_FOLDABLE);
        return bl != null && bl != false;
    }

    public boolean isFolded() {
        return Boolean.TRUE.equals(this.getProperty(KEY_FOLDED));
    }

    public String[] getNonFoldableChildName() {
        return Styles.getReplacementIfNull((String[])this.getProperty(KEY_NON_FOLDABLE_CHILD_NAME), EMPTY_STRING_ARRAY);
    }

    public boolean isTableCaption() {
        return this.getDisplay().equals("table-caption");
    }

    public boolean isInlineInCSS() {
        String string = (String)this.getProperty(KEY_DISPLAY);
        return string == null || "inline".equals(string);
    }

    public boolean isInlineBlockInCSS() {
        String string = (String)this.getProperty(KEY_DISPLAY);
        return "inline-block".equals(string);
    }

    public String getVerticalAlign() {
        return Styles.getReplacementIfNull((String)this.getProperty(KEY_VERTICAL_ALIGN), "baseline");
    }

    @Deprecated
    public String[] getTextDecoration() {
        return this.getTextDecorationLine();
    }

    public String[] getTextDecorationLine() {
        return Styles.getReplacementIfNull((String[])this.getProperty(KEY_TEXT_DECORATION_LINE), new String[]{"none"});
    }

    public String getTextDecorationStyle() {
        return Styles.getReplacementIfNull((String)this.getProperty(KEY_TEXT_DECORATION_STYLE), "solid");
    }

    public Color getTextDecorationColor() {
        return Styles.getReplacementIfNull((Color)this.getProperty(KEY_TEXT_DECORATION_COLOR), () -> new Color(o.getInstance().getTextForegroundColor()));
    }

    public CSSCounter[] getCounters() {
        CSSCounter[] cSSCounterArray = (CSSCounter[])this.getProperty(KEY_COUNTER_RESET);
        return cSSCounterArray == null ? EMPTY_COUNTERS : cSSCounterArray;
    }

    public CSSCounterIncrement[] getCountersIncrement() {
        CSSCounterIncrement[] cSSCounterIncrementArray = (CSSCounterIncrement[])this.getProperty(KEY_COUNTER_INCREMENT);
        return cSSCounterIncrementArray == null ? EMPTY_COUNTERS_INCREMENT : cSSCounterIncrementArray;
    }

    public boolean isInTable() {
        return this.isTable() || this.isTableRow() || this.isTableRowGroup() || this.isTableFooterGroup() || this.isTableHeaderGroup();
    }

    public String getLinkURL() {
        return (String)this.getProperty(KEY_LINK);
    }

    public String getHyperlinkActivationType() {
        return (String)this.getProperty(KEY_OXY_LINK_ACTIVATION_TRIGGER);
    }

    public String getDisplayTags() {
        return Styles.getReplacementIfNull((String)this.getProperty(KEY_DISPLAY_TAGS), "default");
    }

    public String getTextTransform() {
        return (String)this.getProperty(KEY_TEXT_TRANSFORM);
    }

    public boolean isFilteredOut() {
        return Boolean.TRUE.equals(this.getProperty(KEY_FILTERED_OUT));
    }

    public boolean equals(Object object) {
        boolean bl;
        boolean bl2 = bl = this == object;
        if (!bl && object instanceof Styles) {
            Styles styles = (Styles)object;
            Object[] objectArray = styles.getStylesArray();
            bl = this.enablePagedMediaProperties == styles.enablePagedMediaProperties && this.pseudoLevel == styles.getPseudoLevel() && Arrays.deepEquals(this.stylesArray, objectArray) && i.f(this.getCustomCssProperties(), styles.getCustomCssProperties());
        }
        return bl;
    }

    public int hashCode() {
        int n2 = Arrays.deepHashCode(this.stylesArray);
        return n2 + this.customPropsHash(n2);
    }

    private int customPropsHash(int n2) {
        int n3 = n2;
        if (this.customCssProperties != null) {
            Set<Map.Entry<String, e>> set = this.customCssProperties.entrySet();
            for (Map.Entry<String, e> entry : set) {
                e e2;
                String string = entry.getKey();
                if (string != null) {
                    n3 = Styles.hash(n3, string.hashCode());
                }
                if ((e2 = entry.getValue()) == null) continue;
                n3 = Styles.hash(n3, String.valueOf(e2.c()).hashCode());
            }
        }
        return n3;
    }

    private static int hash(int n2, int n3) {
        return 37 * n2 + n3;
    }

    public Styles clone() {
        try {
            Styles styles = null;
            if (this.enablePagedMediaProperties) {
                try {
                    Constructor<?> constructor = this.getClass().getConstructor(Boolean.TYPE);
                    styles = (Styles)constructor.newInstance(this.enablePagedMediaProperties);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Constructor<?> constructor = this.getClass().getConstructor(new Class[0]);
                    styles = (Styles)constructor.newInstance(new Object[0]);
                }
            } else {
                styles = (Styles)this.getClass().newInstance();
            }
            System.arraycopy(this.stylesArray, 0, styles.stylesArray, 0, this.stylesArray.length);
            styles.pseudoLevel = this.pseudoLevel;
            styles.enablePagedMediaProperties = this.enablePagedMediaProperties;
            if (this.customCssProperties != null) {
                styles.customCssProperties = (HashMap)this.customCssProperties.clone();
            }
            return styles;
        }
        catch (Exception exception) {
            throw new RuntimeException("Cannot clone styles, check the constructor. " + exception.getMessage(), exception);
        }
    }

    public boolean canBeCached() {
        return this.canBeCached && this.getCounters().length == 0 && this.getMixedContent().length == 0;
    }

    public void setCanBeCached(boolean bl) {
        this.canBeCached = bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("STYLES:\n");
        for (int i2 = 0; i2 < this.stylesArray.length; ++i2) {
            if (this.stylesArray[i2] == null) continue;
            stringBuilder.append("key ").append(Styles.getPropertyName(i2)).append(" val:").append(this.stylesArray[i2]).append('\n');
        }
        return stringBuilder.toString();
    }

    public RelativeLength getMinHeight() {
        return Styles.getReplacementIfNull((RelativeLength)this.getProperty(KEY_MIN_HEIGHT), ZERO_RELATIVE_LENGTH);
    }

    public RelativeLength getLeft() {
        return (RelativeLength)this.getProperty(KEY_LEFT);
    }

    public RelativeLength getRight() {
        return (RelativeLength)this.getProperty(KEY_RIGHT);
    }

    public RelativeLength getTop() {
        return (RelativeLength)this.getProperty(KEY_TOP);
    }

    public RelativeLength getBottom() {
        return (RelativeLength)this.getProperty(KEY_BOTTOM);
    }

    public void setPseudoLevel(int n2) {
        this.pseudoLevel = n2;
    }

    public int getPseudoLevel() {
        return this.pseudoLevel;
    }

    public int getRecognizedPropertiesNumber() {
        return this.enablePagedMediaProperties ? pmCounter : counter;
    }

    public LexicalUnit getLexicalUnit(int n2) {
        return null;
    }

    String getFloat() {
        return Styles.getReplacementIfNull((String)this.getProperty(KEY_FLOAT), "none");
    }

    public int getTableRowSpan() {
        return Styles.getReplacementIfNull((Integer)this.getProperty(KEY_TABLE_ROW_SPAN), 1);
    }

    public int getTableColumnSpan() {
        return Styles.getReplacementIfNull((Integer)this.getProperty(KEY_TABLE_COLUMN_SPAN), 1);
    }

    String getCaptionSide() {
        return Styles.getReplacementIfNull((String)this.getProperty(KEY_CAPTION_SIDE), "top");
    }

    String getColumnSpan() {
        return Styles.getReplacementIfNull((String)this.getProperty(KEY_COLUMN_SPAN), "none");
    }

    int getTransformRotation() {
        return Styles.getReplacementIfNull((Integer)this.getProperty(KEY_TRANSFORM_ROTATION), 0);
    }

    float getImageResolution() {
        return Styles.getReplacementIfNull((Float)this.getProperty(KEY_IMAGE_RESOLUTION), Float.valueOf(-1.0f)).floatValue();
    }

    String getPage() {
        return (String)this.getProperty(KEY_PAGE);
    }

    String getPageBreakBefore() {
        return Styles.getReplacementIfNull((String)this.getProperty(KEY_PAGE_BREAK_BEFORE), "auto");
    }

    String getPageBreakAfter() {
        return Styles.getReplacementIfNull((String)this.getProperty(KEY_PAGE_BREAK_AFTER), "auto");
    }

    String getPageBreakInside() {
        return Styles.getReplacementIfNull((String)this.getProperty(KEY_PAGE_BREAK_INSIDE), "auto");
    }

    int getWidows() {
        return Styles.getReplacementIfNull((Integer)this.getProperty(KEY_WIDOWS), 2);
    }

    int getOrphans() {
        return Styles.getReplacementIfNull((Integer)this.getProperty(KEY_ORPHANS), 2);
    }

    StaticContent[] getBookmarkLabel() {
        return Styles.getReplacementIfNull((StaticContent[])this.getProperty(KEY_BOOKMARK_LABEL), EMPTY_CONTENT);
    }

    public Map<String, StaticContent[]> getStringSet() {
        return Styles.getReplacementIfNull((Map)(this.enablePagedMediaProperties ? this.getProperty(KEY_STRING_SET) : null), Collections.emptyMap());
    }

    public String getAlignmentBaseline() {
        return Styles.getReplacementIfNull((String)this.getProperty(KEY_ALIGNMENT_BASELINE), "baseline");
    }

    public String getBordersConditionality() {
        return Styles.getReplacementIfNull((String)this.getProperty(KEY_OXY_BORDERS_CONDITIONALITY), "discard");
    }

    public String getSpaceBeforeConditionality() {
        return Styles.getReplacementIfNull((String)this.getProperty(KEY_OXY_SPACE_BEFORE_CONDITIONALITY), "discard");
    }

    public String getSpaceAfterConditionality() {
        return Styles.getReplacementIfNull((String)this.getProperty(KEY_OXY_SPACE_AFTER_CONDITIONALITY), "discard");
    }

    void copyNotNullStylesFrom(Styles styles) {
        if (styles != null) {
            Object[] objectArray = styles.stylesArray;
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                if (objectArray[i2] == null) continue;
                this.setProperty(i2, objectArray[i2], styles.getLexicalUnit(i2));
            }
        }
    }

    public boolean dependsOnTargetCounter() {
        boolean bl = false;
        StaticContent[] staticContentArray = this.getMixedContent();
        for (int i2 = 0; i2 < staticContentArray.length && !bl; ++i2) {
            bl = staticContentArray[i2].getType() == 7 || staticContentArray[i2].getType() == 8;
        }
        return bl;
    }

    public boolean affectsCounters() {
        return this.getCountersIncrement().length > 0 || this.getCounters().length > 0;
    }

    public void setCustomProperty(Map<String, e> map) {
        if (map != null) {
            this.customCssProperties = new LinkedHashMap<String, e>(map);
        }
    }

    public Map<String, e> getCustomCssProperties() {
        return Styles.getReplacementIfNull(this.customCssProperties, Collections.emptyMap());
    }

    static {
        KEY_VISIBITY = KEY_VISIBILITY = counter++;
        KEY_EMPTY_CELLS = counter++;
        KEY_FOLDABLE = counter++;
        KEY_NON_FOLDABLE_CHILD_NAME = counter++;
        KEY_VERTICAL_ALIGN = counter++;
        KEY_COUNTER_RESET = counter++;
        KEY_COUNTER_INCREMENT = counter++;
        KEY_IMPOSED_DISPLAY = counter++;
        KEY_TEXT_DECORATION = KEY_TEXT_DECORATION_LINE = counter++;
        KEY_TEXT_DECORATION_COLOR = counter++;
        KEY_LINK_URL = KEY_LINK = counter++;
        KEY_DISPLAY_TAGS = counter++;
        KEY_DIRECT_WHITESPACE = counter++;
        KEY_FILTERED_OUT = counter++;
        KEY_TEXT_TRANSFORM = counter++;
        KEY_SHOW_PLACEHOLDER = counter++;
        KEY_PLACEHOLDER_CONTENT = counter++;
        KEY_FOLDED = counter++;
        KEY_TAGS_BACKGROUND_COLOR = counter++;
        KEY_TAGS_COLOR = counter++;
        KEY_BACKGROUND_IMAGE = counter++;
        KEY_OXY_FOREGROUND_IMAGE = counter++;
        KEY_OXY_VIDEO_COVER = counter++;
        KEY_BACKGROUND_REPEAT = counter++;
        KEY_BACKGROUND_POSITION = counter++;
        KEY_DIRECTION = counter++;
        KEY_UNICODE_BIDI = counter++;
        KEY_TEXT_DECORATION_STYLE = counter++;
        KEY_MIN_HEIGHT = counter++;
        KEY_MAX_HEIGHT = counter++;
        KEY_POSITION = counter++;
        KEY_TOP = counter++;
        KEY_BOTTOM = counter++;
        KEY_LEFT = counter++;
        KEY_RIGHT = counter++;
        KEY_OUTLINE_COLOR = counter++;
        KEY_OUTLINE_STYLE = counter++;
        KEY_OUTLINE_WIDTH = counter++;
        KEY_OXY_STYLE = counter++;
        KEY_EMPTY_CELLS_BOOLEAN = counter++;
        KEY_OXY_LINK_ACTIVATION_TRIGGER = counter++;
        KEY_OXY_FLOATING_TOOLBAR = counter++;
        KEY_BORDER_TOP_LEFT_RADIUS = counter++;
        KEY_BORDER_TOP_RIGHT_RADIUS = counter++;
        KEY_BORDER_BOTTOM_RIGHT_RADIUS = counter++;
        KEY_BORDER_BOTTOM_LEFT_RADIUS = counter++;
        pmCounter = counter;
        KEY_LIST_STYLE_IMAGE = pmCounter++;
        KEY_PAGE = pmCounter++;
        KEY_OXY_PAGE_GROUP = pmCounter++;
        KEY_IMAGE_RESOLUTION = pmCounter++;
        KEY_OXY_ALT_TEXT = pmCounter++;
        KEY_OXY_PDF_TAG_TYPE = pmCounter++;
        KEY_OXY_PDF_META_AUTHOR = pmCounter++;
        KEY_OXY_PDF_META_TITLE = pmCounter++;
        KEY_OXY_PDF_META_DESCRIPTION = pmCounter++;
        KEY_OXY_PDF_META_KEYWORDS = pmCounter++;
        KEY_OXY_PDF_META_KEYWORD = pmCounter++;
        KEY_OXY_PDF_META_COPYRIGHT = pmCounter++;
        KEY_OXY_PDF_META_COPYRIGHTED = pmCounter++;
        KEY_OXY_PDF_META_COPYRIGHT_URL = pmCounter++;
        KEY_OXY_PDF_META_CUSTOM = pmCounter++;
        KEY_BACKGROUND_SIZE = pmCounter++;
        KEY_BREAK_BEFORE = pmCounter++;
        KEY_BREAK_AFTER = pmCounter++;
        KEY_BREAK_INSIDE = pmCounter++;
        KEY_PAGE_BREAK_AFTER = pmCounter++;
        KEY_PAGE_BREAK_BEFORE = pmCounter++;
        KEY_PAGE_BREAK_INSIDE = pmCounter++;
        KEY_OXY_COLUMN_BREAK_AFTER = pmCounter++;
        KEY_OXY_COLUMN_BREAK_BEFORE = pmCounter++;
        KEY_OXY_COLUMN_BREAK_INSIDE = pmCounter++;
        KEY_OXY_BORDERS_CONDITIONALITY = pmCounter++;
        KEY_OXY_SPACE_BEFORE_CONDITIONALITY = pmCounter++;
        KEY_OXY_SPACE_AFTER_CONDITIONALITY = pmCounter++;
        KEY_OXY_CHANGEBAR_OFFSET = pmCounter++;
        KEY_OXY_CHANGEBAR_STYLE = pmCounter++;
        KEY_OXY_CHANGEBAR_PLACEMENT = pmCounter++;
        KEY_OXY_CHANGEBAR_COLOR = pmCounter++;
        KEY_OXY_CHANGEBAR_WIDTH = pmCounter++;
        KEY_ORPHANS = pmCounter++;
        KEY_WIDOWS = pmCounter++;
        KEY_STRING_SET = pmCounter++;
        KEY_FLOAT = pmCounter++;
        KEY_TABLE_ROW_SPAN = pmCounter++;
        KEY_TABLE_COLUMN_SPAN = pmCounter++;
        KEY_CAPTION_SIDE = pmCounter++;
        KEY_TABLE_LAYOUT = pmCounter++;
        KEY_BORDER_COLLAPSE = pmCounter++;
        KEY_COLUMN_SPAN = pmCounter++;
        KEY_TRANSFORM_ROTATION = pmCounter++;
        KEY_HYPHENS = pmCounter++;
        KEY_BOOKMARK_LEVEL = pmCounter++;
        KEY_BOOKMARK_LABEL = pmCounter++;
        KEY_BOOKMARK_STATE = pmCounter++;
        KEY_LETTER_SPACING = pmCounter++;
        KEY_FONT_FAMILY = pmCounter++;
        KEY_FONT_SIZE = pmCounter++;
        KEY_FONT_STYLE = pmCounter++;
        KEY_FONT_VARIANT = pmCounter++;
        KEY_FONT_VARIANT_ALTERNATES = pmCounter++;
        KEY_FONT_VARIANT_LIGATURES = pmCounter++;
        KEY_FONT_VARIANT_NUMERIC = pmCounter++;
        KEY_OVERFLOW_WRAP = pmCounter++;
        KEY_OXY_HYPHENATION_CHARACTER = pmCounter++;
        KEY_OXY_HYPHENATION_PUSH_CHARACTER_COUNT = pmCounter++;
        KEY_OXY_HYPHENATION_REMAIN_CHARACTER_COUNT = pmCounter++;
        KEY_ALIGNMENT_BASELINE = pmCounter++;
        KEY_OXY_CAPTION_REPEAT_ON_NEXT_PAGES = pmCounter++;
        KEY_OXY_SHOW_ONLY_WHEN_CAPTION_REPEATED_ON_NEXT_PAGES = pmCounter++;
        KEY_OXY_AVOID_BREAKING_LINE_AT_HYPHENS = pmCounter++;
        KEY_OXY_BREAK_LINE_AT_HYPHENS = pmCounter++;
        KEY_OXY_PDF_VIEWER_ZOOM = pmCounter++;
        KEY_OXY_PDF_VIEWER_HIDE_TOOLBAR = pmCounter++;
        KEY_OXY_PDF_VIEWER_HIDE_MENUBAR = pmCounter++;
        KEY_OXY_PDF_VIEWER_FIT_WINDOW = pmCounter++;
        KEY_OXY_PDF_VIEWER_DISPLAY_FILENAME = pmCounter++;
        KEY_OXY_PDF_TABLE_OMIT_HEADER_BREAK = pmCounter++;
        KEY_OXY_PDF_TABLE_OMIT_FOOTER_BREAK = pmCounter++;
        KEY_OXY_PDF_VIEWER_PAGE_MODE = pmCounter++;
        KEY_OXY_PDF_VIEWER_PAGE_LAYOUT = pmCounter++;
        EMPTY_STRING_ARRAY = new String[0];
        EMPTY_CONTENT = new StaticContent[0];
        EMPTY_COUNTERS = new CSSCounter[0];
        EMPTY_COUNTERS_INCREMENT = new CSSCounterIncrement[0];
        EMPTY_BORDER_SPACING = new int[]{0, 0};
        ZERO_RELATIVE_LENGTH = RelativeLength.createAbsolute(0);
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        HashMap<Object, Integer> object3 = new HashMap<Object, Integer>();
        Field[] fieldArray = Styles.class.getDeclaredFields();
        for (int i2 = 0; i2 < fieldArray.length; ++i2) {
            boolean bl;
            String string = fieldArray[i2].getName();
            boolean bl2 = bl = string.startsWith("KEY") && fieldArray[i2].getAnnotation(Deprecated.class) == null;
            if (!bl) continue;
            Object object = string.substring(4);
            if (((String)object).startsWith("OXY_")) {
                object = "-" + (String)object;
            }
            object = ((String)object).toLowerCase();
            object = ((String)object).replace("_", "-");
            try {
                int n2 = fieldArray[i2].getInt(null);
                object3.put(object, n2);
                hashMap.put(n2, object);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object3.put("text-decoration", KEY_TEXT_DECORATION_LINE);
        object3.put("color", KEY_FOREGROUND_COLOR);
        hashMap.put(KEY_FOREGROUND_COLOR, "color");
        object3.put("white-space", KEY_WHITESPACE);
        hashMap.put(KEY_WHITESPACE, "white-space");
        object3.put("content", KEY_MIXED_CONTENT);
        hashMap.put(KEY_MIXED_CONTENT, "content");
        object3.remove("font");
        object3.remove("font-family");
        object3.remove("font-style");
        object3.remove("font-size");
        PROPERTY_TO_INDEX = Collections.unmodifiableMap(object3);
        INDEX_TO_PROPERTY = Collections.unmodifiableMap(hashMap);
        UN_INHERITABLE_STYLES = new HashMap();
        UN_INHERITABLE_STYLES.put(KEY_DISPLAY, "display");
        UN_INHERITABLE_STYLES.put(KEY_COUNTER_RESET, "counter-reset");
        UN_INHERITABLE_STYLES.put(KEY_COUNTER_INCREMENT, "counter-increment");
        UN_INHERITABLE_STYLES.put(KEY_FOLDABLE, "-oxy-foldable");
        UN_INHERITABLE_STYLES.put(KEY_FOLDED, "-oxy-folded");
        UN_INHERITABLE_STYLES.put(KEY_MIXED_CONTENT, "content");
        UN_INHERITABLE_STYLES.put(KEY_FILTERED_OUT, null);
        UN_INHERITABLE_STYLES.put(KEY_SHOW_PLACEHOLDER, "-oxy-show-placeholder");
        UN_INHERITABLE_STYLES.put(KEY_PLACEHOLDER_CONTENT, "-oxy-placeholder-content");
        UN_INHERITABLE_STYLES.put(KEY_MARGIN_BOTTOM, "margin-bottom");
        UN_INHERITABLE_STYLES.put(KEY_MARGIN_LEFT, "margin-left");
        UN_INHERITABLE_STYLES.put(KEY_MARGIN_RIGHT, "margin-right");
        UN_INHERITABLE_STYLES.put(KEY_MARGIN_TOP, "margin-top");
        UN_INHERITABLE_STYLES.put(KEY_PAGE, "page");
        UN_INHERITABLE_STYLES.put(KEY_PADDING_BOTTOM, "padding-bottom");
        UN_INHERITABLE_STYLES.put(KEY_PADDING_LEFT, "padding-left");
        UN_INHERITABLE_STYLES.put(KEY_PADDING_RIGHT, "padding-right");
        UN_INHERITABLE_STYLES.put(KEY_PADDING_TOP, "padding-top");
        UN_INHERITABLE_STYLES.put(KEY_BORDER_BOTTOM_COLOR, "border-bottom-color");
        UN_INHERITABLE_STYLES.put(KEY_BORDER_BOTTOM_STYLE, "border-bottom-style");
        UN_INHERITABLE_STYLES.put(KEY_BORDER_BOTTOM_WIDTH, "border-bottom-width");
        UN_INHERITABLE_STYLES.put(KEY_BORDER_LEFT_COLOR, "border-left-color");
        UN_INHERITABLE_STYLES.put(KEY_BORDER_LEFT_STYLE, "border-left-style");
        UN_INHERITABLE_STYLES.put(KEY_BORDER_LEFT_WIDTH, "border-left-width");
        UN_INHERITABLE_STYLES.put(KEY_BORDER_RIGHT_COLOR, "border-right-color");
        UN_INHERITABLE_STYLES.put(KEY_BORDER_RIGHT_STYLE, "border-right-style");
        UN_INHERITABLE_STYLES.put(KEY_BORDER_RIGHT_WIDTH, "border-right-width");
        UN_INHERITABLE_STYLES.put(KEY_BORDER_TOP_COLOR, "border-top-color");
        UN_INHERITABLE_STYLES.put(KEY_BORDER_TOP_STYLE, "border-top-style");
        UN_INHERITABLE_STYLES.put(KEY_BORDER_TOP_WIDTH, "border-top-width");
        UN_INHERITABLE_STYLES.put(KEY_OUTLINE_COLOR, "outline-color");
        UN_INHERITABLE_STYLES.put(KEY_OUTLINE_STYLE, "outline-style");
        UN_INHERITABLE_STYLES.put(KEY_OUTLINE_WIDTH, "outline-width");
        UN_INHERITABLE_STYLES.put(KEY_BACKGROUND_COLOR, "background-color");
        UN_INHERITABLE_STYLES.put(KEY_BACKGROUND_IMAGE, "background-image");
        UN_INHERITABLE_STYLES.put(KEY_OXY_FOREGROUND_IMAGE, "-oxy-foreground-image");
        UN_INHERITABLE_STYLES.put(KEY_OXY_VIDEO_COVER, "-oxy-video-cover");
        UN_INHERITABLE_STYLES.put(KEY_BACKGROUND_REPEAT, "background-repeat");
        UN_INHERITABLE_STYLES.put(KEY_BACKGROUND_POSITION, "background-position");
        UN_INHERITABLE_STYLES.put(KEY_BACKGROUND_SIZE, "background-size");
        UN_INHERITABLE_STYLES.put(KEY_UNICODE_BIDI, "unicode-bidi");
        UN_INHERITABLE_STYLES.put(KEY_WIDTH, "width");
        UN_INHERITABLE_STYLES.put(KEY_HEIGHT, "height");
        UN_INHERITABLE_STYLES.put(KEY_MIN_WIDTH, "min-width");
        UN_INHERITABLE_STYLES.put(KEY_MAX_WIDTH, "max-width");
        UN_INHERITABLE_STYLES.put(KEY_MIN_HEIGHT, "min-height");
        UN_INHERITABLE_STYLES.put(KEY_MAX_HEIGHT, "max-height");
        UN_INHERITABLE_STYLES.put(KEY_VERTICAL_ALIGN, "vertical-align");
        UN_INHERITABLE_STYLES.put(KEY_ALIGNMENT_BASELINE, "alignment-baseline");
        UN_INHERITABLE_STYLES.put(KEY_NON_FOLDABLE_CHILD_NAME, "-oxy-not-foldable-child");
        UN_INHERITABLE_STYLES.put(KEY_POSITION, "position");
        UN_INHERITABLE_STYLES.put(KEY_LEFT, "left");
        UN_INHERITABLE_STYLES.put(KEY_RIGHT, "right");
        UN_INHERITABLE_STYLES.put(KEY_TOP, "top");
        UN_INHERITABLE_STYLES.put(KEY_BOTTOM, "bottom");
        UN_INHERITABLE_STYLES.put(KEY_TAGS_BACKGROUND_COLOR, "-oxy-tags-background-color");
        UN_INHERITABLE_STYLES.put(KEY_TAGS_COLOR, "-oxy-tags-color");
        UN_INHERITABLE_STYLES.put(KEY_TEXT_DECORATION, "text-decoration");
        UN_INHERITABLE_STYLES.put(KEY_TEXT_DECORATION_LINE, "text-decoration-line");
        UN_INHERITABLE_STYLES.put(KEY_TEXT_DECORATION_COLOR, "text-decoration-color");
        UN_INHERITABLE_STYLES.put(KEY_TEXT_DECORATION_STYLE, "text-decoration-style");
        UN_INHERITABLE_STYLES.put(KEY_OXY_STYLE, "-oxy-style");
        UN_INHERITABLE_STYLES.put(KEY_BREAK_BEFORE, "break-before");
        UN_INHERITABLE_STYLES.put(KEY_BREAK_AFTER, "break-after");
        UN_INHERITABLE_STYLES.put(KEY_BREAK_INSIDE, "break-inside");
        UN_INHERITABLE_STYLES.put(KEY_PAGE_BREAK_AFTER, "page-break-after");
        UN_INHERITABLE_STYLES.put(KEY_PAGE_BREAK_BEFORE, "page-break-before");
        UN_INHERITABLE_STYLES.put(KEY_PAGE_BREAK_INSIDE, "page-break-inside");
        UN_INHERITABLE_STYLES.put(KEY_OXY_COLUMN_BREAK_AFTER, "-oxy-column-break-after");
        UN_INHERITABLE_STYLES.put(KEY_OXY_COLUMN_BREAK_BEFORE, "-oxy-column-break-before");
        UN_INHERITABLE_STYLES.put(KEY_OXY_COLUMN_BREAK_INSIDE, "-oxy-column-break-inside");
        UN_INHERITABLE_STYLES.put(KEY_STRING_SET, "string-set");
        UN_INHERITABLE_STYLES.put(KEY_FLOAT, "float");
        UN_INHERITABLE_STYLES.put(KEY_TABLE_ROW_SPAN, "table-row-span");
        UN_INHERITABLE_STYLES.put(KEY_TABLE_COLUMN_SPAN, "table-column-span");
        UN_INHERITABLE_STYLES.put(KEY_TABLE_LAYOUT, "table-layout");
        UN_INHERITABLE_STYLES.put(KEY_COLUMN_SPAN, "column-span");
        UN_INHERITABLE_STYLES.put(KEY_TRANSFORM_ROTATION, "transform-rotation");
        UN_INHERITABLE_STYLES.put(KEY_OXY_ALT_TEXT, "-oxy-alt-text");
        UN_INHERITABLE_STYLES.put(KEY_OXY_PDF_TAG_TYPE, "-oxy-pdf-tag-type");
        UN_INHERITABLE_STYLES.put(KEY_OXY_PDF_META_AUTHOR, "-oxy-pdf-meta-author");
        UN_INHERITABLE_STYLES.put(KEY_OXY_PDF_META_TITLE, "-oxy-pdf-meta-title");
        UN_INHERITABLE_STYLES.put(KEY_OXY_PDF_META_DESCRIPTION, "-oxy-pdf-meta-description");
        UN_INHERITABLE_STYLES.put(KEY_OXY_PDF_META_KEYWORDS, "-oxy-pdf-meta-keywords");
        UN_INHERITABLE_STYLES.put(KEY_OXY_PDF_META_KEYWORD, "-oxy-pdf-meta-keyword");
        UN_INHERITABLE_STYLES.put(KEY_OXY_PDF_META_CUSTOM, "-oxy-pdf-meta-custom");
        UN_INHERITABLE_STYLES.put(KEY_OXY_PDF_META_COPYRIGHT, "-oxy-pdf-meta-copyright");
        UN_INHERITABLE_STYLES.put(KEY_OXY_PDF_META_COPYRIGHTED, "-oxy-pdf-meta-copyrighted");
        UN_INHERITABLE_STYLES.put(KEY_OXY_PDF_META_COPYRIGHT_URL, "-oxy-pdf-meta-copyright-url");
        UN_INHERITABLE_STYLES.put(KEY_OXY_PDF_VIEWER_ZOOM, "-oxy-pdf-viewer-zoom");
        UN_INHERITABLE_STYLES.put(KEY_OXY_PDF_VIEWER_FIT_WINDOW, "-oxy-pdf-viewer-fit-window");
        UN_INHERITABLE_STYLES.put(KEY_OXY_PDF_VIEWER_DISPLAY_FILENAME, "-oxy-pdf-viewer-display-filename");
        UN_INHERITABLE_STYLES.put(KEY_OXY_PDF_VIEWER_PAGE_LAYOUT, "-oxy-pdf-viewer-page-layout");
        UN_INHERITABLE_STYLES.put(KEY_OXY_PDF_VIEWER_PAGE_MODE, "-oxy-pdf-viewer-page-mode");
        UN_INHERITABLE_STYLES.put(KEY_OXY_PDF_VIEWER_HIDE_TOOLBAR, "-oxy-pdf-viewer-hide-toolbar");
        UN_INHERITABLE_STYLES.put(KEY_OXY_PDF_VIEWER_HIDE_MENUBAR, "-oxy-pdf-viewer-hide-menubar");
        UN_INHERITABLE_STYLES.put(KEY_OXY_PDF_TABLE_OMIT_FOOTER_BREAK, "-oxy-pdf-table-omit-footer-at-break");
        UN_INHERITABLE_STYLES.put(KEY_OXY_PDF_TABLE_OMIT_HEADER_BREAK, "-oxy-pdf-table-omit-header-at-break");
        UN_INHERITABLE_STYLES.put(KEY_BOOKMARK_LEVEL, "bookmark-level");
        UN_INHERITABLE_STYLES.put(KEY_BOOKMARK_LABEL, "bookmark-label");
        UN_INHERITABLE_STYLES.put(KEY_BOOKMARK_STATE, "bookmark-state");
        UN_INHERITABLE_STYLES.put(KEY_OXY_PAGE_GROUP, "-oxy-page-group");
        UN_INHERITABLE_STYLES.put(KEY_OXY_BORDERS_CONDITIONALITY, "-oxy-borders-conditionality");
        UN_INHERITABLE_STYLES.put(KEY_OXY_SPACE_BEFORE_CONDITIONALITY, "-oxy-space-before-conditionality");
        UN_INHERITABLE_STYLES.put(KEY_OXY_SPACE_AFTER_CONDITIONALITY, "-oxy-space-after-conditionality");
        UN_INHERITABLE_STYLES.put(KEY_OXY_SHOW_ONLY_WHEN_CAPTION_REPEATED_ON_NEXT_PAGES, "-oxy-show-only-when-caption-repeated-on-next-pages");
        UN_INHERITABLE_STYLES.put(KEY_OXY_FLOATING_TOOLBAR, "-oxy-floating-toolbar");
        UN_INHERITABLE_STYLES.put(KEY_BORDER_TOP_LEFT_RADIUS, "border-top-left-radius");
        UN_INHERITABLE_STYLES.put(KEY_BORDER_TOP_RIGHT_RADIUS, "border-top-right-radius");
        UN_INHERITABLE_STYLES.put(KEY_BORDER_BOTTOM_RIGHT_RADIUS, "border-bottom-right-radius");
        UN_INHERITABLE_STYLES.put(KEY_BORDER_BOTTOM_LEFT_RADIUS, "border-bottom-left-radius");
        UN_INHERITABLE_PROPERTIES = new HashSet<String>();
        for (String string : UN_INHERITABLE_STYLES.values()) {
            UN_INHERITABLE_PROPERTIES.add(string);
        }
    }
}

