/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.css;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.css.sac.LexicalUnit;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;

@API(type=APIType.INTERNAL, src=SourceType.PRIVATE)
@SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.PUBLIC, methods=SkipLevel.PUBLIC)
public class FontFaceDefinitionSrcParser {
    private static final String c = "local";
    private static final String e = "format";
    private static final Logger b = LoggerFactory.getLogger((String)FontFaceDefinitionSrcParser.class.getName());
    private final URL d;

    public FontFaceDefinitionSrcParser(URL uRL) {
        this.d = uRL;
    }

    public String getFirstURIFontReferencesFromSrc(LexicalUnit lexicalUnit) {
        List<FontLocation> list = this.getFontReferences(lexicalUnit);
        FontLocation fontLocation = null;
        for (FontLocation fontLocation2 : list) {
            if (fontLocation2.b != FontLocationType.REMOTE) continue;
            fontLocation = fontLocation2;
            break;
        }
        if (fontLocation != null) {
            return fontLocation.f;
        }
        return null;
    }

    public List<FontLocation> getFontReferences(LexicalUnit lexicalUnit) {
        ArrayList<FontLocation> arrayList = new ArrayList<FontLocation>(1);
        LexicalUnit lexicalUnit2 = lexicalUnit;
        while (lexicalUnit2 != null) {
            FontLocation fontLocation;
            FontLocation fontLocation2;
            if (lexicalUnit2.getLexicalUnitType() == 24) {
                fontLocation2 = new FontLocation(FontLocationType.REMOTE, null, lexicalUnit2.getStringValue());
                fontLocation2.c = this.d;
                arrayList.add(fontLocation2);
                lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                if (lexicalUnit2 != null && lexicalUnit2.getLexicalUnitType() == 41 && e.equalsIgnoreCase(lexicalUnit2.getFunctionName()) && (fontLocation = lexicalUnit2.getParameters()) != null) {
                    fontLocation2.e = fontLocation.getStringValue();
                }
            } else if (lexicalUnit2.getLexicalUnitType() == 41) {
                if (c.equalsIgnoreCase(lexicalUnit2.getFunctionName()) && (fontLocation2 = lexicalUnit2.getParameters()) != null) {
                    fontLocation = new FontLocation(FontLocationType.LOCAL, fontLocation2.getStringValue(), null);
                    arrayList.add(fontLocation);
                }
            } else if (lexicalUnit2.getLexicalUnitType() != 0) {
                b.warn("Unexpected value for the font-face src property: {} {}", (Object)lexicalUnit2.getLexicalUnitType(), (Object)lexicalUnit2);
            }
            if (lexicalUnit2 == null) continue;
            lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
        }
        return arrayList;
    }

    public URL getCssUrl() {
        return this.d;
    }

    @API(type=APIType.INTERNAL, src=SourceType.PRIVATE)
    @SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.PUBLIC, methods=SkipLevel.PUBLIC)
    public static class FontLocation {
        private final FontLocationType b;
        private final String d;
        private final String f;
        private String e;
        private URL c;

        public FontLocationType getType() {
            return this.b;
        }

        public String getLocalFontName() {
            return this.d;
        }

        public String getRemoteLocation() {
            return this.f;
        }

        public String getFormat() {
            return this.e;
        }

        public URL getCssURL() {
            return this.c;
        }

        public FontLocation(FontLocationType fontLocationType, String string, String string2) {
            this.b = fontLocationType;
            this.d = string;
            this.f = string2;
        }

        public String toString() {
            String string = this.b == FontLocationType.LOCAL ? "(local:" + this.d + ")" : "(remote:" + this.f + ", " + this.c + " )";
            return string;
        }
    }

    @API(type=APIType.INTERNAL, src=SourceType.PRIVATE)
    @SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.PUBLIC, methods=SkipLevel.PUBLIC)
    public static final class FontLocationType
    extends Enum<FontLocationType> {
        public static final /* enum */ FontLocationType LOCAL = new FontLocationType();
        public static final /* enum */ FontLocationType REMOTE = new FontLocationType();
        private static final /* synthetic */ FontLocationType[] b;

        public static FontLocationType[] values() {
            return (FontLocationType[])b.clone();
        }

        public static FontLocationType valueOf(String string) {
            return Enum.valueOf(FontLocationType.class, string);
        }

        private static /* synthetic */ FontLocationType[] b() {
            return new FontLocationType[]{LOCAL, REMOTE};
        }

        static {
            b = FontLocationType.b();
        }
    }
}

