/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.css;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.flute.parser.LexicalUnitImpl;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.css.CSSCounter;
import ro.sync.ecss.css.CSSCounterIncrement;
import ro.sync.ecss.css.CounterContent;
import ro.sync.ecss.css.CountersContent;
import ro.sync.ecss.css.EditorContent;
import ro.sync.ecss.css.LabelContent;
import ro.sync.ecss.css.RelativeLength;
import ro.sync.ecss.css.StaticContent;
import ro.sync.ecss.css.URIContent;
import ro.sync.ecss.css.cb;
import ro.sync.ecss.css.functions.lc;
import ro.sync.ecss.css.h;
import ro.sync.ecss.css.ib;
import ro.sync.exml.editor.xmleditor.prettyprint.c;
import ro.sync.exml.view.graphics.Color;
import ro.sync.exml.view.graphics.Font;

@API(type=APIType.INTERNAL, src=SourceType.PRIVATE)
public final class CSSInspectorInfoStylePropertySerializer {
    private static final Logger b = LoggerFactory.getLogger((String)CSSInspectorInfoStylePropertySerializer.class.getName());
    private static final int c = 100;
    private static final List<String> d = Collections.unmodifiableList(Arrays.asList("-width", "-height", "-size", "-bottom", "-left", "-top", "-right", "-spacing"));

    private CSSInspectorInfoStylePropertySerializer() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static String getCSSValueRepr(String string, Object object, boolean bl, boolean bl2) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            if (object instanceof String) {
                stringBuilder.append(CSSInspectorInfoStylePropertySerializer.f(object.toString(), bl));
            } else if (object instanceof Integer) {
                CSSInspectorInfoStylePropertySerializer.k(string, (Integer)object, bl2, stringBuilder);
            } else if (object instanceof Boolean) {
                stringBuilder.append((Boolean)object);
            } else if (object instanceof Color) {
                CSSInspectorInfoStylePropertySerializer.e((Color)object, stringBuilder);
            } else if (object instanceof URIContent) {
                CSSInspectorInfoStylePropertySerializer.m((URIContent)object, stringBuilder);
            } else if (object instanceof RelativeLength) {
                CSSInspectorInfoStylePropertySerializer.h(string, (RelativeLength)object, bl2, stringBuilder);
            } else if (object instanceof Font) {
                CSSInspectorInfoStylePropertySerializer.l((Font)object, stringBuilder);
            } else if (object instanceof String[]) {
                CSSInspectorInfoStylePropertySerializer.g((String[])object, stringBuilder);
            } else if (object instanceof int[]) {
                CSSInspectorInfoStylePropertySerializer.j(string, (int[])object, bl2, stringBuilder);
            } else if (object instanceof StaticContent[]) {
                CSSInspectorInfoStylePropertySerializer.b((StaticContent[])object, stringBuilder);
            } else if (object instanceof CSSCounterIncrement[]) {
                CSSInspectorInfoStylePropertySerializer.n((CSSCounterIncrement[])object, stringBuilder);
            } else if (object instanceof CSSCounter[]) {
                CSSCounter[] cSSCounterArray;
                for (CSSCounter cSSCounter : cSSCounterArray = (CSSCounter[])object) {
                    stringBuilder.append(cSSCounter.getName()).append(',');
                }
            } else if (object instanceof Float) {
                CSSInspectorInfoStylePropertySerializer.k(string, (Float)object, bl2, stringBuilder);
            } else if (object instanceof lc) {
                ((lc)((Object)object)).toStringNoNext(stringBuilder);
            } else if (object instanceof cb) {
                cb cb2 = (cb)object;
                String string2 = cb2.b().toString().toLowerCase();
                String string3 = cb2.c().toString().toLowerCase();
                stringBuilder.append(string2).append(' ').append(string3);
            } else if (object instanceof LexicalUnitImpl) {
                if (!h.ab(string)) {
                    ((LexicalUnitImpl)object).toStringNoNext(stringBuilder);
                } else {
                    stringBuilder.append(object);
                }
            } else {
                stringBuilder.append(object);
                b.warn(() -> "Property value not handled for :" + string + " " + object.getClass() + " " + object);
            }
            return stringBuilder.toString();
        }
        catch (Throwable throwable) {
            throw new AssertionError((Object)("Unreachable: " + throwable));
        }
    }

    private static boolean i(String string) {
        String string2;
        boolean bl = false;
        Iterator<String> iterator = d.iterator();
        while (iterator.hasNext() && !(bl = string.endsWith(string2 = iterator.next()))) {
        }
        return bl;
    }

    private static void k(String string, Number number, boolean bl, StringBuilder stringBuilder) {
        if (CSSInspectorInfoStylePropertySerializer.i(string)) {
            if (bl) {
                double d2 = (double)number.floatValue() * 72.0 / (double)ib.e;
                if ((d2 = (double)Math.round(d2 * 1000.0) / 1000.0) == Math.floor(d2)) {
                    stringBuilder.append((int)d2);
                } else {
                    stringBuilder.append(d2);
                }
                stringBuilder.append("pt");
            } else {
                stringBuilder.append(number);
                if (number.floatValue() != 0.0f) {
                    stringBuilder.append("px");
                }
            }
        } else {
            stringBuilder.append(number);
        }
    }

    private static void j(String string, int[] nArray, boolean bl, StringBuilder stringBuilder) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            CSSInspectorInfoStylePropertySerializer.k(string, nArray[i2], bl, stringBuilder);
            stringBuilder.append(' ');
        }
    }

    private static void e(Color color, StringBuilder stringBuilder) {
        if (color.getAlpha() != 255) {
            stringBuilder.append("rgba(").append(color.getRed()).append(',').append(color.getGreen()).append(',').append(color.getBlue()).append(',');
            float f2 = (float)((int)((double)color.getAlpha() / 255.0 * 100.0)) / 100.0f;
            stringBuilder.append(Double.toString(f2)).append(')');
        } else {
            stringBuilder.append(Color.getHexColor(color));
        }
    }

    private static void m(URIContent uRIContent, StringBuilder stringBuilder) {
        Object object = uRIContent.getHref();
        if (object != null && ((String)object).length() > 100 && ((String)object).startsWith("data:")) {
            object = ((String)object).substring(0, 100) + "...";
        }
        stringBuilder.append("url(").append((String)object).append(')');
    }

    private static void h(String string, RelativeLength relativeLength, boolean bl, StringBuilder stringBuilder) {
        if (relativeLength.isAuto()) {
            stringBuilder.append("auto");
        } else if (relativeLength.isRelative() || relativeLength.isCalc()) {
            stringBuilder.append(relativeLength.getLengthRepr());
        } else {
            CSSInspectorInfoStylePropertySerializer.k(string, (int)relativeLength.getValue(), bl, stringBuilder);
        }
    }

    private static void l(Font font, StringBuilder stringBuilder) {
        if (font.isItalic()) {
            stringBuilder.append("italic ");
        }
        if (font.isBold()) {
            stringBuilder.append("bold ");
        }
        stringBuilder.append(font.getSize()).append("px ").append(font.getName());
        String[] stringArray = font.getFontNames();
        for (int i2 = 1; i2 < stringArray.length; ++i2) {
            stringBuilder.append(" , ").append(stringArray[i2]);
        }
    }

    private static void g(String[] stringArray, StringBuilder stringBuilder) {
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(stringArray[i2]);
        }
    }

    private static void d(StaticContent staticContent, StringBuilder stringBuilder) {
        switch (staticContent.getType()) {
            case 0: {
                stringBuilder.append(CSSInspectorInfoStylePropertySerializer.f(staticContent.toString(), true));
                break;
            }
            case 5: {
                stringBuilder.append("oxy_label(");
                for (Map.Entry<String, Object> entry : ((LabelContent)staticContent).getProperties().entrySet()) {
                    stringBuilder.append(entry.getKey()).append(", ").append(entry.getValue()).append(", ");
                }
                stringBuilder.append(')');
                break;
            }
            case 1: {
                CSSInspectorInfoStylePropertySerializer.m((URIContent)staticContent, stringBuilder);
                break;
            }
            case 4: {
                Map<String, Object> map = ((EditorContent)staticContent).getProperties();
                TreeSet<String> treeSet = new TreeSet<String>(map.keySet());
                stringBuilder.append("oxy_editor(");
                boolean bl = true;
                for (String string : treeSet) {
                    if (!bl) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(string).append(", ").append(CSSInspectorInfoStylePropertySerializer.getCSSValueRepr(null, map.get(string), true, false));
                    bl = false;
                }
                stringBuilder.append(')');
                break;
            }
            case 2: {
                String string = ((CounterContent)staticContent).getCounterName();
                stringBuilder.append("counter(").append(string).append(')');
                break;
            }
            case 3: {
                CountersContent countersContent = (CountersContent)staticContent;
                String string = countersContent.getCounterName();
                stringBuilder.append("counters(").append(string).append(',').append(countersContent.getDelimiter()).append(')');
                break;
            }
        }
    }

    private static void b(StaticContent[] staticContentArray, StringBuilder stringBuilder) {
        for (int i2 = 0; i2 < staticContentArray.length; ++i2) {
            CSSInspectorInfoStylePropertySerializer.d(staticContentArray[i2], stringBuilder);
            if (i2 >= staticContentArray.length - 1) continue;
            stringBuilder.append(' ');
        }
    }

    private static void n(CSSCounterIncrement[] cSSCounterIncrementArray, StringBuilder stringBuilder) {
        for (CSSCounterIncrement cSSCounterIncrement : cSSCounterIncrementArray) {
            stringBuilder.append(cSSCounterIncrement.getName());
            int n2 = cSSCounterIncrement.getIncrement();
            if (n2 != 1) {
                stringBuilder.append(' ').append(n2);
            }
            stringBuilder.append(',');
        }
    }

    private static Object f(String string, boolean bl) {
        boolean bl2 = bl;
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n2);
        block5: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '\n': {
                    stringBuilder.append("\\A");
                    continue block5;
                }
                case '\"': {
                    stringBuilder.append("\\\"");
                    bl2 = true;
                    continue block5;
                }
                case '\'': 
                case '/': {
                    bl2 = true;
                }
                default: {
                    bl2 = bl2 || ro.sync.exml.editor.xmleditor.prettyprint.c.c(c2);
                    stringBuilder.append(c2);
                }
            }
        }
        if (bl2) {
            string = stringBuilder.insert(0, '\"').append('\"').toString();
        }
        return string;
    }
}

