/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.component.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.Date;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.undo.UndoManager;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.document.hc;
import ro.sync.document.q;
import ro.sync.ecss.component.editor.db;
import ro.sync.ecss.component.editor.fb;
import ro.sync.ecss.component.editor.lb;
import ro.sync.ecss.extensions.api.CursorType;
import ro.sync.ecss.extensions.api.editor.AbstractInplaceEditor;
import ro.sync.ecss.extensions.api.editor.AuthorInplaceContext;
import ro.sync.ecss.extensions.api.editor.EditingEvent;
import ro.sync.ecss.extensions.api.editor.InplaceRenderer;
import ro.sync.ecss.extensions.api.editor.RendererLayoutInfo;
import ro.sync.ecss.extensions.commons.editor.InplaceEditorUtil;
import ro.sync.exml.view.graphics.Dimension;
import ro.sync.exml.view.graphics.Font;
import ro.sync.exml.view.graphics.Point;
import ro.sync.exml.view.graphics.Rectangle;
import ro.sync.exml.workspace.api.standalone.ui.Button;
import ro.sync.i18n.c;
import ro.sync.i18n.r;
import ro.sync.ui.calendar.d;
import ro.sync.ui.calendar.f;
import ro.sync.ui.jb;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class DatePickerEditor
extends AbstractInplaceEditor
implements InplaceRenderer,
fb {
    private static final Logger pty = LoggerFactory.getLogger((String)DatePickerEditor.class.getName());
    protected static final c messages = r.m();
    private String kty = "custom";
    private String nty;
    private d ity;
    private f oty;
    private java.awt.Font hty;
    private String mty;
    private DocumentListener rty = new DocumentListener(){

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            DatePickerEditor.this.fireEditingOccured();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            DatePickerEditor.this.fireEditingOccured();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            DatePickerEditor.this.fireEditingOccured();
        }
    };
    private KeyAdapter qty;
    private Color lty;
    private boolean jty = true;

    public DatePickerEditor() {
        final KeyStroke keyStroke = hc.f();
        this.oty = new f(null){

            @Override
            protected boolean processKeyBinding(KeyStroke keyStroke2, KeyEvent keyEvent, int n2, boolean bl) {
                boolean bl2 = true;
                if (keyStroke.equals(keyStroke2)) {
                    q q2 = hc.e(this.getDocument());
                    bl2 = ((UndoManager)q2).canUndo();
                }
                return bl2 ? super.processKeyBinding(keyStroke2, keyEvent, n2, bl) : false;
            }
        };
        this.ity = new d(null, null, null, this.oty, null);
        ArrayList<Component> arrayList = new ArrayList<Component>(1);
        arrayList.add(this.oty);
        this.ity.setFocusTraversalPolicy(new jb(this.ity, arrayList, this.oty, false));
        this.ity.setFocusTraversalPolicyProvider(true);
        this.qty = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    keyEvent.consume();
                    DatePickerEditor.this.cancelEditing();
                } else if (keyEvent.getKeyCode() == 10) {
                    keyEvent.consume();
                    DatePickerEditor.this.oyp(false, true);
                }
            }
        };
        this.hty = this.ity.getFont();
        this.lty = this.oty.j();
    }

    @Override
    public String getDescription() {
        return "A date picker.";
    }

    @Override
    public Object getEditorComponent(AuthorInplaceContext authorInplaceContext, Rectangle rectangle, Point point) {
        this.uyp(authorInplaceContext, true);
        return this.ity;
    }

    @Override
    public Rectangle getScrollRectangle() {
        return null;
    }

    @Override
    public void requestFocus() {
        this.oty.requestFocus();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getValue() {
        String string = "";
        Date date = this.ity.b();
        if (date != null) {
            if ("xs:date".equals(this.kty)) {
                return new SimpleDateFormat("yyyy-MM-dd").format(date);
            }
            if ("xs:dateTime".equals(this.kty)) {
                return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(date);
            }
            java.util.Date date2 = new java.util.Date(date.getTime());
            try {
                return new SimpleDateFormat(this.nty).format(date2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (!pty.isDebugEnabled()) return string;
                pty.debug((Object)illegalArgumentException, (Throwable)illegalArgumentException);
            }
            return string;
        } else {
            if (this.jty) return string;
            return this.oty.getText();
        }
    }

    private void oyp(boolean bl, boolean bl2) {
        this.ity.g();
        this.ity.removeKeyListener(this.qty);
        this.oty.getDocument().removeDocumentListener(this.rty);
        if (bl2) {
            this.fireNextEditLocationRequested();
        } else {
            this.fireEditingStopped(new EditingEvent((String)this.getValue(), bl));
        }
    }

    @Override
    public void stopEditing() {
        this.oyp(true, false);
    }

    @Override
    public void commitValue() {
        this.fireCommitValue(new EditingEvent((String)this.getValue()));
    }

    @Override
    public void cancelEditing() {
        this.ity.g();
        this.ity.removeKeyListener(this.qty);
        this.oty.getDocument().removeDocumentListener(this.rty);
        this.fireEditingCanceled();
    }

    @Override
    public Object getRendererComponent(AuthorInplaceContext authorInplaceContext) {
        this.uyp(authorInplaceContext, false);
        return this.ity;
    }

    @Override
    public CursorType getCursorType(AuthorInplaceContext authorInplaceContext, int n2, int n3) {
        return CursorType.CURSOR_NORMAL;
    }

    @Override
    public String getTooltipText(AuthorInplaceContext authorInplaceContext, int n2, int n3) {
        this.uyp(authorInplaceContext, false);
        if (this.mty != null) {
            return this.mty;
        }
        Component component = this.qyp(this.ity, n2, n3);
        if (component instanceof Button) {
            return messages.getString("Click_to_edit");
        }
        return this.oty.getText();
    }

    @Override
    public RendererLayoutInfo getRenderingInfo(AuthorInplaceContext authorInplaceContext) {
        this.uyp(authorInplaceContext, false);
        Dimension dimension = InplaceEditorUtil.getPreferredSize(this.ity, authorInplaceContext);
        return new RendererLayoutInfo(db.b(this.oty, dimension.width, dimension.height), dimension);
    }

    private void uyp(AuthorInplaceContext authorInplaceContext, boolean bl) {
        this.mty = null;
        Font font = (Font)authorInplaceContext.getArguments().get("font");
        if (font != null) {
            this.ity.setFont(new java.awt.Font(font.getName(), font.getStyle(), font.getSize()));
        } else {
            this.ity.setFont(this.hty);
        }
        ro.sync.exml.view.graphics.Color color = (ro.sync.exml.view.graphics.Color)authorInplaceContext.getArguments().get("color");
        if (color != null) {
            this.oty.g(new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()));
        } else {
            this.oty.g(this.lty);
        }
        this.ity.setOpaque(false);
        String string = (String)authorInplaceContext.getArguments().get("validateInput");
        boolean bl2 = this.jty = string == null ? true : Boolean.valueOf(string);
        if (this.jty) {
            this.oty.b(true);
        } else {
            this.oty.b(false);
        }
        this.kty = lb.b(authorInplaceContext);
        this.nty = (String)authorInplaceContext.getArguments().get("format");
        String string2 = ((SimpleDateFormat)DateFormat.getDateInstance(2, this.oty.getLocale())).toPattern();
        if (this.nty == null) {
            this.nty = string2;
        }
        this.syp(authorInplaceContext);
        if (bl) {
            this.oty.getDocument().addDocumentListener(this.rty);
            this.oty.addKeyListener(this.qty);
            this.oty.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    DatePickerEditor.this.ity.g();
                }
            });
        }
        this.oty.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!DatePickerEditor.this.ity.h()) {
                    DatePickerEditor.this.fireCommitValue(new EditingEvent((String)DatePickerEditor.this.getValue()));
                }
            }
        });
        Dimension dimension = InplaceEditorUtil.getPreferredSize(this.ity, authorInplaceContext);
        this.ity.setBounds(0, 0, dimension.width, dimension.height);
        this.oty.doLayout();
        if (!bl) {
            int n2;
            int n3;
            Component component;
            JButton jButton = this.ity.d();
            ButtonModel buttonModel = jButton.getModel();
            buttonModel.setRollover(false);
            buttonModel.setSelected(false);
            Point point = authorInplaceContext.getRelativeMouseLocation();
            if (point != null && (component = this.qyp(this.ity, n3 = point.x, n2 = point.y)) instanceof Button) {
                buttonModel.setRollover(true);
                buttonModel.setSelected(true);
            }
        }
    }

    private Component qyp(Component component, int n2, int n3) {
        Component component2 = component.getComponentAt(n2, n3);
        while (component2 != null && component2 != component) {
            component = component2;
            component2 = component.getComponentAt(n2 -= component2.getX(), n3 -= component2.getY());
        }
        return component2;
    }

    private void syp(AuthorInplaceContext authorInplaceContext) {
        String string = ((SimpleDateFormat)DateFormat.getDateInstance(2, this.oty.getLocale())).toPattern();
        Object object = authorInplaceContext.getArguments().get("format");
        String string2 = (String)authorInplaceContext.getArguments().get("initial_value");
        Long l2 = null;
        if ("custom".equals(this.kty)) {
            block17: {
                if (string2 != null) {
                    try {
                        java.util.Date date = new SimpleDateFormat(this.nty).parse(string2);
                        l2 = date.getTime();
                    }
                    catch (Exception exception) {
                        this.mty = exception.getMessage() + ". Expected \"" + this.nty + "\" format.";
                        if (!pty.isDebugEnabled()) break block17;
                        pty.debug((Object)exception, (Throwable)exception);
                    }
                }
            }
            this.oty.setDateFormatString(this.nty);
        } else if ("xs:date".equals(this.kty)) {
            if (string2 != null) {
                try {
                    Calendar calendar = DatatypeConverter.parseDate((String)string2);
                    l2 = calendar.getTimeInMillis();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.mty = "Invalid date: " + illegalArgumentException.getMessage() + ". Expected the xs:date format.";
                }
            }
            this.oty.setDateFormatString(object != null ? (String)object : string);
        } else if ("xs:dateTime".equals(this.kty)) {
            Object object2;
            if (string2 != null) {
                try {
                    object2 = DatatypeConverter.parseDateTime((String)string2);
                    l2 = ((Calendar)object2).getTimeInMillis();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.mty = "Invalid date-time: " + illegalArgumentException.getMessage() + ". Expected the xs:dateTime format.";
                }
            }
            object2 = ((SimpleDateFormat)DateFormat.getDateTimeInstance(2, 3)).toPattern();
            this.oty.setDateFormatString((String)(object != null ? (String)object : object2));
        }
        if (l2 != null) {
            this.ity.i(new Date(l2));
        } else {
            this.ity.i(null);
        }
        if (this.mty != null && string2 != null) {
            this.oty.setText(string2);
        }
    }

    @Override
    public CursorType getCursorType(int n2, int n3) {
        return null;
    }

    @Override
    public void dump(AuthorInplaceContext authorInplaceContext, StringBuilder stringBuilder) {
        this.uyp(authorInplaceContext, false);
        stringBuilder.append("value:'").append(this.oty.getText()).append("'");
        stringBuilder.append("color:'").append(this.oty.getForeground()).append("'");
    }

    @Override
    public void refresh(AuthorInplaceContext authorInplaceContext) {
        this.syp(authorInplaceContext);
    }

    @Override
    public boolean insertContent(String string) {
        boolean bl = false;
        try {
            this.oty.getDocument().insertString(this.oty.getCaretPosition(), string, null);
            bl = true;
        }
        catch (BadLocationException badLocationException) {
            pty.error((Object)badLocationException, (Throwable)badLocationException);
        }
        return bl;
    }
}

