/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.document;

import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.document.DetailedExceptionInfo;
import ro.sync.document.DocumentPositionedInfo;

@SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.PUBLIC, methods=SkipLevel.PUBLIC)
public class DPIDetailedExceptionUtil {
    private static final Logger b = LoggerFactory.getLogger((String)DPIDetailedExceptionUtil.class.getName());

    public static void computeAndAttachDetailedMessageToDPI(Throwable throwable, DocumentPositionedInfo documentPositionedInfo) {
        if (throwable != null) {
            if (documentPositionedInfo.getDetailedExceptionInfo() == null) {
                documentPositionedInfo.setDetailedExceptionInfo(DPIDetailedExceptionUtil.getDetailedExceptionData(throwable));
            }
            if (documentPositionedInfo.getDetailedExceptionInfo() == null) {
                documentPositionedInfo.setDetailedExceptionInfo(DPIDetailedExceptionUtil.getDetailedExceptionStackTrace(throwable));
            }
        }
    }

    public static DetailedExceptionInfo getDetailedExceptionData(Throwable throwable) {
        if (throwable != null && "ro.sync.net.protocol.http.HttpExceptionWithDetails".equals(throwable.getClass().getName())) {
            try {
                String string = (String)throwable.getClass().getMethod("getReason", null).invoke((Object)throwable, (Object[])null);
                URL uRL = (URL)throwable.getClass().getMethod("getBaseURL", null).invoke((Object)throwable, (Object[])null);
                if (string != null && string.length() > 0) {
                    return new DetailedExceptionInfo(string, uRL, throwable.getMessage());
                }
            }
            catch (Exception exception) {
                b.warn((Object)exception, (Throwable)exception);
            }
        }
        return null;
    }

    public static DetailedExceptionInfo getDetailedExceptionStackTrace(Throwable throwable) {
        return DPIDetailedExceptionUtil.getDetailedExceptionData(throwable);
    }

    public static DetailedExceptionInfo getDetailedExceptionData(DocumentPositionedInfo documentPositionedInfo) {
        return documentPositionedInfo.getDetailedExceptionInfo();
    }
}

