/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.diff.script;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.io.FileSystemUtil;
import ro.sync.basic.util.PlatformDetector;
import ro.sync.basic.util.URLUtil;
import ro.sync.diff.api.DiffOptions;
import ro.sync.diff.factory.DiffInfo;
import ro.sync.diff.merge.g;
import ro.sync.diff.script.CompareFiles;
import ro.sync.diff.script.b;
import ro.sync.diff.script.d;
import ro.sync.diff.ui.d.e;
import ro.sync.diff.ui.d.f;
import ro.sync.diff.ui.d.p;
import ro.sync.exml.options.Options;
import ro.sync.find.c.c;
import ro.sync.find.c.i;
import ro.sync.find.c.j;
import ro.sync.find.c.l;
import ro.sync.ui.t;
import ro.sync.util.fb;

@SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.NOT_SPECIFIED, methods=SkipLevel.PUBLIC)
public class CompareDirs
implements p {
    protected static final String[] o = new String[]{"-d1", "firstDirPath", "Mandatory argument that specifies the 1st directory path (it can also be provided as a URL using 'file://' protocol).\n", "-d1a"};
    protected static final String[] l = new String[]{"-d2", "secondDirPath", "Mandatory argument that specifies the 2nd directory path (it can also be provided as a URL using 'file://' protocol).\n", "-d2a"};
    protected static final String[] m = new String[]{CompareFiles.o[0], "baseDirPath", "Optional argument that specifies the path of the base directory that the other two directories will be compared against in a 3-way comparison (it can also be provided as a URL using 'file://' protocol). If present, it must appear immediately after the first two mandatory arguments.\n", "-bsa"};
    protected static final String[] n = new String[]{"-a", "dirPathAlias", "Optional argument used as directory path alias. Displayed in the HTML formatted operation report instead of a long directory path. If present, it must appear immediately after a directory path.\n"};
    protected static final String[] w = new String[]{"-sl", "suppressLinks", "Set this to \"true\" to suppress links to the compared directories and files shown in the HTML formatted report of the operation. Default value = \"false\".\n"};
    protected static final String[] p = new String[]{"-if", "includeFilesFilter", "Use this argument to only include files that match the specified pattern in the comparison (e.g. \"*.xml,*.json\"). Default value = \"*\".\n"};
    protected static final String[] f = new String[]{"-ia", "includeArchives", "Set this to \"true\" to include files from archives in the comparison. Default value = \"false\".\n"};
    protected static final String[] j = new String[]{"-ef", "excludeFilesFilter", "Excludes files that match the specified pattern from the comparison (e.g. \"*.jpg\").\n"};
    protected static final String[] i = new String[]{"-ed", "excludeSubdirsFilter", "Excludes sub-directories that match the specified pattern from the comparison (e.g. \".svn,_svn,.git\").\n"};
    protected static final String[] u = new String[]{"-cm", "comparisonMode", "Specifies the comparison mode. There are 3 modes available: \"content\", \"binary\", \"timestamp\". Default value = \"content\".\n"};
    protected static final String[] r = new String[]{"-out", "outputFormat", "Specifies the output format. Possible values = \"yaml/grouped\", \"yaml/raw\", \"json/grouped\", \"json/raw\", \"xml/grouped\", \"xml/raw\", \"html\", \"html/ifcr\", \"htm\", \"htm/ifcr\". Default value = \"yaml/grouped\". If you choose to save/redirect the console output to a file, this argument establishes the type of the output file and its content is formatted accordingly. If you skip specifying the \"/grouped\" or the \"/raw\" 'qualifiers', \"/grouped\" is the one considered. If you choose the \"html\" or \"htm\" output format, it is recommended that you also choose to save/redirect the console to the specified HTML file to view the comparison result in your preferred browser. The \"/ifcr\" qualifier for 'html/htm' values is considered only if the \"outfile\" argument is also present. \"IFCR\" is an acronym for 'Include File Comparison Reports' and it means that, along with generating the directory comparison report, separate file comparison reports will be generated for all modified file pairs. These file comparison reports are available through links from the main report and are saved to a specific directory based on the value provided by the \"outfile\" argument: it will have the same parent directory and the same name as the 'outputFile', plus \"-OXY-FC-REPORTS\" added to the end of its name. The 'html/htm' values, as well as any of 'grouped', 'raw', and 'ifcr' qualifiers, are not considered if the \"merge\" argument is present.\n"};
    protected static final String[] t = new String[]{"-merge", "mergeOperation", "If eet to \"true\", a merge operation is invoked after the comparison. Default value = \"false\". The argument is considered only for 3-way comparisons (i.e. only if the \"baseDirPath\" argument is provided). The merge operation is similar to the same process in any versioning system. Following the comparison between the first and second directories (relative to the base folder), all the differences of type \"incoming\" are considered and the contents of the 1st directory are updated accordingly. Conflicting changes are not addressed. After the comparison, a report is created that provides details about the changes that were made.\n"};
    protected static final String[] q = new String[]{"-mergeout", "outputDirPathForMerge", "Invokes a merge operation after the comparison and also allows you to specify the output directory path for the merge operation, For example it allows you to specify a specific existing or new directory where the result of the merge operation is saved, other than the first directory path for the comparison, (which is what happens when using only the \"-merge\" argument). The path of the directory can also be provided as a URL using 'file://' protocol. This argument and the \"-merge\" argument are not dependent on each other.\n"};
    protected static final String x = "M : ";
    public static final String k = "M1: ";
    public static final String h = "M2: ";
    protected static final String s = "O1: ";
    protected static final String e = "O2: ";
    protected static final String[] v = new String[]{"outgoing", "incoming", "modifications", "conflicts"};
    protected static final String[] g = new String[]{"added", "deleted", "updated", "merged", "conflicts"};

    private static void ab() {
        String[] stringArray;
        int n2;
        System.out.println("Script for comparing directories (2-way or 3-way) using the oXygen XML Editor Diff Directories Comparator\n");
        char c2 = ' ';
        String string = " = ";
        StringBuilder stringBuilder = new StringBuilder(c2);
        stringBuilder.append(o[1]).append(c2);
        stringBuilder.append('[').append(n[0]).append(c2).append(n[1]).append(']').append(c2);
        stringBuilder.append(l[1]).append(c2);
        stringBuilder.append('[').append(n[0]).append(c2).append(n[1]).append(']').append(c2);
        stringBuilder.append("[[").append(m[1]).append(c2);
        stringBuilder.append('[').append(n[0]).append(c2).append(n[1]).append("]] ");
        List<String[]> list = CompareDirs.q();
        for (n2 = 0; n2 < list.size(); ++n2) {
            stringArray = list.get(n2);
            stringBuilder.append(n2 > 0 ? Character.valueOf(c2) : "").append('[').append(stringArray[0]).append(c2).append(stringArray[1]).append(']');
        }
        stringBuilder.append(']').append(c2).append('[').append("-help | --help | -h | --h").append(']');
        System.out.println((PlatformDetector.isWin() ? "compareDirs.bat " : "sh compareDirs.sh ") + stringBuilder.toString());
        stringBuilder = new StringBuilder("\nWhere:\n");
        stringBuilder.append(c2).append(o[1]).append(string).append(o[2]);
        stringBuilder.append(c2).append(l[1]).append(string).append(l[2]);
        stringBuilder.append(c2).append(m[1]).append(string).append(m[2]);
        stringBuilder.append(c2).append(n[0]).append(c2).append(n[1]).append(string).append(n[2]);
        for (n2 = 0; n2 < list.size(); ++n2) {
            stringArray = list.get(n2);
            stringBuilder.append(c2).append(stringArray[0]).append(c2).append(stringArray[1]).append(string).append(stringArray[2]);
        }
        stringBuilder.append(c2).append("-help | --help | -h | --h").append(string).append("shows this help text.");
        stringBuilder.append('\n').append("\nFurther notes:").append("\n In the case of Boolean arguments, it is not necessary to provide the \"true\" value, in addition.\n Their presence in the argument list is equivalent to setting their value to \"true\",\n just as their absence from the argument list means setting their value to \"false\".\n However, constructions of the form \"bool_option true|false\" are accepted and interpreted accordingly.");
        stringBuilder.append('\n').append('\n').append(" File markers used in reports: ");
        stringBuilder.append(x.trim()).append(string).append("modified, ");
        stringBuilder.append(s.trim()).append(string).append("only found in 1st folder, ");
        stringBuilder.append(e.trim()).append(string).append("only found in 2nd folder.");
        System.out.println(stringBuilder.toString());
    }

    private static List<String[]> q() {
        List<String[]> list = Arrays.asList(w, p, f, j, i, u);
        list = Stream.concat(list.stream(), CompareFiles.g().stream()).collect(Collectors.toList());
        list.remove(CompareFiles.q);
        list.remove(CompareFiles.u);
        list.remove(CompareFiles.t);
        list.remove(CompareFiles.d);
        list.remove(CompareFiles.w);
        list.remove(CompareFiles.r);
        list.add(r);
        list.add(CompareFiles.d);
        list.add(t);
        list.add(q);
        return list;
    }

    private static Map<String, String> p(String[] stringArray) {
        return CompareDirs.g(stringArray, CompareDirs.q());
    }

    private static Map<String, String> g(String[] stringArray, List<String[]> list) {
        String string;
        int n2;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n3 = 0;
        int n4 = -1;
        boolean bl = false;
        String[] stringArray2 = new String[]{null, null, null};
        String[] stringArray3 = new String[]{null, null, null};
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n2 = 0; n2 < list.size(); ++n2) {
            arrayList.add(list.get(n2)[0]);
        }
        while (n3 < stringArray.length && arrayList.indexOf(string = stringArray[n3]) == -1) {
            if (n[0].equals(string)) {
                bl = true;
            } else {
                if (bl) {
                    stringArray3[n4] = string;
                } else if (n4 < stringArray2.length - 1) {
                    stringArray2[++n4] = string;
                }
                bl = false;
            }
            ++n3;
        }
        n2 = 0;
        if (stringArray2[0] != null) {
            hashMap.put(o[0], stringArray2[0]);
            ++n2;
        }
        if (stringArray2[1] != null) {
            hashMap.put(l[0], stringArray2[1]);
            ++n2;
        }
        if (stringArray2[2] != null) {
            hashMap.put(m[0], stringArray2[2]);
            ++n2;
        }
        if (n2 > 1) {
            if (stringArray3[0] != null) {
                hashMap.put(o[3], stringArray3[0]);
            }
            if (stringArray3[1] != null) {
                hashMap.put(l[3], stringArray3[1]);
            }
            if (stringArray3[2] != null) {
                hashMap.put(m[3], stringArray3[2]);
            }
            hashMap.putAll(b.h(stringArray, arrayList, n3));
        } else {
            hashMap = null;
        }
        return hashMap;
    }

    private static void j(Map<String, String> map, boolean bl) {
        if (map == null) {
            System.err.println("ERROR: Wrong argument list. At least the directory paths must be provided.\n");
            System.exit(1);
        } else if (map.size() > 2) {
            CompareDirs.u(map);
            b.g(map, bl);
            b.d(map);
            b.f(map, f[0], "Include archive");
            b.i(map);
            CompareDirs.o(map);
            b.f(map, t[0], "Merge");
        }
    }

    private static void u(Map<String, String> map) {
        String string;
        String string2;
        if (!(map.get(u[0]) == null || (string2 = "content").equalsIgnoreCase(string = map.get(u[0])) || "binary".equalsIgnoreCase(string) || "timestamp".equalsIgnoreCase(string))) {
            System.err.println("Comparison mode option wrongly specified");
            System.err.println("Assumed 'content' comparison mode by default\n");
            map.put(u[0], string2);
        }
    }

    private static void o(Map<String, String> map) {
        if (map.get(r[0]) != null) {
            String string = map.get(r[0]).toLowerCase();
            String string2 = "yaml/grouped";
            String string3 = "json/grouped";
            String string4 = "xml/grouped";
            String string5 = "Output format option wrongly specified.\nAssumed 'yaml/grouped' format by default.\n";
            if (string.startsWith("html") || string.startsWith("htm")) {
                if ("html".equals(string) || "htm".equals(string)) {
                    map.put(CompareFiles.t[0], string);
                } else if ("html/ifcr".equals(string) || "htm/ifcr".equals(string)) {
                    if (map.get(CompareFiles.d[0]) != null) {
                        map.put(CompareFiles.t[0], string);
                    } else {
                        System.err.println("Qualifier for 'html' output file format option not considered because no output file provided through the '-outfile' argument.\n");
                        map.put(CompareFiles.t[0], "html");
                    }
                } else if (string.startsWith("html/") || string.startsWith("htm/")) {
                    System.err.println("Qualifier for 'html' output file format option wrongly specified and therefore not considered.\n");
                    map.put(CompareFiles.t[0], "html");
                } else {
                    System.err.println(string5);
                }
            } else if (string.contains("/")) {
                if (!(string2.equals(string) || "yaml/raw".equals(string) || string3.equals(string) || "json/raw".equals(string) || string4.equals(string) || "xml/raw".equals(string))) {
                    System.err.println(string5);
                    map.put(r[0], string2);
                } else {
                    map.put(r[0], string);
                }
            } else if ("yaml".equals(string)) {
                map.put(r[0], string2);
            } else if ("json".equals(string)) {
                map.put(r[0], string3);
            } else if ("xml".equals(string)) {
                map.put(r[0], string4);
            } else {
                System.err.println(string5);
                map.put(r[0], string2);
            }
        }
    }

    private static File eb(String string, boolean bl) throws _b {
        URL uRL = URLUtil.convertToURL((String)string);
        if (uRL == null) {
            throw new _b("ERROR: Directory not found: " + string);
        }
        String string2 = uRL.getProtocol();
        if ("file".equals(string2)) {
            File file = URLUtil.getCanonicalFileFromFileUrl((URL)uRL);
            String string3 = null;
            try {
                string3 = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                string3 = string;
            }
            if (!file.exists()) {
                throw new _b("ERROR: Directory not found: " + string3);
            }
            if (file.isFile()) {
                throw new _b("ERROR: File path specified instead of directory path: " + string3);
            }
            if (bl) {
                file = new de.schlichtherle.io.File(file);
            }
            return file;
        }
        throw new _b("ERROR: Protocols other than 'file' not considered: " + string);
    }

    private static int ib(String string) {
        int n2 = 0;
        if ("binary".equalsIgnoreCase(string)) {
            n2 = 1;
        } else if ("timestamp".equalsIgnoreCase(string)) {
            n2 = 2;
        }
        return n2;
    }

    private static FileFilter e(String string, String string2, String string3) {
        return new i(new FileFilter[]{string != null ? new c(string, false) : null, string2 != null ? new l(string2) : null, string3 != null ? new j(string3) : null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String y(String[] stringArray, URL[] uRLArray) {
        Object object;
        Map<String, String> map = CompareDirs.p(stringArray);
        String string = null;
        String string2 = null;
        String string3 = null;
        if (map != null) {
            string = map.get(m[0]);
            string3 = map.get(q[0]);
            if (uRLArray != null) {
                string2 = map.get(CompareFiles.d[0]);
            }
        }
        CompareDirs.j(map, string != null);
        boolean bl = "true".equalsIgnoreCase(map.get(f[0]));
        if (bl) {
            ro.sync.exml.zip.l.t().k(false);
        }
        try {
            File file;
            File file2 = CompareDirs.eb(map.get(o[0]), bl);
            object = CompareDirs.eb(map.get(l[0]), bl);
            File file3 = string != null ? CompareDirs.eb(string, bl) : null;
            File file4 = file = string3 != null ? URLUtil.getFileFromFileUrl((URL)b.l(string3, true), (boolean)true, (boolean)false, (boolean)false) : null;
            if (uRLArray != null) {
                URL uRL = uRLArray[0] = string2 != null ? b.l(string2, true) : null;
            }
            if (file != null) {
                CompareDirs.db(file2, file);
                file2 = file;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            if (file3 != null) {
                List<ro.sync.diff.merge.l> list = new ro.sync.diff.d.b.c().jc(file2, (File)object, file3, CompareDirs.e(map.get(p[0]), map.get(j[0]), map.get(i[0])), CompareDirs.ib(map.get(u[0])), null, new DiffInfo(b.b(map)));
                String[] stringArray2 = new String[]{file2.getAbsolutePath(), ((File)object).getAbsolutePath(), file3.getAbsolutePath()};
                String string4 = map.get(r[0]);
                if (map.get(t[0]) != null && "true".equalsIgnoreCase(map.get(t[0])) || file != null) {
                    String string5 = CompareDirs.jb(list, stringArray2, string4);
                    return string5;
                }
                String string6 = CompareDirs.k(list, stringArray2, new String[]{map.get(o[3]), map.get(l[3]), map.get(m[3])}, map.get(w[0]) != null && "true".equalsIgnoreCase(map.get(w[0])), string4, b.b(map), uRLArray != null ? uRLArray[0] : null);
                return string6;
            }
            f f2 = new e().ob(file2, (File)object, CompareDirs.e(map.get(p[0]), map.get(j[0]), map.get(i[0])), CompareDirs.ib(map.get(u[0])), null, new DiffInfo(b.b(map)));
            CompareDirs.buildDiffFilesList(f2, new int[]{file2.getAbsolutePath().length(), ((File)object).getAbsolutePath().length()}, arrayList);
            String string7 = CompareDirs.l(arrayList, new String[]{file2.getAbsolutePath(), ((File)object).getAbsolutePath()}, new String[]{map.get(o[3]), map.get(l[3]), null}, map.get(w[0]) != null && "true".equalsIgnoreCase(map.get(w[0])), map.get(r[0]), b.b(map), uRLArray != null ? uRLArray[0] : null);
            return string7;
        }
        catch (InterruptedException | _b | CompareFiles._b exception) {
            object = exception.getMessage();
            return object;
        }
        finally {
            Options.getInstance().setStringProperty("diff.ignore.xpath.expression", null);
            if (bl) {
                ro.sync.exml.zip.l.t().k(true);
                ro.sync.exml.zip.l.t().p(null);
            }
        }
    }

    private static String l(List<String> list, String[] stringArray, String[] stringArray2, boolean bl, String string, DiffOptions diffOptions, URL uRL) {
        String string2 = string != null ? ("html".equals(string) || "htm".equals(string) ? d.i(list, stringArray, stringArray2, uRL, bl, true) : ("html/ifcr".equals(string) || "htm/ifcr".equals(string) ? d.v(list, stringArray, stringArray2, diffOptions, uRL, bl, true, null, null) : ("yaml/grouped".equals(string) ? CompareDirs.mb(list, false) : ("yaml/raw".equals(string) ? CompareDirs.w(list, false) : ("json/grouped".equals(string) ? CompareDirs.r(list) : ("json/raw".equals(string) ? CompareDirs.m(list) : ("xml/grouped".equals(string) ? CompareDirs.t(list) : CompareDirs.d(list, false)))))))) : CompareDirs.mb(list, true);
        return string2;
    }

    public static void buildDiffFilesList(f f2, int[] nArray, List list) {
        File file = f2.k(true);
        File file2 = f2.k(false);
        if (f2.f() == 1) {
            list.add(k + file.getAbsolutePath().substring(nArray[0] + 1));
            list.add(h + file2.getAbsolutePath().substring(nArray[1] + 1));
        } else if (f2.f() == 0) {
            if (file != null) {
                list.add(s + file.getAbsolutePath().substring(nArray[0] + 1));
            } else if (file2 != null) {
                list.add(e + file2.getAbsolutePath().substring(nArray[1] + 1));
            }
        }
        List<f> list2 = f2.c();
        for (int i2 = 0; i2 < list2.size(); ++i2) {
            CompareDirs.buildDiffFilesList(list2.get(i2), nArray, list);
        }
    }

    protected static String cb(int n2, boolean bl) {
        String string;
        switch (n2) {
            case 0: {
                string = bl ? "onlyFoundInFolder1" : "only found in 1st folder";
                break;
            }
            case 1: {
                string = bl ? "onlyFoundInFolder2" : "only found in 2nd folder";
                break;
            }
            case 2: {
                string = "modified";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    private static String mb(List list, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "differences";
        String string2 = "  diffsNo: ";
        String string3 = ":\n";
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        CompareDirs.gb(list, arrayList2, arrayList3, arrayList);
        if (!list.isEmpty()) {
            String string4 = "  ";
            stringBuilder.append(string).append(string3).append(string2);
            stringBuilder.append(arrayList.size() + arrayList2.size() + arrayList3.size()).append('\n');
            stringBuilder.append(string4).append(CompareDirs.cb(0, true)).append(string3);
            stringBuilder.append(CompareDirs.bb(arrayList2));
            stringBuilder.append(string4).append(CompareDirs.cb(1, true)).append(string3);
            stringBuilder.append(CompareDirs.bb(arrayList3));
            stringBuilder.append(string4).append(CompareDirs.cb(2, true)).append(string3);
            stringBuilder.append(CompareDirs.bb(arrayList));
        } else if (bl) {
            stringBuilder = new StringBuilder("No ").append(string).append('.');
        } else {
            stringBuilder.append(string).append(string3).append(string2);
            stringBuilder.append(arrayList.size() + arrayList2.size() + arrayList3.size());
        }
        return stringBuilder.toString();
    }

    private static String w(List list, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        int[] nArray = new int[3];
        List list2 = CompareDirs.getFinalDiffListForRawFormatting(list, nArray);
        int n2 = nArray[0] + nArray[1] + nArray[2];
        String string = "\n  ";
        String string2 = ": ";
        stringBuilder.append("differences").append(":\n  diffsNo: ").append(n2);
        stringBuilder.append(string).append(CompareDirs.cb(0, true));
        stringBuilder.append(string2).append(nArray[0]);
        stringBuilder.append(string).append(CompareDirs.cb(1, true));
        stringBuilder.append(string2).append(nArray[1]);
        stringBuilder.append(string).append(CompareDirs.cb(2, true));
        stringBuilder.append(string2).append(nArray[2]);
        if (n2 > 0) {
            stringBuilder.append("\n  files:");
            for (int i2 = 0; i2 < list2.size(); ++i2) {
                stringBuilder.append("\n  - ").append((String)list2.get(i2));
            }
        }
        if (bl && n2 > 0) {
            stringBuilder.append("\n\n# M:  modified file");
            stringBuilder.append("\n# O1: file only found in the 1st directory");
            stringBuilder.append("\n# O2: file only found in the 2nd directory");
        }
        return stringBuilder.toString();
    }

    private static String bb(List list) {
        String string = "    files";
        StringBuilder stringBuilder = new StringBuilder(string).append("No: ");
        int n2 = list.size();
        stringBuilder.append(n2).append('\n');
        if (n2 > 0) {
            stringBuilder.append(string).append(":\n");
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuilder.append("    - ").append(list.get(i2)).append('\n');
            }
        }
        return stringBuilder.toString();
    }

    private static String r(List list) {
        StringBuilder stringBuilder = new StringBuilder("{\n");
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        CompareDirs.gb(list, arrayList2, arrayList3, arrayList);
        stringBuilder.append("  \"differences\": {\n").append("    \"diffsNo\": ");
        stringBuilder.append(arrayList.size() + arrayList2.size() + arrayList3.size());
        if (!list.isEmpty()) {
            String string = "\": {\n";
            String string2 = "    }";
            String string3 = ",\n    \"";
            stringBuilder.append(string3).append(CompareDirs.cb(0, true));
            stringBuilder.append(string);
            stringBuilder.append(CompareDirs.z(arrayList2));
            stringBuilder.append(string2);
            stringBuilder.append(string3).append(CompareDirs.cb(1, true));
            stringBuilder.append(string);
            stringBuilder.append(CompareDirs.z(arrayList3));
            stringBuilder.append(string2);
            stringBuilder.append(string3).append(CompareDirs.cb(2, true));
            stringBuilder.append(string);
            stringBuilder.append(CompareDirs.z(arrayList));
            stringBuilder.append(string2);
        }
        stringBuilder.append("\n  }\n}");
        return stringBuilder.toString();
    }

    private static String m(List list) {
        StringBuilder stringBuilder = new StringBuilder("{\n");
        String string = "    \"";
        String string2 = ",\n";
        int[] nArray = new int[3];
        List list2 = CompareDirs.getFinalDiffListForRawFormatting(list, nArray);
        int n2 = nArray[0] + nArray[1] + nArray[2];
        stringBuilder.append("  \"differences\": {\n").append("    \"diffsNo\": ");
        stringBuilder.append(n2).append(n2 > 0 ? string2 : "");
        if (n2 > 0) {
            String string3 = "\": ";
            stringBuilder.append(string).append(CompareDirs.cb(0, true));
            stringBuilder.append(string3).append(nArray[0]).append(string2);
            stringBuilder.append(string).append(CompareDirs.cb(1, true));
            stringBuilder.append(string3).append(nArray[1]).append(string2);
            stringBuilder.append(string).append(CompareDirs.cb(2, true));
            stringBuilder.append(string3).append(nArray[2]).append(",\n    \"files\": [");
            for (int i2 = 0; i2 < list2.size(); ++i2) {
                String string4 = (String)list2.get(i2);
                stringBuilder.append("\n      {").append('\"').append(string4.substring(0, 2).trim()).append("\": ");
                stringBuilder.append('\"').append(CompareDirs.kb(string4.substring(3).trim())).append("\"}");
                stringBuilder.append(i2 < n2 - 1 ? Character.valueOf(',') : "");
            }
            stringBuilder.append("\n    ]");
        }
        stringBuilder.append("\n  }\n}");
        return stringBuilder.toString();
    }

    private static String z(List list) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = ",\n";
        int n2 = list.size();
        stringBuilder.append("      \"filesNo\": ").append(n2);
        if (n2 == 0) {
            stringBuilder.append('\n');
        } else {
            stringBuilder.append(string);
            stringBuilder.append("      \"files\": [").append(n2 > 1 ? "\n" : "");
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuilder.append(n2 > 1 ? "        " : "").append("\"");
                stringBuilder.append(CompareDirs.kb((String)list.get(i2))).append('\"');
                stringBuilder.append(i2 < n2 - 1 ? string : "");
            }
            stringBuilder.append(n2 > 1 ? "\n      " : "").append("]\n");
        }
        return stringBuilder.toString();
    }

    private static String kb(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (PlatformDetector.isWin()) {
            for (int i2 = 0; i2 < string.length(); ++i2) {
                char c2 = string.charAt(i2);
                stringBuilder.append(c2);
                if (c2 != '\\') continue;
                stringBuilder.append('\\');
            }
            return stringBuilder.toString();
        }
        return string;
    }

    private static String t(List list) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "differences";
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        CompareDirs.gb(list, arrayList2, arrayList3, arrayList);
        stringBuilder.append("<").append(string).append(" diffsNo=\"");
        stringBuilder.append(arrayList.size() + arrayList2.size() + arrayList3.size()).append("\"");
        if (!list.isEmpty()) {
            stringBuilder.append(">\n");
            stringBuilder.append(CompareDirs.b(arrayList2, CompareDirs.cb(0, true)));
            stringBuilder.append(CompareDirs.b(arrayList3, CompareDirs.cb(1, true)));
            stringBuilder.append(CompareDirs.b(arrayList, CompareDirs.cb(2, true)));
            stringBuilder.append("</").append(string).append('>');
        } else {
            stringBuilder.append("/>");
        }
        return stringBuilder.toString();
    }

    private static String d(List list, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "differences";
        String string2 = " filesNo=\"";
        String string3 = "  <";
        String string4 = "\"/>\n";
        int[] nArray = new int[3];
        List list2 = CompareDirs.getFinalDiffListForRawFormatting(list, nArray);
        int n2 = nArray[0] + nArray[1] + nArray[2];
        stringBuilder.append('<').append(string).append(" diffsNo=\"").append(n2).append("\">\n");
        stringBuilder.append(string3).append(CompareDirs.cb(0, true));
        stringBuilder.append(string2).append(nArray[0]).append(string4);
        stringBuilder.append(string3).append(CompareDirs.cb(1, true));
        stringBuilder.append(string2).append(nArray[1]).append(string4);
        stringBuilder.append(string3).append(CompareDirs.cb(2, true)).append(string2);
        stringBuilder.append(nArray[2]).append("\"/>");
        if (n2 > 0) {
            for (int i2 = 0; i2 < list2.size(); ++i2) {
                String string5 = (String)list2.get(i2);
                stringBuilder.append("\n  <file diffMark=\"");
                stringBuilder.append(string5.substring(0, 2).trim()).append("\">");
                stringBuilder.append(string5.substring(3).trim()).append("</file>");
            }
        }
        stringBuilder.append("\n</").append(string).append('>');
        if (bl && n2 > 0) {
            stringBuilder.append("\n\n<!--\nM:  modified file\n");
            stringBuilder.append("O1: file only found in the 1st directory\n");
            stringBuilder.append("O2: file only found in the 2nd directory\n-->");
        }
        return stringBuilder.toString();
    }

    private static String b(List list, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = "file>";
        int n2 = list.size();
        stringBuilder.append("  <").append(string);
        stringBuilder.append(" filesNo=\"").append(n2).append('\"');
        if (n2 > 0) {
            stringBuilder.append('>');
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuilder.append("\n    <").append(string2).append(list.get(i2)).append("</").append(string2);
            }
            stringBuilder.append("\n  </").append(string).append('>');
        } else {
            stringBuilder.append("/>");
        }
        stringBuilder.append('\n');
        return stringBuilder.toString();
    }

    private static void gb(List list, List list2, List list3, List list4) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String string = (String)list.get(i2);
            int n2 = k.length();
            if (string.startsWith(k)) {
                list4.add(string.substring(n2));
                continue;
            }
            if (string.startsWith(s)) {
                list2.add(string.substring(n2));
                continue;
            }
            if (!string.startsWith(e)) continue;
            list3.add(string.substring(n2));
        }
    }

    public static List getFinalDiffListForRawFormatting(List list, int[] nArray) {
        int n2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = 0;
        }
        for (n2 = 0; n2 < list.size(); ++n2) {
            int n3;
            String string = (String)list.get(n2);
            String string2 = string.substring(0, n3 = h.length());
            if (k.equals(string2)) {
                arrayList.add(x + string.substring(n3));
                nArray[2] = nArray[2] + 1;
                continue;
            }
            if (h.equals(string2)) continue;
            arrayList.add(string);
            if (s.equals(string2)) {
                nArray[0] = nArray[0] + 1;
                continue;
            }
            nArray[1] = nArray[1] + 1;
        }
        return arrayList;
    }

    private static String k(List<ro.sync.diff.merge.l> list, String[] stringArray, String[] stringArray2, boolean bl, String string, DiffOptions diffOptions, URL uRL) {
        int[] nArray = new int[]{stringArray[0].length(), stringArray[1].length()};
        String string2 = string != null ? ("html".equals(string) || "htm".equals(string) ? d.l(list, stringArray, stringArray2, uRL, bl, true) : ("html/ifcr".equals(string) || "htm/ifcr".equals(string) ? d.y(list, stringArray, stringArray2, diffOptions, uRL, bl, true, null, null) : ("yaml/grouped".equals(string) ? CompareDirs.hb(list, nArray, false) : ("yaml/raw".equals(string) ? CompareDirs.x(list, nArray) : ("json/grouped".equals(string) ? CompareDirs.c(list, nArray) : ("json/raw".equals(string) ? CompareDirs.n(list, nArray) : ("xml/grouped".equals(string) ? CompareDirs.s(list, nArray) : CompareDirs.fb(list, nArray)))))))) : CompareDirs.hb(list, nArray, true);
        return string2;
    }

    private static String hb(List<ro.sync.diff.merge.l> list, int[] nArray, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        String string = "differences";
        String string2 = "  diffsNo: ";
        String string3 = "    files";
        String string4 = "  ";
        String string5 = string4 + string4;
        String string6 = ":\n";
        int n2 = 0;
        if (!list.isEmpty()) {
            Map<String, List<Byte>> map = CompareDirs.getDiffCategoryCodes();
            Map<Byte, List<ro.sync.diff.merge.l>> map2 = CompareDirs.getThreeWayDiffsGroupedByDiffStatusCode(list);
            for (int i2 = 0; i2 < v.length; ++i2) {
                StringBuilder stringBuilder3 = new StringBuilder();
                String string7 = v[i2];
                List<Byte> list2 = map.get(string7);
                int n3 = 0;
                for (int i3 = 0; i3 < list2.size(); ++i3) {
                    Byte by = list2.get(i3);
                    List<ro.sync.diff.merge.l> list3 = map2.get(by);
                    if (list3 == null) continue;
                    String string8 = CompareDirs.getDescriptionForThreeWayDiffStatusCode(by);
                    int n4 = string8.indexOf(58);
                    boolean bl2 = string8.substring(0, n4).contains("1");
                    stringBuilder3.append(string5).append(string8.substring(n4 + 1)).append(string6);
                    stringBuilder3.append(string4).append(string3).append("No: ").append(list3.size()).append('\n');
                    stringBuilder3.append(string4).append(string3).append(string6);
                    for (int i4 = 0; i4 < list3.size(); ++i4) {
                        ++n2;
                        ++n3;
                        ro.sync.diff.merge.l l2 = list3.get(i4);
                        URL uRL = bl2 ? l2.l() : l2.k();
                        String string9 = URLUtil.getFileFromFileUrl((URL)uRL, (boolean)true, (boolean)false, (boolean)false).getAbsolutePath();
                        stringBuilder3.append(string5).append(string4).append("- ");
                        stringBuilder3.append(string9.substring((bl2 ? nArray[0] : nArray[1]) + 1)).append('\n');
                    }
                }
                if (n3 <= 0) continue;
                stringBuilder = new StringBuilder();
                stringBuilder.append(string4).append(string7).append(":\n");
                stringBuilder.append(string4).append(string4).append(string7).append("No: ");
                stringBuilder.append(n3).append('\n');
                stringBuilder2.append((CharSequence)stringBuilder).append((CharSequence)stringBuilder3);
            }
            stringBuilder = new StringBuilder();
            stringBuilder.append(string).append(string6);
            stringBuilder.append(string2).append(n2).append('\n');
        }
        if (n2 == 0) {
            if (bl) {
                stringBuilder2 = new StringBuilder("No ").append(string).append('.');
            } else {
                stringBuilder2.append(string).append(string6).append(string2).append('0');
            }
            stringBuilder.setLength(0);
        }
        return stringBuilder.toString() + stringBuilder2.toString();
    }

    private static String x(List<ro.sync.diff.merge.l> list, int[] nArray) {
        Object object;
        Object object2;
        int n2;
        Object object3;
        Object object4;
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            object4 = list.get(i2);
            object3 = CompareDirs.getDescriptionForThreeWayDiffStatusCode(((ro.sync.diff.merge.l)object4).g());
            if ("U".equalsIgnoreCase((String)(object3 = ((String)object3).substring(0, ((String)object3).indexOf(58))))) continue;
            ++n3;
            stringBuilder.append("\n  - ");
            n2 = ((String)object3).contains("1") ? 1 : 0;
            object2 = n2 != 0 ? ((ro.sync.diff.merge.l)object4).l() : ((ro.sync.diff.merge.l)object4).k();
            object = URLUtil.getFileFromFileUrl((URL)object2, (boolean)true, (boolean)false, (boolean)false).getAbsolutePath();
            stringBuilder.append((String)object3).append(": ");
            stringBuilder.append(((String)object).substring((n2 != 0 ? nArray[0] : nArray[1]) + 1));
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append("differences").append(":\n  diffsNo: ").append(n3).append('\n');
        if (n3 > 0) {
            object4 = CompareDirs.getDiffCategoryCodes();
            object3 = CompareDirs.getThreeWayDiffsGroupedByDiffStatusCode(list);
            for (n2 = 0; n2 < v.length; ++n2) {
                object2 = v[n2];
                object = (List)object4.get(object2);
                int n4 = 0;
                StringBuilder stringBuilder3 = new StringBuilder();
                for (int i3 = 0; i3 < object.size(); ++i3) {
                    byte by = (Byte)object.get(i3);
                    List list2 = (List)object3.get(by);
                    if (list2 == null) continue;
                    String string = CompareDirs.getDescriptionForThreeWayDiffStatusCode(by);
                    string = string.substring(string.indexOf(58) + 1);
                    int n5 = ((List)object3.get(by)).size();
                    n4 = (byte)(n4 + n5);
                    stringBuilder3.append("    ").append(string).append(": ");
                    stringBuilder3.append(n5).append('\n');
                }
                if (n4 <= 0) continue;
                stringBuilder2.append("  ").append((String)object2).append(":\n");
                stringBuilder2.append("    ").append((String)object2).append("No: ");
                stringBuilder2.append(n4).append('\n').append((CharSequence)stringBuilder3);
            }
        }
        stringBuilder2.append("  files:");
        return stringBuilder2.toString() + stringBuilder.toString();
    }

    private static String c(List<ro.sync.diff.merge.l> list, int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        int n2 = 0;
        if (!list.isEmpty()) {
            Map<String, List<Byte>> map = CompareDirs.getDiffCategoryCodes();
            Map<Byte, List<ro.sync.diff.merge.l>> map2 = CompareDirs.getThreeWayDiffsGroupedByDiffStatusCode(list);
            for (int i2 = 0; i2 < v.length; ++i2) {
                StringBuilder stringBuilder3 = new StringBuilder();
                String string = v[i2];
                List<Byte> list2 = map.get(string);
                int n3 = 0;
                for (int i3 = 0; i3 < list2.size(); ++i3) {
                    Byte by = list2.get(i3);
                    List<ro.sync.diff.merge.l> list3 = map2.get(by);
                    if (list3 == null) continue;
                    int n4 = list3.size();
                    String string2 = CompareDirs.getDescriptionForThreeWayDiffStatusCode(by);
                    int n5 = string2.indexOf(58);
                    boolean bl = string2.substring(0, n5).contains("1");
                    stringBuilder3.append("      \"").append(string2.substring(n5 + 1)).append("\": {\n");
                    stringBuilder3.append("        \"filesNo\": ").append(n4).append(",\n");
                    stringBuilder3.append("        \"files\": [").append(n4 > 1 ? "\n" : "");
                    for (int i4 = 0; i4 < n4; ++i4) {
                        ++n2;
                        ++n3;
                        ro.sync.diff.merge.l l2 = list3.get(i4);
                        URL uRL = bl ? l2.l() : l2.k();
                        String string3 = URLUtil.getFileFromFileUrl((URL)uRL, (boolean)true, (boolean)false, (boolean)false).getAbsolutePath();
                        string3 = string3.substring((bl ? nArray[0] : nArray[1]) + 1);
                        stringBuilder3.append(n4 > 1 ? "          " : "").append('\"');
                        stringBuilder3.append(CompareDirs.kb(string3));
                        stringBuilder3.append('\"').append(i4 < n4 - 1 ? Character.valueOf(',') : "");
                        stringBuilder3.append(n4 > 1 ? Character.valueOf('\n') : "");
                    }
                    stringBuilder3.append(n4 > 1 ? "        " : "").append("]\n      },\n");
                }
                if (n3 <= 0) continue;
                stringBuilder = new StringBuilder();
                stringBuilder.append("    \"").append(string).append("\": {\n");
                stringBuilder.append("      \"").append(string).append("No\": ");
                stringBuilder.append(n3).append(",\n");
                stringBuilder2.append((CharSequence)stringBuilder).append((CharSequence)stringBuilder3);
                stringBuilder2.setLength(stringBuilder2.length() - 2);
                stringBuilder2.append("\n    },\n");
            }
            stringBuilder = new StringBuilder();
            stringBuilder.append("{\n  \"").append("differences").append("\": {\n");
            stringBuilder.append("    \"diffsNo\": ").append(n2).append(n2 > 0 ? ",\n" : "");
        }
        stringBuilder2.setLength(n2 > 0 ? stringBuilder2.length() - 2 : stringBuilder2.length());
        stringBuilder2.append("\n  }\n}");
        return stringBuilder.toString() + stringBuilder2.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static String n(List<ro.sync.diff.merge.l> list, int[] nArray) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            object4 = list.get(i2);
            object3 = CompareDirs.getDescriptionForThreeWayDiffStatusCode(((ro.sync.diff.merge.l)object4).g());
            if ("U".equalsIgnoreCase((String)(object3 = ((String)object3).substring(0, ((String)object3).indexOf(58))))) continue;
            ++n3;
            boolean n2 = ((String)object3).contains("1");
            object2 = n2 ? ((ro.sync.diff.merge.l)object4).l() : ((ro.sync.diff.merge.l)object4).k();
            object = URLUtil.getFileFromFileUrl((URL)object2, (boolean)true, (boolean)false, (boolean)false).getAbsolutePath();
            object = ((String)object).substring((n2 ? nArray[0] : nArray[1]) + 1);
            stringBuilder.append(i2 > 0 ? Character.valueOf(',') : "").append("\n      {\"").append((String)object3).append("\": \"");
            stringBuilder.append(CompareDirs.kb((String)object)).append("\"}");
        }
        stringBuilder.append(n3 > 0 ? "\n    ]" : "").append("\n  }\n}");
        StringBuilder stringBuilder2 = new StringBuilder("{\n  \"differences\": {");
        stringBuilder2.append("\n    \"diffsNo\": ").append(n3);
        if (n3 > 0) {
            void var7_10;
            stringBuilder2.append(',');
            object4 = CompareDirs.getDiffCategoryCodes();
            object3 = CompareDirs.getThreeWayDiffsGroupedByDiffStatusCode(list);
            boolean bl = false;
            while (var7_10 < v.length) {
                object2 = v[var7_10];
                object = (List)object4.get(object2);
                int n2 = 0;
                StringBuilder stringBuilder3 = new StringBuilder();
                for (int i2 = 0; i2 < object.size(); ++i2) {
                    byte by = (Byte)object.get(i2);
                    List list2 = (List)object3.get(by);
                    if (list2 == null) continue;
                    String string = CompareDirs.getDescriptionForThreeWayDiffStatusCode(by);
                    string = string.substring(string.indexOf(58) + 1);
                    int n4 = ((List)object3.get(by)).size();
                    n2 = (byte)(n2 + n4);
                    stringBuilder3.append("\n      \"").append(string).append("\": ");
                    stringBuilder3.append(n4).append(',');
                }
                if (stringBuilder3.length() > 0) {
                    stringBuilder3.setLength(stringBuilder3.length() - 1);
                }
                stringBuilder3.append("\n    },");
                if (n2 > 0) {
                    stringBuilder2.append("\n    \"").append((String)object2).append("\": {");
                    stringBuilder2.append("\n      \"").append((String)object2).append("No\": ");
                    stringBuilder2.append(n2).append(',').append((CharSequence)stringBuilder3);
                }
                ++var7_10;
            }
            stringBuilder2.append("\n    \"files\": [");
        }
        return stringBuilder2.toString() + stringBuilder.toString();
    }

    private static String s(List<ro.sync.diff.merge.l> list, int[] nArray) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = new StringBuilder();
        int n2 = 0;
        if (!list.isEmpty()) {
            Map<String, List<Byte>> map = CompareDirs.getDiffCategoryCodes();
            Map<Byte, List<ro.sync.diff.merge.l>> map2 = CompareDirs.getThreeWayDiffsGroupedByDiffStatusCode(list);
            for (int i2 = 0; i2 < v.length; ++i2) {
                StringBuilder stringBuilder3 = new StringBuilder();
                String string = v[i2];
                List<Byte> list2 = map.get(string);
                int n3 = 0;
                for (int i3 = 0; i3 < list2.size(); ++i3) {
                    Byte by = list2.get(i3);
                    List<ro.sync.diff.merge.l> list3 = map2.get(by);
                    if (list3 == null) continue;
                    String string2 = CompareDirs.getDescriptionForThreeWayDiffStatusCode(by);
                    int n4 = string2.indexOf(58);
                    string2 = string2.substring(n4 + 1);
                    boolean bl = string2.substring(0, n4).contains("1");
                    stringBuilder3.append("    <").append(string2);
                    stringBuilder3.append(" filesNo=\"").append(list3.size()).append("\">");
                    for (int i4 = 0; i4 < list3.size(); ++i4) {
                        ++n2;
                        ++n3;
                        ro.sync.diff.merge.l l2 = list3.get(i4);
                        URL uRL = bl ? l2.l() : l2.k();
                        String string3 = URLUtil.getFileFromFileUrl((URL)uRL, (boolean)true, (boolean)false, (boolean)false).getAbsolutePath();
                        stringBuilder3.append("\n      <file>");
                        stringBuilder3.append(string3.substring((bl ? nArray[0] : nArray[1]) + 1));
                        stringBuilder3.append("</file>");
                    }
                    stringBuilder3.append("\n    </").append(string2).append(">\n");
                }
                if (n3 <= 0) continue;
                stringBuilder = new StringBuilder();
                stringBuilder.append("  <").append(string);
                stringBuilder.append(" filesNo=\"").append(n3).append("\">\n");
                stringBuilder2.append((CharSequence)stringBuilder).append((CharSequence)stringBuilder3).append("  </").append(string).append(">\n");
            }
        }
        stringBuilder = new StringBuilder("<differences diffsNo=\"");
        stringBuilder.append(n2).append('\"');
        stringBuilder.append(n2 > 0 ? ">\n" : "/>").append((CharSequence)stringBuilder2);
        stringBuilder.append(n2 > 0 ? "</differences>" : "");
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static String fb(List<ro.sync.diff.merge.l> list, int[] nArray) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            object4 = list.get(i2);
            object3 = CompareDirs.getDescriptionForThreeWayDiffStatusCode(((ro.sync.diff.merge.l)object4).g());
            if ("U".equalsIgnoreCase((String)(object3 = ((String)object3).substring(0, ((String)object3).indexOf(58))))) continue;
            ++n3;
            stringBuilder.append("\n  <file diffMark=\"").append((String)object3).append("\">");
            boolean n2 = ((String)object3).contains("1");
            object2 = n2 ? ((ro.sync.diff.merge.l)object4).l() : ((ro.sync.diff.merge.l)object4).k();
            object = URLUtil.getFileFromFileUrl((URL)object2, (boolean)true, (boolean)false, (boolean)false).getAbsolutePath();
            stringBuilder.append(((String)object).substring((n2 ? nArray[0] : nArray[1]) + 1));
            stringBuilder.append("</file>");
        }
        stringBuilder.append(n3 > 0 ? "\n</differences>" : "");
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append("<differences diffsNo=\"").append(n3).append('\"');
        stringBuilder2.append(n3 > 0 ? Character.valueOf('>') : "/>");
        if (n3 > 0) {
            void var7_10;
            object4 = CompareDirs.getDiffCategoryCodes();
            object3 = CompareDirs.getThreeWayDiffsGroupedByDiffStatusCode(list);
            boolean bl = false;
            while (var7_10 < v.length) {
                object2 = v[var7_10];
                object = (List)object4.get(object2);
                int n2 = 0;
                StringBuilder stringBuilder3 = new StringBuilder();
                for (int i2 = 0; i2 < object.size(); ++i2) {
                    byte by = (Byte)object.get(i2);
                    List list2 = (List)object3.get(by);
                    if (list2 == null) continue;
                    String string = CompareDirs.getDescriptionForThreeWayDiffStatusCode(by);
                    string = string.substring(string.indexOf(58) + 1);
                    int n4 = ((List)object3.get(by)).size();
                    n2 = (byte)(n2 + n4);
                    stringBuilder3.append("\n    <").append(string);
                    stringBuilder3.append(" filesNo=\"").append(n4).append("\"/>");
                }
                if (n2 > 0) {
                    stringBuilder2.append("\n  <").append((String)object2);
                    stringBuilder2.append(' ').append((String)object2).append("No=\"");
                    stringBuilder2.append(n2).append("\">").append((CharSequence)stringBuilder3);
                    stringBuilder2.append("\n  </").append((String)object2).append('>');
                }
                ++var7_10;
            }
        }
        return stringBuilder2.toString() + stringBuilder.toString();
    }

    public static String getDescriptionForThreeWayDiffStatusCode(byte by) {
        String string;
        switch (by) {
            case 0: {
                string = "U" + ':' + "unmodified";
                break;
            }
            case 1: {
                string = "A1" + ':' + "addedToFolder1";
                break;
            }
            case 2: {
                string = "A2" + ':' + "addedToFolder2";
                break;
            }
            case 3: {
                string = "D1" + ':' + "deletedFromFolder1";
                break;
            }
            case 4: {
                string = "D2" + ':' + "deletedFromFolder2";
                break;
            }
            case 5: {
                string = "D1D2" + ':' + "deletedFromBothFolder1AndFolder2";
                break;
            }
            case 6: {
                string = "D1M2" + ':' + "deletedFromFolder1AndModifiedInFolder2";
                break;
            }
            case 7: {
                string = "M1" + ':' + "modifiedInFolder1";
                break;
            }
            case 8: {
                string = "M2" + ':' + "modifiedInFolder2";
                break;
            }
            case 9: {
                string = "M1M2" + ':' + "modifiedInBothFolder1AndFolder2";
                break;
            }
            case 12: {
                string = "M1M2M" + ':' + "modifiedInBothFolder1AndFolder2Mergeable";
                break;
            }
            case 11: {
                string = "A1A2" + ':' + "addedToBothFolder1AndFolder2";
                break;
            }
            case 10: {
                string = "M1D2" + ':' + "modifiedInFolder1AndDeletedFromFolder2";
                break;
            }
            default: {
                string = "ERROR" + ": " + "unknownStatus";
            }
        }
        return string;
    }

    public static Map<String, List<Byte>> getDiffCategoryCodes() {
        HashMap<String, List<Byte>> hashMap = new HashMap<String, List<Byte>>();
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        arrayList.add((byte)1);
        arrayList.add((byte)3);
        arrayList.add((byte)7);
        hashMap.put(v[0], arrayList);
        arrayList = new ArrayList();
        arrayList.add((byte)2);
        arrayList.add((byte)4);
        arrayList.add((byte)8);
        hashMap.put(v[1], arrayList);
        arrayList = new ArrayList();
        arrayList.add((byte)5);
        arrayList.add((byte)12);
        hashMap.put(v[2], arrayList);
        arrayList = new ArrayList();
        arrayList.add((byte)6);
        arrayList.add((byte)10);
        arrayList.add((byte)11);
        arrayList.add((byte)9);
        hashMap.put(v[3], arrayList);
        return hashMap;
    }

    public static Map<Byte, List<ro.sync.diff.merge.l>> getThreeWayDiffsGroupedByDiffStatusCode(List<ro.sync.diff.merge.l> list) {
        HashMap<Byte, List<ro.sync.diff.merge.l>> hashMap = new HashMap<Byte, List<ro.sync.diff.merge.l>>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ro.sync.diff.merge.l l2 = list.get(i2);
            byte by = l2.g();
            ArrayList<ro.sync.diff.merge.l> arrayList = (ArrayList<ro.sync.diff.merge.l>)hashMap.get(by);
            if (arrayList == null) {
                arrayList = new ArrayList<ro.sync.diff.merge.l>();
            }
            arrayList.add(l2);
            hashMap.put(by, arrayList);
        }
        return hashMap;
    }

    private static void db(File file, File file2) throws _b {
        if (!file2.exists()) {
            file2.mkdir();
        } else {
            FileSystemUtil.deleteRecursivelly((File)file2);
        }
        try {
            FileSystemUtil.copyDir((File)file, (File)file2, (boolean)true, (boolean)true);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            Object object = iOException.getMessage();
            object = object == null ? "ERROR: Destination folder could not be created: " : "ERROR: " + iOException.getMessage();
            throw new _b((String)object);
        }
    }

    private static String jb(List<ro.sync.diff.merge.l> list, String[] stringArray, String string) {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        for (int i2 = 0; i2 < g.length; ++i2) {
            hashMap.put(g[i2], new ArrayList());
        }
        t t2 = new t(){

            @Override
            protected int e(String string, String string2) {
                return 0;
            }
        };
        String string2 = null;
        for (int i3 = 0; i3 < list.size(); ++i3) {
            ro.sync.diff.merge.l l2 = list.get(i3);
            byte by = l2.g();
            String string3 = URLUtil.getFileFromFileUrl((URL)l2.k(), (boolean)true, (boolean)false, (boolean)false).getAbsolutePath();
            String string4 = string3.substring(stringArray[1].length() + 1);
            byte by2 = l2.h();
            if (by2 == 0) {
                try {
                    ro.sync.diff.merge.g.e(l2, new ro.sync.diff.merge.b(false, true), t2, null);
                    if (2 == by) {
                        ((List)hashMap.get(g[0])).add(string4);
                        continue;
                    }
                    if (4 == by) {
                        ((List)hashMap.get(g[1])).add(string4);
                        continue;
                    }
                    if (8 == by) {
                        ((List)hashMap.get(g[2])).add(string4);
                        continue;
                    }
                    if (12 != by) continue;
                    ((List)hashMap.get(g[3])).add(string4);
                    continue;
                }
                catch (IOException iOException) {
                    string2 = "ERROR: " + iOException.getMessage().trim();
                    break;
                }
            }
            if (by2 != 4) continue;
            ((List)hashMap.get(g[4])).add(string4);
        }
        return CompareDirs.lb(hashMap, string, string2);
    }

    private static String lb(Map<String, List<String>> map, String string, String string2) {
        String string3 = "html".equals(string) || "htm".equals(string) || "yaml/grouped".equals(string) || "yaml/raw".equals(string) ? CompareDirs.h(map, string2) : ("json/grouped".equals(string) || "json/raw".equals(string) ? CompareDirs.v(map, string2) : ("xml/grouped".equals(string) || "xml/raw".equals(string) ? CompareDirs.f(map, string2) : CompareDirs.h(map, string2)));
        return string3;
    }

    private static String h(Map<String, List<String>> map, String string) {
        StringBuilder stringBuilder = new StringBuilder("mergeReport:\n");
        stringBuilder.append("  operationStatus: \"");
        stringBuilder.append(string != null ? "OPERATION COULD NOT BE COMPLETED\"" : "OPERATION COMPLETED\"");
        if (string != null) {
            stringBuilder.append("\n  errorMessage: \"").append(string).append('\"');
        }
        for (int i2 = 0; i2 < map.size(); ++i2) {
            stringBuilder.append("\n  ").append(g[i2]).append(":\n");
            List<String> list = map.get(g[i2]);
            int n2 = list.size();
            stringBuilder.append("    filesNo: ").append(n2);
            if (n2 <= 0) continue;
            stringBuilder.append("\n    files:");
            for (int i3 = 0; i3 < n2; ++i3) {
                stringBuilder.append("\n    - ").append(list.get(i3));
            }
        }
        return stringBuilder.toString();
    }

    private static String v(Map<String, List<String>> map, String string) {
        StringBuilder stringBuilder = new StringBuilder("{\n  \"mergeReport\": {\n");
        stringBuilder.append("    \"operationStatus\": \"");
        stringBuilder.append(string != null ? "OPERATION COULD NOT BE COMPLETED" : "OPERATION COMPLETED");
        stringBuilder.append("\",");
        if (string != null) {
            stringBuilder.append("\n    \"errorMessage\": \"").append(string).append("\",");
        }
        for (int i2 = 0; i2 < map.size(); ++i2) {
            stringBuilder.append("\n    \"").append(g[i2]).append("\": {");
            List<String> list = map.get(g[i2]);
            int n2 = list.size();
            if (n2 > 0) {
                stringBuilder.append("\n      \"filesNo\": ").append(n2).append(",\n      \"files\": [");
                if (n2 == 1) {
                    stringBuilder.append("\"").append(CompareDirs.kb(list.get(0))).append("\"]\n    }");
                } else {
                    for (int i3 = 0; i3 < n2; ++i3) {
                        stringBuilder.append("\n         \"").append(CompareDirs.kb(list.get(i3)));
                        stringBuilder.append('\"').append(i3 < n2 - 1 ? Character.valueOf(',') : "");
                    }
                    stringBuilder.append("\n      ]\n    }");
                }
            } else {
                stringBuilder.append("\"filesNo\": 0}");
            }
            stringBuilder.append(i2 < map.size() - 1 ? "," : "");
        }
        return stringBuilder.append("\n  }\n}").toString();
    }

    private static String f(Map<String, List<String>> map, String string) {
        StringBuilder stringBuilder = new StringBuilder("<mergeReport>\n");
        stringBuilder.append("  <operationStatus>");
        stringBuilder.append(string != null ? "OPERATION COULD NOT BE COMPLETED" : "OPERATION COMPLETED");
        stringBuilder.append("</operationStatus>");
        if (string != null) {
            stringBuilder.append("\n  <errorMessage>").append(string).append("</errorMessage>");
        }
        for (int i2 = 0; i2 < map.size(); ++i2) {
            List<String> list = map.get(g[i2]);
            int n2 = list.size();
            stringBuilder.append("\n  <").append(g[i2]).append(" filesNo=\"").append(n2).append("\"");
            if (n2 > 0) {
                stringBuilder.append('>');
                for (int i3 = 0; i3 < n2; ++i3) {
                    stringBuilder.append("\n    <file>").append(list.get(i3)).append("</file>");
                }
                stringBuilder.append("\n  </").append(g[i2]).append(">");
                continue;
            }
            stringBuilder.append("/>");
        }
        return stringBuilder.append("\n</mergeReport>").toString();
    }

    protected static boolean i(String[] stringArray) {
        URL[] uRLArray = new URL[]{null};
        String string = CompareDirs.y(stringArray, uRLArray);
        boolean bl = string.startsWith("ERROR: ");
        if (bl) {
            System.err.println(string);
        } else if (uRLArray[0] != null) {
            bl = !b.n(string, uRLArray[0]);
        } else {
            System.out.println(string);
        }
        bl = bl || string.substring(0, Math.min(100, string.length())).contains("OPERATION COULD NOT BE COMPLETED");
        return !bl;
    }

    public static void main(String[] stringArray) {
        b.c("Compare directories");
        if (stringArray.length == 1 && fb.b(stringArray[0])) {
            CompareDirs.ab();
            System.exit(0);
        }
        System.exit(CompareDirs.i(stringArray) ? 0 : 1);
    }

    protected static class _b
    extends Exception {
        protected static final String h = "ERROR: ";
        protected static final String c = "ERROR: Directory not found: ";
        protected static final String f = "ERROR: File path specified instead of directory path: ";
        protected static final String b = "ERROR: Protocols other than 'file' not considered: ";
        protected static final String g = "OPERATION COULD NOT BE COMPLETED";
        protected static final String d = "ERROR: Destination folder could not be created: ";
        protected static final String e = "ERROR: Could not save the operation report to: ";

        protected _b(String string) {
            super(string);
        }
    }
}

