/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.diff.factory;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.diff.api.DiffOptions;
import ro.sync.options.PersistentObject;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class DiffInfo
implements PersistentObject {
    private static final Logger logger = LoggerFactory.getLogger((String)DiffInfo.class.getName());
    public int algorithm;
    public int algorithm3Way;
    public boolean ignorePI;
    public boolean ignoreComments;
    public boolean ignoreCDATA;
    public boolean ignoreWhitespaces;
    public boolean ignoreDOCTYPE;
    public boolean ignoreText;
    public boolean ignoreAttributesOrder;
    public boolean ignorePrefixes;
    public boolean ignoreNamespaces;
    public boolean ignoreNamespaceDeclarations;
    public boolean mergeAdjacentDifferences;
    public boolean markEndTagsAsDifferent;
    public int maxNoOfDiffs;
    public int maxNoOfDiffs3Way;
    public boolean ignoreEntities;
    public boolean ignoreStateOfEmptyElements;
    public boolean ignoreNodesByXPath;
    public String defaultXPath;

    public DiffInfo(int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10, boolean bl11, boolean bl12, boolean bl13, boolean bl14, _b _b2, boolean bl15, String string) {
        this(n2, DiffInfo.getThreeWayAlgorithm(n2), bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8, bl9, bl10, bl11, bl12, bl13, bl14, _b2, _b2, bl15, string);
    }

    public DiffInfo(int n2, int n3, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10, boolean bl11, boolean bl12, boolean bl13, boolean bl14, _b _b2, _b _b3, boolean bl15, String string) {
        this.algorithm = n2;
        this.algorithm3Way = n3;
        this.ignorePI = bl;
        this.ignoreComments = bl2;
        this.ignoreCDATA = bl3;
        this.ignoreWhitespaces = bl4;
        this.ignoreDOCTYPE = bl5;
        this.ignoreText = bl6;
        this.ignoreAttributesOrder = bl7;
        this.ignorePrefixes = bl8;
        this.ignoreNamespaces = bl9;
        this.ignoreNamespaceDeclarations = bl10;
        this.ignoreEntities = bl11;
        this.mergeAdjacentDifferences = bl12;
        this.markEndTagsAsDifferent = bl13;
        this.ignoreStateOfEmptyElements = bl14;
        if (_b2 == null) {
            _b2 = _b.d;
        }
        this.maxNoOfDiffs = _b2.b();
        if (_b3 == null) {
            _b3 = _b.d;
        }
        this.maxNoOfDiffs3Way = _b3.b();
        this.ignoreNodesByXPath = bl15;
        this.defaultXPath = string;
    }

    public DiffInfo(DiffOptions diffOptions) {
        this.algorithm = diffOptions.getAlgorithm();
        this.algorithm3Way = DiffInfo.getThreeWayAlgorithm(diffOptions.getAlgorithm());
        this.ignoreAttributesOrder = diffOptions.isIgnoreAttributesOrder();
        this.ignoreCDATA = diffOptions.isIgnoreCDATA();
        this.ignoreComments = diffOptions.isIgnoreComments();
        this.ignoreDOCTYPE = diffOptions.isIgnoreDOCTYPE();
        this.ignoreEntities = diffOptions.isIgnoreEntities();
        this.ignoreNamespaceDeclarations = diffOptions.isIgnoreNamespaceDeclarations();
        this.ignoreNamespaces = diffOptions.isIgnoreNamespaces();
        this.ignorePI = diffOptions.isIgnorePI();
        this.ignorePrefixes = diffOptions.isIgnorePrefixes();
        this.ignoreStateOfEmptyElements = diffOptions.isIgnoreStateOfEmptyElements();
        this.ignoreText = diffOptions.isIgnoreText();
        this.ignoreWhitespaces = diffOptions.isIgnoreWhitespaces();
        this.markEndTagsAsDifferent = diffOptions.isMarkEndTagsAsDifferent();
        this.maxNoOfDiffs = diffOptions.getMaxNumberOfDiffs();
        this.maxNoOfDiffs3Way = diffOptions.getMaxNumberOfDiffs();
        this.mergeAdjacentDifferences = diffOptions.isMergeAdjacentDifferences();
        this.ignoreNodesByXPath = diffOptions.isIgnoreNodesByXPath();
        this.defaultXPath = diffOptions.getDefaultXPath();
    }

    public DiffInfo() {
        this(0, false, false, false, false, false, false, false, false, false, false, true, false, false, false, _b.d, false, null);
    }

    private static int getThreeWayAlgorithm(int n2) {
        return n2 == 3 || n2 == 6 || n2 == 5 ? n2 : 0;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logger.error((Object)cloneNotSupportedException, (Throwable)cloneNotSupportedException);
            return null;
        }
    }

    public String toString() {
        return "2-Way Algorithm : " + this.algorithm + "3-Way Algorithm : " + this.algorithm3Way + " AttrOrder : " + this.ignoreAttributesOrder + " Comments : " + this.ignoreComments + " CData: " + this.ignoreCDATA + " Doctype: " + this.ignoreDOCTYPE + " Entity : " + this.ignoreEntities + " Namespace : " + this.ignoreNamespaces + " Namespace Declaration : " + this.ignoreNamespaceDeclarations + " PI : " + this.ignorePI + " Pref : " + this.ignorePrefixes + " Text: " + this.ignoreText + " Whitespaces : " + this.ignoreWhitespaces + "Max diff 2-way: " + this.maxNoOfDiffs + "Max diff 3-way: " + this.maxNoOfDiffs3Way + " Merge : " + this.mergeAdjacentDifferences;
    }

    public DiffOptions getAsDiffOptions(boolean bl) {
        DiffOptions diffOptions = new DiffOptions(bl ? this.algorithm : this.algorithm3Way, this.ignoreWhitespaces, bl ? this.maxNoOfDiffs : this.maxNoOfDiffs3Way, this.ignorePI, this.ignoreComments, this.ignoreCDATA, this.ignoreDOCTYPE, this.ignoreText, this.ignoreAttributesOrder, this.ignorePrefixes, this.ignoreNamespaces, this.ignoreNamespaceDeclarations, this.ignoreEntities, this.mergeAdjacentDifferences, this.markEndTagsAsDifferent, this.ignoreStateOfEmptyElements);
        diffOptions.setDefaultXPath(this.defaultXPath);
        diffOptions.setIgnoreNodesByXPath(this.ignoreNodesByXPath);
        return diffOptions;
    }

    @Override
    public void checkValid() {
        if (this.algorithm < 0 || this.algorithm > 6) {
            this.algorithm = 0;
        }
        if (this.maxNoOfDiffs <= 0) {
            this.maxNoOfDiffs = _b.d.b();
        }
        if (this.algorithm3Way < 0 || this.algorithm3Way > 6) {
            this.algorithm3Way = 0;
        }
        if (this.maxNoOfDiffs3Way <= 0) {
            this.maxNoOfDiffs3Way = _b.d.b();
        }
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return null;
    }

    public static final class _b
    extends Enum<_b> {
        public static final /* enum */ _b h = new _b(1000, "Low");
        public static final /* enum */ _b d = new _b(10000, "Medium");
        public static final /* enum */ _b c = new _b(50000, "High");
        public static final /* enum */ _b e = new _b(150000, "Very_high");
        private final String b;
        private final int g;
        private static final /* synthetic */ _b[] f;

        public static _b[] values() {
            return (_b[])f.clone();
        }

        public static _b valueOf(String string) {
            return Enum.valueOf(_b.class, string);
        }

        private _b(int n3, String string2) {
            this.g = n3;
            this.b = string2;
        }

        public String c() {
            return this.b;
        }

        public int b() {
            return this.g;
        }

        private static /* synthetic */ _b[] d() {
            return new _b[]{h, d, c, e};
        }

        static {
            f = _b.d();
        }
    }
}

