/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.diff.api;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.io.IOUtil;
import ro.sync.diff.api.DiffException;
import ro.sync.diff.api.DiffLicenseMode;
import ro.sync.diff.ui.DiffFilesFrameDescriptor;
import ro.sync.exml.cd;
import ro.sync.exml.options.yg;
import ro.sync.g.c;
import ro.sync.g.e;
import ro.sync.g.e.h;
import ro.sync.g.e.i;
import ro.sync.g.e.w;
import ro.sync.ui.application.b.k;
import ro.sync.ui.application.gb;

@API(type=APIType.INTERNAL, src=SourceType.PRIVATE)
public final class DiffLicenseCheckerAndRegister {
    private static final List<String> COMPONENTS_WITH_DIFF_INCLUDED = List.of("Author", "Author-Component", "XML-Developer", "XML-Editor", "JSON-Editor", "Oxygen-Scripting");
    private static final Logger logger = LoggerFactory.getLogger((String)DiffLicenseCheckerAndRegister.class.getName());
    private static String alternateDiffLicense;

    private DiffLicenseCheckerAndRegister() {
    }

    public static void licenseCheck() throws DiffException {
        DiffLicenseMode diffLicenseMode = DiffLicenseCheckerAndRegister.getLicenseMode();
        if (diffLicenseMode == DiffLicenseMode.INVALID_LICENSE) {
            throw new DiffException("Your current license key does not cover the diff functionality.");
        }
        if (diffLicenseMode == DiffLicenseMode.NO_LICENSE_DETECTED) {
            throw new DiffException("ERROR: No valid Diff Server license found, diff perform aborted...\nPlease register a valid license key!");
        }
    }

    public static DiffLicenseMode getLicenseMode() {
        DiffLicenseMode diffLicenseMode = DiffLicenseMode.LICENSED;
        if (c.n() != null && c.n().i() != null) {
            h h2 = c.n().i();
            List<String> list = h2.y();
            diffLicenseMode = list.contains("Diff-Srv") || DiffLicenseCheckerAndRegister.isDiffLicensedByAnotherComponent(list) ? DiffLicenseMode.LICENSED : (alternateDiffLicense != null ? DiffLicenseCheckerAndRegister.detectDiffModeFromAdditionalLicense(alternateDiffLicense, new String[]{"AI-Positron-WA"}) : (list.contains("AI-Positron") ? DiffLicenseMode.LIMITED : DiffLicenseMode.INVALID_LICENSE));
        } else {
            ro.sync.exml.k.e e2 = new ro.sync.exml.k.e(new String[]{"Diff-Srv"});
            if (null == e2.licenseCheck(false)) {
                diffLicenseMode = DiffLicenseMode.NO_LICENSE_DETECTED;
            }
        }
        return diffLicenseMode;
    }

    private static boolean isDiffLicensedByAnotherComponent(List<String> list) {
        for (String string : i.m) {
            if (!COMPONENTS_WITH_DIFF_INCLUDED.contains(string)) continue;
            for (String string2 : list) {
                if (!string2.split("@")[0].equals(string)) continue;
                return true;
            }
        }
        for (String string : COMPONENTS_WITH_DIFF_INCLUDED) {
            if (!list.contains(string)) continue;
            return true;
        }
        return false;
    }

    public static void registerLicenseKey(Reader reader) throws DiffException {
        if (cd.q()) {
            logger.error("License key for diff cannot be registered when using Web Author.");
        } else {
            try {
                yg.p().i(IOUtil.read((Reader)reader).toString());
                gb.c(new DiffFilesFrameDescriptor());
            }
            catch (IOException iOException) {
                throw new DiffException("Could not read the license key!", iOException);
            }
        }
    }

    private static DiffLicenseMode detectDiffModeFromAdditionalLicense(String string, String[] stringArray) {
        try {
            e e2 = new e();
            w w2 = new w(e2);
            String string2 = Optional.ofNullable(k.d()).map(d2 -> d2.g()).orElse(null);
            w2.g(string, string2, stringArray);
            return DiffLicenseMode.LIMITED;
        }
        catch (Exception exception) {
            logger.debug("Your current license key does not cover the diff functionality. " + exception.getMessage(), (Throwable)exception);
            return DiffLicenseMode.INVALID_LICENSE;
        }
    }

    public static synchronized void registerAlternateLicenseKey(String string) {
        alternateDiffLicense = string;
    }
}

