/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.contentcompletion.xsl;

import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.util.Equaler;
import ro.sync.options.InvalidPersistentObjException;
import ro.sync.options.PersistentObject;
import ro.sync.util.Resource;
import ro.sync.util.editorvars.EditorVariables;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class XSLResultSchemaInfo
implements PersistentObject {
    private static final Logger logger = LoggerFactory.getLogger((String)XSLResultSchemaInfo.class.getName());
    public static final XSLResultSchemaInfo DEFAULT = new XSLResultSchemaInfo(null, "HTML", true);
    String systemID;
    String schemaType;
    boolean detectSchema = true;

    public XSLResultSchemaInfo() {
    }

    public XSLResultSchemaInfo(String string, String string2, boolean bl) {
        this.systemID = string;
        this.schemaType = string2;
        this.detectSchema = bl;
    }

    public URL getURL() {
        if ("NONE".equals(this.schemaType)) {
            return null;
        }
        if ("HTML".equals(this.schemaType)) {
            return Resource.getResource("/builtin/html5/epub-xhtml-30-no-ns.rnc");
        }
        if ("FOP".equals(this.schemaType)) {
            return Resource.getResource("/builtin/fo.xsd");
        }
        URL uRL = null;
        if (this.systemID != null) {
            String string = EditorVariables.expandEditorVariables(this.systemID, null);
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                logger.warn((Object)malformedURLException, (Throwable)malformedURLException);
            }
        }
        return uRL;
    }

    public String getSystemID() {
        return this.systemID;
    }

    public String getSchemaType() {
        return this.schemaType;
    }

    public boolean equals(Object object) {
        if (object instanceof XSLResultSchemaInfo) {
            XSLResultSchemaInfo xSLResultSchemaInfo = (XSLResultSchemaInfo)object;
            return Equaler.verifyEquals((Object)this.systemID, (Object)xSLResultSchemaInfo.getSystemID()) && Equaler.verifyEquals((Object)this.schemaType, (Object)xSLResultSchemaInfo.getSchemaType());
        }
        return false;
    }

    public int hashCode() {
        int n2 = 1;
        if (this.systemID != null) {
            n2 += this.systemID.hashCode();
        }
        if (this.schemaType != null) {
            n2 += this.schemaType.hashCode();
        }
        return n2;
    }

    @Override
    public void checkValid() throws InvalidPersistentObjException {
        boolean bl;
        if (this.schemaType == null) {
            throw new InvalidPersistentObjException("Missing schema type in the xsl result schema");
        }
        boolean bl2 = bl = this.schemaType.equals("XML_SCHEMA") || this.schemaType.equals("DTD") || this.schemaType.equals("RNG") || this.schemaType.equals("RNC") || this.schemaType.equals("NVDL") || this.schemaType.equals("UNKNOWN");
        if (this.systemID == null && bl) {
            throw new InvalidPersistentObjException("Missing systemID for used defined schema");
        }
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return null;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logger.error((Object)cloneNotSupportedException, (Throwable)cloneNotSupportedException);
            return null;
        }
    }

    public boolean isDetectSchema() {
        return this.detectSchema;
    }
}

