/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.traversers;

import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaNamespaceSupport;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSAttributeDecl;
import org.apache.xerces.impl.xs.XSGrammarBucket;
import org.apache.xerces.impl.xs.traversers.Container;
import org.apache.xerces.impl.xs.traversers.OneAttr;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.impl.xs.traversers.XSDocumentInfo;
import org.apache.xerces.impl.xs.util.XInt;
import org.apache.xerces.impl.xs.util.XIntPool;
import org.apache.xerces.util.DOMUtil;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xni.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class XSAttributeCheckerXerces {
    private static final String ELEMENT_N = "element_n";
    private static final String ELEMENT_R = "element_r";
    private static final String ATTRIBUTE_N = "attribute_n";
    private static final String ATTRIBUTE_R = "attribute_r";
    private static final String UNIQUE_R = "unique_r";
    private static final String KEY_R = "key_r";
    private static final String KEYREF_R = "keyref_r";
    private static int ATTIDX_COUNT = 0;
    public static final int ATTIDX_ABSTRACT = ATTIDX_COUNT++;
    public static final int ATTIDX_AFORMDEFAULT = ATTIDX_COUNT++;
    public static final int ATTIDX_BASE = ATTIDX_COUNT++;
    public static final int ATTIDX_BLOCK = ATTIDX_COUNT++;
    public static final int ATTIDX_BLOCKDEFAULT = ATTIDX_COUNT++;
    public static final int ATTIDX_DEFAULT = ATTIDX_COUNT++;
    public static final int ATTIDX_EFORMDEFAULT = ATTIDX_COUNT++;
    public static final int ATTIDX_FINAL = ATTIDX_COUNT++;
    public static final int ATTIDX_FINALDEFAULT = ATTIDX_COUNT++;
    public static final int ATTIDX_FIXED = ATTIDX_COUNT++;
    public static final int ATTIDX_FORM = ATTIDX_COUNT++;
    public static final int ATTIDX_ID = ATTIDX_COUNT++;
    public static final int ATTIDX_ITEMTYPE = ATTIDX_COUNT++;
    public static final int ATTIDX_MAXOCCURS = ATTIDX_COUNT++;
    public static final int ATTIDX_MEMBERTYPES = ATTIDX_COUNT++;
    public static final int ATTIDX_MINOCCURS = ATTIDX_COUNT++;
    public static final int ATTIDX_MIXED = ATTIDX_COUNT++;
    public static final int ATTIDX_NAME = ATTIDX_COUNT++;
    public static final int ATTIDX_NAMESPACE = ATTIDX_COUNT++;
    public static final int ATTIDX_NAMESPACE_LIST = ATTIDX_COUNT++;
    public static final int ATTIDX_NILLABLE = ATTIDX_COUNT++;
    public static final int ATTIDX_NONSCHEMA = ATTIDX_COUNT++;
    public static final int ATTIDX_PROCESSCONTENTS = ATTIDX_COUNT++;
    public static final int ATTIDX_PUBLIC = ATTIDX_COUNT++;
    public static final int ATTIDX_REF = ATTIDX_COUNT++;
    public static final int ATTIDX_REFER = ATTIDX_COUNT++;
    public static final int ATTIDX_SCHEMALOCATION = ATTIDX_COUNT++;
    public static final int ATTIDX_SOURCE = ATTIDX_COUNT++;
    public static final int ATTIDX_SUBSGROUP = ATTIDX_COUNT++;
    public static final int ATTIDX_SYSTEM = ATTIDX_COUNT++;
    public static final int ATTIDX_TARGETNAMESPACE = ATTIDX_COUNT++;
    public static final int ATTIDX_TYPE = ATTIDX_COUNT++;
    public static final int ATTIDX_USE = ATTIDX_COUNT++;
    public static final int ATTIDX_VALUE = ATTIDX_COUNT++;
    public static final int ATTIDX_ENUMNSDECLS = ATTIDX_COUNT++;
    public static final int ATTIDX_VERSION = ATTIDX_COUNT++;
    public static final int ATTIDX_XML_LANG = ATTIDX_COUNT++;
    public static final int ATTIDX_XPATH = ATTIDX_COUNT++;
    public static final int ATTIDX_FROMDEFAULT = ATTIDX_COUNT++;
    public static final int ATTIDX_ISRETURNED = ATTIDX_COUNT++;
    public static final int ATTIDX_APPLIESTOEMPTY = ATTIDX_COUNT++;
    public static final int ATTIDX_DEFAULTATTRAPPLY = ATTIDX_COUNT++;
    public static final int ATTIDX_DEFAULTATTRIBUTES = ATTIDX_COUNT++;
    public static final int ATTIDX_MODE = ATTIDX_COUNT++;
    public static final int ATTIDX_NOTNAMESPACE = ATTIDX_COUNT++;
    public static final int ATTIDX_NOTQNAME = ATTIDX_COUNT++;
    public static final int ATTIDX_XPATHDEFAULTNS = ATTIDX_COUNT++;
    public static final int ATTIDX_INHERITABLE = ATTIDX_COUNT++;
    public static final int ATTIDX_XPATHDEFAULTNS_TWOPOUNDDFLT = ATTIDX_COUNT++;
    protected static final XIntPool fXIntPool = new XIntPool();
    private static final XInt INT_QUALIFIED = fXIntPool.getXInt(1);
    private static final XInt INT_UNQUALIFIED = fXIntPool.getXInt(0);
    private static final XInt INT_EMPTY_SET = fXIntPool.getXInt(0);
    private static final XInt INT_ANY_STRICT = fXIntPool.getXInt(1);
    private static final XInt INT_ANY_LAX = fXIntPool.getXInt(3);
    private static final XInt INT_ANY_SKIP = fXIntPool.getXInt(2);
    private static final XInt INT_ANY_ANY = fXIntPool.getXInt(1);
    private static final XInt INT_ANY_LIST = fXIntPool.getXInt(3);
    private static final XInt INT_ANY_NOT = fXIntPool.getXInt(2);
    private static final XInt INT_USE_OPTIONAL = fXIntPool.getXInt(0);
    private static final XInt INT_USE_REQUIRED = fXIntPool.getXInt(1);
    private static final XInt INT_USE_PROHIBITED = fXIntPool.getXInt(2);
    private static final XInt INT_WS_PRESERVE = fXIntPool.getXInt(0);
    private static final XInt INT_WS_REPLACE = fXIntPool.getXInt(1);
    private static final XInt INT_WS_COLLAPSE = fXIntPool.getXInt(2);
    private static final XInt INT_ET_OPTION = fXIntPool.getXInt(0);
    private static final XInt INT_ET_REQUIRED = fXIntPool.getXInt(1);
    private static final XInt INT_ET_PROHIBITED = fXIntPool.getXInt(2);
    private static final XInt INT_UNBOUNDED = fXIntPool.getXInt(-1);
    private static final XInt INT_MODE_NONE = fXIntPool.getXInt(0);
    private static final XInt INT_MODE_INTERLEAVE = fXIntPool.getXInt(1);
    private static final XInt INT_MODE_SUFFIX = fXIntPool.getXInt(2);
    private static final Hashtable fEleAttrsMapG = new Hashtable(29);
    private static final Hashtable fEleAttrsMapL = new Hashtable(79);
    private static final Hashtable fEleAttrs11MapG = new Hashtable(31);
    private static final Hashtable fEleAttrs11MapL = new Hashtable(102);
    protected static final int DT_ANYURI = 0;
    protected static final int DT_ID = 1;
    protected static final int DT_QNAME = 2;
    protected static final int DT_STRING = 3;
    protected static final int DT_TOKEN = 4;
    protected static final int DT_NCNAME = 5;
    protected static final int DT_XPATH = 6;
    protected static final int DT_XPATH1 = 7;
    protected static final int DT_LANGUAGE = 8;
    protected static final int DT_COUNT = 9;
    private static final XSSimpleType[] fExtraDVs = new XSSimpleType[9];
    protected static final int DT_BLOCK = -1;
    protected static final int DT_BLOCK1 = -2;
    protected static final int DT_FINAL = -3;
    protected static final int DT_FINAL1 = -4;
    protected static final int DT_FINAL2 = -5;
    protected static final int DT_FORM = -6;
    protected static final int DT_MAXOCCURS = -7;
    protected static final int DT_MAXOCCURS1 = -8;
    protected static final int DT_MEMBERTYPES = -9;
    protected static final int DT_MINOCCURS1 = -10;
    protected static final int DT_NAMESPACE = -11;
    protected static final int DT_PROCESSCONTENTS = -12;
    protected static final int DT_USE = -13;
    protected static final int DT_WHITESPACE = -14;
    protected static final int DT_BOOLEAN = -15;
    protected static final int DT_NONNEGINT = -16;
    protected static final int DT_POSINT = -17;
    protected static final int DT_XPATH_DEFAULT_NS = -18;
    protected static final int DT_MODE = -19;
    protected static final int DT_MODE1 = -20;
    protected static final int DT_NOTNAMESPACE = -21;
    protected static final int DT_NOTQNAME = -22;
    protected static final int DT_INT = -23;
    protected static final int DT_EXPLICITTIMEZONE = -24;
    protected XSDHandler fSchemaHandler = null;
    protected SymbolTable fSymbolTable = null;
    protected Hashtable fNonSchemaAttrs = new Hashtable();
    protected Vector fNamespaceList = new Vector();
    protected boolean[] fSeen = new boolean[ATTIDX_COUNT];
    private static boolean[] fSeenTemp;
    static final int INIT_POOL_SIZE = 10;
    static final int INC_POOL_SIZE = 10;
    Object[][] fArrayPool = new Object[10][ATTIDX_COUNT];
    private static Object[] fTempArray;
    int fPoolPos = 0;

    public XSAttributeCheckerXerces(XSDHandler schemaHandler) {
        this.fSchemaHandler = schemaHandler;
    }

    public void reset(SymbolTable symbolTable) {
        this.fSymbolTable = symbolTable;
        this.fNonSchemaAttrs.clear();
    }

    public String checkTargetNamespace(Element element, XSDocumentInfo schemaDoc) {
        if (DOMUtil.getAttr(element, SchemaSymbols.ATT_TARGETNAMESPACE) != null) {
            String value = DOMUtil.getAttrValueTrimmed(element, SchemaSymbols.ATT_TARGETNAMESPACE);
            try {
                fExtraDVs[0].validate(value, (ValidationContext)schemaDoc.fValidationContext, null);
                return this.fSymbolTable.addSymbol(value);
            }
            catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                // empty catch block
            }
        }
        return null;
    }

    public Object[] checkAttributes(Element element, boolean isGlobal, XSDocumentInfo schemaDoc) {
        return this.checkAttributes(element, isGlobal, schemaDoc, false);
    }

    public Object[] checkAttributes(Element element, boolean isGlobal, XSDocumentInfo schemaDoc, boolean enumAsQName) {
        Container attrList;
        if (element == null) {
            return null;
        }
        Attr[] attrs = DOMUtil.getAttrs(element);
        this.resolveNamespace(element, attrs, schemaDoc.fNamespaceSupport);
        String uri = DOMUtil.getNamespaceURI(element);
        String elName = DOMUtil.getLocalName(element);
        if (!SchemaSymbols.URI_SCHEMAFORSCHEMA.equals(uri)) {
            this.reportSchemaError("s4s-elt-schema-ns", new Object[]{elName}, element);
        }
        Hashtable eleAttrsMap = this.fSchemaHandler.fSchemaVersion < 4 ? fEleAttrsMapG : fEleAttrs11MapG;
        String lookupName = elName;
        if (!isGlobal) {
            Hashtable hashtable = eleAttrsMap = this.fSchemaHandler.fSchemaVersion < 4 ? fEleAttrsMapL : fEleAttrs11MapL;
            if (elName.equals(SchemaSymbols.ELT_ELEMENT)) {
                lookupName = DOMUtil.getAttr(element, SchemaSymbols.ATT_REF) != null ? ELEMENT_R : ELEMENT_N;
            } else if (elName.equals(SchemaSymbols.ELT_ATTRIBUTE)) {
                lookupName = DOMUtil.getAttr(element, SchemaSymbols.ATT_REF) != null ? ATTRIBUTE_R : ATTRIBUTE_N;
            } else if (this.fSchemaHandler.fSchemaVersion == 4 && DOMUtil.getAttr(element, SchemaSymbols.ATT_REF) != null) {
                if (elName.equals(SchemaSymbols.ELT_UNIQUE)) {
                    lookupName = UNIQUE_R;
                } else if (elName.equals(SchemaSymbols.ELT_KEY)) {
                    lookupName = KEY_R;
                } else if (elName.equals(SchemaSymbols.ELT_KEYREF)) {
                    lookupName = KEYREF_R;
                }
            }
        }
        if ((attrList = (Container)eleAttrsMap.get(lookupName)) == null) {
            this.reportSchemaError("s4s-elt-invalid", new Object[]{elName}, element);
            return null;
        }
        Object[] attrValues = this.getAvailableArray();
        long fromDefault = 0L;
        System.arraycopy(fSeenTemp, 0, this.fSeen, 0, ATTIDX_COUNT);
        int length = attrs.length;
        Attr sattr = null;
        for (int i = 0; i < length; ++i) {
            block37: {
                sattr = attrs[i];
                String attrName = sattr.getName();
                String attrURI = DOMUtil.getNamespaceURI(sattr);
                String attrVal = DOMUtil.getValue(sattr);
                if (attrName.startsWith("xml")) {
                    String attrPrefix = DOMUtil.getPrefix(sattr);
                    if ("xmlns".equals(attrPrefix) || "xmlns".equals(attrName)) continue;
                    if (SchemaSymbols.ATT_XML_LANG.equals(attrName) && (SchemaSymbols.ELT_SCHEMA.equals(elName) || SchemaSymbols.ELT_DOCUMENTATION.equals(elName))) {
                        attrURI = null;
                    }
                }
                if (attrURI != null && attrURI.length() != 0) {
                    if (attrURI.equals(SchemaSymbols.URI_SCHEMAFORSCHEMA)) {
                        this.reportSchemaError("s4s-att-not-allowed", new Object[]{elName, attrName}, element);
                        continue;
                    }
                    if (attrValues[ATTIDX_NONSCHEMA] == null) {
                        attrValues[XSAttributeCheckerXerces.ATTIDX_NONSCHEMA] = new Vector(4, 2);
                    }
                    ((Vector)attrValues[ATTIDX_NONSCHEMA]).addElement(attrName);
                    ((Vector)attrValues[ATTIDX_NONSCHEMA]).addElement(attrVal);
                    continue;
                }
                OneAttr oneAttr = attrList.get(attrName);
                if (oneAttr == null) {
                    this.reportSchemaError("s4s-att-not-allowed", new Object[]{elName, attrName}, element);
                    continue;
                }
                this.fSeen[oneAttr.valueIndex] = true;
                try {
                    if (oneAttr.dvIndex >= 0) {
                        if (oneAttr.dvIndex != 3 && oneAttr.dvIndex != 6 && oneAttr.dvIndex != 7) {
                            Object avalue;
                            XSSimpleType dv = fExtraDVs[oneAttr.dvIndex];
                            if (oneAttr.valueIndex == ATTIDX_SUBSGROUP) {
                                if (attrValues[ATTIDX_SUBSGROUP] == null) {
                                    attrValues[XSAttributeCheckerXerces.ATTIDX_SUBSGROUP] = new Vector();
                                }
                                if (this.fSchemaHandler.fSchemaVersion == 4) {
                                    StringTokenizer st = new StringTokenizer(attrVal, " \n\t\r");
                                    while (st.hasMoreTokens()) {
                                        Object avalue2 = dv.validate(st.nextToken(), (ValidationContext)schemaDoc.fValidationContext, null);
                                        this.modifyQNameForChameleonProcessing(schemaDoc, avalue2);
                                        ((Vector)attrValues[ATTIDX_SUBSGROUP]).addElement(avalue2);
                                    }
                                } else {
                                    avalue = dv.validate(attrVal, (ValidationContext)schemaDoc.fValidationContext, null);
                                    this.modifyQNameForChameleonProcessing(schemaDoc, avalue);
                                    ((Vector)attrValues[ATTIDX_SUBSGROUP]).addElement(avalue);
                                }
                            } else {
                                avalue = dv.validate(attrVal, (ValidationContext)schemaDoc.fValidationContext, null);
                                if (oneAttr.dvIndex == 2) {
                                    this.modifyQNameForChameleonProcessing(schemaDoc, avalue);
                                }
                                attrValues[oneAttr.valueIndex] = avalue;
                            }
                        } else {
                            attrValues[oneAttr.valueIndex] = attrVal;
                        }
                    } else {
                        attrValues[oneAttr.valueIndex] = this.validate(attrValues, attrName, attrVal, oneAttr.dvIndex, schemaDoc);
                    }
                }
                catch (InvalidDatatypeValueException ide) {
                    this.reportSchemaError("s4s-att-invalid-value", new Object[]{elName, attrName, ide.getMessage()}, element);
                    if (oneAttr.dfltValue == null) break block37;
                    attrValues[oneAttr.valueIndex] = oneAttr.dfltValue;
                }
            }
            if (!elName.equals(SchemaSymbols.ELT_ENUMERATION) || !enumAsQName) continue;
            attrValues[XSAttributeCheckerXerces.ATTIDX_ENUMNSDECLS] = new SchemaNamespaceSupport(schemaDoc.fNamespaceSupport);
        }
        OneAttr[] reqAttrs = attrList.values;
        for (int i = 0; i < reqAttrs.length; ++i) {
            OneAttr oneAttr = reqAttrs[i];
            if (oneAttr.dfltValue == null || this.fSeen[oneAttr.valueIndex]) continue;
            attrValues[oneAttr.valueIndex] = oneAttr.dfltValue;
            fromDefault |= (long)(1 << oneAttr.valueIndex);
        }
        attrValues[XSAttributeCheckerXerces.ATTIDX_FROMDEFAULT] = new Long(fromDefault);
        if (attrValues[ATTIDX_MAXOCCURS] != null) {
            int min = ((XInt)attrValues[ATTIDX_MINOCCURS]).intValue();
            int max = ((XInt)attrValues[ATTIDX_MAXOCCURS]).intValue();
            if (max != -1 && min > max) {
                this.reportSchemaError("p-props-correct.2.1", new Object[]{elName, attrValues[ATTIDX_MINOCCURS], attrValues[ATTIDX_MAXOCCURS]}, element);
                attrValues[XSAttributeCheckerXerces.ATTIDX_MINOCCURS] = attrValues[ATTIDX_MAXOCCURS];
            }
        }
        return attrValues;
    }

    private void modifyQNameForChameleonProcessing(XSDocumentInfo schemaDoc, Object qnameVal) {
        QName qname = (QName)qnameVal;
        if (qname.prefix == XMLSymbols.EMPTY_STRING && qname.uri == null && schemaDoc.fIsChameleonSchema) {
            qname.uri = schemaDoc.fTargetNamespace;
        }
    }

    private Object validate(Object[] attrValues, String attr, String ivalue, int dvIndex, XSDocumentInfo schemaDoc) throws InvalidDatatypeValueException {
        if (ivalue == null) {
            return null;
        }
        String value = XMLChar.trim(ivalue);
        Object retValue = null;
        switch (dvIndex) {
            case -15: {
                if (value.equals("false") || value.equals("0")) {
                    retValue = Boolean.FALSE;
                    break;
                }
                if (value.equals("true") || value.equals("1")) {
                    retValue = Boolean.TRUE;
                    break;
                }
                throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{value, "boolean"});
            }
            case -16: {
                try {
                    if (value.length() > 0 && value.charAt(0) == '+') {
                        value = value.substring(1);
                    }
                    retValue = fXIntPool.getXInt(Integer.parseInt(value));
                }
                catch (NumberFormatException e) {
                    throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{value, "nonNegativeInteger"});
                }
                if (((XInt)retValue).intValue() >= 0) break;
                throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{value, "nonNegativeInteger"});
            }
            case -17: {
                try {
                    if (value.length() > 0 && value.charAt(0) == '+') {
                        value = value.substring(1);
                    }
                    retValue = fXIntPool.getXInt(Integer.parseInt(value));
                }
                catch (NumberFormatException e) {
                    throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{value, "positiveInteger"});
                }
                if (((XInt)retValue).intValue() > 0) break;
                throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{value, "positiveInteger"});
            }
            case -1: {
                int choice = 0;
                if (value.equals("#all")) {
                    choice = 31;
                } else {
                    StringTokenizer t = new StringTokenizer(value, " \n\t\r");
                    while (t.hasMoreTokens()) {
                        String token = t.nextToken();
                        if (token.equals("extension")) {
                            choice |= 1;
                            continue;
                        }
                        if (token.equals("restriction")) {
                            choice |= 2;
                            continue;
                        }
                        if (token.equals("substitution")) {
                            choice |= 4;
                            continue;
                        }
                        throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.3", new Object[]{value, "(#all | List of (extension | restriction | substitution))"});
                    }
                }
                retValue = fXIntPool.getXInt(choice);
                break;
            }
            case -3: 
            case -2: {
                int choice = 0;
                if (value.equals("#all")) {
                    choice = 31;
                } else {
                    StringTokenizer t = new StringTokenizer(value, " \n\t\r");
                    while (t.hasMoreTokens()) {
                        String token = t.nextToken();
                        if (token.equals("extension")) {
                            choice |= 1;
                            continue;
                        }
                        if (token.equals("restriction")) {
                            choice |= 2;
                            continue;
                        }
                        throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.3", new Object[]{value, "(#all | List of (extension | restriction))"});
                    }
                }
                retValue = fXIntPool.getXInt(choice);
                break;
            }
            case -4: {
                int choice = 0;
                if (value.equals("#all")) {
                    choice = 31;
                } else {
                    StringTokenizer t = new StringTokenizer(value, " \n\t\r");
                    while (t.hasMoreTokens()) {
                        String token = t.nextToken();
                        if (token.equals("list")) {
                            choice |= 0x10;
                            continue;
                        }
                        if (token.equals("union")) {
                            choice |= 8;
                            continue;
                        }
                        if (token.equals("restriction")) {
                            choice |= 2;
                            continue;
                        }
                        throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.3", new Object[]{value, "(#all | List of (list | union | restriction))"});
                    }
                }
                retValue = fXIntPool.getXInt(choice);
                break;
            }
            case -5: {
                int choice = 0;
                if (value.equals("#all")) {
                    choice = 31;
                } else {
                    StringTokenizer t = new StringTokenizer(value, " \n\t\r");
                    while (t.hasMoreTokens()) {
                        String token = t.nextToken();
                        if (token.equals("extension")) {
                            choice |= 1;
                            continue;
                        }
                        if (token.equals("restriction")) {
                            choice |= 2;
                            continue;
                        }
                        if (token.equals("list")) {
                            choice |= 0x10;
                            continue;
                        }
                        if (token.equals("union")) {
                            choice |= 8;
                            continue;
                        }
                        throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.3", new Object[]{value, "(#all | List of (extension | restriction | list | union))"});
                    }
                }
                retValue = fXIntPool.getXInt(choice);
                break;
            }
            case -6: {
                if (value.equals("qualified")) {
                    retValue = INT_QUALIFIED;
                    break;
                }
                if (value.equals("unqualified")) {
                    retValue = INT_UNQUALIFIED;
                    break;
                }
                throw new InvalidDatatypeValueException("cvc-enumeration-valid", new Object[]{value, "(qualified | unqualified)"});
            }
            case -7: {
                if (value.equals("unbounded")) {
                    retValue = INT_UNBOUNDED;
                    break;
                }
                try {
                    retValue = this.validate(attrValues, attr, value, -16, schemaDoc);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.3", new Object[]{value, "(nonNegativeInteger | unbounded)"});
                }
            }
            case -8: {
                if (value.equals("1")) {
                    retValue = fXIntPool.getXInt(1);
                    break;
                }
                throw new InvalidDatatypeValueException("cvc-enumeration-valid", new Object[]{value, "(1)"});
            }
            case -9: {
                Vector<QName> memberType = new Vector<QName>();
                try {
                    StringTokenizer t = new StringTokenizer(value, " \n\t\r");
                    while (t.hasMoreTokens()) {
                        String token = t.nextToken();
                        QName qname = (QName)fExtraDVs[2].validate(token, (ValidationContext)schemaDoc.fValidationContext, null);
                        if (qname.prefix == XMLSymbols.EMPTY_STRING && qname.uri == null && schemaDoc.fIsChameleonSchema) {
                            qname.uri = schemaDoc.fTargetNamespace;
                        }
                        memberType.addElement(qname);
                    }
                    retValue = memberType;
                    break;
                }
                catch (InvalidDatatypeValueException ide) {
                    throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.2", new Object[]{value, "(List of QName)"});
                }
            }
            case -10: {
                if (value.equals("0")) {
                    retValue = fXIntPool.getXInt(0);
                    break;
                }
                if (value.equals("1")) {
                    retValue = fXIntPool.getXInt(1);
                    break;
                }
                throw new InvalidDatatypeValueException("cvc-enumeration-valid", new Object[]{value, "(0 | 1)"});
            }
            case -11: {
                if (value.equals("##any")) {
                    retValue = INT_ANY_ANY;
                    break;
                }
                if (value.equals("##other")) {
                    retValue = INT_ANY_NOT;
                    String[] list = new String[]{schemaDoc.fTargetNamespace, null};
                    attrValues[XSAttributeCheckerXerces.ATTIDX_NAMESPACE_LIST] = list;
                    break;
                }
                retValue = INT_ANY_LIST;
                attrValues[XSAttributeCheckerXerces.ATTIDX_NAMESPACE_LIST] = this.processNamespaceList(value, schemaDoc);
                break;
            }
            case -12: {
                if (value.equals("strict")) {
                    retValue = INT_ANY_STRICT;
                    break;
                }
                if (value.equals("lax")) {
                    retValue = INT_ANY_LAX;
                    break;
                }
                if (value.equals("skip")) {
                    retValue = INT_ANY_SKIP;
                    break;
                }
                throw new InvalidDatatypeValueException("cvc-enumeration-valid", new Object[]{value, "(lax | skip | strict)"});
            }
            case -13: {
                if (value.equals("optional")) {
                    retValue = INT_USE_OPTIONAL;
                    break;
                }
                if (value.equals("required")) {
                    retValue = INT_USE_REQUIRED;
                    break;
                }
                if (value.equals("prohibited")) {
                    retValue = INT_USE_PROHIBITED;
                    break;
                }
                throw new InvalidDatatypeValueException("cvc-enumeration-valid", new Object[]{value, "(optional | prohibited | required)"});
            }
            case -20: {
                if (value.equals("none")) {
                    retValue = INT_MODE_NONE;
                    break;
                }
            }
            case -19: {
                Object[] objectArray;
                if (value.equals("interleave")) {
                    retValue = INT_MODE_INTERLEAVE;
                    break;
                }
                if (value.equals("suffix")) {
                    retValue = INT_MODE_SUFFIX;
                    break;
                }
                if (dvIndex == -20) {
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = value;
                    objectArray = objectArray2;
                    objectArray2[1] = "(none | interleave | suffix)";
                } else {
                    Object[] objectArray3 = new Object[2];
                    objectArray3[0] = value;
                    objectArray = objectArray3;
                    objectArray3[1] = "(interleave | sufix)";
                }
                throw new InvalidDatatypeValueException("cvc-enumeration-valid", objectArray);
            }
            case -22: {
                if (attrValues[ATTIDX_NOTQNAME] == null) {
                    attrValues[XSAttributeCheckerXerces.ATTIDX_NOTQNAME] = new Vector();
                }
                Vector notQNameList = (Vector)attrValues[ATTIDX_NOTQNAME];
                StringTokenizer tokens = new StringTokenizer(value, " \n\t\r");
                Boolean definedKeyword = Boolean.FALSE;
                Boolean siblingKeyword = Boolean.FALSE;
                try {
                    while (tokens.hasMoreTokens()) {
                        String token = tokens.nextToken();
                        if (token.equals("##defined")) {
                            definedKeyword = Boolean.TRUE;
                            continue;
                        }
                        if (token.equals("##definedSibling")) {
                            siblingKeyword = Boolean.TRUE;
                            continue;
                        }
                        QName qname = (QName)fExtraDVs[2].validate(token, (ValidationContext)schemaDoc.fValidationContext, null);
                        if (notQNameList.contains(qname)) continue;
                        notQNameList.addElement(qname);
                    }
                    int num = notQNameList.size();
                    Object[] list = new QName[num];
                    notQNameList.copyInto(list);
                    notQNameList.clear();
                    notQNameList.add(list);
                    notQNameList.add(definedKeyword);
                    notQNameList.add(siblingKeyword);
                }
                catch (InvalidDatatypeValueException ide) {
                    throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.3", new Object[]{value, "(List of (QName | ##defined) )"});
                }
                retValue = notQNameList;
                break;
            }
            case -21: {
                retValue = this.processNamespaceList(value, schemaDoc);
                break;
            }
            case -14: {
                if (value.equals("preserve")) {
                    retValue = INT_WS_PRESERVE;
                    break;
                }
                if (value.equals("replace")) {
                    retValue = INT_WS_REPLACE;
                    break;
                }
                if (value.equals("collapse")) {
                    retValue = INT_WS_COLLAPSE;
                    break;
                }
                throw new InvalidDatatypeValueException("cvc-enumeration-valid", new Object[]{value, "(preserve | replace | collapse)"});
            }
            case -18: {
                retValue = null;
                if (value.equals("##targetNamespace")) {
                    retValue = schemaDoc.fTargetNamespace;
                    break;
                }
                if (value.equals("##defaultNamespace")) {
                    retValue = schemaDoc.fValidationContext.getURI(XMLSymbols.EMPTY_STRING);
                    if (retValue != null) {
                        retValue = this.fSymbolTable.addSymbol((String)retValue);
                    }
                    attrValues[XSAttributeCheckerXerces.ATTIDX_XPATHDEFAULTNS_TWOPOUNDDFLT] = Boolean.TRUE;
                    break;
                }
                if (value.equals("##local")) break;
                try {
                    fExtraDVs[0].validate(value, (ValidationContext)schemaDoc.fValidationContext, null);
                    retValue = this.fSymbolTable.addSymbol(value);
                    break;
                }
                catch (InvalidDatatypeValueException ide) {
                    throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.3", new Object[]{value, "anyURI | ##defaultNamespace | ##targetNamespace | ##local"});
                }
            }
            case -23: {
                boolean isPositive = false;
                try {
                    if (value.length() > 0 && value.charAt(0) == '+') {
                        isPositive = true;
                        value = value.substring(1);
                    }
                    retValue = fXIntPool.getXInt(Integer.parseInt(value));
                }
                catch (NumberFormatException e) {
                    throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{value, "Integer"});
                }
                if (!isPositive || ((XInt)retValue).intValue() >= 0) break;
                throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{"+" + value, "Integer"});
            }
            case -24: {
                if (value.equals("optional")) {
                    retValue = INT_ET_OPTION;
                    break;
                }
                if (value.equals("required")) {
                    retValue = INT_ET_REQUIRED;
                    break;
                }
                if (value.equals("prohibited")) {
                    retValue = INT_ET_PROHIBITED;
                    break;
                }
                throw new InvalidDatatypeValueException("cvc-enumeration-valid", new Object[]{value, "(optional | required | prohibited)"});
            }
        }
        return retValue;
    }

    private String[] processNamespaceList(String value, XSDocumentInfo schemaDoc) throws InvalidDatatypeValueException {
        this.fNamespaceList.removeAllElements();
        StringTokenizer tokens = new StringTokenizer(value, " \n\t\r");
        try {
            while (tokens.hasMoreTokens()) {
                String tempNamespace;
                String token = tokens.nextToken();
                if (token.equals("##local")) {
                    tempNamespace = null;
                } else if (token.equals("##targetNamespace")) {
                    tempNamespace = schemaDoc.fTargetNamespace;
                } else {
                    fExtraDVs[0].validate(token, (ValidationContext)schemaDoc.fValidationContext, null);
                    tempNamespace = this.fSymbolTable.addSymbol(token);
                }
                if (this.fNamespaceList.contains(tempNamespace)) continue;
                this.fNamespaceList.addElement(tempNamespace);
            }
        }
        catch (InvalidDatatypeValueException ide) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.3", new Object[]{value, "((##any | ##other) | List of (anyURI | (##targetNamespace | ##local)) )"});
        }
        int num = this.fNamespaceList.size();
        Object[] list = new String[num];
        this.fNamespaceList.copyInto(list);
        return list;
    }

    void reportSchemaError(String key, Object[] args, Element ele) {
        this.fSchemaHandler.reportSchemaError(key, args, ele);
    }

    public void checkNonSchemaAttributes(XSGrammarBucket grammarBucket) {
        for (Map.Entry entry : this.fNonSchemaAttrs.entrySet()) {
            XSSimpleType dv;
            XSAttributeDecl attrDecl;
            String attrRName = (String)entry.getKey();
            String attrURI = attrRName.substring(0, attrRName.indexOf(44));
            String attrLocal = attrRName.substring(attrRName.indexOf(44) + 1);
            SchemaGrammar sGrammar = grammarBucket.getGrammar(attrURI);
            if (sGrammar == null || (attrDecl = sGrammar.getGlobalAttributeDecl(attrLocal)) == null || (dv = (XSSimpleType)attrDecl.getTypeDefinition()) == null) continue;
            Vector values = (Vector)entry.getValue();
            String attrName = (String)values.elementAt(0);
            int count = values.size();
            for (int i = 1; i < count; i += 2) {
                String elName = (String)values.elementAt(i);
                try {
                    dv.validate((String)values.elementAt(i + 1), null, null);
                    continue;
                }
                catch (InvalidDatatypeValueException ide) {
                    this.reportSchemaError("s4s-att-invalid-value", new Object[]{elName, attrName, ide.getMessage()}, null);
                }
            }
        }
    }

    public static String normalize(String content, short ws) {
        int len;
        int n = len = content == null ? 0 : content.length();
        if (len == 0 || ws == 0) {
            return content;
        }
        StringBuffer sb = new StringBuffer();
        if (ws == 1) {
            for (int i = 0; i < len; ++i) {
                char ch = content.charAt(i);
                if (ch != '\t' && ch != '\n' && ch != '\r') {
                    sb.append(ch);
                    continue;
                }
                sb.append(' ');
            }
        } else {
            boolean isLeading = true;
            for (int i = 0; i < len; ++i) {
                char ch = content.charAt(i);
                if (ch != '\t' && ch != '\n' && ch != '\r' && ch != ' ') {
                    sb.append(ch);
                    isLeading = false;
                    continue;
                }
                while (i < len - 1 && ((ch = content.charAt(i + 1)) == '\t' || ch == '\n' || ch == '\r' || ch == ' ')) {
                    ++i;
                }
                if (i >= len - 1 || isLeading) continue;
                sb.append(' ');
            }
        }
        return sb.toString();
    }

    protected Object[] getAvailableArray() {
        if (this.fArrayPool.length == this.fPoolPos) {
            this.fArrayPool = new Object[this.fPoolPos + 10][];
            for (int i = this.fPoolPos; i < this.fArrayPool.length; ++i) {
                this.fArrayPool[i] = new Object[ATTIDX_COUNT];
            }
        }
        Object[] retArray = this.fArrayPool[this.fPoolPos];
        this.fArrayPool[this.fPoolPos++] = null;
        System.arraycopy(fTempArray, 0, retArray, 0, ATTIDX_COUNT - 1);
        retArray[XSAttributeCheckerXerces.ATTIDX_ISRETURNED] = Boolean.FALSE;
        retArray[XSAttributeCheckerXerces.ATTIDX_XPATHDEFAULTNS_TWOPOUNDDFLT] = Boolean.FALSE;
        return retArray;
    }

    public void returnAttrArray(Object[] attrArray, XSDocumentInfo schemaDoc) {
        if (schemaDoc != null) {
            schemaDoc.fNamespaceSupport.popContext();
        }
        if (this.fPoolPos == 0 || attrArray == null || attrArray.length != ATTIDX_COUNT || ((Boolean)attrArray[ATTIDX_ISRETURNED]).booleanValue()) {
            return;
        }
        attrArray[XSAttributeCheckerXerces.ATTIDX_ISRETURNED] = Boolean.TRUE;
        if (attrArray[ATTIDX_NONSCHEMA] != null) {
            ((Vector)attrArray[ATTIDX_NONSCHEMA]).clear();
        }
        if (attrArray[ATTIDX_SUBSGROUP] != null) {
            ((Vector)attrArray[ATTIDX_SUBSGROUP]).clear();
        }
        if (attrArray[ATTIDX_NOTQNAME] != null) {
            ((Vector)attrArray[ATTIDX_NOTQNAME]).clear();
        }
        this.fArrayPool[--this.fPoolPos] = attrArray;
    }

    public void resolveNamespace(Element element, Attr[] attrs, SchemaNamespaceSupport nsSupport) {
        nsSupport.pushContext();
        int length = attrs.length;
        Attr sattr = null;
        for (int i = 0; i < length; ++i) {
            sattr = attrs[i];
            String rawname = DOMUtil.getName(sattr);
            String prefix = null;
            if (rawname.equals(XMLSymbols.PREFIX_XMLNS)) {
                prefix = XMLSymbols.EMPTY_STRING;
            } else if (rawname.startsWith("xmlns:")) {
                prefix = this.fSymbolTable.addSymbol(DOMUtil.getLocalName(sattr));
            }
            if (prefix == null) continue;
            String uri = this.fSymbolTable.addSymbol(DOMUtil.getValue(sattr));
            nsSupport.declarePrefix(prefix, uri.length() != 0 ? uri : null);
        }
    }

    static {
        SchemaGrammar grammar = SchemaGrammar.getS4SGrammar((short)1);
        XSAttributeCheckerXerces.fExtraDVs[0] = (XSSimpleType)grammar.getGlobalTypeDecl("anyURI");
        XSAttributeCheckerXerces.fExtraDVs[1] = (XSSimpleType)grammar.getGlobalTypeDecl("ID");
        XSAttributeCheckerXerces.fExtraDVs[2] = (XSSimpleType)grammar.getGlobalTypeDecl("QName");
        XSAttributeCheckerXerces.fExtraDVs[3] = (XSSimpleType)grammar.getGlobalTypeDecl("string");
        XSAttributeCheckerXerces.fExtraDVs[4] = (XSSimpleType)grammar.getGlobalTypeDecl("token");
        XSAttributeCheckerXerces.fExtraDVs[5] = (XSSimpleType)grammar.getGlobalTypeDecl("NCName");
        XSAttributeCheckerXerces.fExtraDVs[6] = fExtraDVs[3];
        XSAttributeCheckerXerces.fExtraDVs[6] = fExtraDVs[3];
        XSAttributeCheckerXerces.fExtraDVs[8] = (XSSimpleType)grammar.getGlobalTypeDecl("language");
        int attCount = 0;
        int ATT_ABSTRACT_D = attCount++;
        int ATT_ATTRIBUTE_FD_D = attCount++;
        int ATT_BASE_R = attCount++;
        int ATT_BASE_N = attCount++;
        int ATT_BLOCK_N = attCount++;
        int ATT_BLOCK1_N = attCount++;
        int ATT_BLOCK_D_D = attCount++;
        int ATT_DEFAULT_N = attCount++;
        int ATT_ELEMENT_FD_D = attCount++;
        int ATT_FINAL_N = attCount++;
        int ATT_FINAL1_N = attCount++;
        int ATT_FINAL_D_D = attCount++;
        int ATT_FIXED_N = attCount++;
        int ATT_FIXED_D = attCount++;
        int ATT_FORM_N = attCount++;
        int ATT_ID_N = attCount++;
        int ATT_ITEMTYPE_N = attCount++;
        int ATT_MAXOCCURS_D = attCount++;
        int ATT_MAXOCCURS1_D = attCount++;
        int ATT_MEMBER_T_N = attCount++;
        int ATT_MINOCCURS_D = attCount++;
        int ATT_MINOCCURS1_D = attCount++;
        int ATT_MIXED_D = attCount++;
        int ATT_MIXED_N = attCount++;
        int ATT_NAME_R = attCount++;
        int ATT_NAMESPACE_D = attCount++;
        int ATT_NAMESPACE_N = attCount++;
        int ATT_NILLABLE_D = attCount++;
        int ATT_PROCESS_C_D = attCount++;
        int ATT_PUBLIC_R = attCount++;
        int ATT_REF_R = attCount++;
        int ATT_REFER_R = attCount++;
        int ATT_SCHEMA_L_R = attCount++;
        int ATT_SCHEMA_L_N = attCount++;
        int ATT_SOURCE_N = attCount++;
        int ATT_SUBSTITUTION_G_N = attCount++;
        int ATT_SYSTEM_N = attCount++;
        int ATT_TARGET_N_N = attCount++;
        int ATT_TYPE_N = attCount++;
        int ATT_USE_D = attCount++;
        int ATT_VALUE_NNI_N = attCount++;
        int ATT_VALUE_PI_N = attCount++;
        int ATT_VALUE_STR_N = attCount++;
        int ATT_VALUE_WS_N = attCount++;
        int ATT_VERSION_N = attCount++;
        int ATT_XML_LANG = attCount++;
        int ATT_XPATH_R = attCount++;
        int ATT_XPATH1_R = attCount++;
        int ATT_VALUE_INT = attCount++;
        int ATT_APPLIESTO_EMPTY_D = attCount++;
        int ATT_DEFAULT_ATTRIBUTES_N = attCount++;
        int ATT_DEFAULT_ATTR_APPLY_D = attCount++;
        int ATT_DEFAULT_XPATH_NS_N = attCount++;
        int ATT_MODE_D = attCount++;
        int ATT_MODE1_D = attCount++;
        int ATT_NAMESPACE1_N = attCount++;
        int ATT_NOTNAMESPACE_N = attCount++;
        int ATT_NOTQNAME_N = attCount++;
        int ATT_TEST_XPATH_R = attCount++;
        int ATT_INHERITABLE_N = attCount++;
        int ATT_VALUE_ET_N = attCount++;
        OneAttr[] allAttrs = new OneAttr[attCount];
        allAttrs[ATT_ABSTRACT_D] = new OneAttr(SchemaSymbols.ATT_ABSTRACT, -15, ATTIDX_ABSTRACT, Boolean.FALSE);
        allAttrs[ATT_ATTRIBUTE_FD_D] = new OneAttr(SchemaSymbols.ATT_ATTRIBUTEFORMDEFAULT, -6, ATTIDX_AFORMDEFAULT, INT_UNQUALIFIED);
        allAttrs[ATT_BASE_R] = new OneAttr(SchemaSymbols.ATT_BASE, 2, ATTIDX_BASE, null);
        allAttrs[ATT_BASE_N] = new OneAttr(SchemaSymbols.ATT_BASE, 2, ATTIDX_BASE, null);
        allAttrs[ATT_BLOCK_N] = new OneAttr(SchemaSymbols.ATT_BLOCK, -1, ATTIDX_BLOCK, null);
        allAttrs[ATT_BLOCK1_N] = new OneAttr(SchemaSymbols.ATT_BLOCK, -2, ATTIDX_BLOCK, null);
        allAttrs[ATT_BLOCK_D_D] = new OneAttr(SchemaSymbols.ATT_BLOCKDEFAULT, -1, ATTIDX_BLOCKDEFAULT, INT_EMPTY_SET);
        allAttrs[ATT_DEFAULT_N] = new OneAttr(SchemaSymbols.ATT_DEFAULT, 3, ATTIDX_DEFAULT, null);
        allAttrs[ATT_ELEMENT_FD_D] = new OneAttr(SchemaSymbols.ATT_ELEMENTFORMDEFAULT, -6, ATTIDX_EFORMDEFAULT, INT_UNQUALIFIED);
        allAttrs[ATT_FINAL_N] = new OneAttr(SchemaSymbols.ATT_FINAL, -3, ATTIDX_FINAL, null);
        allAttrs[ATT_FINAL1_N] = new OneAttr(SchemaSymbols.ATT_FINAL, -4, ATTIDX_FINAL, null);
        allAttrs[ATT_FINAL_D_D] = new OneAttr(SchemaSymbols.ATT_FINALDEFAULT, -5, ATTIDX_FINALDEFAULT, INT_EMPTY_SET);
        allAttrs[ATT_FIXED_N] = new OneAttr(SchemaSymbols.ATT_FIXED, 3, ATTIDX_FIXED, null);
        allAttrs[ATT_FIXED_D] = new OneAttr(SchemaSymbols.ATT_FIXED, -15, ATTIDX_FIXED, Boolean.FALSE);
        allAttrs[ATT_FORM_N] = new OneAttr(SchemaSymbols.ATT_FORM, -6, ATTIDX_FORM, null);
        allAttrs[ATT_ID_N] = new OneAttr(SchemaSymbols.ATT_ID, 1, ATTIDX_ID, null);
        allAttrs[ATT_ITEMTYPE_N] = new OneAttr(SchemaSymbols.ATT_ITEMTYPE, 2, ATTIDX_ITEMTYPE, null);
        allAttrs[ATT_MAXOCCURS_D] = new OneAttr(SchemaSymbols.ATT_MAXOCCURS, -7, ATTIDX_MAXOCCURS, fXIntPool.getXInt(1));
        allAttrs[ATT_MAXOCCURS1_D] = new OneAttr(SchemaSymbols.ATT_MAXOCCURS, -8, ATTIDX_MAXOCCURS, fXIntPool.getXInt(1));
        allAttrs[ATT_MEMBER_T_N] = new OneAttr(SchemaSymbols.ATT_MEMBERTYPES, -9, ATTIDX_MEMBERTYPES, null);
        allAttrs[ATT_MINOCCURS_D] = new OneAttr(SchemaSymbols.ATT_MINOCCURS, -16, ATTIDX_MINOCCURS, fXIntPool.getXInt(1));
        allAttrs[ATT_MINOCCURS1_D] = new OneAttr(SchemaSymbols.ATT_MINOCCURS, -10, ATTIDX_MINOCCURS, fXIntPool.getXInt(1));
        allAttrs[ATT_MIXED_D] = new OneAttr(SchemaSymbols.ATT_MIXED, -15, ATTIDX_MIXED, Boolean.FALSE);
        allAttrs[ATT_MIXED_N] = new OneAttr(SchemaSymbols.ATT_MIXED, -15, ATTIDX_MIXED, null);
        allAttrs[ATT_NAME_R] = new OneAttr(SchemaSymbols.ATT_NAME, 5, ATTIDX_NAME, null);
        allAttrs[ATT_NAMESPACE_D] = new OneAttr(SchemaSymbols.ATT_NAMESPACE, -11, ATTIDX_NAMESPACE, INT_ANY_ANY);
        allAttrs[ATT_NAMESPACE_N] = new OneAttr(SchemaSymbols.ATT_NAMESPACE, 0, ATTIDX_NAMESPACE, null);
        allAttrs[ATT_NILLABLE_D] = new OneAttr(SchemaSymbols.ATT_NILLABLE, -15, ATTIDX_NILLABLE, Boolean.FALSE);
        allAttrs[ATT_PROCESS_C_D] = new OneAttr(SchemaSymbols.ATT_PROCESSCONTENTS, -12, ATTIDX_PROCESSCONTENTS, INT_ANY_STRICT);
        allAttrs[ATT_PUBLIC_R] = new OneAttr(SchemaSymbols.ATT_PUBLIC, 4, ATTIDX_PUBLIC, null);
        allAttrs[ATT_REF_R] = new OneAttr(SchemaSymbols.ATT_REF, 2, ATTIDX_REF, null);
        allAttrs[ATT_REFER_R] = new OneAttr(SchemaSymbols.ATT_REFER, 2, ATTIDX_REFER, null);
        allAttrs[ATT_SCHEMA_L_R] = new OneAttr(SchemaSymbols.ATT_SCHEMALOCATION, 0, ATTIDX_SCHEMALOCATION, null);
        allAttrs[ATT_SCHEMA_L_N] = new OneAttr(SchemaSymbols.ATT_SCHEMALOCATION, 0, ATTIDX_SCHEMALOCATION, null);
        allAttrs[ATT_SOURCE_N] = new OneAttr(SchemaSymbols.ATT_SOURCE, 0, ATTIDX_SOURCE, null);
        allAttrs[ATT_SUBSTITUTION_G_N] = new OneAttr(SchemaSymbols.ATT_SUBSTITUTIONGROUP, 2, ATTIDX_SUBSGROUP, null);
        allAttrs[ATT_SYSTEM_N] = new OneAttr(SchemaSymbols.ATT_SYSTEM, 0, ATTIDX_SYSTEM, null);
        allAttrs[ATT_TARGET_N_N] = new OneAttr(SchemaSymbols.ATT_TARGETNAMESPACE, 0, ATTIDX_TARGETNAMESPACE, null);
        allAttrs[ATT_TYPE_N] = new OneAttr(SchemaSymbols.ATT_TYPE, 2, ATTIDX_TYPE, null);
        allAttrs[ATT_USE_D] = new OneAttr(SchemaSymbols.ATT_USE, -13, ATTIDX_USE, INT_USE_OPTIONAL);
        allAttrs[ATT_VALUE_NNI_N] = new OneAttr(SchemaSymbols.ATT_VALUE, -16, ATTIDX_VALUE, null);
        allAttrs[ATT_VALUE_PI_N] = new OneAttr(SchemaSymbols.ATT_VALUE, -17, ATTIDX_VALUE, null);
        allAttrs[ATT_VALUE_STR_N] = new OneAttr(SchemaSymbols.ATT_VALUE, 3, ATTIDX_VALUE, null);
        allAttrs[ATT_VALUE_WS_N] = new OneAttr(SchemaSymbols.ATT_VALUE, -14, ATTIDX_VALUE, null);
        allAttrs[ATT_VERSION_N] = new OneAttr(SchemaSymbols.ATT_VERSION, 4, ATTIDX_VERSION, null);
        allAttrs[ATT_XML_LANG] = new OneAttr(SchemaSymbols.ATT_XML_LANG, 8, ATTIDX_XML_LANG, null);
        allAttrs[ATT_XPATH_R] = new OneAttr(SchemaSymbols.ATT_XPATH, 6, ATTIDX_XPATH, null);
        allAttrs[ATT_XPATH1_R] = new OneAttr(SchemaSymbols.ATT_XPATH, 7, ATTIDX_XPATH, null);
        allAttrs[ATT_VALUE_INT] = new OneAttr(SchemaSymbols.ATT_VALUE, -23, ATTIDX_VALUE, null);
        allAttrs[ATT_APPLIESTO_EMPTY_D] = new OneAttr(SchemaSymbols.ATT_APPLIESTOEMPTY, -15, ATTIDX_APPLIESTOEMPTY, Boolean.FALSE);
        allAttrs[ATT_DEFAULT_ATTRIBUTES_N] = new OneAttr(SchemaSymbols.ATT_DEFAULTATTRIBUTES, 2, ATTIDX_DEFAULTATTRIBUTES, null);
        allAttrs[ATT_DEFAULT_ATTR_APPLY_D] = new OneAttr(SchemaSymbols.ATT_DEFAULTATTRIBUTESAPPLY, -15, ATTIDX_DEFAULTATTRAPPLY, Boolean.TRUE);
        allAttrs[ATT_DEFAULT_XPATH_NS_N] = new OneAttr(SchemaSymbols.ATT_XPATH_DEFAULT_NS, -18, ATTIDX_XPATHDEFAULTNS, null);
        allAttrs[ATT_MODE_D] = new OneAttr(SchemaSymbols.ATT_MODE, -19, ATTIDX_MODE, INT_MODE_INTERLEAVE);
        allAttrs[ATT_MODE1_D] = new OneAttr(SchemaSymbols.ATT_MODE, -20, ATTIDX_MODE, INT_MODE_INTERLEAVE);
        allAttrs[ATT_NAMESPACE1_N] = new OneAttr(SchemaSymbols.ATT_NAMESPACE, -11, ATTIDX_NAMESPACE, null);
        allAttrs[ATT_NOTNAMESPACE_N] = new OneAttr(SchemaSymbols.ATT_NAMESPACE, -21, ATTIDX_NOTNAMESPACE, null);
        allAttrs[ATT_NOTQNAME_N] = new OneAttr(SchemaSymbols.ATT_NOTQNAME, -22, ATTIDX_NOTQNAME, null);
        allAttrs[ATT_TEST_XPATH_R] = new OneAttr(SchemaSymbols.ATT_TEST, 7, ATTIDX_XPATH, null);
        allAttrs[ATT_INHERITABLE_N] = new OneAttr(SchemaSymbols.ATT_INHERITABLE, -15, ATTIDX_INHERITABLE, Boolean.FALSE);
        allAttrs[ATT_VALUE_ET_N] = new OneAttr(SchemaSymbols.ATT_VALUE, -24, ATTIDX_VALUE, null);
        Container attrList = Container.getContainer(5);
        attrList.put(SchemaSymbols.ATT_DEFAULT, allAttrs[ATT_DEFAULT_N]);
        attrList.put(SchemaSymbols.ATT_FIXED, allAttrs[ATT_FIXED_N]);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_NAME, allAttrs[ATT_NAME_R]);
        attrList.put(SchemaSymbols.ATT_TYPE, allAttrs[ATT_TYPE_N]);
        fEleAttrsMapG.put(SchemaSymbols.ELT_ATTRIBUTE, attrList);
        attrList = Container.getContainer(6);
        attrList.put(SchemaSymbols.ATT_DEFAULT, allAttrs[ATT_DEFAULT_N]);
        attrList.put(SchemaSymbols.ATT_FIXED, allAttrs[ATT_FIXED_N]);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_NAME, allAttrs[ATT_NAME_R]);
        attrList.put(SchemaSymbols.ATT_TYPE, allAttrs[ATT_TYPE_N]);
        attrList.put(SchemaSymbols.ATT_INHERITABLE, allAttrs[ATT_INHERITABLE_N]);
        fEleAttrs11MapG.put(SchemaSymbols.ELT_ATTRIBUTE, attrList);
        attrList = Container.getContainer(7);
        attrList.put(SchemaSymbols.ATT_DEFAULT, allAttrs[ATT_DEFAULT_N]);
        attrList.put(SchemaSymbols.ATT_FIXED, allAttrs[ATT_FIXED_N]);
        attrList.put(SchemaSymbols.ATT_FORM, allAttrs[ATT_FORM_N]);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_NAME, allAttrs[ATT_NAME_R]);
        attrList.put(SchemaSymbols.ATT_TYPE, allAttrs[ATT_TYPE_N]);
        attrList.put(SchemaSymbols.ATT_USE, allAttrs[ATT_USE_D]);
        fEleAttrsMapL.put(ATTRIBUTE_N, attrList);
        attrList = Container.getContainer(5);
        attrList.put(SchemaSymbols.ATT_DEFAULT, allAttrs[ATT_DEFAULT_N]);
        attrList.put(SchemaSymbols.ATT_FIXED, allAttrs[ATT_FIXED_N]);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_REF, allAttrs[ATT_REF_R]);
        attrList.put(SchemaSymbols.ATT_USE, allAttrs[ATT_USE_D]);
        fEleAttrsMapL.put(ATTRIBUTE_R, attrList);
        attrList = Container.getContainer(6);
        attrList.put(SchemaSymbols.ATT_DEFAULT, allAttrs[ATT_DEFAULT_N]);
        attrList.put(SchemaSymbols.ATT_FIXED, allAttrs[ATT_FIXED_N]);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_REF, allAttrs[ATT_REF_R]);
        attrList.put(SchemaSymbols.ATT_USE, allAttrs[ATT_USE_D]);
        attrList.put(SchemaSymbols.ATT_INHERITABLE, allAttrs[ATT_INHERITABLE_N]);
        fEleAttrs11MapL.put(ATTRIBUTE_R, attrList);
        attrList = Container.getContainer(10);
        attrList.put(SchemaSymbols.ATT_ABSTRACT, allAttrs[ATT_ABSTRACT_D]);
        attrList.put(SchemaSymbols.ATT_BLOCK, allAttrs[ATT_BLOCK_N]);
        attrList.put(SchemaSymbols.ATT_DEFAULT, allAttrs[ATT_DEFAULT_N]);
        attrList.put(SchemaSymbols.ATT_FINAL, allAttrs[ATT_FINAL_N]);
        attrList.put(SchemaSymbols.ATT_FIXED, allAttrs[ATT_FIXED_N]);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_NAME, allAttrs[ATT_NAME_R]);
        attrList.put(SchemaSymbols.ATT_NILLABLE, allAttrs[ATT_NILLABLE_D]);
        attrList.put(SchemaSymbols.ATT_SUBSTITUTIONGROUP, allAttrs[ATT_SUBSTITUTION_G_N]);
        attrList.put(SchemaSymbols.ATT_TYPE, allAttrs[ATT_TYPE_N]);
        fEleAttrsMapG.put(SchemaSymbols.ELT_ELEMENT, attrList);
        fEleAttrs11MapG.put(SchemaSymbols.ELT_ELEMENT, attrList);
        attrList = Container.getContainer(10);
        attrList.put(SchemaSymbols.ATT_BLOCK, allAttrs[ATT_BLOCK_N]);
        attrList.put(SchemaSymbols.ATT_DEFAULT, allAttrs[ATT_DEFAULT_N]);
        attrList.put(SchemaSymbols.ATT_FIXED, allAttrs[ATT_FIXED_N]);
        attrList.put(SchemaSymbols.ATT_FORM, allAttrs[ATT_FORM_N]);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_MAXOCCURS, allAttrs[ATT_MAXOCCURS_D]);
        attrList.put(SchemaSymbols.ATT_MINOCCURS, allAttrs[ATT_MINOCCURS_D]);
        attrList.put(SchemaSymbols.ATT_NAME, allAttrs[ATT_NAME_R]);
        attrList.put(SchemaSymbols.ATT_NILLABLE, allAttrs[ATT_NILLABLE_D]);
        attrList.put(SchemaSymbols.ATT_TYPE, allAttrs[ATT_TYPE_N]);
        fEleAttrsMapL.put(ELEMENT_N, attrList);
        attrList = Container.getContainer(4);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_MAXOCCURS, allAttrs[ATT_MAXOCCURS_D]);
        attrList.put(SchemaSymbols.ATT_MINOCCURS, allAttrs[ATT_MINOCCURS_D]);
        attrList.put(SchemaSymbols.ATT_REF, allAttrs[ATT_REF_R]);
        fEleAttrsMapL.put(ELEMENT_R, attrList);
        fEleAttrs11MapL.put(ELEMENT_R, attrList);
        attrList = Container.getContainer(6);
        attrList.put(SchemaSymbols.ATT_ABSTRACT, allAttrs[ATT_ABSTRACT_D]);
        attrList.put(SchemaSymbols.ATT_BLOCK, allAttrs[ATT_BLOCK1_N]);
        attrList.put(SchemaSymbols.ATT_FINAL, allAttrs[ATT_FINAL_N]);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_MIXED, allAttrs[ATT_MIXED_D]);
        attrList.put(SchemaSymbols.ATT_NAME, allAttrs[ATT_NAME_R]);
        fEleAttrsMapG.put(SchemaSymbols.ELT_COMPLEXTYPE, attrList);
        attrList = Container.getContainer(4);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_NAME, allAttrs[ATT_NAME_R]);
        attrList.put(SchemaSymbols.ATT_PUBLIC, allAttrs[ATT_PUBLIC_R]);
        attrList.put(SchemaSymbols.ATT_SYSTEM, allAttrs[ATT_SYSTEM_N]);
        fEleAttrsMapG.put(SchemaSymbols.ELT_NOTATION, attrList);
        fEleAttrs11MapG.put(SchemaSymbols.ELT_NOTATION, attrList);
        attrList = Container.getContainer(2);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_MIXED, allAttrs[ATT_MIXED_D]);
        fEleAttrsMapL.put(SchemaSymbols.ELT_COMPLEXTYPE, attrList);
        attrList = Container.getContainer(1);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        fEleAttrsMapL.put(SchemaSymbols.ELT_SIMPLECONTENT, attrList);
        fEleAttrs11MapL.put(SchemaSymbols.ELT_SIMPLECONTENT, attrList);
        attrList = Container.getContainer(2);
        attrList.put(SchemaSymbols.ATT_BASE, allAttrs[ATT_BASE_N]);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        fEleAttrsMapL.put(SchemaSymbols.ELT_RESTRICTION, attrList);
        fEleAttrs11MapL.put(SchemaSymbols.ELT_RESTRICTION, attrList);
        attrList = Container.getContainer(2);
        attrList.put(SchemaSymbols.ATT_BASE, allAttrs[ATT_BASE_R]);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        fEleAttrsMapL.put(SchemaSymbols.ELT_EXTENSION, attrList);
        fEleAttrs11MapL.put(SchemaSymbols.ELT_EXTENSION, attrList);
        attrList = Container.getContainer(2);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_REF, allAttrs[ATT_REF_R]);
        fEleAttrsMapL.put(SchemaSymbols.ELT_ATTRIBUTEGROUP, attrList);
        fEleAttrs11MapL.put(SchemaSymbols.ELT_ATTRIBUTEGROUP, attrList);
        attrList = Container.getContainer(3);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_NAMESPACE, allAttrs[ATT_NAMESPACE_D]);
        attrList.put(SchemaSymbols.ATT_PROCESSCONTENTS, allAttrs[ATT_PROCESS_C_D]);
        fEleAttrsMapL.put(SchemaSymbols.ELT_ANYATTRIBUTE, attrList);
        attrList = Container.getContainer(2);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_MIXED, allAttrs[ATT_MIXED_N]);
        fEleAttrsMapL.put(SchemaSymbols.ELT_COMPLEXCONTENT, attrList);
        fEleAttrs11MapL.put(SchemaSymbols.ELT_COMPLEXCONTENT, attrList);
        attrList = Container.getContainer(2);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_NAME, allAttrs[ATT_NAME_R]);
        fEleAttrsMapG.put(SchemaSymbols.ELT_ATTRIBUTEGROUP, attrList);
        fEleAttrs11MapG.put(SchemaSymbols.ELT_ATTRIBUTEGROUP, attrList);
        attrList = Container.getContainer(2);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_NAME, allAttrs[ATT_NAME_R]);
        fEleAttrsMapG.put(SchemaSymbols.ELT_GROUP, attrList);
        fEleAttrs11MapG.put(SchemaSymbols.ELT_GROUP, attrList);
        attrList = Container.getContainer(4);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_MAXOCCURS, allAttrs[ATT_MAXOCCURS_D]);
        attrList.put(SchemaSymbols.ATT_MINOCCURS, allAttrs[ATT_MINOCCURS_D]);
        attrList.put(SchemaSymbols.ATT_REF, allAttrs[ATT_REF_R]);
        fEleAttrsMapL.put(SchemaSymbols.ELT_GROUP, attrList);
        fEleAttrs11MapL.put(SchemaSymbols.ELT_GROUP, attrList);
        attrList = Container.getContainer(3);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_MAXOCCURS, allAttrs[ATT_MAXOCCURS1_D]);
        attrList.put(SchemaSymbols.ATT_MINOCCURS, allAttrs[ATT_MINOCCURS1_D]);
        fEleAttrsMapL.put(SchemaSymbols.ELT_ALL, attrList);
        fEleAttrs11MapL.put(SchemaSymbols.ELT_ALL, attrList);
        attrList = Container.getContainer(3);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_MAXOCCURS, allAttrs[ATT_MAXOCCURS_D]);
        attrList.put(SchemaSymbols.ATT_MINOCCURS, allAttrs[ATT_MINOCCURS_D]);
        fEleAttrsMapL.put(SchemaSymbols.ELT_CHOICE, attrList);
        fEleAttrsMapL.put(SchemaSymbols.ELT_SEQUENCE, attrList);
        fEleAttrs11MapL.put(SchemaSymbols.ELT_CHOICE, attrList);
        fEleAttrs11MapL.put(SchemaSymbols.ELT_SEQUENCE, attrList);
        attrList = Container.getContainer(5);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_MAXOCCURS, allAttrs[ATT_MAXOCCURS_D]);
        attrList.put(SchemaSymbols.ATT_MINOCCURS, allAttrs[ATT_MINOCCURS_D]);
        attrList.put(SchemaSymbols.ATT_NAMESPACE, allAttrs[ATT_NAMESPACE_D]);
        attrList.put(SchemaSymbols.ATT_PROCESSCONTENTS, allAttrs[ATT_PROCESS_C_D]);
        fEleAttrsMapL.put(SchemaSymbols.ELT_ANY, attrList);
        attrList = Container.getContainer(2);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_NAME, allAttrs[ATT_NAME_R]);
        fEleAttrsMapL.put(SchemaSymbols.ELT_UNIQUE, attrList);
        fEleAttrsMapL.put(SchemaSymbols.ELT_KEY, attrList);
        fEleAttrs11MapL.put(SchemaSymbols.ELT_UNIQUE, attrList);
        fEleAttrs11MapL.put(SchemaSymbols.ELT_KEY, attrList);
        attrList = Container.getContainer(2);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_REF, allAttrs[ATT_REF_R]);
        fEleAttrs11MapL.put(UNIQUE_R, attrList);
        fEleAttrs11MapL.put(KEY_R, attrList);
        fEleAttrs11MapL.put(KEYREF_R, attrList);
        attrList = Container.getContainer(3);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_NAME, allAttrs[ATT_NAME_R]);
        attrList.put(SchemaSymbols.ATT_REFER, allAttrs[ATT_REFER_R]);
        fEleAttrsMapL.put(SchemaSymbols.ELT_KEYREF, attrList);
        fEleAttrs11MapL.put(SchemaSymbols.ELT_KEYREF, attrList);
        attrList = Container.getContainer(2);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_REF, allAttrs[ATT_REF_R]);
        fEleAttrs11MapL.put(UNIQUE_R, attrList);
        fEleAttrs11MapL.put(KEY_R, attrList);
        fEleAttrs11MapL.put(KEYREF_R, attrList);
        attrList = Container.getContainer(2);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_XPATH, allAttrs[ATT_XPATH_R]);
        fEleAttrsMapL.put(SchemaSymbols.ELT_SELECTOR, attrList);
        attrList = Container.getContainer(2);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_XPATH, allAttrs[ATT_XPATH1_R]);
        fEleAttrsMapL.put(SchemaSymbols.ELT_FIELD, attrList);
        attrList = Container.getContainer(1);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        fEleAttrsMapG.put(SchemaSymbols.ELT_ANNOTATION, attrList);
        fEleAttrsMapL.put(SchemaSymbols.ELT_ANNOTATION, attrList);
        fEleAttrs11MapG.put(SchemaSymbols.ELT_ANNOTATION, attrList);
        fEleAttrs11MapL.put(SchemaSymbols.ELT_ANNOTATION, attrList);
        attrList = Container.getContainer(1);
        attrList.put(SchemaSymbols.ATT_SOURCE, allAttrs[ATT_SOURCE_N]);
        fEleAttrsMapG.put(SchemaSymbols.ELT_APPINFO, attrList);
        fEleAttrsMapL.put(SchemaSymbols.ELT_APPINFO, attrList);
        fEleAttrs11MapG.put(SchemaSymbols.ELT_APPINFO, attrList);
        fEleAttrs11MapL.put(SchemaSymbols.ELT_APPINFO, attrList);
        attrList = Container.getContainer(2);
        attrList.put(SchemaSymbols.ATT_SOURCE, allAttrs[ATT_SOURCE_N]);
        attrList.put(SchemaSymbols.ATT_XML_LANG, allAttrs[ATT_XML_LANG]);
        fEleAttrsMapG.put(SchemaSymbols.ELT_DOCUMENTATION, attrList);
        fEleAttrsMapL.put(SchemaSymbols.ELT_DOCUMENTATION, attrList);
        fEleAttrs11MapG.put(SchemaSymbols.ELT_DOCUMENTATION, attrList);
        fEleAttrs11MapL.put(SchemaSymbols.ELT_DOCUMENTATION, attrList);
        attrList = Container.getContainer(3);
        attrList.put(SchemaSymbols.ATT_FINAL, allAttrs[ATT_FINAL1_N]);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_NAME, allAttrs[ATT_NAME_R]);
        fEleAttrsMapG.put(SchemaSymbols.ELT_SIMPLETYPE, attrList);
        fEleAttrs11MapG.put(SchemaSymbols.ELT_SIMPLETYPE, attrList);
        attrList = Container.getContainer(2);
        attrList.put(SchemaSymbols.ATT_FINAL, allAttrs[ATT_FINAL1_N]);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        fEleAttrsMapL.put(SchemaSymbols.ELT_SIMPLETYPE, attrList);
        fEleAttrs11MapL.put(SchemaSymbols.ELT_SIMPLETYPE, attrList);
        attrList = Container.getContainer(2);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_ITEMTYPE, allAttrs[ATT_ITEMTYPE_N]);
        fEleAttrsMapL.put(SchemaSymbols.ELT_LIST, attrList);
        fEleAttrs11MapL.put(SchemaSymbols.ELT_LIST, attrList);
        attrList = Container.getContainer(2);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_MEMBERTYPES, allAttrs[ATT_MEMBER_T_N]);
        fEleAttrsMapL.put(SchemaSymbols.ELT_UNION, attrList);
        fEleAttrs11MapL.put(SchemaSymbols.ELT_UNION, attrList);
        attrList = Container.getContainer(8);
        attrList.put(SchemaSymbols.ATT_ATTRIBUTEFORMDEFAULT, allAttrs[ATT_ATTRIBUTE_FD_D]);
        attrList.put(SchemaSymbols.ATT_BLOCKDEFAULT, allAttrs[ATT_BLOCK_D_D]);
        attrList.put(SchemaSymbols.ATT_ELEMENTFORMDEFAULT, allAttrs[ATT_ELEMENT_FD_D]);
        attrList.put(SchemaSymbols.ATT_FINALDEFAULT, allAttrs[ATT_FINAL_D_D]);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_TARGETNAMESPACE, allAttrs[ATT_TARGET_N_N]);
        attrList.put(SchemaSymbols.ATT_VERSION, allAttrs[ATT_VERSION_N]);
        attrList.put(SchemaSymbols.ATT_XML_LANG, allAttrs[ATT_XML_LANG]);
        fEleAttrsMapG.put(SchemaSymbols.ELT_SCHEMA, attrList);
        attrList = Container.getContainer(2);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_SCHEMALOCATION, allAttrs[ATT_SCHEMA_L_R]);
        fEleAttrsMapG.put(SchemaSymbols.ELT_INCLUDE, attrList);
        fEleAttrsMapG.put(SchemaSymbols.ELT_REDEFINE, attrList);
        fEleAttrs11MapG.put(SchemaSymbols.ELT_INCLUDE, attrList);
        fEleAttrs11MapG.put(SchemaSymbols.ELT_REDEFINE, attrList);
        fEleAttrs11MapG.put(SchemaSymbols.ELT_OVERRIDE, attrList);
        attrList = Container.getContainer(3);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_NAMESPACE, allAttrs[ATT_NAMESPACE_N]);
        attrList.put(SchemaSymbols.ATT_SCHEMALOCATION, allAttrs[ATT_SCHEMA_L_N]);
        fEleAttrsMapG.put(SchemaSymbols.ELT_IMPORT, attrList);
        fEleAttrs11MapG.put(SchemaSymbols.ELT_IMPORT, attrList);
        attrList = Container.getContainer(3);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_VALUE, allAttrs[ATT_VALUE_NNI_N]);
        attrList.put(SchemaSymbols.ATT_FIXED, allAttrs[ATT_FIXED_D]);
        fEleAttrsMapL.put(SchemaSymbols.ELT_LENGTH, attrList);
        fEleAttrsMapL.put(SchemaSymbols.ELT_MINLENGTH, attrList);
        fEleAttrsMapL.put(SchemaSymbols.ELT_MAXLENGTH, attrList);
        fEleAttrsMapL.put(SchemaSymbols.ELT_FRACTIONDIGITS, attrList);
        fEleAttrs11MapL.put(SchemaSymbols.ELT_LENGTH, attrList);
        fEleAttrs11MapL.put(SchemaSymbols.ELT_MINLENGTH, attrList);
        fEleAttrs11MapL.put(SchemaSymbols.ELT_MAXLENGTH, attrList);
        fEleAttrs11MapL.put(SchemaSymbols.ELT_FRACTIONDIGITS, attrList);
        attrList = Container.getContainer(3);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_VALUE, allAttrs[ATT_VALUE_PI_N]);
        attrList.put(SchemaSymbols.ATT_FIXED, allAttrs[ATT_FIXED_D]);
        fEleAttrsMapL.put(SchemaSymbols.ELT_TOTALDIGITS, attrList);
        fEleAttrs11MapL.put(SchemaSymbols.ELT_TOTALDIGITS, attrList);
        attrList = Container.getContainer(2);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_VALUE, allAttrs[ATT_VALUE_STR_N]);
        fEleAttrsMapL.put(SchemaSymbols.ELT_PATTERN, attrList);
        fEleAttrs11MapL.put(SchemaSymbols.ELT_PATTERN, attrList);
        attrList = Container.getContainer(2);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_VALUE, allAttrs[ATT_VALUE_STR_N]);
        fEleAttrsMapL.put(SchemaSymbols.ELT_ENUMERATION, attrList);
        fEleAttrs11MapL.put(SchemaSymbols.ELT_ENUMERATION, attrList);
        attrList = Container.getContainer(3);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_VALUE, allAttrs[ATT_VALUE_WS_N]);
        attrList.put(SchemaSymbols.ATT_FIXED, allAttrs[ATT_FIXED_D]);
        fEleAttrsMapL.put(SchemaSymbols.ELT_WHITESPACE, attrList);
        fEleAttrs11MapL.put(SchemaSymbols.ELT_WHITESPACE, attrList);
        attrList = Container.getContainer(3);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_VALUE, allAttrs[ATT_VALUE_STR_N]);
        attrList.put(SchemaSymbols.ATT_FIXED, allAttrs[ATT_FIXED_D]);
        fEleAttrsMapL.put(SchemaSymbols.ELT_MAXINCLUSIVE, attrList);
        fEleAttrsMapL.put(SchemaSymbols.ELT_MAXEXCLUSIVE, attrList);
        fEleAttrsMapL.put(SchemaSymbols.ELT_MININCLUSIVE, attrList);
        fEleAttrsMapL.put(SchemaSymbols.ELT_MINEXCLUSIVE, attrList);
        fEleAttrs11MapL.put(SchemaSymbols.ELT_MAXINCLUSIVE, attrList);
        fEleAttrs11MapL.put(SchemaSymbols.ELT_MAXEXCLUSIVE, attrList);
        fEleAttrs11MapL.put(SchemaSymbols.ELT_MININCLUSIVE, attrList);
        fEleAttrs11MapL.put(SchemaSymbols.ELT_MINEXCLUSIVE, attrList);
        attrList = Container.getContainer(3);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_VALUE, allAttrs[ATT_VALUE_INT]);
        attrList.put(SchemaSymbols.ATT_FIXED, allAttrs[ATT_FIXED_D]);
        fEleAttrs11MapL.put(SchemaSymbols.ELT_MAXSCALE, attrList);
        fEleAttrs11MapL.put(SchemaSymbols.ELT_MINSCALE, attrList);
        attrList = Container.getContainer(3);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_VALUE, allAttrs[ATT_VALUE_ET_N]);
        attrList.put(SchemaSymbols.ATT_FIXED, allAttrs[ATT_FIXED_D]);
        fEleAttrs11MapL.put(SchemaSymbols.ELT_EXPLICITTIMEZONE, attrList);
        attrList = Container.getContainer(10);
        attrList.put(SchemaSymbols.ATT_ATTRIBUTEFORMDEFAULT, allAttrs[ATT_ATTRIBUTE_FD_D]);
        attrList.put(SchemaSymbols.ATT_DEFAULTATTRIBUTES, allAttrs[ATT_DEFAULT_ATTRIBUTES_N]);
        attrList.put(SchemaSymbols.ATT_BLOCKDEFAULT, allAttrs[ATT_BLOCK_D_D]);
        attrList.put(SchemaSymbols.ATT_XPATH_DEFAULT_NS, allAttrs[ATT_DEFAULT_XPATH_NS_N]);
        attrList.put(SchemaSymbols.ATT_ELEMENTFORMDEFAULT, allAttrs[ATT_ELEMENT_FD_D]);
        attrList.put(SchemaSymbols.ATT_FINALDEFAULT, allAttrs[ATT_FINAL_D_D]);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_TARGETNAMESPACE, allAttrs[ATT_TARGET_N_N]);
        attrList.put(SchemaSymbols.ATT_VERSION, allAttrs[ATT_VERSION_N]);
        attrList.put(SchemaSymbols.ATT_XML_LANG, allAttrs[ATT_XML_LANG]);
        fEleAttrs11MapG.put(SchemaSymbols.ELT_SCHEMA, attrList);
        attrList = Container.getContainer(9);
        attrList.put(SchemaSymbols.ATT_DEFAULT, allAttrs[ATT_DEFAULT_N]);
        attrList.put(SchemaSymbols.ATT_FIXED, allAttrs[ATT_FIXED_N]);
        attrList.put(SchemaSymbols.ATT_FORM, allAttrs[ATT_FORM_N]);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_NAME, allAttrs[ATT_NAME_R]);
        attrList.put(SchemaSymbols.ATT_TARGETNAMESPACE, allAttrs[ATT_TARGET_N_N]);
        attrList.put(SchemaSymbols.ATT_TYPE, allAttrs[ATT_TYPE_N]);
        attrList.put(SchemaSymbols.ATT_USE, allAttrs[ATT_USE_D]);
        attrList.put(SchemaSymbols.ATT_INHERITABLE, allAttrs[ATT_INHERITABLE_N]);
        fEleAttrs11MapL.put(ATTRIBUTE_N, attrList);
        attrList = Container.getContainer(11);
        attrList.put(SchemaSymbols.ATT_BLOCK, allAttrs[ATT_BLOCK_N]);
        attrList.put(SchemaSymbols.ATT_DEFAULT, allAttrs[ATT_DEFAULT_N]);
        attrList.put(SchemaSymbols.ATT_FIXED, allAttrs[ATT_FIXED_N]);
        attrList.put(SchemaSymbols.ATT_FORM, allAttrs[ATT_FORM_N]);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_MAXOCCURS, allAttrs[ATT_MAXOCCURS_D]);
        attrList.put(SchemaSymbols.ATT_MINOCCURS, allAttrs[ATT_MINOCCURS_D]);
        attrList.put(SchemaSymbols.ATT_NAME, allAttrs[ATT_NAME_R]);
        attrList.put(SchemaSymbols.ATT_NILLABLE, allAttrs[ATT_NILLABLE_D]);
        attrList.put(SchemaSymbols.ATT_TARGETNAMESPACE, allAttrs[ATT_TARGET_N_N]);
        attrList.put(SchemaSymbols.ATT_TYPE, allAttrs[ATT_TYPE_N]);
        fEleAttrs11MapL.put(ELEMENT_N, attrList);
        attrList = Container.getContainer(7);
        attrList.put(SchemaSymbols.ATT_ABSTRACT, allAttrs[ATT_ABSTRACT_D]);
        attrList.put(SchemaSymbols.ATT_BLOCK, allAttrs[ATT_BLOCK1_N]);
        attrList.put(SchemaSymbols.ATT_FINAL, allAttrs[ATT_FINAL_N]);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_MIXED, allAttrs[ATT_MIXED_D]);
        attrList.put(SchemaSymbols.ATT_NAME, allAttrs[ATT_NAME_R]);
        attrList.put(SchemaSymbols.ATT_DEFAULTATTRIBUTESAPPLY, allAttrs[ATT_DEFAULT_ATTR_APPLY_D]);
        fEleAttrs11MapG.put(SchemaSymbols.ELT_COMPLEXTYPE, attrList);
        attrList = Container.getContainer(3);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_MIXED, allAttrs[ATT_MIXED_D]);
        attrList.put(SchemaSymbols.ATT_DEFAULTATTRIBUTESAPPLY, allAttrs[ATT_DEFAULT_ATTR_APPLY_D]);
        fEleAttrs11MapL.put(SchemaSymbols.ELT_COMPLEXTYPE, attrList);
        attrList = Container.getContainer(3);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_XPATH, allAttrs[ATT_XPATH_R]);
        attrList.put(SchemaSymbols.ATT_XPATH_DEFAULT_NS, allAttrs[ATT_DEFAULT_XPATH_NS_N]);
        fEleAttrs11MapL.put(SchemaSymbols.ELT_SELECTOR, attrList);
        attrList = Container.getContainer(3);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_XPATH, allAttrs[ATT_XPATH1_R]);
        attrList.put(SchemaSymbols.ATT_XPATH_DEFAULT_NS, allAttrs[ATT_DEFAULT_XPATH_NS_N]);
        fEleAttrs11MapL.put(SchemaSymbols.ELT_FIELD, attrList);
        attrList = Container.getContainer(7);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_MAXOCCURS, allAttrs[ATT_MAXOCCURS_D]);
        attrList.put(SchemaSymbols.ATT_MINOCCURS, allAttrs[ATT_MINOCCURS_D]);
        attrList.put(SchemaSymbols.ATT_NAMESPACE, allAttrs[ATT_NAMESPACE1_N]);
        attrList.put(SchemaSymbols.ATT_NOTNAMESPACE, allAttrs[ATT_NOTNAMESPACE_N]);
        attrList.put(SchemaSymbols.ATT_NOTQNAME, allAttrs[ATT_NOTQNAME_N]);
        attrList.put(SchemaSymbols.ATT_PROCESSCONTENTS, allAttrs[ATT_PROCESS_C_D]);
        fEleAttrs11MapL.put(SchemaSymbols.ELT_ANY, attrList);
        attrList = Container.getContainer(5);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_NAMESPACE, allAttrs[ATT_NAMESPACE1_N]);
        attrList.put(SchemaSymbols.ATT_NOTNAMESPACE, allAttrs[ATT_NOTNAMESPACE_N]);
        attrList.put(SchemaSymbols.ATT_NOTQNAME, allAttrs[ATT_NOTQNAME_N]);
        attrList.put(SchemaSymbols.ATT_PROCESSCONTENTS, allAttrs[ATT_PROCESS_C_D]);
        fEleAttrs11MapL.put(SchemaSymbols.ELT_ANYATTRIBUTE, attrList);
        attrList = Container.getContainer(4);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_TEST, allAttrs[ATT_TEST_XPATH_R]);
        attrList.put(SchemaSymbols.ATT_TYPE, allAttrs[ATT_TYPE_N]);
        attrList.put(SchemaSymbols.ATT_XPATH_DEFAULT_NS, allAttrs[ATT_DEFAULT_XPATH_NS_N]);
        fEleAttrs11MapL.put(SchemaSymbols.ELT_ALTERNATIVE, attrList);
        attrList = Container.getContainer(3);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_TEST, allAttrs[ATT_TEST_XPATH_R]);
        attrList.put(SchemaSymbols.ATT_XPATH_DEFAULT_NS, allAttrs[ATT_DEFAULT_XPATH_NS_N]);
        fEleAttrs11MapL.put(SchemaSymbols.ELT_ASSERT, attrList);
        fEleAttrs11MapL.put(SchemaSymbols.ELT_ASSERTION, attrList);
        attrList = Container.getContainer(3);
        attrList.put(SchemaSymbols.ATT_APPLIESTOEMPTY, allAttrs[ATT_APPLIESTO_EMPTY_D]);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_MODE, allAttrs[ATT_MODE_D]);
        fEleAttrs11MapG.put(SchemaSymbols.ELT_DEFAULTOPENCONTENT, attrList);
        attrList = Container.getContainer(2);
        attrList.put(SchemaSymbols.ATT_ID, allAttrs[ATT_ID_N]);
        attrList.put(SchemaSymbols.ATT_MODE, allAttrs[ATT_MODE1_D]);
        fEleAttrs11MapL.put(SchemaSymbols.ELT_OPENCONTENT, attrList);
        fSeenTemp = new boolean[ATTIDX_COUNT];
        fTempArray = new Object[ATTIDX_COUNT];
    }
}

