/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.traversers;

import org.apache.xerces.impl.xs.traversers.XSAttributeCheckerXerces;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.impl.xs.traversers.XSDocumentInfo;
import org.apache.xerces.impl.xs.util.XInt;
import org.apache.xerces.util.DOMUtil;
import org.w3c.dom.Element;

public class XSAttributeChecker
extends XSAttributeCheckerXerces {
    public XSAttributeChecker(XSDHandler schemaHandler) {
        super(schemaHandler);
    }

    @Override
    public Object[] checkAttributes(Element element, boolean isGlobal, XSDocumentInfo schemaDoc, boolean enumAsQName) {
        int min;
        String elName;
        int max;
        Object[] attrValues = super.checkAttributes(element, isGlobal, schemaDoc, enumAsQName);
        if (attrValues == null) {
            return null;
        }
        if (attrValues[ATTIDX_MAXOCCURS] != null && (max = ((XInt)attrValues[ATTIDX_MAXOCCURS]).intValue()) > 256) {
            elName = DOMUtil.getLocalName(element);
            this.reportSchemaWarning("oxygen-maxOccursLimit", new Object[]{elName, attrValues[ATTIDX_MAXOCCURS]}, element);
            attrValues[XSAttributeChecker.ATTIDX_MAXOCCURS] = fXIntPool.getXInt(-1);
        }
        if (attrValues[ATTIDX_MINOCCURS] != null && (min = ((XInt)attrValues[ATTIDX_MINOCCURS]).intValue()) > 256) {
            elName = DOMUtil.getLocalName(element);
            this.reportSchemaWarning("oxygen-minOccursLimit", new Object[]{elName, attrValues[ATTIDX_MINOCCURS], new Integer(256)}, element);
            attrValues[XSAttributeChecker.ATTIDX_MINOCCURS] = fXIntPool.getXInt(256);
        }
        return attrValues;
    }

    void reportSchemaWarning(String key, Object[] args, Element ele) {
        this.fSchemaHandler.reportSchemaWarning(key, args, ele);
    }
}

