/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.locator;

import java.util.List;
import java.util.Stack;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.locator.AttributeLocator;
import org.apache.xerces.impl.locator.AttributeOrElementLocator;
import org.apache.xerces.impl.locator.ElementLocator;
import org.apache.xerces.impl.locator.XMLItemLocator;
import org.apache.xerces.impl.xs.opti.ElementImpl;
import org.apache.xerces.util.MessageFormatter;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;

public class XMLLocatingErrorReporter
extends XMLErrorReporter {
    private static Logger logger = LoggerFactory.getLogger((String)XMLLocatingErrorReporter.class.getName());
    private XMLErrorReporter xercesErrorReporter;
    private String currentErrorKey;
    private Object[] currentErrorArguments;
    private Stack<ElementLocator> elementLocators = new Stack();
    private XMLItemLocator entityLocator;
    private XMLItemLocator externalEntityDeclLocator;
    private AttributeLocator attrLocator;
    private ElementImpl currentXSDErrorElement;
    private QName currentValidatedAttribute;
    private AttributeOrElementLocator invalidIdRefLocator;

    public XMLLocatingErrorReporter(XMLErrorReporter errorReporter) {
        this.xercesErrorReporter = errorReporter;
    }

    public ElementImpl getCurrentXSDErrorElement() {
        return this.currentXSDErrorElement;
    }

    public void setCurrentXSDErrorElement(ElementImpl currentErrorElement) {
        this.currentXSDErrorElement = currentErrorElement;
    }

    public void entityRefScanned(XMLItemLocator locator) {
        this.entityLocator = locator;
    }

    public void externalEntityDeclScanned(XMLItemLocator locator) {
        this.externalEntityDeclLocator = locator;
    }

    public void scanStartElement(int elementNameStartLine, int elementNameStartColumn, String publicId, String systemId) {
        ElementLocator elementLocator = new ElementLocator(elementNameStartLine, elementNameStartColumn, publicId, systemId);
        this.elementLocators.push(elementLocator);
    }

    public void scanEndElement(int elementContentEndLine, int elementContentEndColumn) {
        if (!this.elementLocators.isEmpty()) {
            ElementLocator elementLocator = this.elementLocators.peek();
            elementLocator.setContentEndLine(elementContentEndLine);
            elementLocator.setContentEndColumn(elementContentEndColumn);
        }
    }

    public void endElementScanned() {
        if (!this.elementLocators.isEmpty()) {
            this.elementLocators.pop();
        } else {
            logger.warn("The element locator stack is empty.", (Throwable)new Exception());
        }
    }

    public void startContentScanned(XMLItemLocator elementContentLocator) {
        if (!this.elementLocators.isEmpty()) {
            ElementLocator elementLocator = this.elementLocators.peek();
            elementLocator.addContentLocator(elementContentLocator);
        }
    }

    public void elementContentScanned(XMLItemLocator elementContentLocator) {
        if (!this.elementLocators.isEmpty()) {
            ElementLocator elementLocator = this.elementLocators.peek();
            elementLocator.addContentLocator(elementContentLocator);
        }
    }

    public void attributeNameScaned(AttributeLocator attribute) {
        if (!this.elementLocators.isEmpty()) {
            ElementLocator elementLocator = this.elementLocators.peek();
            elementLocator.addAttributeLocator(attribute);
        }
        this.attrLocator = attribute;
    }

    public AttributeLocator getAttributeWithName(String name) {
        AttributeLocator attributeLocator = null;
        if (!this.elementLocators.isEmpty()) {
            ElementLocator elementLocator = this.elementLocators.peek();
            attributeLocator = elementLocator.getAttributeWithName(name);
        }
        return attributeLocator;
    }

    public AttributeLocator getAttributeWithValue(String value) {
        AttributeLocator attributeLocator = null;
        if (!this.elementLocators.isEmpty()) {
            ElementLocator elementLocator = this.elementLocators.peek();
            attributeLocator = elementLocator.getAttributeWithValue(value);
        }
        return attributeLocator;
    }

    public void startElementScanned(int lineNumber, int columnNumber) {
        if (!this.elementLocators.isEmpty()) {
            ElementLocator elementLocator = this.elementLocators.peek();
            elementLocator.setContentStartLine(lineNumber);
            elementLocator.setContentStartColumn(columnNumber);
        }
        this.attrLocator = null;
    }

    public ElementLocator getCurrentElementLocator() {
        ElementLocator locator = null;
        if (!this.elementLocators.isEmpty()) {
            locator = this.elementLocators.peek();
        }
        return locator;
    }

    public List getElementContentLocators() {
        List<XMLItemLocator> locators = null;
        if (!this.elementLocators.isEmpty()) {
            ElementLocator elLocator = this.elementLocators.peek();
            locators = elLocator.getElementContentLocators();
        }
        return locators;
    }

    public void elementNameScanned(int lineNumber, int columnNumber) {
        if (!this.elementLocators.isEmpty()) {
            ElementLocator elLocator = this.elementLocators.peek();
            elLocator.setNameEndLocation(lineNumber, columnNumber);
        }
    }

    public String getErrorKey() {
        return this.currentErrorKey;
    }

    public Object[] getErrorArguments() {
        return this.currentErrorArguments;
    }

    public XMLItemLocator getEntityLocator() {
        return this.entityLocator;
    }

    public XMLItemLocator getExternalEntityDeclLocator() {
        return this.externalEntityDeclLocator;
    }

    public AttributeLocator getCurrentAttrLocator() {
        return this.attrLocator;
    }

    @Override
    public String reportError(XMLLocator location, String domain, String errorKey, Object[] arguments, short severity) throws XNIException {
        this.currentErrorKey = errorKey;
        this.currentErrorArguments = arguments;
        return this.xercesErrorReporter.reportError(location, domain, errorKey, arguments, severity);
    }

    @Override
    public String reportError(String domain, String key, Object[] arguments, short severity) throws XNIException {
        this.currentErrorKey = key;
        this.currentErrorArguments = arguments;
        return this.xercesErrorReporter.reportError(domain, key, arguments, severity);
    }

    @Override
    public String reportError(XMLLocator location, String domain, String key, Object[] arguments, short severity, Exception exception) throws XNIException {
        this.currentErrorKey = key;
        this.currentErrorArguments = arguments;
        return this.xercesErrorReporter.reportError(location, domain, key, arguments, severity, exception);
    }

    @Override
    public String reportError(String domain, String key, Object[] arguments, short severity, Exception exception) throws XNIException {
        this.currentErrorKey = key;
        this.currentErrorArguments = arguments;
        return this.xercesErrorReporter.reportError(domain, key, arguments, severity, exception);
    }

    @Override
    public MessageFormatter getMessageFormatter(String domain) {
        return this.xercesErrorReporter.getMessageFormatter(domain);
    }

    @Override
    public void setDocumentLocator(XMLLocator locator) {
        this.xercesErrorReporter.setDocumentLocator(locator);
    }

    @Override
    public void putMessageFormatter(String domain, MessageFormatter messageFormatter) {
        this.xercesErrorReporter.putMessageFormatter(domain, messageFormatter);
    }

    @Override
    public MessageFormatter removeMessageFormatter(String domain) {
        return this.xercesErrorReporter.removeMessageFormatter(domain);
    }

    @Override
    public void reset(XMLComponentManager componentManager) throws XNIException {
        this.xercesErrorReporter.reset(componentManager);
    }

    @Override
    public String[] getRecognizedFeatures() {
        return this.xercesErrorReporter.getRecognizedFeatures();
    }

    @Override
    public void setFeature(String featureId, boolean state) throws XMLConfigurationException {
        this.xercesErrorReporter.setFeature(featureId, state);
    }

    @Override
    public boolean getFeature(String featureId) throws XMLConfigurationException {
        return this.xercesErrorReporter.getFeature(featureId);
    }

    @Override
    public String[] getRecognizedProperties() {
        return this.xercesErrorReporter.getRecognizedProperties();
    }

    @Override
    public void setProperty(String propertyId, Object value) throws XMLConfigurationException {
        this.xercesErrorReporter.setProperty(propertyId, value);
    }

    @Override
    public Boolean getFeatureDefault(String featureId) {
        return this.xercesErrorReporter.getFeatureDefault(featureId);
    }

    @Override
    public Object getPropertyDefault(String propertyId) {
        return this.xercesErrorReporter.getPropertyDefault(propertyId);
    }

    @Override
    public XMLErrorHandler getErrorHandler() {
        return this.xercesErrorReporter.getErrorHandler();
    }

    @Override
    public ErrorHandler getSAXErrorHandler() {
        return this.xercesErrorReporter.getSAXErrorHandler();
    }

    public void setCurrentValidatedAttribute(QName currentValidatedAttribute) {
        this.currentValidatedAttribute = currentValidatedAttribute;
    }

    public AttributeLocator getCurrentValidatedAttrLocator() {
        if (this.currentValidatedAttribute != null) {
            return this.getAttributeWithName(this.currentValidatedAttribute.rawname);
        }
        return null;
    }

    public void setInvalidIdRefLocator(AttributeOrElementLocator invalidIdRefLocator) {
        this.invalidIdRefLocator = invalidIdRefLocator;
    }

    public AttributeOrElementLocator getInvalidIdRefLocator() {
        return this.invalidIdRefLocator;
    }
}

