/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl;

import java.io.IOException;
import org.apache.xerces.impl.XMLEntityScannerXerces;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.xni.XMLString;

public class XMLEntityScanner
extends XMLEntityScannerXerces {
    @Override
    public int scanChar() throws IOException {
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.load(0, true);
        }
        int c = this.fCurrentEntity.ch[this.fCurrentEntity.position++];
        boolean external = false;
        if (c == 10 || c == 13 && (external = this.fCurrentEntity.isExternal())) {
            ++this.fCurrentEntity.lineNumber;
            this.fCurrentEntity.columnNumber = 1;
            if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                this.fCurrentEntity.ch[0] = (char)c;
                this.load(1, false);
            }
            if (c == 13 && external) {
                if (this.fCurrentEntity.position < this.fCurrentEntity.count && this.fCurrentEntity.ch[this.fCurrentEntity.position++] != '\n') {
                    --this.fCurrentEntity.position;
                }
                c = 10;
            }
        } else {
            ++this.fCurrentEntity.columnNumber;
        }
        return c;
    }

    @Override
    public int scanContent(XMLString content) throws IOException {
        int length;
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.load(0, true);
        } else if (this.fCurrentEntity.position == this.fCurrentEntity.count - 1) {
            this.fCurrentEntity.ch[0] = this.fCurrentEntity.ch[this.fCurrentEntity.count - 1];
            this.load(1, false);
            this.fCurrentEntity.position = 0;
            this.fCurrentEntity.startPosition = 0;
        }
        int offset = this.fCurrentEntity.position;
        int c = this.fCurrentEntity.ch[offset];
        int newlines = 0;
        int newlinesOxygen = 0;
        boolean external = this.fCurrentEntity.isExternal();
        if (c == 10 || c == 13 && external) {
            do {
                if ((c = this.fCurrentEntity.ch[this.fCurrentEntity.position++]) == 13 && external) {
                    ++newlines;
                    ++newlinesOxygen;
                    ++this.fCurrentEntity.lineNumber;
                    this.fCurrentEntity.columnNumber = 1;
                    if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                        offset = 0;
                        this.fCurrentEntity.baseCharOffset += this.fCurrentEntity.position - this.fCurrentEntity.startPosition;
                        this.fCurrentEntity.position = newlines;
                        this.fCurrentEntity.startPosition = newlines;
                        if (this.load(newlines, false)) break;
                    }
                    if (this.fCurrentEntity.ch[this.fCurrentEntity.position] == '\n') {
                        ++this.fCurrentEntity.position;
                        ++offset;
                        continue;
                    }
                    ++newlines;
                    continue;
                }
                if (c == 10) {
                    ++newlines;
                    ++newlinesOxygen;
                    ++this.fCurrentEntity.lineNumber;
                    this.fCurrentEntity.columnNumber = 1;
                    if (this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
                    offset = 0;
                    this.fCurrentEntity.baseCharOffset += this.fCurrentEntity.position - this.fCurrentEntity.startPosition;
                    this.fCurrentEntity.position = newlines;
                    this.fCurrentEntity.startPosition = newlines;
                    if (!this.load(newlines, false)) continue;
                    break;
                }
                --this.fCurrentEntity.position;
                break;
            } while (this.fCurrentEntity.position < this.fCurrentEntity.count - 1);
            for (int i = offset; i < this.fCurrentEntity.position; ++i) {
                this.fCurrentEntity.ch[i] = 10;
            }
            length = this.fCurrentEntity.position - offset;
            if (this.fCurrentEntity.position == this.fCurrentEntity.count - 1) {
                content.setValues(this.fCurrentEntity.ch, offset, length);
                return -1;
            }
        }
        while (this.fCurrentEntity.position < this.fCurrentEntity.count) {
            if (XMLChar.isContent(c = this.fCurrentEntity.ch[this.fCurrentEntity.position++])) continue;
            --this.fCurrentEntity.position;
            break;
        }
        length = this.fCurrentEntity.position - offset;
        this.fCurrentEntity.columnNumber += length - newlinesOxygen;
        content.setValues(this.fCurrentEntity.ch, offset, length);
        if (this.fCurrentEntity.position != this.fCurrentEntity.count) {
            c = this.fCurrentEntity.ch[this.fCurrentEntity.position];
            if (c == 13 && external) {
                c = 10;
            }
        } else {
            c = -1;
        }
        return c;
    }

    @Override
    public int scanLiteral(int quote, XMLString content) throws IOException {
        int length;
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.load(0, true);
        } else if (this.fCurrentEntity.position == this.fCurrentEntity.count - 1) {
            this.fCurrentEntity.ch[0] = this.fCurrentEntity.ch[this.fCurrentEntity.count - 1];
            this.load(1, false);
            this.fCurrentEntity.position = 0;
            this.fCurrentEntity.startPosition = 0;
        }
        int offset = this.fCurrentEntity.position;
        int c = this.fCurrentEntity.ch[offset];
        int newlines = 0;
        int newLinesOxygen = 0;
        boolean external = this.fCurrentEntity.isExternal();
        if (c == 10 || c == 13 && external) {
            do {
                if ((c = this.fCurrentEntity.ch[this.fCurrentEntity.position++]) == 13 && external) {
                    ++newlines;
                    ++newLinesOxygen;
                    ++this.fCurrentEntity.lineNumber;
                    this.fCurrentEntity.columnNumber = 1;
                    if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                        offset = 0;
                        this.fCurrentEntity.baseCharOffset += this.fCurrentEntity.position - this.fCurrentEntity.startPosition;
                        this.fCurrentEntity.position = newlines;
                        this.fCurrentEntity.startPosition = newlines;
                        if (this.load(newlines, false)) break;
                    }
                    if (this.fCurrentEntity.ch[this.fCurrentEntity.position] == '\n') {
                        ++this.fCurrentEntity.position;
                        ++offset;
                        continue;
                    }
                    ++newlines;
                    continue;
                }
                if (c == 10) {
                    ++newlines;
                    ++newLinesOxygen;
                    ++this.fCurrentEntity.lineNumber;
                    this.fCurrentEntity.columnNumber = 1;
                    if (this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
                    offset = 0;
                    this.fCurrentEntity.baseCharOffset += this.fCurrentEntity.position - this.fCurrentEntity.startPosition;
                    this.fCurrentEntity.position = newlines;
                    this.fCurrentEntity.startPosition = newlines;
                    if (!this.load(newlines, false)) continue;
                    break;
                }
                --this.fCurrentEntity.position;
                break;
            } while (this.fCurrentEntity.position < this.fCurrentEntity.count - 1);
            for (int i = offset; i < this.fCurrentEntity.position; ++i) {
                this.fCurrentEntity.ch[i] = 10;
            }
            length = this.fCurrentEntity.position - offset;
            if (this.fCurrentEntity.position == this.fCurrentEntity.count - 1) {
                content.setValues(this.fCurrentEntity.ch, offset, length);
                return -1;
            }
        }
        while (this.fCurrentEntity.position < this.fCurrentEntity.count) {
            if (((c = this.fCurrentEntity.ch[this.fCurrentEntity.position++]) != quote || this.fCurrentEntity.literal && !external) && c != 37 && (XMLChar.isContent(c) || c == 13 && !external)) continue;
            --this.fCurrentEntity.position;
            break;
        }
        length = this.fCurrentEntity.position - offset;
        this.fCurrentEntity.columnNumber += length - newLinesOxygen;
        content.setValues(this.fCurrentEntity.ch, offset, length);
        if (this.fCurrentEntity.position != this.fCurrentEntity.count) {
            c = this.fCurrentEntity.ch[this.fCurrentEntity.position];
            if (c == quote && this.fCurrentEntity.literal) {
                c = -1;
            }
        } else {
            c = -1;
        }
        return c;
    }
}

