/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.indexer.stem;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.br.BrazilianAnalyzer;
import org.apache.lucene.analysis.cz.CzechAnalyzer;
import org.apache.lucene.analysis.de.GermanAnalyzer;
import org.apache.lucene.analysis.el.GreekAnalyzer;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.es.SpanishAnalyzer;
import org.apache.lucene.analysis.fr.FrenchAnalyzer;
import org.apache.lucene.analysis.hu.HungarianAnalyzer;
import org.apache.lucene.analysis.hy.ArmenianAnalyzer;
import org.apache.lucene.analysis.it.ItalianAnalyzer;
import org.apache.lucene.analysis.pt.PortugueseAnalyzer;
import org.apache.lucene.analysis.ro.RomanianAnalyzer;
import org.apache.lucene.analysis.ru.RussianAnalyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import ro.sync.exml.indexer.stem.Stemmer;
import ro.sync.exml.indexer.stem.StemmerLanguageNotSupportedException;

public class AnalyzerBasedStemmer
implements Stemmer {
    private Analyzer analyzer = null;

    public AnalyzerBasedStemmer(String lang) throws StemmerLanguageNotSupportedException {
        if ("en".equals(lang)) {
            this.analyzer = new EnglishAnalyzer();
        } else if ("ar".equals(lang)) {
            this.analyzer = new ArmenianAnalyzer();
        } else if ("br".equals(lang)) {
            this.analyzer = new BrazilianAnalyzer();
        } else if ("cs".equals(lang)) {
            this.analyzer = new CzechAnalyzer();
        } else if ("de".equals(lang)) {
            this.analyzer = new GermanAnalyzer();
        } else if ("es".equals(lang)) {
            this.analyzer = new SpanishAnalyzer();
        } else if ("fr".equals(lang)) {
            this.analyzer = new FrenchAnalyzer();
        } else if ("gr".equals(lang)) {
            this.analyzer = new GreekAnalyzer();
        } else if ("hu".equals(lang)) {
            this.analyzer = new HungarianAnalyzer();
        } else if ("it".equals(lang)) {
            this.analyzer = new ItalianAnalyzer();
        } else if ("pt".equals(lang)) {
            this.analyzer = new PortugueseAnalyzer();
        } else if ("ro".equals(lang)) {
            this.analyzer = new RomanianAnalyzer();
        } else if ("ru".equals(lang)) {
            this.analyzer = new RussianAnalyzer();
        } else {
            throw new StemmerLanguageNotSupportedException();
        }
    }

    @Override
    public String stem(String in) {
        StringBuilder result = new StringBuilder();
        try {
            TokenStream tStream = this.analyzer.tokenStream("contents", (Reader)new StringReader(in));
            CharTermAttribute charTermAttribute = (CharTermAttribute)tStream.addAttribute(CharTermAttribute.class);
            tStream.reset();
            while (tStream.incrementToken()) {
                result.append(charTermAttribute.toString());
            }
            tStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result.toString();
    }
}

