/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.indexer.score;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.TreeMap;
import org.apache.lucene.analysis.CharArraySet;
import ro.sync.exml.indexer.score.IScoreProvider;

public class ScoreRepository {
    private ArrayList<String> stopWords;
    private TreeMap<String, WordInfo> wordScores;
    private IScoreProvider scoreProvider;
    private Stack<Integer> parentScoreStack;
    private File lastIndexedFile;
    private int fileIndex;
    private TreeMap<String, String> accumulatedScores;
    private boolean writeWordIndices = true;

    public ScoreRepository(IScoreProvider elemScoreProvider) {
        this.scoreProvider = elemScoreProvider;
        this.wordScores = new TreeMap();
        this.parentScoreStack = new Stack();
        this.fileIndex = -1;
        this.accumulatedScores = new TreeMap();
    }

    public boolean startElementScore(String elementWClass) {
        boolean toReturn = true;
        int elemScore = 0;
        if (this.scoreProvider != null) {
            elemScore = this.scoreProvider.getElementScore(elementWClass);
        }
        if (elemScore == Integer.MIN_VALUE) {
            toReturn = false;
        } else {
            int pScore = 0;
            if (!this.parentScoreStack.isEmpty()) {
                pScore = this.parentScoreStack.peek();
            }
            this.parentScoreStack.push(elemScore + pScore);
        }
        return toReturn;
    }

    public void endElementScore() {
        this.parentScoreStack.pop();
    }

    public void setStopWords(CharArraySet stopWordsSet) {
        if (this.stopWords == null) {
            this.stopWords = new ArrayList();
            for (Object nextItem : stopWordsSet) {
                String nextStopWord = null;
                nextStopWord = nextItem instanceof char[] ? String.valueOf((char[])nextItem) : String.valueOf(nextItem);
                this.stopWords.add(nextStopWord);
            }
        }
    }

    public void updateWordScore(String word, int wordIdx) {
        int wScore = 0;
        if (!this.parentScoreStack.isEmpty()) {
            wScore = this.parentScoreStack.peek();
        }
        if (word != null && word.trim().length() > 0) {
            WordInfo wordInfo = this.wordScores.get(word = word.trim());
            if (wordInfo != null) {
                wordInfo.score = wordInfo.score + (wScore == 0 ? 1 : wScore);
                wordInfo.fileIndexes.add(wordIdx);
            } else {
                WordInfo wi = new WordInfo(wScore);
                wi.addFileIndex(wordIdx);
                this.wordScores.put(word, wi);
            }
        }
    }

    public TreeMap<String, String> getScores() {
        this.flushAccumulatedScores();
        return this.accumulatedScores;
    }

    public ArrayList<String> getStopWords() {
        return this.stopWords;
    }

    public void startIndexingFile(File file) {
        if (this.lastIndexedFile == null || !this.lastIndexedFile.equals(file)) {
            this.lastIndexedFile = file;
            this.flushAccumulatedScores();
        }
    }

    private void flushAccumulatedScores() {
        if (this.fileIndex >= 0) {
            for (String word : this.wordScores.keySet()) {
                String allScores = this.accumulatedScores.get(word);
                WordInfo wi = this.wordScores.get(word);
                StringBuilder sbIdx = new StringBuilder();
                Iterator<Integer> iterator = wi.fileIndexes.iterator();
                while (iterator.hasNext()) {
                    Integer idx = iterator.next();
                    String idx64Base = Integer.toString(idx, 32);
                    sbIdx.append(idx64Base);
                    if (!iterator.hasNext()) continue;
                    sbIdx.append("$");
                }
                StringBuilder sb = new StringBuilder();
                if (allScores != null) {
                    sb.append("\"").append(allScores.substring(1, allScores.length() - 2)).append(",").append(String.valueOf(this.fileIndex)).append("*").append(String.valueOf(wi.score));
                    if (this.writeWordIndices) {
                        sb.append("*").append(sbIdx.toString());
                    }
                    sb.append("\";");
                } else {
                    sb.append("\"").append(String.valueOf(this.fileIndex)).append("*").append(String.valueOf(wi.score));
                    if (this.writeWordIndices) {
                        sb.append("*").append(sbIdx.toString());
                    }
                    sb.append("\";");
                }
                this.accumulatedScores.put(word, sb.toString());
            }
            this.wordScores.clear();
        }
        ++this.fileIndex;
    }

    public void setWriteWordIndices(boolean writeWordIndices) {
        this.writeWordIndices = writeWordIndices;
    }

    public static class WordInfo {
        private int score;
        private List<Integer> fileIndexes = new ArrayList<Integer>();

        public WordInfo(int score) {
            this.score = score;
        }

        public void addFileIndex(int idx) {
            this.fileIndexes.add(idx);
        }
    }
}

