/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.indexer.score;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.indexer.score.IScoreProvider;

public class ElementScoreProvider
implements IScoreProvider {
    private static final Logger logger = LoggerFactory.getLogger((String)ElementScoreProvider.class.getName());
    private static final String SCORING_FILE_PROPS = "scoring.properties";
    private static final String IGNORED = "ignored";
    private Properties scoreCfgProperties = new Properties();

    public ElementScoreProvider(String propertiesDir) {
        InputStream input = null;
        try {
            if (propertiesDir == null || propertiesDir.trim().length() == 0) {
                System.out.println("Loading scoring from /etc/ folder. ");
                input = this.getClass().getResourceAsStream("/etc/scoring.properties");
            } else {
                File scoringFile = new File(propertiesDir, SCORING_FILE_PROPS);
                if (!scoringFile.exists()) {
                    logger.error("Cannot find scoring file: " + scoringFile + ". Using flat scoring model.");
                } else {
                    logger.info("Using scoring configuration file: " + scoringFile);
                    input = new FileInputStream(scoringFile);
                }
            }
            if (input != null) {
                this.scoreCfgProperties.load(input);
                input.close();
            } else {
                logger.error("Properies dir is null and scoring properties are not available in 'etc' in the java resources!");
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private int getElementWithClassScore(String elementName, String classes) {
        int toReturn = 0;
        StringTokenizer st = new StringTokenizer(classes, " ");
        boolean foundClassScore = false;
        boolean ignoredClass = false;
        while (st.hasMoreTokens()) {
            String clazz = st.nextToken();
            String strToFind = elementName + "." + clazz;
            if (this.scoreCfgProperties.getProperty(strToFind) == null) continue;
            int scoreFromConfigurationFile = this.getScoreFromConfigurationFile(strToFind);
            if (scoreFromConfigurationFile == Integer.MIN_VALUE) {
                ignoredClass = true;
                break;
            }
            toReturn += scoreFromConfigurationFile;
            foundClassScore = true;
        }
        if (ignoredClass) {
            toReturn = Integer.MIN_VALUE;
        } else if (!foundClassScore) {
            toReturn = this.getScoreFromConfigurationFile(elementName);
        }
        return toReturn;
    }

    private int getScoreFromConfigurationFile(String tag) {
        int toReturn = 0;
        String valStr = this.scoreCfgProperties.getProperty(tag);
        if (valStr != null) {
            if (valStr.toLowerCase().equals(IGNORED)) {
                toReturn = Integer.MIN_VALUE;
            } else {
                try {
                    toReturn = Integer.parseInt(valStr);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return toReturn;
    }

    @Override
    public int getElementScore(String elementName) {
        Integer toReturn = 0;
        if (elementName != null) {
            int dotPosition = elementName.toLowerCase().indexOf(".");
            if (dotPosition > 0) {
                String tag = elementName.substring(0, dotPosition);
                String clss = elementName.substring(dotPosition + 1);
                toReturn = this.getElementWithClassScore(tag, clss);
            } else {
                toReturn = this.getScoreFromConfigurationFile(elementName);
            }
        }
        return toReturn;
    }

    @Override
    public void addDoNotIndex(String doNotIndex) {
        if (doNotIndex != null) {
            StringTokenizer st = new StringTokenizer(doNotIndex, ",");
            while (st.hasMoreElements()) {
                String tag = st.nextToken();
                if ((tag = tag.trim()).length() <= 0) continue;
                this.scoreCfgProperties.put(tag, IGNORED);
            }
        }
    }
}

