/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.indexer.parser;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ro.sync.exml.indexer.utils.IndexedFileInfo;

public abstract class ReviewAwareContentHandler
extends DefaultHandler {
    private final Stack<Map<String, String>> attrsStack = new Stack();
    private int reviewElementsLevel = 0;
    private boolean captureText = false;
    protected final StringBuilder buffer = new StringBuilder();
    protected final IndexedFileInfo fileInfo;

    public ReviewAwareContentHandler(IndexedFileInfo fileInfo) {
        this.fileInfo = fileInfo;
    }

    protected abstract void startElementInternal(String var1, String var2, String var3, Map<String, String> var4);

    protected abstract void endElementInternal(String var1, String var2, String var3, Map<String, String> var4);

    @Override
    public final void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        Map<String, String> attributesMap = this.getAttributesMap(attributes);
        this.attrsStack.push(attributesMap);
        if (this.isReviewElem(qName, attributesMap)) {
            ++this.reviewElementsLevel;
        }
        this.startElementInternal(uri, localName, qName, attributesMap);
    }

    @Override
    public final void endElement(String uri, String localName, String qName) throws SAXException {
        Map<String, String> attributes = this.attrsStack.pop();
        boolean isCommElem = this.isReviewElem(qName, attributes);
        if (isCommElem) {
            --this.reviewElementsLevel;
        }
        this.endElementInternal(uri, localName, qName, attributes);
    }

    private Map<String, String> getAttributesMap(Attributes attributes) {
        int length;
        HashMap<String, String> attrsMap = Collections.EMPTY_MAP;
        if (attributes != null && (length = attributes.getLength()) > 0) {
            attrsMap = new HashMap<String, String>(length);
            for (int i = 0; i < length; ++i) {
                attrsMap.put(attributes.getQName(i), attributes.getValue(i));
            }
        }
        return attrsMap;
    }

    public boolean isReviewElem(String qName, Map<String, String> attributes) {
        String classAttr;
        boolean review = false;
        if ("span".equals(qName) && (classAttr = attributes.get("class")) != null && (classAttr.equals("oxy-comment") || classAttr.equals("oxy-delete") || classAttr.equals("oxy-insert"))) {
            review = true;
        }
        return review;
    }

    public boolean isCaptureText() {
        return this.captureText && this.reviewElementsLevel == 0;
    }

    public void setCaptureText(boolean captureText) {
        this.captureText = captureText;
    }
}

