/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.indexer.js;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import ro.sync.exml.indexer.keywords.IKeywordsRepository;
import ro.sync.exml.indexer.score.ScoreRepository;
import ro.sync.exml.indexer.utils.IndexedFileInfo;

public abstract class JsFilesBuilder {
    protected static final String INDEXER_FILES_ENCODING = "UTF-8";
    protected static final String TXT_INDICES_LOCATION = "Generated index files are located in ";
    protected static final Set<Character> trimmableChars = new HashSet<Character>();

    private static String hex(char ch) {
        return Integer.toHexString(ch).toUpperCase(Locale.ENGLISH);
    }

    protected String stripNonAlphabeticalChars(String input) {
        String output = input;
        for (int i = input.length() - 1; i > 0; --i) {
            char charAt = input.charAt(i);
            if (!trimmableChars.contains(Character.valueOf(charAt))) {
                return output;
            }
            output = output.substring(0, output.length() - 1);
        }
        return output;
    }

    protected String escapeJavaScript(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder out = new StringBuilder();
        block12: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch > '\u0fff') {
                out.append("\\u" + JsFilesBuilder.hex(ch));
                continue;
            }
            if (ch > '\u00ff') {
                out.append("\\u0" + JsFilesBuilder.hex(ch));
                continue;
            }
            if (ch > '\u007f') {
                out.append("\\u00" + JsFilesBuilder.hex(ch));
                continue;
            }
            if (ch < ' ') {
                switch (ch) {
                    case '\b': {
                        out.append('\\');
                        out.append('b');
                        break;
                    }
                    case '\n': {
                        out.append('\\');
                        out.append('n');
                        break;
                    }
                    case '\t': {
                        out.append('\\');
                        out.append('t');
                        break;
                    }
                    case '\f': {
                        out.append('\\');
                        out.append('f');
                        break;
                    }
                    case '\r': {
                        out.append('\\');
                        out.append('r');
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            out.append("\\u00" + JsFilesBuilder.hex(ch));
                            break;
                        }
                        out.append("\\u000" + JsFilesBuilder.hex(ch));
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case '\'': {
                    out.append('\\');
                    out.append('\'');
                    continue block12;
                }
                case '\"': {
                    out.append('\\');
                    out.append('\"');
                    continue block12;
                }
                case '\\': {
                    out.append('\\');
                    out.append('\\');
                    continue block12;
                }
                default: {
                    out.append(ch);
                }
            }
        }
        return out.toString();
    }

    protected String escapeHtml(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        block6: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public abstract void writeHTMLInfoList(String var1, List<IndexedFileInfo> var2, boolean var3);

    public abstract void writeIndex(String var1, ScoreRepository var2, String var3);

    public abstract void writeKeywords(String var1, IKeywordsRepository var2);

    public abstract void writeStopWords(OutputStreamWriter var1, ScoreRepository var2) throws IOException;

    public abstract void writeLinkToParent(File var1, List<IndexedFileInfo> var2, File var3);

    static {
        trimmableChars.add(Character.valueOf('.'));
        trimmableChars.add(Character.valueOf(','));
        trimmableChars.add(Character.valueOf(':'));
        trimmableChars.add(Character.valueOf(';'));
        trimmableChars.add(Character.valueOf(' '));
        trimmableChars.add(Character.valueOf('-'));
    }
}

