/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.indexer;

import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.cjk.CJKWidthFilter;
import org.apache.lucene.analysis.ja.JapaneseAnalyzer;
import org.apache.lucene.analysis.ja.JapaneseBaseFormFilter;
import org.apache.lucene.analysis.ja.JapanesePartOfSpeechStopFilter;
import org.apache.lucene.analysis.ja.JapaneseTokenizer;
import org.apache.lucene.analysis.ja.dict.UserDictionary;

public class WebHelpJapaneseAnalyzer
extends JapaneseAnalyzer {
    private final JapaneseTokenizer.Mode mode;
    private final Set<String> stoptags;
    private final UserDictionary userDict;

    public WebHelpJapaneseAnalyzer(UserDictionary userDict, JapaneseTokenizer.Mode mode, CharArraySet stopwords, Set<String> stoptags) {
        super(userDict, mode, stopwords, stoptags);
        this.userDict = userDict;
        this.mode = mode;
        this.stoptags = stoptags;
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        JapaneseTokenizer tokenizer = new JapaneseTokenizer(this.userDict, true, this.mode);
        JapaneseBaseFormFilter stream = new JapaneseBaseFormFilter((TokenStream)tokenizer);
        stream = new JapanesePartOfSpeechStopFilter((TokenStream)stream, this.stoptags);
        stream = new CJKWidthFilter((TokenStream)stream);
        stream = new StopFilter((TokenStream)stream, this.stopwords);
        stream = new LowerCaseFilter((TokenStream)stream);
        return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)stream);
    }
}

