/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.indexer;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.tools.ant.util.StringUtils;

public class StopWordsPreferences {
    private String stopWordsExclude;
    private String stopWordsInclude;

    public StopWordsPreferences() {
    }

    public StopWordsPreferences(String stopWordsExclude, String stopWordsInclude) {
        this.stopWordsExclude = stopWordsExclude;
        this.stopWordsInclude = stopWordsInclude;
    }

    public CharArraySet getStopWords(CharArraySet defaultStopWords) {
        if (StringUtils.trimToNull((String)this.stopWordsExclude) == null && StringUtils.trimToNull((String)this.stopWordsInclude) == null) {
            return defaultStopWords;
        }
        List<String> toExclude = this.extractStopWords(this.stopWordsExclude);
        List<String> toInclude = this.extractStopWords(this.stopWordsInclude);
        List defaultSet = defaultStopWords.stream().map(element -> {
            if (element instanceof char[]) {
                return new String((char[])element);
            }
            return null;
        }).filter(element -> element != null).collect(Collectors.toList());
        ArrayList<Object> newStopWords = new ArrayList<Object>();
        newStopWords.addAll(defaultSet);
        if (toInclude != null && !toInclude.isEmpty()) {
            newStopWords.addAll(toInclude);
        }
        if (toExclude != null && !toExclude.isEmpty()) {
            newStopWords.removeAll(toExclude);
        }
        return new CharArraySet(newStopWords, false);
    }

    private List<String> extractStopWords(String toExtract) {
        ArrayList<String> stopWords = new ArrayList<String>();
        if (toExtract != null && toExtract.trim().length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(toExtract, ",", false);
            while (stringTokenizer.hasMoreTokens()) {
                String sw = stringTokenizer.nextToken();
                stopWords.add(sw.trim());
            }
        }
        return stopWords;
    }
}

