/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.indexer;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.ar.ArabicAnalyzer;
import org.apache.lucene.analysis.bg.BulgarianAnalyzer;
import org.apache.lucene.analysis.ca.CatalanAnalyzer;
import org.apache.lucene.analysis.cjk.CJKAnalyzer;
import org.apache.lucene.analysis.classic.ClassicFilter;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.core.WhitespaceTokenizer;
import org.apache.lucene.analysis.cz.CzechAnalyzer;
import org.apache.lucene.analysis.da.DanishAnalyzer;
import org.apache.lucene.analysis.de.GermanAnalyzer;
import org.apache.lucene.analysis.el.GreekAnalyzer;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.es.SpanishAnalyzer;
import org.apache.lucene.analysis.eu.BasqueAnalyzer;
import org.apache.lucene.analysis.fa.PersianAnalyzer;
import org.apache.lucene.analysis.fi.FinnishAnalyzer;
import org.apache.lucene.analysis.fr.FrenchAnalyzer;
import org.apache.lucene.analysis.gl.GalicianAnalyzer;
import org.apache.lucene.analysis.hi.HindiAnalyzer;
import org.apache.lucene.analysis.hu.HungarianAnalyzer;
import org.apache.lucene.analysis.hy.ArmenianAnalyzer;
import org.apache.lucene.analysis.id.IndonesianAnalyzer;
import org.apache.lucene.analysis.it.ItalianAnalyzer;
import org.apache.lucene.analysis.lv.LatvianAnalyzer;
import org.apache.lucene.analysis.miscellaneous.RemoveDuplicatesTokenFilter;
import org.apache.lucene.analysis.miscellaneous.WordDelimiterGraphFilterFactory;
import org.apache.lucene.analysis.nl.DutchAnalyzer;
import org.apache.lucene.analysis.no.NorwegianAnalyzer;
import org.apache.lucene.analysis.pt.PortugueseAnalyzer;
import org.apache.lucene.analysis.ro.RomanianAnalyzer;
import org.apache.lucene.analysis.ru.RussianAnalyzer;
import org.apache.lucene.analysis.sv.SwedishAnalyzer;
import org.apache.lucene.analysis.th.ThaiAnalyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tr.TurkishAnalyzer;
import ro.sync.exml.indexer.StopWordsPreferences;

public class NonCJKAnalyzer
extends Analyzer {
    private static final char[] SEPARATOR_CHARS = new char[]{'[', ']', '(', ')', '\"', ','};
    private String languageCode = "en";
    private StopWordsPreferences stopWordsPreferences = new StopWordsPreferences();

    public NonCJKAnalyzer() {
    }

    public NonCJKAnalyzer(String languageCode, StopWordsPreferences stopWordsPreferences) {
        this.languageCode = languageCode;
        this.stopWordsPreferences = stopWordsPreferences;
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        WhitespaceTokenizer src = new WhitespaceTokenizer();
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("preserveOriginal", "1");
        args.put("splitOnCaseChange", "0");
        args.put("splitOnNumerics", "0");
        WordDelimiterGraphFilterFactory wordDelimiterFilterFactory = new WordDelimiterGraphFilterFactory(args);
        TokenFilter tokenStream = wordDelimiterFilterFactory.create((TokenStream)src);
        tokenStream = new ClassicFilter((TokenStream)tokenStream);
        tokenStream = new LowerCaseFilter((TokenStream)tokenStream);
        tokenStream = new TrimNonWordCharsFilter((TokenStream)tokenStream);
        tokenStream = new IgnoreWordsWithSeparatorsFilter((TokenStream)tokenStream);
        tokenStream = new RemoveDuplicatesTokenFilter((TokenStream)tokenStream);
        CharArraySet stopWordsSet = this.getStopwordSet();
        tokenStream = new StopFilter((TokenStream)tokenStream, stopWordsSet);
        tokenStream = new CompoundWordFilter((TokenStream)tokenStream);
        Analyzer.TokenStreamComponents tokenStreamComponents = new Analyzer.TokenStreamComponents((Tokenizer)src, (TokenStream)tokenStream);
        return tokenStreamComponents;
    }

    public CharArraySet getStopwordSet() {
        CharArraySet stopWords = CharArraySet.EMPTY_SET;
        if (this.languageCode == null) {
            this.languageCode = "";
        }
        this.languageCode = this.languageCode.toLowerCase();
        stopWords = "".equals(this.languageCode) ? this.stopWordsPreferences.getStopWords(EnglishAnalyzer.getDefaultStopSet()) : (this.languageCode.equals("en") ? this.stopWordsPreferences.getStopWords(EnglishAnalyzer.getDefaultStopSet()) : (this.languageCode.equals("fr") ? this.stopWordsPreferences.getStopWords(FrenchAnalyzer.getDefaultStopSet()) : (this.languageCode.equals("de") ? this.stopWordsPreferences.getStopWords(GermanAnalyzer.getDefaultStopSet()) : (this.languageCode.equals("nl") ? this.stopWordsPreferences.getStopWords(DutchAnalyzer.getDefaultStopSet()) : (this.languageCode.equals("ja") ? this.stopWordsPreferences.getStopWords(CJKAnalyzer.getDefaultStopSet()) : (this.languageCode.equals("zh") ? this.stopWordsPreferences.getStopWords(CJKAnalyzer.getDefaultStopSet()) : (this.languageCode.equals("ko") ? this.stopWordsPreferences.getStopWords(CJKAnalyzer.getDefaultStopSet()) : (this.languageCode.equals("ar") ? this.stopWordsPreferences.getStopWords(ArabicAnalyzer.getDefaultStopSet()) : (this.languageCode.equals("hy") ? this.stopWordsPreferences.getStopWords(ArmenianAnalyzer.getDefaultStopSet()) : (this.languageCode.equals("eu") ? this.stopWordsPreferences.getStopWords(BasqueAnalyzer.getDefaultStopSet()) : (this.languageCode.equals("ca") ? this.stopWordsPreferences.getStopWords(CatalanAnalyzer.getDefaultStopSet()) : (this.languageCode.equals("bg") ? this.stopWordsPreferences.getStopWords(BulgarianAnalyzer.getDefaultStopSet()) : (this.languageCode.equals("cs") ? this.stopWordsPreferences.getStopWords(CzechAnalyzer.getDefaultStopSet()) : (this.languageCode.equals("da") ? this.stopWordsPreferences.getStopWords(DanishAnalyzer.getDefaultStopSet()) : (this.languageCode.equals("fi") ? this.stopWordsPreferences.getStopWords(FinnishAnalyzer.getDefaultStopSet()) : (this.languageCode.equals("gl") ? this.stopWordsPreferences.getStopWords(GalicianAnalyzer.getDefaultStopSet()) : (this.languageCode.equals("el") ? this.stopWordsPreferences.getStopWords(GreekAnalyzer.getDefaultStopSet()) : (this.languageCode.equals("hi") ? this.stopWordsPreferences.getStopWords(HindiAnalyzer.getDefaultStopSet()) : (this.languageCode.equals("hu") ? this.stopWordsPreferences.getStopWords(HungarianAnalyzer.getDefaultStopSet()) : (this.languageCode.equals("id") ? this.stopWordsPreferences.getStopWords(IndonesianAnalyzer.getDefaultStopSet()) : (this.languageCode.equals("it") ? this.stopWordsPreferences.getStopWords(ItalianAnalyzer.getDefaultStopSet()) : (this.languageCode.equals("lv") ? this.stopWordsPreferences.getStopWords(LatvianAnalyzer.getDefaultStopSet()) : (this.languageCode.equals("no") ? this.stopWordsPreferences.getStopWords(NorwegianAnalyzer.getDefaultStopSet()) : (this.languageCode.equals("fa") ? this.stopWordsPreferences.getStopWords(PersianAnalyzer.getDefaultStopSet()) : (this.languageCode.equals("pt") ? this.stopWordsPreferences.getStopWords(PortugueseAnalyzer.getDefaultStopSet()) : (this.languageCode.equals("ro") ? this.stopWordsPreferences.getStopWords(RomanianAnalyzer.getDefaultStopSet()) : (this.languageCode.equals("ru") ? this.stopWordsPreferences.getStopWords(RussianAnalyzer.getDefaultStopSet()) : (this.languageCode.equals("es") ? this.stopWordsPreferences.getStopWords(SpanishAnalyzer.getDefaultStopSet()) : (this.languageCode.equals("sv") ? this.stopWordsPreferences.getStopWords(SwedishAnalyzer.getDefaultStopSet()) : (this.languageCode.equals("th") ? this.stopWordsPreferences.getStopWords(ThaiAnalyzer.getDefaultStopSet()) : (this.languageCode.equals("tr") ? this.stopWordsPreferences.getStopWords(TurkishAnalyzer.getDefaultStopSet()) : this.stopWordsPreferences.getStopWords(EnglishAnalyzer.getDefaultStopSet()))))))))))))))))))))))))))))))));
        return CharArraySet.unmodifiableSet((CharArraySet)CharArraySet.copy((Set)stopWords));
    }

    protected Reader initReader(String fieldName, Reader reader) {
        return super.initReader(fieldName, reader);
    }

    private final class TrimNonWordCharsFilter
    extends TokenFilter {
        private final List<Character> startWordRemovableChars;
        private final List<Character> endWordRemovableChars;
        private final CharTermAttribute termAtt;

        private TrimNonWordCharsFilter(TokenStream input) {
            super(input);
            this.startWordRemovableChars = Arrays.asList(Character.valueOf('\''), Character.valueOf('\"'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('['), Character.valueOf(']'));
            this.endWordRemovableChars = Arrays.asList(Character.valueOf('\''), Character.valueOf('\"'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf(','), Character.valueOf('.'), Character.valueOf('?'), Character.valueOf('!'), Character.valueOf(':'), Character.valueOf(';'), Character.valueOf('\u2019'));
            this.clearAttributes();
            this.termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        }

        public boolean incrementToken() throws IOException {
            int bufferLength = 0;
            do {
                if (!this.input.incrementToken()) {
                    return false;
                }
                boolean shouldProcess = true;
                while (shouldProcess) {
                    char ch;
                    char[] buffer = this.termAtt.buffer();
                    bufferLength = this.termAtt.length();
                    int pos = 0;
                    if (bufferLength > 0) {
                        ch = buffer[pos];
                        while ((this.startWordRemovableChars.contains(Character.valueOf(ch)) || Character.isWhitespace(ch) || Character.isSpaceChar(ch)) && ++pos < bufferLength) {
                            ch = buffer[pos];
                        }
                        char[] tempBuffer = new char[bufferLength - pos];
                        System.arraycopy(buffer, pos, tempBuffer, 0, bufferLength - pos);
                        this.termAtt.copyBuffer(tempBuffer, 0, bufferLength - pos);
                        this.termAtt.setLength(bufferLength - pos);
                        bufferLength -= pos;
                    }
                    if (bufferLength > 0) {
                        ch = buffer[bufferLength - 1];
                        while ((this.endWordRemovableChars.contains(Character.valueOf(ch)) || Character.isWhitespace(ch) || Character.isSpaceChar(ch)) && --bufferLength > 0) {
                            ch = buffer[bufferLength - 1];
                        }
                        this.termAtt.setLength(bufferLength);
                    }
                    boolean hasDigitOrLetter = false;
                    for (int i = 0; i < bufferLength; ++i) {
                        if (!Character.isLetterOrDigit(buffer[i])) continue;
                        hasDigitOrLetter = true;
                        break;
                    }
                    if (!hasDigitOrLetter) {
                        bufferLength = 0;
                        this.termAtt.setLength(bufferLength);
                    }
                    if (bufferLength != 0) {
                        shouldProcess = false;
                        continue;
                    }
                    if (this.input.incrementToken()) continue;
                    return false;
                }
            } while (bufferLength < 2);
            return true;
        }
    }

    private final class IgnoreWordsWithSeparatorsFilter
    extends TokenFilter {
        CharTermAttribute termAtt;

        private IgnoreWordsWithSeparatorsFilter(TokenStream input) {
            super(input);
            this.termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        }

        public boolean incrementToken() throws IOException {
            if (!this.input.incrementToken()) {
                return false;
            }
            String token = new String(this.termAtt.buffer(), 0, this.termAtt.length()).trim();
            for (int i = 0; i < SEPARATOR_CHARS.length; ++i) {
                if (token.indexOf(SEPARATOR_CHARS[i]) < 0) continue;
            }
            return true;
        }
    }

    private final class CompoundWordFilter
    extends TokenFilter {
        private final CharTermAttribute charTermAttr;
        private final PositionIncrementAttribute positionIncrementAttr;
        private String compoundWord;

        private CompoundWordFilter(TokenStream input) {
            super(input);
            this.clearAttributes();
            this.charTermAttr = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
            this.positionIncrementAttr = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
        }

        public boolean incrementToken() throws IOException {
            String currentToken = this.charTermAttr.toString();
            if (this.compoundWord == null || this.compoundWord.isEmpty()) {
                this.compoundWord = currentToken;
            }
            if (!this.input.incrementToken()) {
                return false;
            }
            String nextToken = this.charTermAttr.toString();
            if (this.compoundWord != null && !this.compoundWord.isEmpty() && this.compoundWord.contains(nextToken)) {
                this.positionIncrementAttr.setPositionIncrement(0);
            } else {
                this.compoundWord = null;
            }
            return true;
        }
    }
}

