/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.xml.schema;

import ro.sync.basic.util.Equaler;

public class ExternalDTDInfo
implements Cloneable {
    private final String dtdSystemID;
    private final String detectedDoctype;
    private final String baseLocation;
    private static final String EXTERNAL_DTD_SEPARATOR = "EXTERNAL_DTD_INFO_SEPARATOR";

    public ExternalDTDInfo(String dtdSystemID, String detectedDoctype, String baseLocation) {
        this.dtdSystemID = dtdSystemID;
        this.detectedDoctype = detectedDoctype;
        this.baseLocation = baseLocation;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExternalDTDInfo) {
            ExternalDTDInfo edi = (ExternalDTDInfo)obj;
            return Equaler.verifyEquals(this.toSerializedRepresentationWithMarkers(), edi.toSerializedRepresentationWithMarkers());
        }
        return false;
    }

    public int hashCode() {
        return this.toSerializedRepresentationWithMarkers().hashCode();
    }

    public String getBaseLocation() {
        return this.baseLocation;
    }

    public String getDetectedDoctype() {
        return this.detectedDoctype;
    }

    public String getDtdSystemID() {
        return this.dtdSystemID;
    }

    public String toSerializedRepresentationWithMarkers() {
        return this.dtdSystemID + EXTERNAL_DTD_SEPARATOR + this.baseLocation + EXTERNAL_DTD_SEPARATOR + this.detectedDoctype;
    }

    public static ExternalDTDInfo fromSerializedRepresentationWithMarkers(String serialization) {
        ExternalDTDInfo info = null;
        if (serialization != null) {
            String[] split = serialization.split(EXTERNAL_DTD_SEPARATOR);
            String dtdSysID = "null".equals(split[0]) ? split[0] : null;
            String baseLocation = null;
            String detectedDoctype = null;
            if (split.length > 0) {
                String string = baseLocation = "null".equals(split[1]) ? split[1] : null;
            }
            if (split.length > 1) {
                detectedDoctype = "null".equals(split[2]) ? split[2] : null;
            }
            info = new ExternalDTDInfo(dtdSysID, detectedDoctype, baseLocation);
        }
        return info;
    }

    public String toString() {
        return this.toSerializedRepresentationWithMarkers();
    }
}

