/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.util.testing;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import ro.sync.annotations.ModifiedFromTests;

public class StaticFieldOverrider {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void overrideField(Class<?> klass, String fieldName, T value) throws NoSuchFieldException, IllegalAccessException {
        Field field = klass.getDeclaredField(fieldName);
        if (field.getType().isPrimitive()) {
            throw new IllegalArgumentException("Use boxed types instead of primitives (e.g. boolean -> Boolean). Primitive types are most likely inlined by the compiler, so they cannot be overriden using this mechanism. ");
        }
        if (field.getAnnotation(ModifiedFromTests.class) == null) {
            throw new IllegalArgumentException("The field " + fieldName + " from " + klass.getName() + " class must be annotated with @" + ModifiedFromTests.class.getName() + " annotation.");
        }
        boolean wasAccessible = field.isAccessible();
        field.setAccessible(true);
        try {
            if (Modifier.isFinal(field.getModifiers())) {
                StaticFieldOverrider.makeNonFinalAndSet(klass, field, value);
            } else {
                field.set(klass, value);
            }
        }
        finally {
            field.setAccessible(wasAccessible);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> void makeNonFinalAndSet(Class<?> klass, Field field, T value) throws IllegalAccessException {
        MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(Field.class, MethodHandles.lookup());
        try {
            VarHandle modifiers = lookup.findVarHandle(Field.class, "modifiers", Integer.TYPE);
            int modifiersBefore = field.getModifiers();
            modifiers.set(field, modifiersBefore & 0xFFFFFFEF);
            try {
                field.set(klass, value);
            }
            finally {
                modifiers.set(field, modifiersBefore);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

