/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.util.java;

import java.util.Locale;
import ro.sync.basic.util.java.ECJavaVMVendor;
import ro.sync.basic.util.java.JavaVMVendor;

public final class JavaVendorDetector {
    private JavaVendorDetector() {
        throw new IllegalStateException("Utility class instantiation is prohibited.");
    }

    static boolean isCurrentVMVendor(JavaVMVendor jvmVendor) {
        if (jvmVendor == null) {
            return false;
        }
        String vmVendor = System.getProperty("java.vm.vendor");
        return vmVendor != null && !vmVendor.isEmpty() && vmVendor.toLowerCase(Locale.ENGLISH).contains(jvmVendor.name().toLowerCase(Locale.ENGLISH));
    }

    static boolean isCurrentVMVendor(ECJavaVMVendor jvmVendor) {
        if (jvmVendor == null) {
            return false;
        }
        String vmVendor = System.getProperty("java.vm.vendor");
        return vmVendor != null && !vmVendor.isEmpty() && vmVendor.toLowerCase(Locale.ENGLISH).contains(jvmVendor.name().toLowerCase(Locale.ENGLISH));
    }

    public static boolean isKnownVMVendor() {
        for (JavaVMVendor jvmVendor : JavaVMVendor.values()) {
            if (!jvmVendor.isCurrentVendor()) continue;
            return true;
        }
        return false;
    }

    public static boolean isKnownECVMVendor() {
        for (ECJavaVMVendor jvmVendor : ECJavaVMVendor.values()) {
            if (!jvmVendor.isCurrentVendor()) continue;
            return true;
        }
        return false;
    }
}

