/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.StringTokenizer;
import ro.sync.basic.util.URLUtil;

public class URLInfo {
    private static final String DEFAULT_PARAM_PREFIX = "oxy";
    private static final int NAME_INDEX = 0;
    private static final int VALUE_INDEX = 1;
    private List<String[]> customQueryParamsList;
    private String reference;
    private String simplifiedURL;
    private String unknownQueryPart;
    private String customParamPrefix;

    public URLInfo(URL url) throws MalformedURLException {
        this(url, DEFAULT_PARAM_PREFIX);
    }

    public URLInfo(URL url, String customParamPrefix) throws MalformedURLException {
        this.customParamPrefix = customParamPrefix;
        this.reference = url.getRef();
        String query = url.getQuery();
        String remainingQuery = null;
        StringBuilder remainingQueryBuilder = new StringBuilder();
        ArrayList<String[]> queryValues = new ArrayList<String[]>();
        if (query != null) {
            if (query.contains(customParamPrefix)) {
                StringTokenizer stringTokenizer = new StringTokenizer(query, "&", false);
                while (stringTokenizer.hasMoreTokens()) {
                    String nextToken = stringTokenizer.nextToken();
                    if (nextToken.startsWith(customParamPrefix)) {
                        int indexOfEquals = nextToken.indexOf("=");
                        if (indexOfEquals == -1) continue;
                        String paramName = nextToken.substring(customParamPrefix.length(), indexOfEquals);
                        String paramValue = nextToken.substring(indexOfEquals + 1, nextToken.length());
                        queryValues.add(new String[]{URLUtil.uncorrect(paramName), URLUtil.uncorrect(paramValue)});
                        continue;
                    }
                    if (remainingQueryBuilder.length() > 0) {
                        remainingQueryBuilder.append("&");
                    }
                    remainingQueryBuilder.append(nextToken);
                }
            } else {
                remainingQueryBuilder.append(query);
            }
        }
        if (remainingQueryBuilder.length() > 0) {
            remainingQuery = remainingQueryBuilder.toString();
        }
        this.simplifiedURL = URLInfo.removeURLQueryAndReference(url.toString());
        this.customQueryParamsList = queryValues.isEmpty() ? null : queryValues;
        this.unknownQueryPart = remainingQuery;
    }

    private static String removeURLQueryAndReference(String url) throws MalformedURLException {
        String toRet = url;
        int idx1 = toRet.indexOf("#");
        int idx2 = toRet.indexOf("?");
        int idx = -1;
        idx = idx1 != -1 && idx2 != -1 ? Math.min(idx1, idx2) : Math.max(idx1, idx2);
        if (idx >= 0) {
            toRet = toRet.substring(0, idx);
        }
        return toRet;
    }

    public URL getURL(boolean addReferencePart, boolean addCustomQueryPart, boolean addUnknownQueryPart) throws MalformedURLException {
        StringBuilder toRetStr = new StringBuilder(this.simplifiedURL);
        boolean addDelimiter = true;
        if (addUnknownQueryPart && this.unknownQueryPart != null) {
            toRetStr.append("?").append(this.unknownQueryPart);
            addDelimiter = false;
        }
        if (addCustomQueryPart && this.customQueryParamsList != null) {
            boolean firstAddedParam = true;
            for (int i = 0; i < this.customQueryParamsList.size(); ++i) {
                String[] kv = this.customQueryParamsList.get(i);
                String key = kv[0];
                if (!this.addCustomQueryParam(key)) continue;
                if (firstAddedParam) {
                    if (addDelimiter) {
                        toRetStr.append("?");
                    } else {
                        toRetStr.append("&");
                    }
                }
                firstAddedParam = false;
                toRetStr.append(this.customParamPrefix).append(URLUtil.encodeURIComponent(key)).append("=").append(URLUtil.encodeURIComponent(kv[1]));
                if (i >= this.customQueryParamsList.size() - 1) continue;
                toRetStr.append("&");
            }
        }
        if (addReferencePart && this.reference != null) {
            toRetStr.append("#").append(this.reference);
        }
        return new URL(toRetStr.toString());
    }

    protected boolean addCustomQueryParam(String key) {
        return true;
    }

    public List<String[]> getCustomQueryParametersList() {
        return this.customQueryParamsList;
    }

    public LinkedHashMap<String, String> getCustomQueryParameters() {
        LinkedHashMap<String, String> paramsMap = null;
        if (this.customQueryParamsList != null) {
            paramsMap = new LinkedHashMap<String, String>();
            for (int i = 0; i < this.customQueryParamsList.size(); ++i) {
                String[] kv = this.customQueryParamsList.get(i);
                paramsMap.put(kv[0], kv[1]);
            }
        }
        return paramsMap;
    }

    public void addCustomQueryParam(String name, String value) {
        if (this.customQueryParamsList == null) {
            this.customQueryParamsList = new ArrayList<String[]>();
        }
        this.customQueryParamsList.add(new String[]{name, value});
    }

    public void removeCustomQueryParam(String queryParameter) {
        if (queryParameter != null && !queryParameter.isEmpty() && this.customQueryParamsList != null) {
            Iterator<String[]> iterator = this.customQueryParamsList.iterator();
            while (iterator.hasNext()) {
                String[] paramPair = iterator.next();
                String name = paramPair[0];
                if (!queryParameter.equals(name)) continue;
                iterator.remove();
            }
        }
        if (this.customQueryParamsList.isEmpty()) {
            this.customQueryParamsList = null;
        }
    }

    public String getReference() {
        return this.reference;
    }
}

