/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.util;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;

@API(type=APIType.NOT_EXTENDABLE, src=SourceType.PRIVATE)
public class SmallAndFastHashtable
implements Cloneable {
    private Object[] keysAndData;
    private int length = 0;

    public SmallAndFastHashtable() {
        this(2);
    }

    public SmallAndFastHashtable(int initialSize) {
        if (initialSize >= 0) {
            this.keysAndData = new Object[initialSize * 2];
        }
    }

    public final void put(String key, Object data) {
        int idx = -1;
        int len = this.keysAndData.length;
        boolean performOverwrite = false;
        for (int i = 0; i < len; i += 2) {
            if (this.keysAndData[i] == null) {
                idx = i;
                break;
            }
            if (!this.keysAndData[i].equals(key)) continue;
            performOverwrite = true;
            idx = i;
            break;
        }
        if (idx == -1) {
            int newLen = this.keysAndData.length + this.keysAndData.length / 2 + 2;
            if (newLen % 2 != 0) {
                ++newLen;
            }
            Object[] tmp = new Object[newLen];
            idx = this.keysAndData.length;
            System.arraycopy(this.keysAndData, 0, tmp, 0, this.keysAndData.length);
            this.keysAndData = tmp;
        }
        this.keysAndData[idx] = key;
        this.keysAndData[idx + 1] = data;
        if (!performOverwrite) {
            ++this.length;
        }
    }

    public final Object get(String key) {
        Object ret = null;
        int len = this.keysAndData.length;
        for (int i = 0; i < len; i += 2) {
            if (!key.equals(this.keysAndData[i])) continue;
            ret = this.keysAndData[i + 1];
            break;
        }
        return ret;
    }

    public final String getKey(int index) {
        return (String)this.keysAndData[index * 2];
    }

    public final boolean containsKey(String key) {
        int len = this.keysAndData.length;
        for (int i = 0; i < len; i += 2) {
            if (!key.equals(this.keysAndData[i])) continue;
            return true;
        }
        return false;
    }

    public final void remove(String key) {
        int len = this.keysAndData.length;
        for (int i = 0; i < len; i += 2) {
            if (!key.equals(this.keysAndData[i])) continue;
            Object[] tmp = new Object[len - 2];
            System.arraycopy(this.keysAndData, 0, tmp, 0, i);
            System.arraycopy(this.keysAndData, i + 2, tmp, i, len - i - 2);
            this.keysAndData = tmp;
            --this.length;
            break;
        }
    }

    public SmallIterator iterator() {
        return new SmallIterator(){
            private int index;

            @Override
            public Object[] next() {
                String key = (String)SmallAndFastHashtable.this.keysAndData[this.index];
                Object value = SmallAndFastHashtable.this.keysAndData[this.index + 1];
                this.index += 2;
                return new Object[]{key, value};
            }

            @Override
            public boolean hasNext() {
                return this.index < SmallAndFastHashtable.this.keysAndData.length && SmallAndFastHashtable.this.keysAndData[this.index] != null;
            }
        };
    }

    public Object clone() {
        SmallAndFastHashtable clone = new SmallAndFastHashtable(-1);
        clone.length = this.length;
        clone.keysAndData = new Object[this.keysAndData.length];
        System.arraycopy(this.keysAndData, 0, clone.keysAndData, 0, this.keysAndData.length);
        return clone;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        SmallIterator it = this.iterator();
        while (it.hasNext()) {
            Object[] values = it.next();
            str.append("(");
            str.append(values[0]);
            str.append(",");
            str.append(values[1]);
            str.append(")");
        }
        str.append("]");
        return str.toString();
    }

    public int getLength() {
        return this.length;
    }

    public final void putAll(SmallAndFastHashtable smallAFHashToAdd) {
        for (int i = 0; i < smallAFHashToAdd.length; ++i) {
            String key = smallAFHashToAdd.getKey(i);
            Object data = smallAFHashToAdd.get(key);
            this.put(key, data);
        }
    }

    public static interface SmallIterator {
        public Object[] next();

        public boolean hasNext();
    }
}

