/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.io;

import java.io.IOException;
import java.io.Writer;

public class LineSeparatorFilterWriter
extends Writer {
    private static final char CR = '\r';
    private static final char LF = '\n';
    private final Writer writer;
    private String imposedLineSeparator;
    private boolean previousCR = false;
    private StringBuilder filterBuffer;

    public LineSeparatorFilterWriter(Writer writer, String imposedLineSeparator) {
        this.writer = writer;
        this.imposedLineSeparator = imposedLineSeparator;
        this.filterBuffer = new StringBuilder();
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        char[] filtered = this.filterLineSeparator(cbuf, off, len);
        this.writer.write(filtered, 0, filtered.length);
    }

    private char[] filterLineSeparator(char[] cbuf, int off, int len) {
        this.filterBuffer.setLength(0);
        this.filterBuffer.ensureCapacity(len);
        if (len > 0) {
            int currentOff = off;
            int endOff = off + len - 1;
            if (this.previousCR) {
                char firstCh = cbuf[currentOff];
                if (firstCh == '\n') {
                    ++currentOff;
                }
                this.filterBuffer.append(this.imposedLineSeparator);
            }
            this.previousCR = false;
            while (currentOff <= endOff) {
                char currentCh = cbuf[currentOff];
                if (currentCh == '\r') {
                    int nextOff = currentOff + 1;
                    if (nextOff > endOff) {
                        this.previousCR = true;
                        break;
                    }
                    char nextChar = cbuf[nextOff];
                    currentOff = nextChar == '\n' ? (currentOff += 2) : ++currentOff;
                    this.filterBuffer.append(this.imposedLineSeparator);
                    continue;
                }
                if (currentCh == '\n') {
                    this.filterBuffer.append(this.imposedLineSeparator);
                } else {
                    this.filterBuffer.append(currentCh);
                }
                ++currentOff;
            }
        }
        int length = this.filterBuffer.length();
        char[] processedChars = new char[length];
        this.filterBuffer.getChars(0, length, processedChars, 0);
        return processedChars;
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.previousCR) {
            this.writer.write(this.imposedLineSeparator);
            this.previousCR = false;
        }
        this.writer.close();
    }
}

