/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.io;

import java.io.File;
import java.io.UnsupportedEncodingException;

public class FilePathToURI {
    private static boolean DISABLE_CORRECTION_FOR_OVER_ASCII_CHARS = false;
    private static final boolean[] G_NEED_ESCAPING = new boolean[128];
    private static final char[] G_AFTER_ESCAPING_1 = new char[128];
    private static final char[] G_AFTER_ESCAPING_2 = new char[128];
    private static final char[] G_HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String filepath2URI(String path) {
        if (path == null) {
            return null;
        }
        path = FilePathToURI.escapeSpecialAsciiAndNonAscii(path);
        return path;
    }

    public static String escapeSpecialAsciiAndNonAscii(String path) {
        int i;
        int len = path.length();
        int ch = 0;
        StringBuilder buffer = new StringBuilder(len * 2);
        if (len >= 2 && path.charAt(1) == ':' && (ch = Character.toUpperCase(path.charAt(0))) >= 65 && ch <= 90) {
            buffer.append('/');
        }
        for (i = 0; i < len && ((ch = path.charAt(i)) < 128 || FilePathToURI.isDisableCorrectionForOverAsciiChars() && Character.isAlphabetic(ch)); ++i) {
            if (ch < G_NEED_ESCAPING.length && G_NEED_ESCAPING[ch]) {
                buffer.append('%');
                buffer.append(G_AFTER_ESCAPING_1[ch]);
                buffer.append(G_AFTER_ESCAPING_2[ch]);
                continue;
            }
            buffer.append((char)ch);
        }
        if (i < len) {
            byte[] bytes = null;
            try {
                bytes = path.substring(i).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return path;
            }
            for (byte b : bytes) {
                if (b < 0) {
                    ch = b + 256;
                    buffer.append('%');
                    buffer.append(G_HEX_CHARS[ch >> 4]);
                    buffer.append(G_HEX_CHARS[ch & 0xF]);
                    continue;
                }
                if (G_NEED_ESCAPING[b]) {
                    buffer.append('%');
                    buffer.append(G_AFTER_ESCAPING_1[b]);
                    buffer.append(G_AFTER_ESCAPING_2[b]);
                    continue;
                }
                buffer.append((char)b);
            }
        }
        return buffer.toString();
    }

    public static boolean isDisableCorrectionForOverAsciiChars() {
        return DISABLE_CORRECTION_FOR_OVER_ASCII_CHARS;
    }

    public static void setDisableCorrectionForOverAsciiChars(boolean disableCorrectionForOverAsciiChars) {
        DISABLE_CORRECTION_FOR_OVER_ASCII_CHARS = disableCorrectionForOverAsciiChars;
    }

    public static String replaceFileSeparatorChar(String path) {
        int indexOfThirdSlash;
        int indexOfDoubleSlash;
        char separator = File.separatorChar;
        if (separator == '\\' && (indexOfDoubleSlash = ((String)path).indexOf("//")) != -1 && (indexOfThirdSlash = ((String)path).indexOf("/", indexOfDoubleSlash + 2)) != -1) {
            String pathAfterThirdSlash = ((String)path).substring(indexOfThirdSlash + 1);
            String beforeThirdSlash = ((String)path).substring(0, indexOfThirdSlash + 1);
            path = beforeThirdSlash + pathAfterThirdSlash.replace(separator, '/');
            return path;
        }
        return ((String)path).replace(separator, '/');
    }

    static {
        for (int i = 0; i <= 31; ++i) {
            FilePathToURI.G_NEED_ESCAPING[i] = true;
            FilePathToURI.G_AFTER_ESCAPING_1[i] = G_HEX_CHARS[i >> 4];
            FilePathToURI.G_AFTER_ESCAPING_2[i] = G_HEX_CHARS[i & 0xF];
        }
        FilePathToURI.G_NEED_ESCAPING[127] = true;
        FilePathToURI.G_AFTER_ESCAPING_1[127] = 55;
        FilePathToURI.G_AFTER_ESCAPING_2[127] = 70;
        for (char ch : new char[]{' ', '<', '>', '#', '%', '\"', '{', '}', '?', '|', '\\', '^', '~', '[', ']', '`', '\'', '&'}) {
            FilePathToURI.G_NEED_ESCAPING[ch] = true;
            FilePathToURI.G_AFTER_ESCAPING_1[ch] = G_HEX_CHARS[ch >> 4];
            FilePathToURI.G_AFTER_ESCAPING_2[ch] = G_HEX_CHARS[ch & 0xF];
        }
    }
}

