/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.contenttypes;

import ro.sync.basic.contenttypes.ContentTypes;

public class ContentTypeChecker
implements ContentTypes {
    private static final String[] plainXMLContentTypes = new String[]{"text/xml", "text/xspec", "text/exf", "text/ant", "text/html", "application/xhtml+xml", "text/wsdl", "text/svg", "application/ditamap"};
    private static final String[] jsonContentTypes = new String[]{"text/json", "text/json-schema"};
    private static final String[] schemaContentTypes = new String[]{"text/xsl", "text/xsd", "text/rng", "text/nvdl", "text/sch", "text/xproc"};
    private static String[] allXMLContentTypes = new String[plainXMLContentTypes.length + schemaContentTypes.length];
    private static String[] allJSONContentTypes;

    public static final boolean isXMLContentType(String contentType) {
        return ContentTypeChecker.isXMLContentType(contentType, false);
    }

    public static final boolean isXMLContentType(String contentType, boolean onlyPlainXMLTypes) {
        boolean isXmlCT = false;
        if (contentType != null) {
            int i;
            for (i = 0; i < plainXMLContentTypes.length; ++i) {
                if (!contentType.equals(plainXMLContentTypes[i])) continue;
                isXmlCT = true;
                break;
            }
            if (!onlyPlainXMLTypes && !isXmlCT) {
                for (i = 0; i < schemaContentTypes.length; ++i) {
                    if (!contentType.equals(schemaContentTypes[i])) continue;
                    isXmlCT = true;
                    break;
                }
            }
        }
        return isXmlCT;
    }

    public static final boolean isJSONContentType(String contentType) {
        return ContentTypeChecker.isJSONContentType(contentType, false);
    }

    public static final boolean isJSONContentType(String contentType, boolean includeJSONL) {
        boolean isJSONCT = false;
        if (contentType != null) {
            String[] cts = includeJSONL ? allJSONContentTypes : jsonContentTypes;
            for (int i = 0; i < cts.length; ++i) {
                if (!contentType.equals(cts[i])) continue;
                isJSONCT = true;
                break;
            }
        }
        return isJSONCT;
    }

    public static final String[] getXMLContentTypes() {
        return allXMLContentTypes;
    }

    public static final String[] getJSONContentTypes() {
        return allJSONContentTypes;
    }

    static {
        System.arraycopy(plainXMLContentTypes, 0, allXMLContentTypes, 0, plainXMLContentTypes.length);
        System.arraycopy(schemaContentTypes, 0, allXMLContentTypes, plainXMLContentTypes.length, schemaContentTypes.length);
        allJSONContentTypes = new String[jsonContentTypes.length + 1];
        System.arraycopy(jsonContentTypes, 0, allJSONContentTypes, 0, jsonContentTypes.length);
        ContentTypeChecker.allJSONContentTypes[ContentTypeChecker.allJSONContentTypes.length - 1] = "text/jsonl";
    }
}

