/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.classloader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import ro.sync.basic.classloader.LateDelegationClassLoader;

public class ContextFinder
extends ClassLoader
implements PrivilegedAction {
    private String COM_OXYGENXML_PREFER_PLUGIN_CLASSLOADER_IN_THREAD_CONTEXT_CLASS_LOADER = "com.oxygenxml.prefer.plugin.classloader.context.loader";
    private static final ThreadLocal cycleDetector = new ThreadLocal();
    static final Finder contextFinder = ContextFinder.getFinder();
    private final ClassLoader parentContextClassLoader;
    private final ClassLoader sunClassLoader;

    private static Finder getFinder() {
        return AccessController.doPrivileged(new PrivilegedAction<Finder>(){

            @Override
            public Finder run() {
                return new Finder();
            }
        });
    }

    public ContextFinder(ClassLoader parentClassLoader, ClassLoader sunClassLoader) {
        super(parentClassLoader);
        this.parentContextClassLoader = parentClassLoader;
        this.sunClassLoader = sunClassLoader;
    }

    private ArrayList basicFindClassLoaders() {
        Class[] stack = contextFinder.getClassContext();
        ArrayList<ClassLoader> result = new ArrayList<ClassLoader>(1);
        if (!"false".equals(System.getProperty(this.COM_OXYGENXML_PREFER_PLUGIN_CLASSLOADER_IN_THREAD_CONTEXT_CLASS_LOADER))) {
            ClassLoader previousLoader = null;
            for (int i = stack.length - 1; i >= 0; --i) {
                ClassLoader tmp = stack[i].getClassLoader();
                if (tmp == null || tmp == this.sunClassLoader || tmp == this.parentContextClassLoader || previousLoader == tmp || tmp.getClass().getName().startsWith("sun.") || !(tmp instanceof LateDelegationClassLoader)) continue;
                result.add(tmp);
                previousLoader = tmp;
            }
        }
        return result;
    }

    private ArrayList findClassLoaders() {
        if (System.getSecurityManager() == null) {
            return this.basicFindClassLoaders();
        }
        return (ArrayList)AccessController.doPrivileged(this);
    }

    public Object run() {
        return this.basicFindClassLoaders();
    }

    private boolean startLoading(String name) {
        HashSet<String> classesAndResources = (HashSet<String>)cycleDetector.get();
        if (classesAndResources != null && classesAndResources.contains(name)) {
            return false;
        }
        if (classesAndResources == null) {
            classesAndResources = new HashSet<String>(3);
            cycleDetector.set(classesAndResources);
        }
        classesAndResources.add(name);
        return true;
    }

    private void stopLoading(String name) {
        ((Set)cycleDetector.get()).remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class loadClass(String arg0, boolean arg1) throws ClassNotFoundException {
        if (!this.startLoading(arg0)) {
            throw new ClassNotFoundException(arg0);
        }
        try {
            ArrayList toConsult = this.findClassLoaders();
            Iterator loaders = toConsult.iterator();
            while (loaders.hasNext()) {
                try {
                    Class<?> clazz;
                    Class<?> clazz2 = clazz = ((ClassLoader)loaders.next()).loadClass(arg0);
                    return clazz2;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            Class<?> clazz = this.parentContextClassLoader.loadClass(arg0);
            return clazz;
        }
        finally {
            this.stopLoading(arg0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getResource(String arg0) {
        if (!this.startLoading(arg0)) {
            return null;
        }
        try {
            ArrayList toConsult = this.findClassLoaders();
            Iterator loaders = toConsult.iterator();
            while (loaders.hasNext()) {
                URL result = ((ClassLoader)loaders.next()).getResource(arg0);
                if (result == null) continue;
                URL uRL = result;
                return uRL;
            }
            URL uRL = super.getResource(arg0);
            return uRL;
        }
        finally {
            this.stopLoading(arg0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getResourceAsStream(String name) {
        if (!this.startLoading(name)) {
            return null;
        }
        try {
            ArrayList toConsult = this.findClassLoaders();
            for (Object cl : toConsult) {
                InputStream result = ((ClassLoader)cl).getResourceAsStream(name);
                if (result == null) continue;
                InputStream inputStream = result;
                return inputStream;
            }
            URL url = super.getResource(name);
            try {
                Object cl;
                cl = url != null ? url.openStream() : null;
                return cl;
            }
            catch (IOException e) {
                InputStream inputStream = null;
                this.stopLoading(name);
                return inputStream;
            }
        }
        finally {
            this.stopLoading(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Enumeration findResources(String arg0) throws IOException {
        if (!this.startLoading(arg0)) {
            return null;
        }
        try {
            ArrayList toConsult = this.findClassLoaders();
            Iterator loaders = toConsult.iterator();
            while (loaders.hasNext()) {
                Enumeration<URL> result = ((ClassLoader)loaders.next()).getResources(arg0);
                if (result == null || !result.hasMoreElements()) continue;
                Enumeration<URL> enumeration = result;
                return enumeration;
            }
            Enumeration<URL> enumeration = super.findResources(arg0);
            return enumeration;
        }
        finally {
            this.stopLoading(arg0);
        }
    }

    static final class Finder
    extends SecurityManager {
        Finder() {
        }

        public Class[] getClassContext() {
            return super.getClassContext();
        }
    }
}

