/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.xerces;

import com.thaiopensource.util.PropertyId;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.AbstractSchema;
import com.thaiopensource.validate.Validator;
import com.thaiopensource.validate.prop.xsd.XsdProperty;
import com.thaiopensource.validate.xerces.ValidatorImpl;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.grammars.XMLGrammarPool;

class SchemaImpl
extends AbstractSchema {
    private final SymbolTable symbolTable;
    private final XMLGrammarPool grammarPool;

    SchemaImpl(SymbolTable symbolTable, XMLGrammarPool grammarPool, PropertyMap properties, PropertyId<?>[] supportedPropertyIds) {
        super(properties, supportedPropertyIds);
        this.symbolTable = symbolTable;
        this.grammarPool = grammarPool;
    }

    @Override
    public Validator createValidator(PropertyMap properties) {
        PropertyMap p = properties;
        if (this.getProperties().contains(XsdProperty.XSD_VERSION)) {
            PropertyMapBuilder builder = new PropertyMapBuilder();
            for (int i = 0; i < properties.size(); ++i) {
                SchemaImpl.copy(builder, properties.getKey(i), properties);
            }
            SchemaImpl.copy(builder, XsdProperty.XSD_VERSION, this.getProperties());
            SchemaImpl.copy(builder, XsdProperty.FULL_XPATH, this.getProperties());
            p = builder.toPropertyMap();
        }
        return new ValidatorImpl(this.symbolTable, this.grammarPool, p);
    }

    private static <T> void copy(PropertyMapBuilder builder, PropertyId<T> pid, PropertyMap properties) {
        T value = properties.get(pid);
        if (value != null) {
            builder.put(pid, value);
        }
    }
}

