/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.prop.xsd;

import com.thaiopensource.validate.FlagOption;
import com.thaiopensource.validate.FlagPropertyId;
import com.thaiopensource.validate.Option;
import com.thaiopensource.validate.OptionArgumentFormatException;
import com.thaiopensource.validate.StringOption;
import com.thaiopensource.validate.StringPropertyId;

public class XsdProperty {
    public static final StringPropertyId XSD_VERSION = new StringPropertyId("XSD_VERSION");
    public static final StringOption XSD_VERSION_OPTION = new XsdVersionOption();
    public static final FlagPropertyId FULL_XPATH = new FlagPropertyId("FULL_XPATH");

    private XsdProperty() {
    }

    public static Option getOption(String uri) {
        if (!uri.startsWith("http://www.thaiopensource.com/validate/")) {
            return null;
        }
        if ((uri = uri.substring("http://www.thaiopensource.com/validate/".length())).equals("xsd-version")) {
            return XSD_VERSION_OPTION;
        }
        if (uri.equals("full-xpath")) {
            return new FlagOption(FULL_XPATH);
        }
        return null;
    }

    public static class XsdVersionOption
    extends StringOption {
        private XsdVersionOption() {
            super(XSD_VERSION);
        }

        @Override
        public String normalize(String value) throws OptionArgumentFormatException {
            if (!(value = value.trim()).equals("1.0") && !value.equals("1.1")) {
                throw new OptionArgumentFormatException("Only 1.0 and 1.1 are supported values!");
            }
            return value;
        }
    }
}

