/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.sax;

import com.thaiopensource.relaxng.pattern.IdSoundnessChecker;
import com.thaiopensource.relaxng.pattern.IdTypeMap;
import com.thaiopensource.validate.rng.impl.IdCollector;
import com.thaiopensource.xml.util.Name;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class IdContentHandler
implements ContentHandler {
    private final IdSoundnessChecker checker;
    private Locator locator;
    private IdCollector idList;

    public IdContentHandler(IdTypeMap idTypeMap, ErrorHandler eh, IdCollector idList) {
        this.idList = idList;
        this.checker = new IdSoundnessChecker(idTypeMap, eh, idList);
    }

    public IdContentHandler(IdTypeMap idTypeMap, ErrorHandler eh) {
        this.checker = new IdSoundnessChecker(idTypeMap, eh);
    }

    public void reset() {
        this.checker.reset();
        this.locator = null;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.idList != null) {
            this.idList.clear();
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.checker.endDocument();
        this.setComplete();
    }

    protected void setComplete() {
    }

    @Override
    public void startPrefixMapping(String s, String s1) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String s) throws SAXException {
    }

    @Override
    public void startElement(String namespaceUri, String localName, String qName, Attributes attributes) throws SAXException {
        this.checker.startElement();
        Name elementName = new Name(namespaceUri, localName);
        int len = attributes.getLength();
        for (int i = 0; i < len; ++i) {
            Name attributeName = new Name(attributes.getURI(i), attributes.getLocalName(i));
            String value = attributes.getValue(i);
            this.checker.attribute(elementName, attributeName, attributes.getQName(i), value, this.locator);
        }
        this.checker.startElementFinished();
    }

    @Override
    public void endElement(String s, String s1, String s2) throws SAXException {
        this.checker.endElement();
    }

    @Override
    public void characters(char[] chars, int i, int i1) throws SAXException {
        this.checker.characters(chars, i, i1);
    }

    @Override
    public void ignorableWhitespace(char[] chars, int i, int i1) throws SAXException {
    }

    @Override
    public void processingInstruction(String s, String s1) throws SAXException {
    }

    @Override
    public void skippedEntity(String s) throws SAXException {
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
    }
}

