/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.validate.rng.impl.JingIdValue;
import java.util.List;
import java.util.Stack;

public class SimpleIDAnnotationsExtractor {
    private static final int PREVIEW_MAX_LEN = 100;
    private Stack<List<JingIdValue>> addedIDValuesList = new Stack();
    private Stack<StringBuilder> existingIDValuesAnnotations = new Stack();

    public void startElement(List<JingIdValue> added) {
        this.addedIDValuesList.push(added);
        if (added != null) {
            this.existingIDValuesAnnotations.push(new StringBuilder(0));
        }
    }

    public void characters(char[] chars, int offset, int length) {
        if (!this.existingIDValuesAnnotations.isEmpty()) {
            int size = this.existingIDValuesAnnotations.size();
            for (int i = 0; i < size; ++i) {
                StringBuilder someText = (StringBuilder)this.existingIDValuesAnnotations.get(i);
                if (someText.length() >= 100) continue;
                boolean ws = true;
                for (int j = 0; j < length; ++j) {
                    if (Character.isWhitespace(chars[j + offset])) continue;
                    ws = false;
                    break;
                }
                if (ws) continue;
                someText.append(' ').append(chars, offset, length);
            }
        }
    }

    public void endElement() {
        StringBuilder annotation;
        String normalized;
        List<JingIdValue> vals;
        if (!this.addedIDValuesList.isEmpty() && (vals = this.addedIDValuesList.pop()) != null && !this.existingIDValuesAnnotations.isEmpty() && (normalized = (annotation = this.existingIDValuesAnnotations.pop()).toString().replaceAll("\\s+", " ").trim()).length() > 0) {
            String annotationStr = normalized + "...";
            for (int j = 0; j < vals.size(); ++j) {
                vals.get(j).setAnnotation(annotationStr);
            }
        }
    }
}

